#!/bin/sh

. /home/root/gstreamer_examples/func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

echo " pixel depth"
echo " ================="
echo " 1 = 8-Bit"
echo " 2 = 10-Bit"
#echo " 3 = 12-Bit" # not supported at i.MX8M
read PIX_DEPTH
echo " Your select = $PIX_DEPTH"
case $PIX_DEPTH in
  "1") CAM_COL_FMT="GRBG"; COL_FMT="SGRBG8";;
  "2") CAM_COL_FMT="SGRBG10_1X10"; COL_FMT="SGRBG10";;
#  "3") CAM_COL_FMT="SGRBG12_1X12";; # not supported at i.MX8M
  *) CAM_COL_FMT="SGRBG8_1X8";;
esac

echo ""
echo " configure camera with v4l2_control"
echo " =================================="

v4l2-ctl -d $VID_DEVICE --set-fmt-video=pixelformat=$CAM_COL_FMT,$SENSOR_RES
v4l2-ctl -d $VID_DEVICE --set-selection=target=crop,$OFFSET_SENSOR,$SENSOR_RES

# Additional Settings
X_RES=${SENSOR_RES%%,*}
X_RES=${X_RES##*=}
Y_RES=${SENSOR_RES##*=}

echo " starting save_raw_image with format $COL_FMT"
echo " read $X_RES x $Y_RES and write to RAW-file"
echo " ============================================="

#yavta "$VID_DEVICE" -c8 --skip 7 -f "$COL_FMT" -s "${X_RES}x${Y_RES}" -F$CAMERA"_PixDepth_"$CAM_COL_FMT".raw"
save_raw_image -D $VID_DEVICE -no_subdev -f $COL_FMT -res_x $X_RES -res_y $Y_RES -d $NUMBER_OF_PIC -n $CAMERA"_PixDepth_"$CAM_COL_FMT"_"
