#!/bin/sh
. `dirname $0`/func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

echo 0 > /sys/class/graphics/fbcon/cursor_blink

FRAME_SIZE=",width=640,height=480"
FRAMERATE=""

echo "select resolution"
echo "================="
echo "1 = 2592 x 1944 Full"
echo "2 = 2048 x 1536 QXGA"
echo "3 = 1600 x 1200 UXGA"
echo "4 = 1280 x 1024 SXGA"
echo "5 = 1024 x 768  XGA"
echo "6 = 800  x 600  SVGA"
echo "7 = 640  x 480  VGA"
echo "8 = 1920 x 1080 FullHD"
echo "9 = 1280 x 720  HD"
read RESOLUTION
echo "Your select = $RESOLUTION"
case $RESOLUTION in
  "1") SENSOR_RES_LIVE_DEMO="2592x1944"; GRAB_RES="2592x1944"; FRAME_SIZE=",width=2592,height=1944";;
  "2") SENSOR_RES_LIVE_DEMO="2048x1536"; GRAB_RES="2048x1536"; FRAME_SIZE=",width=2048,height=1536";;
  "3") SENSOR_RES_LIVE_DEMO="1600x1200"; GRAB_RES="1600x1200"; FRAME_SIZE=",width=1600,height=1200";;
  "4") SENSOR_RES_LIVE_DEMO="1280x1024"; GRAB_RES="1280x1024"; FRAME_SIZE=",width=1280,height=1024";;
  "5") SENSOR_RES_LIVE_DEMO="2048x1536"; GRAB_RES="1024x768"; FRAME_SIZE=",width=1024,height=768";;
  "6") SENSOR_RES_LIVE_DEMO="1600x1200"; GRAB_RES="800x600"; FRAME_SIZE=",width=800,height=600";;
  "7") SENSOR_RES_LIVE_DEMO="2560x1920"; GRAB_RES="640x480"; FRAME_SIZE=",width=640,height=480";;
  "8") SENSOR_RES_LIVE_DEMO="1920x1080"; GRAB_RES="1920x1080"; FRAME_SIZE=",width=1920,height=1080";;
  "9") SENSOR_RES_LIVE_DEMO="2560x1440"; GRAB_RES="1280x720"; FRAME_SIZE=",width=1280,height=720";;
  *) SENSOR_RES_LIVE_DEMO="2592x1944"; GRAB_RES="2592x1944"; FRAME_SIZE=",width=2592,height=1944";;
esac



echo "starting gstreamer ..."
gst-launch-1.0 \
	v4l2src device=$DEVICE ! \
	video/x-$COL_FORMAT$FRAME_SIZE$FRAMERATE ! \
	bayer2rgbneon ! \
	queue ! kmssink driver-name="imx-drm" force-modesetting=false sync=true	

echo 1 > /sys/class/graphics/fbcon/cursor_blink