#!/bin/sh

# check the set addresses in config-expansions file
#CAM_I2C_ADRESS_0=$(media-ctl -p | grep -B 7 "> \"ipu1_csi0_mux\"" | grep ar0144 | cut -d: -f2 | cut -c13-14)
#CAM_I2C_ADRESS_1=$(media-ctl -p | grep -B 7 "> \"ipu2_csi1_mux\"" | grep ar0144 | cut -d: -f2 | cut -c13-14)
#CAM_I2C_BUS=$(find /sys/bus/i2c/drivers/ar0144/ -name "?-00*" | cut -d / -f 7 | cut -c1-1 | sed 2d)

#echo ""
#echo " camera0 i2c address = $CAM_I2C_ADRESS_0"
#echo " camera1 i2c address = $CAM_I2C_ADRESS_1"
#echo " i2c bus address = $CAM_I2C_BUS"

# check the devices with "media-ctl -p"
#IPU1_CSI0_DEVICE=$(media-ctl -e "ipu1_csi0 capture")
#IPU2_CSI1_DEVICE=$(media-ctl -e "ipu2_csi1 capture")
#CAM_DEVICE_0=$(media-ctl -e "ar0144 $CAM_I2C_BUS-00$CAM_I2C_ADRESS_0")
#CAM_DEVICE_1=$(media-ctl -e "ar0144 $CAM_I2C_BUS-00$CAM_I2C_ADRESS_1")

#echo " ipu1_csi0 capture device name = $IPU1_CSI0_DEVICE"
#echo " ipu2_csi1 capture device name = $IPU2_CSI1_DEVICE"
#echo " camera0 subdevice name = $CAM_DEVICE_0"
#echo " camera1 subdevice name = $CAM_DEVICE_1"
echo ""
echo " starting gstreamer with two GRAY Sources ..."
echo " read camera_0 from MIPI-CSI-2_CSI1 and camera_1 from MIPI-CSI-2_CSI2 with 1280 x 800"
echo " write side by side to 2560x1600 Pixel, convert to jpg and write to ar0144_bw_dual_image.jpg"
echo " ============================================================================================"
echo ""
echo " configure camera with v4l2_control"
echo " =================================="

#v4l2-ctl -d $VID_DEVICE --set-fmt-video=pixelformat=$CAM_COL_FMT,$SENSOR_RES
#v4l2-ctl -d $VID_DEVICE --set-selection=target=crop,$OFFSET_SENSOR,$SENSOR_RES
v4l2-ctl -d /dev/video0 --set-fmt-video=pixelformat=GREY,width=1280,height=800
v4l2-ctl -d /dev/video0 --set-selection=target=crop,left=0,top=4,width=1280,height=800

#v4l2-ctl -d $VID_DEVICE --set-fmt-video=pixelformat=$CAM_BW_FMT,$SENSOR_RES
#v4l2-ctl -d $VID_DEVICE --set-selection=target=crop,$OFFSET_SENSOR,$SENSOR_RES
v4l2-ctl -d /dev/video1 --set-fmt-video=pixelformat=GREY,width=1280,height=800
v4l2-ctl -d /dev/video1 --set-selection=target=crop,left=0,top=4,width=1280,height=800

echo ""
echo " start gstreamer"
echo " ==============="

gst-launch-1.0 videomixer name=mix  sink_0::xpos=0 sink_0::ypos=0 sink_1::xpos=1280 sink_1::ypos=0 ! videoconvert ! jpegenc ! multifilesink location=ar0144_bw_dual_image.jpg \
	v4l2src num-buffers=5 device=/dev/video0 ! \
	video/x-raw,format=GRAY8,depth=8,width=1280,height=800,framerate=30/1 ! videoconvert ! mix. \
	v4l2src num-buffers=5 device=/dev/video1 ! \
	video/x-raw,format=GRAY8,depth=8,width=1280,height=800,framerate=30/1 ! queue ! videoconvert ! mix. 