#!/bin/sh
. `dirname $0`/../func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param



echo "starting gstreamer with $CAM_COL_FMT Source ..."
echo "read $SENSOR_RES (offset x,y=$OFFSET_SENSOR) and write to file ar0144_bayer.raw"
echo "===================================================================================="
echo ""
echo " configure camera with v4l2_control"
echo " =================================="

v4l2-ctl -d $VID_DEVICE --set-fmt-video=pixelformat=$CAM_COL_FMT,$SENSOR_RES
v4l2-ctl -d $VID_DEVICE --set-selection=target=crop,$OFFSET_SENSOR,$SENSOR_RES
v4l2-ctl -d $VID_DEVICE -c auto_exposure_max=800

echo ""
echo "start gstreamer"
echo "==============="

gst-launch-1.0 \
	v4l2src num-buffers=$NUMBER_OF_PIC device=$VID_DEVICE ! \
	video/x-$COL_FORMAT$FRAME_SIZE ! \
	multifilesink location=ar0144_bayer.raw

echo "File \"mt9p006_bayer.raw\" ($COL_FORMAT$FRAME_SIZE)"	