#!/bin/sh
. `dirname $0`/../func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param



echo " starting gstreamer with $CAM_BW_FMT Source ..."
echo " read $SENSOR_RES (offset x,y=$OFFSET_SENSOR), encode2jpeg and write to file ar0144_mono_image.jpg"
echo " ==========================================================================================="
echo ""
echo " configure camera with v4l2_control"
echo " =================================="

v4l2-ctl -d $VID_DEVICE --set-fmt-video=pixelformat=$CAM_BW_FMT,$SENSOR_RES
v4l2-ctl -d $VID_DEVICE --set-selection=target=crop,$OFFSET_SENSOR,$SENSOR_RES
v4l2-ctl -d $VID_DEVICE -c auto_exposure_max=800

echo ""
echo " start gstreamer"
echo " ==============="

gst-launch-1.0 \
	v4l2src num-buffers=$NUMBER_OF_PIC device=$VID_DEVICE ! \
	video/x-raw,format=GRAY8,depth=8,$SENSOR_RES ! \
	videoconvert ! \
	jpegenc ! \
	multifilesink location=ar0144_mono_image.jpg