#!/bin/sh
. `dirname $0`/../func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

#echo 0 > /sys/class/graphics/fbcon/cursor_blink

SENSOR_RES_ROI="width=800,height=480"
OFFSET_SENSOR="left=240,top=164"

echo " ================================================================================="
echo " starting gstreamer with monochrome Source ..."
echo " read $SENSOR_RES_ROI (ROI in center of pic) and write to framebuffer"
echo " =========================================================================="
echo ""
echo " configure camera with v4l2_control"
echo " =================================="

v4l2-ctl -d $VID_DEVICE --set-fmt-video=pixelformat=$CAM_BW_FMT,$SENSOR_RES_ROI
v4l2-ctl -d $VID_DEVICE --set-selection=target=crop,$OFFSET_SENSOR,$SENSOR_RES_ROI
v4l2-ctl -d $VID_DEVICE -c auto_exposure_max=480

echo ""
echo " start gstreamer, break with ctl-C"
echo " ================================="

gst-launch-1.0 \
	v4l2src device=$VID_DEVICE ! \
	video/x-raw,format=GRAY8,depth=8,$SENSOR_RES_ROI ! \
	videoconvert ! \
	fbdevsink sync=true
#	kmssink driver-name="imx-drm" force-modesetting=false sync=true

v4l2-ctl -d $VID_DEVICE -c auto_exposure_max=800

#echo 1 > /sys/class/graphics/fbcon/cursor_blink