#!/bin/sh
. `dirname $0`/../func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param


echo " select resolution"
echo " ================="
echo " 1 = 1280 x 800 Full"
echo " 2 = 1280 x 720 HD, with ROI"
echo " 3 = 640  x 480 VGA, with ROI"
echo " 4 = 640  x 400 with Skip2"
echo " 5 = 640  x 400 with Skip2 and Binning (col/row average)"
echo " 6 = 640  x 400 with Skip2 and Binning (col summed / row average)"
read RESOLUTION
echo " Your select = $RESOLUTION"
case $RESOLUTION in
  "1") SENSOR_RES="width=1280,height=800"; FRAME_SIZE="width=1280,height=800"; OFFSET_SENSOR="left=0,top=4"; CTLS=( -c horizontal_skipping=0 -c vertical_skipping=0 -c row_binning=0 -c col_binning=0 );;
  "2") SENSOR_RES="width=1280,height=720"; FRAME_SIZE="width=1280,height=720"; OFFSET_SENSOR="left=0,top=44"; CTLS=( -c horizontal_skipping=0 -c vertical_skipping=0 -c row_binning=0 -c col_binning=0  );;
  "3") SENSOR_RES="width=640,height=480"; FRAME_SIZE="width=640,height=480"; OFFSET_SENSOR="left=320,top=164"; CTLS=( -c horizontal_skipping=0 -c vertical_skipping=0 -c row_binning=0 -c col_binning=0  );;
  "4") SENSOR_RES="width=1280,height=800"; FRAME_SIZE="width=640,height=400"; OFFSET_SENSOR="left=0,top=4"; CTLS=( -c horizontal_skipping=1 -c vertical_skipping=1 -c row_binning=0 -c col_binning=0  );;
  "5") SENSOR_RES="width=1280,height=800"; FRAME_SIZE="width=640,height=400"; OFFSET_SENSOR="left=0,top=4"; CTLS=( -c horizontal_skipping=1 -c vertical_skipping=1 -c row_binning=1 -c col_binning=1  );;
  "6") SENSOR_RES="width=1280,height=800"; FRAME_SIZE="width=640,height=400"; OFFSET_SENSOR="left=0,top=4"; CTLS=( -c horizontal_skipping=1 -c vertical_skipping=1 -c row_binning=1 -c col_binning=2  );;
  *) SENSOR_RES="width=1280,height=800"; FRAME_SIZE="width=1280,height=800"; OFFSET_SENSOR="left=0,top=4";;
esac

echo " starting gstreamer with $CAM_BW_FMT Source ..."
echo " read $FRAME_SIZE (offset x,y=$OFFSET_SENSOR) and write to framebuffer"
echo " =============================================================="
echo ""
echo " configure camera with v4l2_control"
echo " =================================="

v4l2-ctl -d $VID_DEVICE --set-fmt-video=pixelformat=$CAM_BW_FMT,$SENSOR_RES
v4l2-ctl -d $VID_DEVICE --set-selection=target=crop,$OFFSET_SENSOR,$SENSOR_RES
v4l2-ctl "${CTLS[@]}" -d "$VID_DEVICE"

Y_RES=${SENSOR_RES##*=}
v4l2-ctl -d $VID_DEVICE -c auto_exposure_max=$Y_RES

echo ""
echo " start gstreamer, break with ctl-C"
echo " ================================="

gst-launch-1.0 \
	v4l2src device=$VID_DEVICE ! \
	video/x-raw,format=GRAY8,depth=8,$FRAME_SIZE ! \
	videoconvert ! \
	fbdevsink sync=false
#	kmssink driver-name="imx-drm" force-modesetting=false sync=true

CTLS=( -c horizontal_skipping=0 -c vertical_skipping=0 -c row_binning=0 -c col_binning=0 )
v4l2-ctl "${CTLS[@]}" -d "$VID_DEVICE"