#!/bin/sh

init_dev() {

echo "====================================================================="

if [ -d /sys/bus/i2c/drivers/ar0144/?-00* ]; then
	CAMERA="VM-016(ar0144)"
	CAM_DRIVER="ar0144"
	CAM_I2C_ADRESS=$(find /sys/bus/i2c/drivers/ar0144/ -name "?-00*" | cut -d / -f 7 | cut -c5-6)
	CAM_I2C_BUS=$(find /sys/bus/i2c/drivers/ar0144/ -name "?-00*" | cut -d / -f 7 | cut -c1-1)
else
	echo "no camera driver loaded"
	echo "please check camera device tree" 
	echo ""
	return 1
fi

VID_DEVICE=`v4l2-ctl --list-devices | grep "/dev/" | cut -c 2-`

if [ "$VID_DEVICE" = "" ]; then
	echo "camera not found"
	echo "please check connected camera type, i2c adress and cable connections"
	echo ""
	return 1
fi

echo ""
echo " camera = $CAMERA at i2c bus=$CAM_I2C_BUS with i2c adress=0x$CAM_I2C_ADRESS installed"
echo " camera device name = $VID_DEVICE"
echo ""
return 0
}

guess_param() {
	COL_FORMAT="bayer,format=grbg,depth=8"
	NUMBER_OF_PIC="5"
	V4L2_CTRL_CAM0=""
	if [ $CAMERA = "VM-016(ar0144)" ]; then
#		FRAME_SIZE="width=1280,height=800"
#		REG_SET_FILE="$(dirname $0)/register-settings-ar0144.txt"
		SENSOR_RES="width=1280,height=800"
		SENSOR_RES_HD="width=1280,height=720"
		OFFSET_SENSOR="left=0,top=4"
		OFFSET_SENSOR_HD="left=0,top=44"
		CAM_BW_FMT="GREY"
		CAM_COL_FMT="GRBG"
		COL_FORMAT="bayer,format=grbg,depth=8"
		NUMBER_OF_PIC="5"
	else
		echo "No Camera found"
	fi
}
