#!/bin/sh
. `dirname $0`/func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param



echo " ================================================================================="
echo "starting gstreamer with COLOR (BAYER, YUV or RGB depend of camera typ) Source ..."
echo "read $SENSOR_RES (offset x,y=$OFFSET_SENSOR), write to file col_$CAMERA.raw"
echo "==========================================================================================="
echo ""
echo " configure camera with v4l2_control"
echo " =================================="

v4l2-ctl -d $VID_DEVICE --set-fmt-video=pixelformat=$CAM_COL_FMT,$SENSOR_RES
v4l2-ctl -d $VID_DEVICE --set-selection=target=crop,$OFFSET_SENSOR,$SENSOR_RES
$V4L2_CTRL_CAM0

echo ""
echo " start gstreamer"
echo " ==============="

gst-launch-1.0 \
	v4l2src num-buffers=$NUMBER_OF_PIC device=$VID_DEVICE ! \
	video/x-$COL_FORMAT,$SENSOR_RES ! \
	multifilesink location=col_$CAMERA.raw

echo "File \"col_$CAMERA.raw\" ($COL_FORMAT$SENSOR_SIZE)"