#!/bin/sh
. `dirname $0`/func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

#echo 0 > /sys/class/graphics/fbcon/cursor_blink

echo " ================================================================================="
echo " starting gstreamer with Monochrome Source ..."
echo " read $SENSOR_RES_HD (offset x,y=$OFFSET_SENSOR_HD), convert and write to framebuffer 1280x720"
echo " ================================================================================="
echo ""
echo " configure camera with v4l2_control"
echo " =================================="

v4l2-ctl -d $VID_DEVICE --set-fmt-video=pixelformat=$CAM_BW_FMT,$SENSOR_RES
v4l2-ctl -d $VID_DEVICE --set-selection=target=crop,$OFFSET_SENSOR_HD,$SENSOR_RES_HD
$V4L2_CTRL_CAM0

echo ""
echo " start gstreamer, break with ctl-C"
echo " ================================="

gst-launch-1.0 \
	v4l2src device=$VID_DEVICE ! \
	video/x-raw,format=GRAY8,depth=8,$SENSOR_RES_HD ! \
	videoconvert ! \
	fbdevsink sync=false
#	kmssink driver-name="imx-drm" force-modesetting=false sync=true render-rectangle="<0,0,1280,720>"
	
#echo 1 > /sys/class/graphics/fbcon/cursor_blink