#!/bin/bash

# [CR] #########################################################################
#   Copyright (c) 2025 IBV - Echtzeit- und Embedded GmbH & Co. KG
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   1. Redistributions of source code must retain the above copyright
#      notice, this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   3. Neither the name of the copyright holder nor the names of
#      its contributors may be used to endorse or promote products derived
#      from this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   “AS IS” AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
#   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
#   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
################################################################################

REMOTEPROC_BASE=/sys/devices/platform/bus@f4000/bus@f4000:r5fss@78000000/78000000.r5f/remoteproc
FIRMWARE=$1

# Check if path to firmware is provided as the first argument
if [ -z "$FIRMWARE" ]; then
    echo "Usage: $0 <firmware>"
    exit 1
fi


# Check if file exists
if [ ! -e "$FIRMWARE" ]; then
    echo "Error: File '$FIRMWARE' does not exist."
    exit 1
fi

# Resolve if relative
FW_ABS="$(realpath "$FIRMWARE")"

# Get path
FW_PATH="$(dirname "$FW_ABS")"

# Get filename
FW_FILENAME="$(basename "$FW_ABS")"


if [ -d "${REMOTEPROC_BASE}/remoteproc1" ]; then
  REMOTEPROC=remoteproc1
fi
if [ -d "${REMOTEPROC_BASE}/remoteproc0" ]; then
  REMOTEPROC=remoteproc0
fi

echo -n $FW_PATH > /sys/module/firmware_class/parameters/path
echo -n $FW_FILENAME > ${REMOTEPROC_BASE}/${REMOTEPROC}/firmware
echo -n start > ${REMOTEPROC_BASE}/${REMOTEPROC}/state

cat ${REMOTEPROC_BASE}/${REMOTEPROC}/state
