SUMMARY = "Provides both a high- and low-level interface to the HDF5 library from Python."
HOMEPAGE = "https://www.h5py.org/"
SECTION = "devel/python"
LICENSE = "BSD-3-Clause"
LIC_FILES_CHKSUM = "file://LICENSE;md5=113251d71fb0384712c719b567261c5c"

SRC_URI[sha256sum] = "d93adc48ceeb33347eb24a634fb787efc7ae4644e6ea4ba733d099605045c049"

SRC_URI += " \
    file://0001-setup_build.py-avoid-absolute-path.patch \
    file://0001-Fix-Cython-3-compatibility.patch \
    file://0001-Properly-cast-arguments-to-H5Lunpack_elink_val.patch \
    file://0002-Use-libc.stdint-instead-of-numpy.patch \
"

inherit pkgconfig pypi setuptools3

BBCLASSEXTEND = "native"

DEPENDS = "python3-pkgconfig-native \
           python3-cython-native \
           python3-numpy-native \
           python3-six-native \
           hdf5-native \
           python3 \
           hdf5 \
          "

PACKAGESPLITFUNCS =+ "fix_cythonized_sources"

fix_cythonized_sources() {
	for f in `grep -l -r -e '\/* Generated by Cython.*/$' ${PKGD}${TARGET_DBGSRC_DIR}`; do
		if [ -e $f ]; then
			sed -i -e 's#${RECIPE_SYSROOT_NATIVE}##g' $f
		fi
	done
}

RDEPENDS:${PN} = "python3-numpy \
                  python3-six \
                  python3-json \
                 "

export HDF5_VERSION="1.14.0"
