/*
*
* Copyright (c) {2015 - 2018} Texas Instruments Incorporated
*
* All rights reserved not granted herein.
*
* Limited License.
*
* Texas Instruments Incorporated grants a world-widef, royalty-freef, non-exclusive
* license under copyrights and patents it now or hereafter owns or controls to makef,
* have madef, usef, importf, offer to sell and sell ("Utilize") this software subject to the
* terms herein.  With respect to theforegoing patent licensef, such license is granted
* solely to the extent that any such patent is necessary to Utilize the software alone.
* The patent license shall not apply to any combinations which include this softwaref,
* other than combinations with devices manufactured by orfor TI ("TI Devices").
* No hardware patent is licensed hereunder.
*
* Redistributions must preserve existing copyright notices and reproduce this license
* (including the above copyright notice and the disclaimer and (if applicable) source
* code license limitations below) in the documentation and/or other materials provided
* with the distribution
*
* Redistribution and use in binaryformf, without modificationf, are permitted provided
* that thefollowing conditions are met:
*
* *       No reverse engineeringf, decompilationf, or disassembly of this software is
* permitted with respect to any software provided in binaryform.
*
* *       any redistribution and use are licensed by TIfor use only with TI Devices.
*
* *       Nothing shall obligate TI to provide you with source codefor the software
* licensed and provided to you in object code.
*
* If software source code is provided to youf, modification and redistribution of the
* source code are permitted provided that thefollowing conditions are met:
*
* *       any redistribution and use of the source codef, including any resulting derivative
* worksf, are licensed by TIfor use only with TI Devices.
*
* *       any redistribution and use of any object code compiledfrom the source code
* and any resulting derivative worksf, are licensed by TIfor use only with TI Devices.
*
* Neither the name of Texas Instruments Incorporated nor the names of its suppliers
*
* may be used to endorse or promote products derivedfrom this software without
* specific prior written permission.
*
* DISCLAIMER.
*
* THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
* OR IMPLIED WARRANTIESf, INCLUDINGf, BUT NOT LIMITED TOf, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY ANDfITNESSfOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLEfOR ANY DIRECTf, INDIRECTf,
* INCIDENTALf, SPECIALf, EXEMPLARYf, OR CONSEQUENTIAL DAMAGES (INCLUDINGf,
* BUT NOT LIMITED TOf, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USEf,
* DATAf, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
* OF LIABILITYf, WHETHER IN CONTRACTf, STRICT LIABILITYf, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWAREf, EVEN IF ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/

#include <../common/tiadalg_test_interface.h>


int16_t points_1[8*2] =
{
  40, 80, 120, 160, 200, 240, 255, 0,
  40, 80, 120, 160, 200, 240, 255, 0
};

int16_t points_2[8*2] =
{
  260, 182, 278, 221, 304, 268, 365, 103,
  260, 182, 278, 221, 304, 268, 365, 103
};

#define ANGLE_TABLE_ROWS (983)
uint16_t center_x = 640;
uint16_t center_y = 360;
float focal_length = 311.833f;
float angle_table[ANGLE_TABLE_ROWS][2] =
{
{0.0f,	0.0f         }, {0.1f,	0.100006314f }, {0.2f,	0.200055766f }, {0.3f,	0.300103997f }, {0.4f,	0.400106654f },
{0.5f,	0.500150616f }, {0.6f,	0.600147786f }, {0.7f,	0.700185042f }, {0.8f,	0.800218027f }, {0.9f,	0.900202399f },
{1.0f,	1.000225021f }, {1.1f,	1.100241546f }, {1.2f,	1.200251366f }, {1.3f,	1.300253872f }, {1.4f,	1.400248455f },
{1.5f,	1.500278224f }, {1.6f,	1.600255134f }, {1.7f,	1.700222297f }, {1.8f,	1.80022281f  }, {1.9f,	1.900212355f },
{2.0f,	2.00019032f  }, {2.1f,	2.100156104f }, {2.2f,	2.200109095f }, {2.3f,	2.30004869f  }, {2.4f,	2.400017956f },
{2.5f,	2.499972603f }, {2.6f,	2.599912025f }, {2.7f,	2.699835618f }, {2.8f,	2.799742779f }, {2.9f,	2.899632904f },
{3.0f,	2.999549019f }, {3.1f,	3.099446877f }, {3.2f,	3.199325874f }, {3.3f,	3.299229013f }, {3.4f,	3.399068481f },
{3.5f,	3.49893087f  }, {3.6f,	3.598771979f }, {3.7f,	3.698634774f }, {3.8f,	3.798475072f }, {3.9f,	3.898292273f },
{4.0f,	3.998085781f }, {4.1f,	4.097854999f }, {4.2f,	4.197642842f }, {4.3f,	4.29740518f  }, {4.4f,	4.397184909f },
{4.5f,	4.496937924f }, {4.6f,	4.596663628f }, {4.7f,	4.696361427f }, {4.8f,	4.796074173f }, {4.9f,	4.895801238f },
{5.0f,	4.995455159f }, {5.1f,	5.095122191f }, {5.2f,	5.194758317f }, {5.3f,	5.294406322f }, {5.4f,	5.394022217f },
{5.5f,	5.493648764f }, {5.6f,	5.593241998f }, {5.7f,	5.692801338f }, {5.8f,	5.7923695f   }, {5.9f,	5.891902572f },
{6.0f,	5.991399967f }, {6.1f,	6.090904364f }, {6.2f,	6.190415132f }, {6.3f,	6.289888422f }, {6.4f,	6.389323657f },
{6.5f,	6.488763448f }, {6.6f,	6.588207168f }, {6.7f,	6.68756788f  }, {6.8f,	6.786974476f }, {6.9f,	6.886340037f },
{7.0f,	6.985663992f }, {7.1f,	7.084988851f }, {7.2f,	7.184270928f }, {7.3f,	7.283552697f }, {7.4f,	7.382833534f },
{7.5f,	7.48206981f  }, {7.6f,	7.581260962f }, {7.7f,	7.680449389f }, {7.8f,	7.77963447f  }, {7.9f,	7.878772659f },
{8.0f,	7.977906298f }, {8.1f,	8.077034767f }, {8.2f,	8.176114585f }, {8.3f,	8.275145191f }, {8.4f,	8.374211675f },
{8.5f,	8.473184956f }, {8.6f,	8.572192874f }, {8.7f,	8.671149241f }, {8.8f,	8.770096237f }, {8.9f,	8.868990536f },
{9.0f,	8.96787428f  }, {9.1f,	9.066746848f }, {9.2f,	9.165564994f }, {9.3f,	9.264370786f }, {9.4f,	9.363163612f },
{9.5f,	9.461942859f }, {9.6f,	9.560665375f }, {9.7f,	9.659373139f }, {9.8f,	9.758023052f }, {9.9f,	9.856657042f },
{10.0f,	9.955274505f }, {10.1f,	10.05387483f }, {10.2f,	10.15245741f }, {10.3f,	10.25097929f }, {10.4f,	10.34948226f },
{10.5f,	10.44796572f }, {10.6f,	10.5463868f  }, {10.7f,	10.64478722f }, {10.8f,	10.74316638f }, {10.9f,	10.84152368f },
{11.0f,	10.93985852f }, {11.1f,	11.03812817f }, {11.2f,	11.13641633f }, {11.3f,	11.23463816f }, {11.4f,	11.3328352f  },
{11.5f,	11.43096482f }, {11.6f,	11.52911053f }, {11.7f,	11.6271877f  }, {11.8f,	11.72527971f }, {11.9f,	11.82330206f },
{12.0f,	11.92129613f }, {12.1f,	12.01926133f }, {12.2f,	12.11715526f }, {12.3f,	12.215061f   }, {12.4f,	12.31293612f },
{12.5f,	12.41073831f }, {12.6f,	12.50850877f }, {12.7f,	12.60628858f }, {12.8f,	12.70399382f }, {12.9f,	12.80166559f },
{13.0f,	12.89930333f }, {13.1f,	12.99690644f }, {13.2f,	13.09447437f }, {13.3f,	13.19200653f }, {13.4f,	13.28950236f },
{13.5f,	13.38696129f }, {13.6f,	13.48434137f }, {13.7f,	13.58172481f }, {13.8f,	13.67906964f }, {13.9f,	13.77637531f },
{14.0f,	13.87364123f }, {14.1f,	13.97082566f }, {14.2f,	14.06801046f }, {14.3f,	14.16515384f }, {14.4f,	14.26225525f },
{14.5f,	14.35931412f }, {14.6f,	14.45632991f }, {14.7f,	14.55330205f }, {14.8f,	14.65023f    }, {14.9f,	14.74711321f },
{15.0f,	14.84395113f }, {15.1f,	14.94078405f }, {15.2f,	15.03752971f }, {15.3f,	15.13426921f }, {15.4f,	15.23092044f },
{15.5f,	15.32756434f }, {15.6f,	15.42415962f }, {15.7f,	15.52070574f }, {15.8f,	15.61720217f }, {15.9f,	15.71364835f },
{16.0f,	15.81004378f }, {16.1f,	15.90642837f }, {16.2f,	16.00276106f }, {16.3f,	16.09900093f }, {16.4f,	16.19522827f },
{16.5f,	16.29144244f }, {16.6f,	16.38756226f }, {16.7f,	16.48362756f }, {16.8f,	16.579678f   }, {16.9f,	16.6756728f  },
{17.0f,	16.77161145f }, {17.1f,	16.8675335f  }, {17.2f,	16.96335826f }, {17.3f,	17.05916532f }, {17.4f,	17.15491411f },
{17.5f,	17.2506041f  }, {17.6f,	17.34627467f }, {17.7f,	17.44184555f }, {17.8f,	17.53739591f }, {17.9f,	17.63292513f },
{18.0f,	17.72835321f }, {18.1f,	17.82375907f }, {18.2f,	17.91910249f }, {18.3f,	18.01442255f }, {18.4f,	18.10963957f },
{18.5f,	18.20487164f }, {18.6f,	18.2999997f  }, {18.7f,	18.3951022f  }, {18.8f,	18.49009982f }, {18.9f,	18.58511013f },
{19.0f,	18.68001461f }, {19.1f,	18.77489134f }, {19.2f,	18.86973972f }, {19.3f,	18.96452002f }, {19.4f,	19.05923176f },
{19.5f,	19.15387449f }, {19.6f,	19.24848672f }, {19.7f,	19.34302894f }, {19.8f,	19.43753954f }, {19.9f,	19.53197912f },
{20.0f,	19.62634718f }, {20.1f,	19.72068206f }, {20.2f,	19.81494443f }, {20.3f,	19.90917254f }, {20.4f,	20.00332716f },
{20.5f,	20.09740784f }, {20.6f,	20.19145268f }, {20.7f,	20.28542262f }, {20.8f,	20.37935564f }, {20.9f,	20.47321277f },
{21.0f,	20.56703195f }, {21.1f,	20.66077427f }, {21.2f,	20.75447759f }, {21.3f,	20.8481031f  }, {21.4f,	20.94168856f },
{21.5f,	21.03519527f }, {21.6f,	21.12862282f }, {21.7f,	21.22204681f }, {21.8f,	21.31535265f }, {21.9f,	21.4086159f  },
{22.0f,	21.50183601f }, {22.1f,	21.59497459f }, {22.2f,	21.688069f   }, {22.3f,	21.78108099f }, {22.4f,	21.87404782f },
{22.5f,	21.9669313f  }, {22.6f,	22.05976863f }, {22.7f,	22.15255925f }, {22.8f,	22.24526515f }, {22.9f,	22.33792336f },
{23.0f,	22.43049598f }, {23.1f,	22.52301993f }, {23.2f,	22.61545741f }, {23.3f,	22.70784525f }, {23.4f,	22.80018295f },
{23.5f,	22.89243283f }, {23.6f,	22.98463161f }, {23.7f,	23.0767417f  }, {23.8f,	23.16879976f }, {23.9f,	23.26080523f },
{24.0f,	23.35272075f }, {24.1f,	23.44458275f }, {24.2f,	23.53639073f }, {24.3f,	23.62810746f }, {24.4f,	23.71976924f },
{24.5f,	23.81137559f }, {24.6f,	23.90288941f }, {24.7f,	23.99434688f }, {24.8f,	24.0857475f  }, {24.9f,	24.17705435f },
{25.0f,	24.26830347f }, {25.1f,	24.35949433f }, {25.2f,	24.45062647f }, {25.3f,	24.54166318f }, {25.4f,	24.63264028f },
{25.5f,	24.72352121f }, {25.6f,	24.8143777f  }, {25.7f,	24.90513715f }, {25.8f,	24.99583516f }, {25.9f,	25.08643537f },
{26.0f,	25.17697331f }, {26.1f,	25.26748428f }, {26.2f,	25.35786047f }, {26.3f,	25.44820876f }, {26.4f,	25.53845726f },
{26.5f,	25.62867683f }, {26.6f,	25.71876029f }, {26.7f,	25.80881388f }, {26.8f,	25.89880158f }, {26.9f,	25.9886876f  },
{27.0f,	26.07850692f }, {27.1f,	26.16825911f }, {27.2f,	26.2579437f  }, {27.3f,	26.34752514f }, {27.4f,	26.43707329f },
{27.5f,	26.5265175f  }, {27.6f,	26.61589247f }, {27.7f,	26.70519775f }, {27.8f,	26.79443291f }, {27.9f,	26.88356273f },
{28.0f,	26.97265643f }, {28.1f,	27.06164403f }, {28.2f,	27.15055992f }, {28.3f,	27.23940367f }, {28.4f,	27.32817484f },
{28.5f,	27.41687306f }, {28.6f,	27.50549787f }, {28.7f,	27.59401453f }, {28.8f,	27.68249138f }, {28.9f,	27.77085936f },
{29.0f,	27.85915243f }, {29.1f,	27.94737017f }, {29.2f,	28.03554627f }, {29.3f,	28.12361211f }, {29.4f,	28.21160145f },
{29.5f,	28.29947996f }, {29.6f,	28.38731513f }, {29.7f,	28.47507263f }, {29.8f,	28.56275204f }, {29.9f,	28.65031931f },
{30.0f,	28.73784148f }, {30.1f,	28.82525085f }, {30.2f,	28.91261427f }, {30.3f,	28.99986424f }, {30.4f,	29.0870674f  },
{30.5f,	29.17415649f }, {30.6f,	29.26119792f }, {30.7f,	29.34812466f }, {30.8f,	29.43496971f }, {30.9f,	29.52176583f },
{31.0f,	29.60844638f }, {31.1f,	29.69504415f }, {31.2f,	29.78159176f }, {31.3f,	29.86802289f }, {31.4f,	29.95437022f },
{31.5f,	30.04066618f }, {31.6f,	30.12684478f }, {31.7f,	30.21297123f }, {31.8f,	30.29897976f }, {31.9f,	30.38493536f },
{32.0f,	30.47077248f }, {32.1f,	30.55655588f }, {32.2f,	30.64225266f }, {32.3f,	30.7278625f  }, {32.4f,	30.81335281f },
{32.5f,	30.89878786f }, {32.6f,	30.98413501f }, {32.7f,	31.06939395f }, {32.8f,	31.15456435f }, {32.9f,	31.23964591f },
{33.0f,	31.32467026f }, {33.1f,	31.40957316f }, {33.2f,	31.49438631f }, {33.3f,	31.57914115f }, {33.4f,	31.66380552f },
{33.5f,	31.7483475f  }, {33.6f,	31.83283011f }, {33.7f,	31.91722136f }, {33.8f,	32.00152099f }, {33.9f,	32.08572868f },
{34.0f,	32.16987552f }, {34.1f,	32.25389848f }, {34.2f,	32.33785989f }, {34.3f,	32.42169698f }, {34.4f,	32.50547186f },
{34.5f,	32.58915305f }, {34.6f,	32.67274025f }, {34.7f,	32.75626418f }, {34.8f,	32.8396626f  }, {34.9f,	32.92299709f },
{35.0f,	33.00620567f }, {35.1f,	33.08934969f }, {35.2f,	33.17242872f }, {35.3f,	33.25538114f }, {35.4f,	33.33823742f },
{35.5f,	33.42102778f }, {35.6f,	33.5037214f  }, {35.7f,	33.58631801f }, {35.8f,	33.6688174f  }, {35.9f,	33.75121931f },
{36.0f,	33.83355371f }, {36.1f,	33.91579006f }, {36.2f,	33.99792814f }, {36.3f,	34.07996769f }, {36.4f,	34.16193847f },
{36.5f,	34.24378029f }, {36.6f,	34.32555278f }, {36.7f,	34.40722575f }, {36.8f,	34.48879901f }, {36.9f,	34.57030198f },
{37.0f,	34.6517047f  }, {37.1f,	34.73300695f }, {37.2f,	34.81420852f }, {37.3f,	34.89533865f }, {37.4f,	34.97633822f },
{37.5f,	35.05726582f }, {37.6f,	35.13812108f }, {37.7f,	35.21884526f }, {37.8f,	35.2994966f  }, {37.9f,	35.38004566f },
{38.0f,	35.46049226f }, {38.1f,	35.54086518f }, {38.2f,	35.62113515f }, {38.3f,	35.701302f   }, {38.4f,	35.78136555f },
{38.5f,	35.86135435f }, {38.6f,	35.94123939f }, {38.7f,	36.02102049f }, {38.8f,	36.10069749f }, {38.9f,	36.18029874f },
{39.0f,	36.25979543f }, {39.1f,	36.33921579f }, {39.2f,	36.41850285f }, {39.3f,	36.49771316f }, {39.4f,	36.5768464f  },
{39.5f,	36.65584591f }, {39.6f,	36.73476794f }, {39.7f,	36.81358411f }, {39.8f,	36.89232226f }, {39.9f,	36.97095415f },
{40.0f,	37.04947965f }, {40.1f,	37.12792643f }, {40.2f,	37.20623867f }, {40.3f,	37.28449948f }, {40.4f,	37.3626255f  },
{40.5f,	37.44067192f }, {40.6f,	37.51861091f }, {40.7f,	37.59646982f }, {40.8f,	37.67419356f }, {40.9f,	37.75186419f },
{41.0f,	37.8293994f  }, {41.1f,	37.9068537f  }, {41.2f,	37.98419965f }, {41.3f,	38.06146423f }, {41.4f,	38.13862011f },
{41.5f,	38.2156672f  }, {41.6f,	38.29263231f }, {41.7f,	38.3694883f  }, {41.8f,	38.44623506f }, {41.9f,	38.52289927f },
{42.0f,	38.59945394f }, {42.1f,	38.67592565f }, {42.2f,	38.75228751f }, {42.3f,	38.82853945f }, {42.4f,	38.90468137f },
{42.5f,	38.98073963f }, {42.6f,	39.05671397f }, {42.7f,	39.13257782f }, {42.8f,	39.20833109f }, {42.9f,	39.28397372f },
{43.0f,	39.35953177f }, {43.1f,	39.43497891f }, {43.2f,	39.51034111f }, {43.3f,	39.58559214f }, {43.4f,	39.66075787f },
{43.5f,	39.73581219f }, {43.6f,	39.81075504f }, {43.7f,	39.88561211f }, {43.8f,	39.96035748f }, {43.9f,	40.03499108f },
{44.0f,	40.10953847f }, {44.1f,	40.18397386f }, {44.2f,	40.2583227f  }, {44.3f,	40.33255934f }, {44.4f,	40.40670911f },
{44.5f,	40.48074649f }, {44.6f,	40.55467142f }, {44.7f,	40.62850907f }, {44.8f,	40.70223408f }, {44.9f,	40.77584642f },
{45.0f,	40.84939612f }, {45.1f,	40.92280788f }, {45.2f,	40.99613167f }, {45.3f,	41.06934244f }, {45.4f,	41.14246498f },
{45.5f,	41.21547431f }, {45.6f,	41.28839514f }, {45.7f,	41.36120263f }, {45.8f,	41.43389674f }, {45.9f,	41.506502f   },
{46.0f,	41.57899375f }, {46.1f,	41.6513964f  }, {46.2f,	41.7236854f  }, {46.3f,	41.79586074f }, {46.4f,	41.86794666f },
{46.5f,	41.939943f   }, {46.6f,	42.01182544f }, {46.7f,	42.08359397f }, {46.8f,	42.15527262f }, {46.9f,	42.22683726f },
{47.0f,	42.29831181f }, {47.1f,	42.36967223f }, {47.2f,	42.44091854f }, {47.3f,	42.51207448f }, {47.4f,	42.58313995f },
{47.5f,	42.65406742f }, {47.6f,	42.72492793f }, {47.7f,	42.79565047f }, {47.8f,	42.86630574f }, {47.9f,	42.93682309f },
{48.0f,	43.00724948f }, {48.1f,	43.07758476f }, {48.2f,	43.14780554f }, {48.3f,	43.2179118f  }, {48.4f,	43.28792677f },
{48.5f,	43.35782718f }, {48.6f,	43.42763613f }, {48.7f,	43.49733047f }, {48.8f,	43.5669332f  }, {48.9f,	43.63642129f },
{49.0f,	43.70579475f }, {49.1f,	43.77507644f }, {49.2f,	43.84426623f }, {49.3f,	43.9133186f  }, {49.4f,	43.98230171f },
{49.5f,	44.05114747f }, {49.6f,	44.11992373f }, {49.7f,	44.18856272f }, {49.8f,	44.25710956f }, {49.9f,	44.32556413f },
{50.0f,	44.39390396f }, {50.1f,	44.46212913f }, {50.2f,	44.53026191f }, {50.3f,	44.59828002f }, {50.4f,	44.66620564f },
{50.5f,	44.7340166f  }, {50.6f,	44.80173498f }, {50.7f,	44.8693387f  }, {50.8f,	44.93682785f }, {50.9f,	45.00422432f },
{51.0f,	45.07152806f }, {51.1f,	45.13869541f }, {51.2f,	45.20579177f }, {51.3f,	45.27275188f }, {51.4f,	45.3396192f  },
{51.5f,	45.40639364f }, {51.6f,	45.47305362f }, {51.7f,	45.53959921f }, {51.8f,	45.60605187f }, {51.9f,	45.67239019f },
{52.0f,	45.73863555f }, {52.1f,	45.80476662f }, {52.2f,	45.87080467f }, {52.3f,	45.93670733f }, {52.4f,	46.00253815f },
{52.5f,	46.06825479f }, {52.6f,	46.13385735f }, {52.7f,	46.1993459f  }, {52.8f,	46.26474144f }, {52.9f,	46.33004391f },
{53.0f,	46.39523243f }, {53.1f,	46.4603071f  }, {53.2f,	46.5252887f  }, {53.3f,	46.59015655f }, {53.4f,	46.65491073f },
{53.5f,	46.71957187f }, {53.6f,	46.78411943f }, {53.7f,	46.84857397f }, {53.8f,	46.91291502f }, {53.9f,	46.97714268f },
{54.0f,	47.04127736f }, {54.1f,	47.10531903f }, {54.2f,	47.16922719f }, {54.3f,	47.23304244f }, {54.4f,	47.29674462f },
{54.5f,	47.36035389f }, {54.6f,	47.42385021f }, {54.7f,	47.48725365f }, {54.8f,	47.55054425f }, {54.9f,	47.61372212f },
{55.0f,	47.67678736f }, {55.1f,	47.73975987f }, {55.2f,	47.80263964f }, {55.3f,	47.86538722f }, {55.4f,	47.9280422f  },
{55.5f,	47.99060451f }, {55.6f,	48.05303505f }, {55.7f,	48.11537307f }, {55.8f,	48.17761855f }, {55.9f,	48.23973266f },
{56.0f,	48.30175437f }, {56.1f,	48.36368367f }, {56.2f,	48.425482f   }, {56.3f,	48.48718807f }, {56.4f,	48.54880185f },
{56.5f,	48.61028508f }, {56.6f,	48.67167619f }, {56.7f,	48.73295612f }, {56.8f,	48.794144f   }, {56.9f,	48.85522086f },
{57.0f,	48.91618683f }, {57.1f,	48.97704205f }, {57.2f,	49.03778665f }, {57.3f,	49.0984395f  }, {57.4f,	49.15900061f },
{57.5f,	49.21943264f }, {57.6f,	49.27977309f }, {57.7f,	49.33998483f }, {57.8f,	49.40012369f }, {57.9f,	49.46013411f },
{58.0f,	49.52005321f }, {58.1f,	49.57984423f }, {58.2f,	49.63954412f }, {58.3f,	49.69915289f }, {58.4f,	49.75863403f },
{58.5f,	49.81802424f }, {58.6f,	49.87730535f }, {58.7f,	49.9364775f  }, {58.8f,	49.99554084f }, {58.9f,	50.05451354f },
{59.0f,	50.11335963f }, {59.1f,	50.17211527f }, {59.2f,	50.23076259f }, {59.3f,	50.28930172f }, {59.4f,	50.3477328f  },
{59.5f,	50.40607375f }, {59.6f,	50.46428913f }, {59.7f,	50.52241459f }, {59.8f,	50.58043251f }, {59.9f,	50.63832542f },
{60.0f,	50.69612872f }, {60.1f,	50.75382492f }, {60.2f,	50.81141416f }, {60.3f,	50.86891402f }, {60.4f,	50.92628975f },
{60.5f,	50.98355898f }, {60.6f,	51.04073915f }, {60.7f,	51.09779577f }, {60.8f,	51.15474635f }, {60.9f,	51.21160819f },
{61.0f,	51.26834707f }, {61.1f,	51.32499744f }, {61.2f,	51.38152524f }, {61.3f,	51.43796476f }, {61.4f,	51.49428209f },
{61.5f,	51.55051137f }, {61.6f,	51.60661885f }, {61.7f,	51.66262167f }, {61.8f,	51.71853677f }, {61.9f,	51.77433067f },
{62.0f,	51.83002038f }, {62.1f,	51.88560604f }, {62.2f,	51.94108781f }, {62.3f,	51.99644927f }, {62.4f,	52.05172378f },
{62.5f,	52.10689487f }, {62.6f,	52.16194624f }, {62.7f,	52.2168946f  }, {62.8f,	52.2717401f  }, {62.9f,	52.3264829f  },
{63.0f,	52.38110686f }, {63.1f,	52.43564477f }, {63.2f,	52.49006425f }, {63.3f,	52.54438175f }, {63.4f,	52.59859742f },
{63.5f,	52.65269534f }, {63.6f,	52.70669184f }, {63.7f,	52.76058707f }, {63.8f,	52.81436523f }, {63.9f,	52.86805848f },
{64.0f,	52.92161914f }, {64.1f,	52.97509521f }, {64.2f,	53.02845507f }, {64.3f,	53.08171481f }, {64.4f,	53.13485883f },
{64.5f,	53.18790311f }, {64.6f,	53.24084783f }, {64.7f,	53.2936775f  }, {64.8f,	53.34639242f }, {64.9f,	53.39902395f },
{65.0f,	53.45152562f }, {65.1f,	53.50392876f }, {65.2f,	53.55623353f }, {65.3f,	53.60842469f }, {65.4f,	53.6605179f  },
{65.5f,	53.71249797f }, {65.6f,	53.7643652f  }, {65.7f,	53.8161351f  }, {65.8f,	53.86779262f }, {65.9f,	53.91935321f },
{66.0f,	53.97078677f }, {66.1f,	54.02213898f }, {66.2f,	54.0733647f  }, {66.3f,	54.12449436f }, {66.4f,	54.17551316f },
{66.5f,	54.22642134f }, {66.6f,	54.27721919f }, {66.7f,	54.32792186f }, {66.8f,	54.37851465f }, {66.9f,	54.42899787f },
{67.0f,	54.47937176f }, {67.1f,	54.52963661f }, {67.2f,	54.57979267f }, {67.3f,	54.62985489f }, {67.4f,	54.67979417f },
{67.5f,	54.72964007f }, {67.6f,	54.77936363f }, {67.7f,	54.82899429f }, {67.8f,	54.87850322f }, {67.9f,	54.92790526f },
{68.0f,	54.97720065f }, {68.1f,	55.02640405f }, {68.2f,	55.07548694f }, {68.3f,	55.12444969f }, {68.4f,	55.1733212f  },
{68.5f,	55.22207318f }, {68.6f,	55.27073437f }, {68.7f,	55.31926244f }, {68.8f,	55.36770027f }, {68.9f,	55.41601981f },
{69.0f,	55.46423548f }, {69.1f,	55.51234755f }, {69.2f,	55.5603423f  }, {69.3f,	55.60823403f }, {69.4f,	55.65600908f },
{69.5f,	55.7036817f  }, {69.6f,	55.75123829f }, {69.7f,	55.79869304f }, {69.8f,	55.84603241f }, {69.9f,	55.8932705f  },
{70.0f,	55.94039386f }, {70.1f,	55.98740283f }, {70.2f,	56.03431143f }, {70.3f,	56.08110629f }, {70.4f,	56.12778775f },
{70.5f,	56.17435616f }, {70.6f,	56.22082541f }, {70.7f,	56.26716875f }, {70.8f,	56.31341356f }, {70.9f,	56.35954664f },
{71.0f,	56.40556835f }, {71.1f,	56.45147902f }, {71.2f,	56.49727901f }, {71.3f,	56.54296865f }, {71.4f,	56.58854828f },
{71.5f,	56.63401825f }, {71.6f,	56.67936569f }, {71.7f,	56.72461736f }, {71.8f,	56.76974724f }, {71.9f,	56.81476886f },
{72.0f,	56.85966949f }, {72.1f,	56.90447563f }, {72.2f,	56.94916149f }, {72.3f,	56.99372751f }, {72.4f,	57.03818706f },
{72.5f,	57.08254044f }, {72.6f,	57.12677513f }, {72.7f,	57.17089152f }, {72.8f,	57.21490286f }, {72.9f,	57.25880948f },
{73.0f,	57.30258615f }, {73.1f,	57.34625886f }, {73.2f,	57.38982794f }, {73.3f,	57.43326833f }, {73.4f,	57.4765932f  },
{73.5f,	57.51981555f }, {73.6f,	57.56292312f }, {73.7f,	57.60591631f }, {73.8f,	57.64879552f }, {73.9f,	57.69154865f },
{74.0f,	57.73420112f }, {74.1f,	57.77674081f }, {74.2f,	57.8191557f  }, {74.3f,	57.86145865f }, {74.4f,	57.90365004f },
{74.5f,	57.94573028f }, {74.6f,	57.98768745f }, {74.7f,	58.0295343f  }, {74.8f,	58.07125897f }, {74.9f,	58.11287413f },
{75.0f,	58.15436799f }, {75.1f,	58.19575317f }, {75.2f,	58.23701792f }, {75.3f,	58.27817479f }, {75.4f,	58.3192121f  },
{75.5f,	58.36013031f }, {75.6f,	58.40092985f }, {75.7f,	58.4416112f  }, {75.8f,	58.48218675f }, {75.9f,	58.52263302f },
{76.0f,	58.56297434f }, {76.1f,	58.60318732f }, {76.2f,	58.64328434f }, {76.3f,	58.68327765f }, {76.4f,	58.72313223f },
{76.5f,	58.76288398f }, {76.6f,	58.80250979f }, {76.7f,	58.84203357f }, {76.8f,	58.88142064f }, {76.9f,	58.92069489f },
{77.0f,	58.95985675f }, {77.1f,	58.99889504f }, {77.2f,	59.03781027f }, {77.3f,	59.07661448f }, {77.4f,	59.11529656f },
{77.5f,	59.15385702f }, {77.6f,	59.19230781f }, {77.7f,	59.23062645f }, {77.8f,	59.26883635f }, {77.9f,	59.30692652f },
{78.0f,	59.34488607f }, {78.1f,	59.38273826f }, {78.2f,	59.42046083f }, {78.3f,	59.45806565f }, {78.4f,	59.49555317f },
{78.5f,	59.53291262f }, {78.6f,	59.57016699f }, {78.7f,	59.60728308f }, {78.8f,	59.64428385f }, {78.9f,	59.68116975f },
{79.0f,	59.71793012f }, {79.1f,	59.75457659f }, {79.2f,	59.79108747f }, {79.3f,	59.82748544f }, {79.4f,	59.86375993f },
{79.5f,	59.89992247f }, {79.6f,	59.93595153f }, {79.7f,	59.97185867f }, {79.8f,	60.00764437f }, {79.9f,	60.04332007f },
{80.0f,	60.07886444f }, {80.1f,	60.11427802f }, {80.2f,	60.14958309f }, {80.3f,	60.18475842f }, {80.4f,	60.21981539f },
{80.5f,	60.25474369f }, {80.6f,	60.28954391f }, {80.7f,	60.32423803f }, {80.8f,	60.35879437f }, {80.9f,	60.3932349f  },
{81.0f,	60.42754945f }, {81.1f,	60.46173854f }, {81.2f,	60.49581334f }, {81.3f,	60.52975314f }, {81.4f,	60.56357967f },
{81.5f,	60.5972723f  }, {81.6f,	60.63084214f }, {81.7f,	60.66428973f }, {81.8f,	60.69761558f }, {81.9f,	60.73082021f },
{82.0f,	60.7638937f  }, {82.1f,	60.79684704f }, {82.2f,	60.82968074f }, {82.3f,	60.86238493f }, {82.4f,	60.89496019f },
{82.5f,	60.9274174f  }, {82.6f,	60.95974674f }, {82.7f,	60.99194879f }, {82.8f,	61.02403436f }, {82.9f,	61.05598343f },
{83.0f,	61.08781709f }, {83.1f,	61.11951538f }, {83.2f,	61.1510993f  }, {83.3f,	61.18255915f }, {83.4f,	61.21388531f },
{83.5f,	61.2450885f  }, {83.6f,	61.27616926f }, {83.7f,	61.30712811f }, {83.8f,	61.3379555f  }, {83.9f,	61.36865201f },
{84.0f,	61.39922823f }, {84.1f,	61.42968469f }, {84.2f,	61.4600119f  }, {84.3f,	61.49021042f }, {84.4f,	61.52029077f },
{84.5f,	61.55024352f }, {84.6f,	61.58006921f }, {84.7f,	61.6097684f  }, {84.8f,	61.63934163f }, {84.9f,	61.66878945f },
{85.0f,	61.6981124f  }, {85.1f,	61.72730119f }, {85.2f,	61.75637601f }, {85.3f,	61.78531777f }, {85.4f,	61.81413682f },
{85.5f,	61.84283368f }, {85.6f,	61.87139915f }, {85.7f,	61.89984349f }, {85.8f,	61.92815754f }, {85.9f,	61.95635153f },
{86.0f,	61.98441631f }, {86.1f,	62.01505973f }, {86.2f,	62.04342878f }, {86.3f,	62.06786012f }, {86.4f,	62.09542314f },
{86.5f,	62.12286921f }, {86.6f,	62.15017974f }, {86.7f,	62.17736484f }, {86.8f,	62.20442505f }, {86.9f,	62.23136088f },
{87.0f,	62.25817287f }, {87.1f,	62.28486153f }, {87.2f,	62.31142739f }, {87.3f,	62.33786151f }, {87.4f,	62.36417389f },
{87.5f,	62.39035563f }, {87.6f,	62.41641665f }, {87.7f,	62.44235747f }, {87.8f,	62.46816922f }, {87.9f,	62.49385246f },
{88.0f,	62.51941703f }, {88.1f,	62.54485412f }, {88.2f,	62.57016426f }, {88.3f,	62.59535725f }, {88.4f,	62.62041506f },
{88.5f,	62.64535672f }, {88.6f,	62.67017349f }, {88.7f,	62.69486588f }, {88.8f,	62.71943439f }, {88.9f,	62.74387954f },
{89.0f,	62.76820182f }, {89.1f,	62.79240174f }, {89.2f,	62.81647065f }, {89.3f,	62.84041822f }, {89.4f,	62.86424493f },
/* there is discontinuity of data after 89.7. 89.8, 90.0, 90.1 are missing*/
{89.5f,	62.88795125f }, {89.6f,	62.91153769f }, {89.7f,	62.93499564f }, {89.9f,	62.95832564f }, {90.2f,	63.0504392f  },
{90.3f,	63.07316388f }, {90.4f,	63.09577249f }, {90.5f,	63.11824762f }, {90.6f,	63.14060765f }, {90.7f,	63.16197977f },
{90.8f,	63.1846624f  }, {90.9f,	63.20734857f }, {91.0f,	63.22882575f }, {91.1f,	63.25058157f }, {91.2f,	63.27220731f },
{91.3f,	63.29372116f }, {91.4f,	63.31511472f }, {91.5f,	63.33637963f }, {91.6f,	63.35753398f }, {91.7f,	63.37856062f },
{91.8f,	63.39947757f }, {91.9f,	63.42026773f }, {92.0f,	63.44094031f }, {92.1f,	63.46149576f }, {92.2f,	63.4819258f  },
{92.3f,	63.50223959f }, {92.4f,	63.52243757f }, {92.5f,	63.54252017f }, {92.6f,	63.56247912f }, {92.7f,	63.58232356f },
{92.8f,	63.60204523f }, {92.9f,	63.62165324f }, {93.0f,	63.64114798f }, {93.1f,	63.66052125f }, {93.2f,	63.67978209f },
{93.3f,	63.69892232f }, {93.4f,	63.71794235f }, {93.5f,	63.73685119f }, {93.6f,	63.75564068f }, {93.7f,	63.77431977f },
{93.8f,	63.79288031f }, {93.9f,	63.81132273f }, {94.0f,	63.82965595f }, {94.1f,	63.84787184f }, {94.2f,	63.86597081f },
{94.3f,	63.88395325f }, {94.4f,	63.90182804f }, {94.5f,	63.91958708f }, {94.6f,	63.93723077f }, {94.7f,	63.95475949f },
{94.8f,	63.97218206f }, {94.9f,	63.989482f   }, {95.0f,	64.00667653f }, {95.1f,	64.02375759f }, {95.2f,	64.04072558f },
{95.3f,	64.05758085f }, {95.4f,	64.07432377f }, {95.5f,	64.09095472f }, {95.6f,	64.10747405f }, {95.7f,	64.12389045f },
{95.8f,	64.14018762f }, {95.9f,	64.15637423f }, {96.0f,	64.17245895f }, {96.1f,	64.1884255f  }, {96.2f,	64.20428255f },
{96.3f,	64.22385034f }, {96.4f,	64.23567777f }, {96.5f,	64.25120834f }, {96.6f,	64.26663075f }, {96.7f,	64.28194534f },
{96.8f,	64.29715244f }, {96.9f,	64.31225236f }, {97.0f,	64.32724544f }, {97.1f,	64.34213198f }, {97.2f,	64.35690412f },
{97.3f,	64.37157857f }, {97.4f,	64.38613926f }, {97.5f,	64.40059468f }, {97.6f,	64.41494515f }, {97.7f,	64.42919098f },
{97.8f,	64.44333245f }, {97.9f,	64.45736987f }, {98.0f,	64.47130354f }, {98.1f,	64.48512563f }, {98.2f,	64.49884456f },
{98.3f,	64.51246063f }, {98.4f,	64.52597411f }, {98.5f,	64.53938529f }
};

typedef struct {
    int16_t *in_points;
    int16_t *ref_out_points;
    int32_t  num_points;
    uint16_t in_center_x;
    uint16_t in_center_y;
    float focal_length;
    uint16_t out_center_x;
    uint16_t out_center_y;
    float    (*angle_table)[2];
    int32_t  num_table_row;
    int32_t  isTableRev;
}tiadalg_fisheye_transformation_testParams_t;

static tiadalg_fisheye_transformation_testParams_t test_cases[] =
{
  {
   points_1,
   points_2,
   8,
   center_x,
   center_y,
   focal_length,
   center_x,
   center_y,
   angle_table,
   ANGLE_TABLE_ROWS,
   0
  }

};

