/*
*
* Copyright (c) {2015 - 2018} Texas Instruments Incorporated
*
* All rights reserved not granted herein.
*
* Limited License.
*
* Texas Instruments Incorporated grants a world-wide, royalty-free, non-exclusive
* license under copyrights and patents it now or hereafter owns or controls to make,
* have made, use, import, offer to sell and sell ("Utilize") this software subject to the
* terms herein.  With respect to the foregoing patent license, such license is granted
* solely to the extent that any such patent is necessary to Utilize the software alone.
* The patent license shall not apply to any combinations which include this software,
* other than combinations with devices manufactured by or for TI ("TI Devices").
* No hardware patent is licensed hereunder.
*
* Redistributions must preserve existing copyright notices and reproduce this license
* (including the above copyright notice and the disclaimer and (if applicable) source
* code license limitations below) in the documentation and/or other materials provided
* with the distribution
*
* Redistribution and use in binary form, without modification, are permitted provided
* that the following conditions are met:
*
* *       No reverse engineering, decompilation, or disassembly of this software is
* permitted with respect to any software provided in binary form.
*
* *       any redistribution and use are licensed by TI for use only with TI Devices.
*
* *       Nothing shall obligate TI to provide you with source code for the software
* licensed and provided to you in object code.
*
* If software source code is provided to you, modification and redistribution of the
* source code are permitted provided that the following conditions are met:
*
* *       any redistribution and use of the source code, including any resulting derivative
* works, are licensed by TI for use only with TI Devices.
*
* *       any redistribution and use of any object code compiled from the source code
* and any resulting derivative works, are licensed by TI for use only with TI Devices.
*
* Neither the name of Texas Instruments Incorporated nor the names of its suppliers
*
* may be used to endorse or promote products derived from this software without
* specific prior written permission.
*
* DISCLAIMER.
*
* THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/**
@file      tiadalg_dof_plane_seperation.h
@brief     This file defines the interface for creating three plane output from packed output from DOF h/w
@version 0.1 Sep 2018 : Initial Code
*/

/** @ingroup    TIADALG_DOF_PLANE_SEPERATION_H */
/*@{*/
#ifndef TIADALG_DOF_PALNE_SEPERATION_H
#define TIADALG_DOF_PALNE_SEPERATION_H
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif
/**
 * @func tiadalg_dof_plane_seperation_cn
 *
 * @brief It does 3 plane creation from raw Dense Optical Flow (DOF) generated by DMPACK hardware accelerator.
 * This API is intended to do generate 3 planes of Dof to be used in Deep Learning networks. First plane is 8-bit
 * horizontal flow vector, second plane is 8-bit vertical flow vector, and last plane is 8-bit confidence for flow
 * vectors.
 *
 * @param dof_plane      [in] : Input row buffer given out by dof hardware accelerator
 * @param img_width      [in] : Width of image for which flow vector has been provided
 * @param img_height     [in] : Height of image for which flow vector is provided
 * @param out_data_type  [in] : Output plane data type. Currently only U08 is supported
 * @param pad_pixel      [in] : Padding of the output plane. 4 values for Left, Top, Right, Bottom needs to be provided.
 * @param out_rgb_planes [in] : Buffer for output RGB plane.
 * @param out_yuv_planes [in] : Buffer for output semi-planer yuv 420 planes.
 *
 * @note
 * - User should allocate output buffer and it should be of size (img_width + pad_pixel[0] + pad_pixel[2])*
 *   (img_height + pad_pixel[1] + pad_pixel[3]) for out_data_type of U08.
 * - Size of the input buffer should be \ref img_width x \ref img_height
 */

  int32_t tiadalg_dof_plane_seperation_cn(uint32_t* dof_plane,
    int32_t img_width, int32_t img_height,
    int32_t out_data_type, int32_t pad_pixel[4],
    void* out_rgb_planes,
    void* out_yuv_planes);

/**
 * @func tiadalg_dof_plane_seperation_c66
 *
 * @brief It does 3 plane creation from raw Dense Optical Flow (DOF) generated by DMPACK hardware accelerator.
 * This API is intended to do generate 3 planes of Dof to be used in Deep Learning networks. First plane is 8-bit
 * horizontal flow vector, second plane is 8-bit vertical flow vector, and last plane is 8-bit confidence for flow
 * vectors.
 *
 * @param dof_plane      [in] : Input row buffer given out by dof hardware accelerator
 * @param img_width      [in] : Width of image for which flow vector has been provided
 * @param img_height     [in] : Height of image for which flow vector is provided
 * @param out_data_type  [in] : Output plane data type. Currently only U08 is supported
 * @param pad_pixel      [in] : Padding of the output plane. 4 values for Left, Top, Right, Bottom needs to be provided.
 * @param out_rgb_planes [in] : Buffer for output RGB plane.
 * @param out_yuv_planes [in] : Buffer for output semi-planer yuv 420 planes.
 *
 * @note
 * - User should allocate output buffer and it should be of size (img_width + pad_pixel[0] + pad_pixel[2])*
 *   (img_height + pad_pixel[1] + pad_pixel[3]) for out_data_type of U08.
 * - Size of the input buffer should be \ref img_width x \ref img_height
 */

  int32_t tiadalg_dof_plane_seperation_c66(uint32_t* dof_plane,
    int32_t img_width, int32_t img_height,
    int32_t out_data_type, int32_t pad_pixel[4],
    void* out_rgb_planes,
    void* out_yuv_planes);
    
#ifdef __cplusplus
}
#endif

#endif
/*@}*/
/* TIADALG_DOF_PLANE_SEPERATION_H */
