/*
 *  Copyright (C) 2022 Texas Instruments Incorporated - http://www.ti.com/
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* Module headers. */
#include <edgeai_nv12_font_utils.h>

//BitMap for fonts of diffrent sizes
uint32_t font_ANDALEMO_12x18[95][7] = {
                                        {0x0,0x300300,0x2003003,0x20,0x300300,0x0,0x0},
                                        {0x0,0x480480,0x4004,0x0,0x0,0x0,0x0},
                                        {0x0,0x900900,0x481fc09,0x481fc048,0x240280,0x0,0x0},
                                        {0x20000000,0x80280700,0x3002802,0xa00a0060,0x780e00,0x2,0x0},
                                        {0x0,0x205408c0,0x3c03605,0x281300f0,0xc41281,0x0,0x0},
                                        {0x0,0x80480380,0x11802804,0xc40a41bc,0x1380c40,0x0,0x0},
                                        {0x0,0x200200,0x2002,0x0,0x0,0x0,0x0},
                                        {0x0,0x400000,0x1002002,0x10010010,0x200200,0x4,0x0},
                                        {0x0,0x100080,0x2002001,0x20020020,0x100200,0x801,0x0},
                                        {0x0,0x780200,0x2007803,0x0,0x0,0x0,0x0},
                                        {0x0,0x0,0x2002002,0x200200fc,0x200,0x0,0x0},
                                        {0x0,0x0,0x0,0x0,0x200200,0x0,0x0},
                                        {0x0,0x0,0x0,0x78000,0x0,0x0,0x0},
                                        {0x0,0x0,0x0,0x0,0x200200,0x0,0x0},
                                        {0x0,0x400400,0x2002004,0x10010010,0x80080,0x0,0x0},
                                        {0x0,0xc0480300,0xb408408,0x840840b4,0x300480,0x0,0x0},
                                        {0x0,0x280300,0x2002002,0x20020020,0xf80200,0x0,0x0},
                                        {0x0,0x400380,0x400400c,0x10020060,0xfc0080,0x0,0x0},
                                        {0x0,0x400380,0x3004004,0xc00c0040,0x3c0400,0x0,0x0},
                                        {0x0,0x600600,0x4805005,0xfc044048,0x400400,0x0,0x0},
                                        {0x0,0x80080780,0x7800800,0x80080040,0x380400,0x0,0x0},
                                        {0x0,0x80180f00,0x7c00c00,0x8808c08c,0x700980,0x0,0x0},
                                        {0x0,0x800fc0,0x6004004,0x10020020,0x80100,0x0,0x0},
                                        {0x0,0x80c80700,0x700c808,0x840840c8,0x780880,0x0,0x0},
                                        {0x0,0x40480700,0xc808408,0xc00800b8,0x380400,0x0,0x0},
                                        {0x0,0x0,0x2002000,0x0,0x200200,0x0,0x0},
                                        {0x0,0x0,0x2002000,0x0,0x200200,0x0,0x0},
                                        {0x0,0x0,0x1006008,0x60010008,0x800,0x0,0x0},
                                        {0x0,0x0,0xfc00,0xfc000,0x0,0x0,0x0},
                                        {0x0,0x80000000,0x6001000,0x10060080,0x80,0x0,0x0},
                                        {0x0,0x480780,0x2004004,0x10010,0x100100,0x0,0x0},
                                        {0x0,0x40880700,0x15417400,0xf40c8148,0x80040,0xf,0x0},
                                        {0x0,0x300300,0x4805807,0x840fc0c8,0x1041840,0x0,0x0},
                                        {0x0,0xc0cc07c0,0x7c0cc08,0x8c08c0cc,0x7c0cc0,0x0,0x0},
                                        {0x0,0x40880700,0x400400,0xc004004,0xf00880,0x0,0x0},
                                        {0x0,0xc04c03c0,0x8c08c08,0x8c08c08c,0x3c04c0,0x0,0x0},
                                        {0x0,0x80080f80,0xf800800,0x8008008,0xf80080,0x0,0x0},
                                        {0x0,0x80080f80,0xf800800,0x8008008,0x80080,0x0,0x0},
                                        {0x0,0x40880700,0x400400,0x8c0840e4,0xf00880,0x0,0x0},
                                        {0x0,0xc08c08c0,0xfc08c08,0x8c08c08c,0x8c08c0,0x0,0x0},
                                        {0x0,0x200780,0x2002002,0x20020020,0x780200,0x0,0x0},
                                        {0x0,0x400400,0x4004004,0x40040040,0x3c0600,0x0,0x0},
                                        {0x0,0xc08c18c0,0x3c02c04,0xcc04c02c,0x10c08c0,0x0,0x0},
                                        {0x0,0x80080080,0x800800,0x8008008,0xf80080,0x0,0x0},
                                        {0x0,0x40cc08c0,0xa40b40d,0x84084084,0x840840,0x0,0x0},
                                        {0x0,0xc08c08c0,0xb409409,0xc40a40a4,0x840c40,0x0,0x0},
                                        {0x0,0x40c80300,0x8408408,0x84084084,0x300c80,0x0,0x0},
                                        {0x0,0x80880780,0x7808808,0x8008008,0x80080,0x0,0x0},
                                        {0x0,0x40c80300,0x8408408,0x84084084,0x700c80,0x1c004,0x0},
                                        {0x0,0xc0cc07c0,0x7c0cc08,0xcc04c02c,0x18c08c0,0x0,0x0},
                                        {0x0,0x80080700,0x3000800,0x80080060,0x780c80,0x0,0x0},
                                        {0x0,0x201fc0,0x2002002,0x20020020,0x200200,0x0,0x0},
                                        {0x0,0xc08c08c0,0x8c08c08,0x8808c08c,0x700c80,0x0,0x0},
                                        {0x0,0x41841040,0xc808c08,0x70058048,0x300300,0x0,0x0},
                                        {0x0,0x41061020,0x13413410,0xcc0d40b4,0x8c0cc0,0x0,0x0},
                                        {0x0,0x80881840,0x3007004,0x48050030,0x1840880,0x0,0x0},
                                        {0x0,0x80880840,0x3007004,0x20020020,0x200200,0x0,0x0},
                                        {0x0,0x800fc0,0x2006004,0x8010010,0xfc0080,0x0,0x0},
                                        {0x0,0x200600,0x2002002,0x20020020,0x200200,0x6002,0x0},
                                        {0x0,0x80080080,0x1001001,0x40020020,0x400400,0x0,0x0},
                                        {0x0,0x200380,0x2002002,0x20020020,0x200200,0x3802,0x0},
                                        {0x0,0x80500200,0x8408804,0x0,0x0,0x0,0x0},
                                        {0x0,0x0,0x0,0x0,0x0,0x1fe00000,0x0},
                                        {0x0,0x200100,0x0,0x0,0x0,0x0,0x0},
                                        {0x0,0x0,0xc807000,0x880f0080,0xb80c80,0x0,0x0},
                                        {0x0,0xc00c00c0,0x8c07c00,0x8c08c08c,0x7c0cc0,0x0,0x0},
                                        {0x0,0x0,0x80f000,0xc00400c,0xf00080,0x0,0x0},
                                        {0x0,0x800800,0xc80b008,0x84084084,0xb00c80,0x0,0x0},
                                        {0x0,0x0,0xc803000,0x40fc084,0xf00080,0x0,0x0},
                                        {0x0,0x300e00,0x100f801,0x10010010,0x100100,0x0,0x0},
                                        {0x0,0x0,0x480f800,0x3804804c,0x80f80080,0x7808c08,0x0},
                                        {0x0,0xc00c00c0,0x8c07c00,0x8c08c08c,0x8c08c0,0x0,0x0},
                                        {0x0,0x200,0x2003800,0x20020020,0x200200,0x0,0x0},
                                        {0x0,0x200,0x2003800,0x20020020,0x200200,0x3802002,0x0},
                                        {0x0,0xc00c00c0,0x2c0cc00,0x6c03c01c,0x8c04c0,0x0,0x0},
                                        {0x0,0x200380,0x2002002,0x20020020,0x600200,0x0,0x0},
                                        {0x0,0x0,0xb40dc00,0xa41a41a4,0x1a41a41,0x0,0x0},
                                        {0x0,0x0,0x8c07c00,0x8c08c08c,0x8c08c0,0x0,0x0},
                                        {0x0,0x0,0x8807800,0x84084084,0x780880,0x0,0x0},
                                        {0x0,0x0,0x8c07c00,0x8c08c08c,0xc07c0cc0,0xc00c00,0x0},
                                        {0x0,0x0,0xc80b000,0x84084084,0xb00c80,0x8008008,0x0},
                                        {0x0,0x0,0x180e800,0x8008018,0x80080,0x0,0x0},
                                        {0x0,0x0,0x807000,0x80070008,0x780c00,0x0,0x0},
                                        {0x0,0x100000,0x1007801,0x10010010,0xe00100,0x0,0x0},
                                        {0x0,0x0,0x8c08c00,0x8c08c08c,0xb80c80,0x0,0x0},
                                        {0x0,0x0,0x8c08400,0x70048048,0x300300,0x0,0x0},
                                        {0x0,0x0,0x10410400,0xdc0b40a4,0x880c80,0x0,0x0},
                                        {0x0,0x0,0x4808c00,0x30030030,0x840480,0x0,0x0},
                                        {0x0,0x0,0x8c08400,0x70048048,0x300300,0xc01001,0x0},
                                        {0x0,0x0,0x400fc00,0x10020020,0xfc0080,0x0,0x0},
                                        {0x0,0x200600,0x3002002,0x20030018,0x200200,0x6002,0x0},
                                        {0x0,0x200200,0x2002002,0x20020020,0x200200,0x2002,0x0},
                                        {0x0,0x100180,0x2002001,0x20020060,0x100300,0x1801,0x0},
                                        {0x0,0x0,0x0,0xe011c,0x0,0x0,0x0},
                                       };

uint32_t font_ANDALEMO_14x22[95][10] = {
                                         {0x0,0x0,0x6001800,0x600180,0x40010,0x4001,0x1800000,0x60,0x0,0x0},
                                         {0x0,0x0,0x19006400,0x1900640,0x4,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x22008800,0x7fc0c80,0x4011004c,0x2607fc06,0x2200880,0xc8,0x0,0x0},
                                         {0x0,0x40000000,0x15007800,0x480160,0x40014,0x90034005,0x5203400,0x1000f0,0x0,0x0},
                                         {0x0,0x0,0x12408600,0xa60498,0x80058039,0x3c04a00d,0x12604d01,0x388,0x0,0x0},
                                         {0x0,0x0,0x9801c00,0x880220,0xa0830014,0xe102c411,0xe303040,0xc70,0x0,0x0},
                                         {0x0,0x0,0x4001000,0x400100,0x10,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x18004000,0x400200,0x80060018,0x8002000,0x1800600,0x200040,0x40018,0x0},
                                         {0x0,0x0,0x3000000,0x400080,0xc0010,0x3000c003,0x1000c00,0x80040,0x3,0x0},
                                         {0x0,0x0,0x14001000,0xe007c0,0x4007c,0x1,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x4000000,0x400100,0x7fc010,0x10004001,0x400,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000c0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xc0000000,0x7,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x1800000,0x40,0x0,0x0},
                                         {0x0,0x0,0x10004000,0x800200,0x80040030,0xc002001,0x400100,0x8,0x0,0x0},
                                         {0x0,0x0,0x11803800,0x2080c20,0xb026c083,0x82020c09,0x4603080,0xe0,0x0,0x0},
                                         {0x0,0x0,0xf003000,0xc00300,0xc0030,0x3000c003,0x3000c00,0x3f8,0x0,0x0},
                                         {0x0,0x0,0x18803c00,0x1000400,0x180040,0x1800c002,0x600300,0x3f8,0x0,0x0},
                                         {0x0,0x0,0x18803c00,0x1000400,0xe0060,0xc0010006,0x6201000,0xf0,0x0,0x0},
                                         {0x0,0x0,0x1c006000,0x1a00780,0x2019006c,0xff018c06,0x6001800,0x180,0x0,0x0},
                                         {0x0,0x0,0x1007c00,0x100040,0xf0004,0xc0030006,0x6203000,0xf0,0x0,0x0},
                                         {0x0,0x0,0x3007800,0x180060,0x601e8002,0x8202080c,0xcc02180,0x1e0,0x0,0x0},
                                         {0x0,0x0,0x3000fe00,0x1800400,0x80020,0x18004003,0xc00200,0x10,0x0,0x0},
                                         {0x0,0x0,0x11803c00,0x3180c20,0x600f006c,0x8302080c,0xc602080,0xf0,0x0,0x0},
                                         {0x0,0x0,0x19801800,0x2080c20,0xc0318082,0xc002000b,0x6201000,0xf0,0x0,0x0},
                                         {0x0,0x0,0x0,0x400000,0x10,0x0,0x1000000,0x40,0x0,0x0},
                                         {0x0,0x0,0x0,0x400000,0x10,0x0,0x1000000,0x1000c0,0x0,0x0},
                                         {0x0,0x0,0x0,0x400600,0xc001800c,0x60004000,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x7fc0000,0x0,0x7fc00,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x800000,0x4000c0,0x300060,0xc004006,0x80,0x0,0x0,0x0},
                                         {0x0,0x0,0x18803c00,0x1000400,0x80040020,0x2000,0x800000,0x20,0x0,0x0},
                                         {0x0,0x0,0x31003800,0x40c0820,0x505a4179,0x25049412,0x7902d41,0x460008,0x1e,0x0},
                                         {0x0,0x0,0xe001000,0xb00380,0x6011006c,0x8203f804,0x183020c0,0x404,0x0,0x0},
                                         {0x0,0x0,0x30807e00,0x3080820,0x200f8042,0x8202080c,0xc202081,0xf8,0x0,0x0},
                                         {0x0,0x0,0x21007800,0xc0020,0x3000c003,0x3000c00,0x8400080,0x1e0,0x0,0x0},
                                         {0x0,0x0,0x18803e00,0x2080c20,0x20608182,0x82060818,0x6203080,0xf8,0x0,0x0},
                                         {0x0,0x0,0x180fe00,0x180060,0x601f8006,0x6001800,0x600180,0x3f8,0x0,0x0},
                                         {0x0,0x0,0x180fe00,0x180060,0x601f8006,0x6001800,0x600180,0x18,0x0,0x0},
                                         {0x0,0x0,0x21807800,0xc0020,0x3000c003,0x83020c0e,0x8602080,0x1e0,0x0,0x0},
                                         {0x0,0x0,0x20808200,0x2080820,0x203f8082,0x82020808,0x8202080,0x208,0x0,0x0},
                                         {0x0,0x0,0x4007c00,0x400100,0x40010,0x10004001,0x1000400,0x1f0,0x0,0x0},
                                         {0x0,0x0,0x18006000,0x1800600,0x180060,0x60018006,0x2200800,0x78,0x0,0x0},
                                         {0x0,0x0,0x30818200,0x880620,0x60078012,0x62018803,0x18203080,0x608,0x0,0x0},
                                         {0x0,0x0,0x1800600,0x180060,0x60018006,0x6001800,0x600180,0x3f8,0x0,0x0},
                                         {0x0,0x0,0x3180c600,0x2b80c60,0x202e80aa,0x82020809,0x8202080,0x208,0x0,0x0},
                                         {0x0,0x0,0x21808600,0x2380860,0x2026808a,0xe202c809,0xc203880,0x308,0x0,0x0},
                                         {0x0,0x0,0x11803800,0x20c0820,0x3060c183,0x83060c18,0x4602080,0xe0,0x0,0x0},
                                         {0x0,0x0,0x31803e00,0x2180860,0xe0318086,0x6001803,0x600180,0x18,0x0,0x0},
                                         {0x0,0x0,0x11803800,0x20c0820,0x3060c183,0x83060c18,0xc602080,0x6001e0,0x70,0x0},
                                         {0x0,0x0,0x30803e00,0x2080c20,0xe01080c2,0x6200c803,0xc201080,0x608,0x0,0x0},
                                         {0x0,0x0,0x11807800,0x80060,0x60004,0x80030006,0x4203000,0xf0,0x0,0x0},
                                         {0x0,0x0,0x401ff00,0x400100,0x40010,0x10004001,0x1000400,0x40,0x0,0x0},
                                         {0x0,0x0,0x20808200,0x2080820,0x20208082,0xc2020808,0x4403080,0xe0,0x0,0x0},
                                         {0x0,0x0,0x60410100,0x2080830,0x401180c6,0x2c01b004,0x3800e00,0x40,0x0,0x0},
                                         {0x0,0x0,0x40410180,0x4041010,0xb06e4111,0xe702ac1a,0xc603180,0x308,0x0,0x0},
                                         {0x0,0x0,0x20818300,0x1b00c60,0x800e0038,0x6c00e003,0x8203180,0x60c,0x0,0x0},
                                         {0x0,0x0,0x30818300,0x1b00c60,0xe002c,0x10004001,0x1000400,0x40,0x0,0x0},
                                         {0x0,0x0,0x3000fe00,0x1800400,0x80040030,0xc002001,0x600100,0x3f8,0x0,0x0},
                                         {0x0,0x0,0x4007000,0x400100,0x40010,0x10004001,0x1000400,0x100040,0x70004,0x0},
                                         {0x0,0x0,0x1000200,0x300040,0x60008,0x2000c001,0x4000800,0x100,0x0,0x0},
                                         {0x0,0x0,0x4001e00,0x400100,0x40010,0x10004001,0x1000400,0x100040,0x1e004,0x0},
                                         {0x0,0xe0010000,0x11002c00,0x2080460,0x183,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfe000000,0xf},
                                         {0x0,0x20000000,0x4001800,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x1e00000,0x3000c4,0x8e03e008,0xe603080,0x270,0x0,0x0},
                                         {0x0,0x0,0x800200,0x1e80020,0x202080c6,0x82020808,0xc602180,0x1c8,0x0,0x0},
                                         {0x0,0x0,0x0,0x1e00000,0x2001808c,0x2000800,0x8c00180,0x1e0,0x0,0x0},
                                         {0x0,0x0,0x20008000,0x3f00800,0x302080c6,0x83020c08,0xe603080,0x270,0x0,0x0},
                                         {0x0,0x0,0x0,0xe00000,0x20308046,0x203f808,0x8400080,0x1e0,0x0,0x0},
                                         {0x0,0x0,0x600f000,0x3f80180,0x80060018,0x18006001,0x1800600,0x60,0x0,0x0},
                                         {0x0,0x0,0x0,0x3f00000,0x20108066,0x1c009804,0x200180,0x818603f8,0xf00c2060,0x0},
                                         {0x0,0x0,0x800200,0x1c80020,0x203180ca,0x82020808,0x8202080,0x208,0x0,0x0},
                                         {0x0,0x0,0xc003000,0xf00000,0xc0030,0x3000c003,0x3000c00,0xc0,0x0,0x0},
                                         {0x0,0x0,0xc003000,0xf00000,0xc0030,0x3000c003,0x3000c00,0x3000c0,0x7001200c,0x0},
                                         {0x0,0x0,0x800200,0x3080020,0xe0048022,0x32007800,0xc201880,0x208,0x0,0x0},
                                         {0x0,0x0,0x4001e00,0x400100,0x40010,0x10004001,0x1000400,0x1c0,0x0,0x0},
                                         {0x0,0x0,0x0,0x3340000,0x3064c1bb,0x93064c19,0x193064c1,0x64c,0x0,0x0},
                                         {0x0,0x0,0x0,0x1c80000,0x203180ca,0x82020808,0x8202080,0x208,0x0,0x0},
                                         {0x0,0x0,0x0,0xf00000,0x302080c6,0x83060c08,0xc602080,0xf0,0x0,0x0},
                                         {0x0,0x0,0x0,0x1e80000,0x202080c6,0x82020808,0xc602180,0x800201c8,0x8002000,0x0},
                                         {0x0,0x0,0x0,0x3f00000,0x302080c6,0x83020c08,0xe603080,0x800270,0x80020,0x2},
                                         {0x0,0x0,0x0,0x1900000,0x4003009c,0x4001000,0x400100,0x10,0x0,0x0},
                                         {0x0,0x0,0x0,0x1f00000,0x60008046,0xc001f000,0x4203000,0xf0,0x0,0x0},
                                         {0x0,0x0,0x2000800,0x1f80080,0x80020008,0x8002000,0x9800200,0x1c0,0x0,0x0},
                                         {0x0,0x0,0x0,0x2080000,0x20208082,0xc2020808,0xa603080,0x270,0x0,0x0},
                                         {0x0,0x0,0x0,0x20c0000,0x401180c2,0x2c019004,0x1800e00,0x60,0x0,0x0},
                                         {0x0,0x0,0x0,0x4040000,0x2060c183,0xaa02e819,0xc603180,0x318,0x0,0x0},
                                         {0x0,0x0,0x0,0x3080000,0x800b0046,0x38006003,0x4600b00,0x308,0x0,0x0},
                                         {0x0,0x0,0x0,0x20c0000,0x601180c2,0x2c019004,0x1800e00,0x180060,0x1c00c002,0x0},
                                         {0x0,0x0,0x0,0x3f80000,0x1800c0,0x8006003,0x600300,0x3f8,0x0,0x0},
                                         {0x0,0x0,0xc006000,0x400100,0x80040010,0x18003001,0x1000400,0x100040,0x6000c,0x0},
                                         {0x0,0x0,0x4001000,0x400100,0x40010,0x10004001,0x1000400,0x100040,0x40010004,0x0},
                                         {0x0,0x0,0x6000c00,0x600180,0x40010,0x10018001,0x1000400,0x180060,0xc006,0x0},
                                         {0x0,0x0,0x0,0x0,0xf0000000,0xe0046000,0x0,0x0,0x0,0x0},
                                        };

uint32_t font_ANDALEMO_16x26[95][13] = {
                                         {0x0,0x0,0xc00000,0xc000c0,0xc000c0,0x800080,0x800080,0x80,0x800000,0x8001c0,0x0,0x0,0x0},
                                         {0x0,0x0,0x2200000,0x2200220,0x2200220,0x220,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x8c00000,0xc400c40,0x1ffc0440,0x6200660,0x2200620,0x1ffc0230,0x3100310,0x1180118,0x0,0x0,0x0},
                                         {0x0,0x0,0x3c00080,0x9004b0,0xb00098,0x1e000f0,0x7800380,0xc800c80,0x4800c80,0x1e00790,0x80,0x0,0x0},
                                         {0x0,0x0,0x8380000,0x6440c6c,0x34402c4,0x1b8016c,0xec00080,0x31601340,0x31303120,0xe181310,0x0,0x0,0x0},
                                         {0x0,0x0,0x1e00000,0x2180330,0x3100318,0x20e001b0,0x199810f0,0xf0c098c,0xe0c060c,0x31f01f18,0x0,0x0,0x0},
                                         {0x0,0x0,0x800000,0x800080,0x800080,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x4000000,0x3000600,0x1800180,0xc000c0,0xc000c0,0xc000c0,0xc000c0,0x18000c0,0x3000180,0x4000600,0x0},
                                         {0x0,0x0,0x100000,0x600030,0x8000c0,0x1800180,0x1000180,0x1000100,0x1800180,0x800180,0x6000c0,0x100030,0x0},
                                         {0x0,0x0,0x800000,0x6b00490,0x1c001c0,0x8006b0,0x80,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x800080,0x800080,0x801ff8,0x800080,0x80,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1800000,0x18001c0,0x80,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x7f00000,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x8001c0,0x0,0x0,0x0},
                                         {0x0,0x0,0x4000000,0x2000600,0x1000300,0x1800180,0xc00080,0x600040,0x300020,0x100030,0x0,0x0,0x0},
                                         {0x0,0x0,0x3e00000,0xc100630,0xc180c18,0x19c80818,0x19c819c8,0xc180818,0xc100c18,0x3c00630,0x0,0x0,0x0},
                                         {0x0,0x0,0x1c00000,0x1b001f0,0x1800180,0x1800180,0x1800180,0x1800180,0x1800180,0xff00180,0x0,0x0,0x0},
                                         {0x0,0x0,0x1e00000,0x6000310,0x6000600,0x6000600,0x3000300,0xc00180,0x200060,0xff80030,0x0,0x0,0x0},
                                         {0x0,0x0,0x1e00000,0x6000710,0x6000600,0x1c00300,0x6000300,0xc000400,0x6000400,0x1f00308,0x0,0x0,0x0},
                                         {0x0,0x0,0x7000000,0x7800780,0x64006c0,0x6200660,0x6100630,0x6080618,0x6001ffc,0x6000600,0x0,0x0,0x0},
                                         {0x0,0x0,0x7f00000,0x300030,0x300030,0x1f00030,0x6000600,0xc000c00,0x6000c00,0x1f00310,0x0,0x0,0x0},
                                         {0x0,0x0,0x7c00000,0x300460,0x180030,0x3d80018,0xc180638,0x8180c18,0xc300c10,0x3c00660,0x0,0x0,0x0},
                                         {0x0,0x0,0xff80000,0x4000c00,0x6000600,0x3000300,0x1800180,0xc00080,0x6000c0,0x200060,0x0,0x0,0x0},
                                         {0x0,0x0,0x3e00000,0xc100630,0xc100c18,0x3e00630,0xc180630,0x8180c18,0xc180c18,0x3e00630,0x0,0x0,0x0},
                                         {0x0,0x0,0x1e00000,0x4180630,0xc180c18,0xc180c18,0xfe00e30,0xc000c00,0x6000400,0x1f00310,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x800000,0x8001c0,0x0,0x0,0x800000,0x8001c0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x800000,0x8001c0,0x0,0x0,0x1800000,0x18001c0,0x80,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x1000600,0x6000c0,0x200010,0x10000c0,0x600,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x1ff80000,0x0,0x1ff80000,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x100000,0x400030,0x2000180,0x2000400,0x400180,0x100020,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x1e00000,0x6000610,0x6000600,0x1800300,0x4000c0,0x40,0x400000,0x4000e0,0x0,0x0,0x0},
                                         {0x0,0x0,0x3c00000,0x8100430,0x10081808,0x1244138c,0x12241224,0x13241324,0x6cc0b24,0x180008,0x3c00430,0x0,0x0},
                                         {0x0,0x0,0x1c00000,0x3c001c0,0x3600360,0x6300660,0x6300630,0xc180ff8,0x180c0818,0x100c180c,0x0,0x0,0x0},
                                         {0x0,0x0,0x3f80000,0xc180618,0xc180c18,0x6180c18,0x61803f8,0x18180c18,0xc181818,0x3f80e18,0x0,0x0,0x0},
                                         {0x0,0x0,0x7c00000,0x100830,0x180018,0xc0008,0xc000c,0x180008,0x100018,0x7c00830,0x0,0x0,0x0},
                                         {0x0,0x0,0x1f80000,0x6180318,0xc180c18,0x18181818,0x18181818,0xc181818,0x6180c18,0x1f80318,0x0,0x0,0x0},
                                         {0x0,0x0,0xff00000,0x300030,0x300030,0x300030,0x3007f0,0x300030,0x300030,0xff00030,0x0,0x0,0x0},
                                         {0x0,0x0,0xff00000,0x300030,0x300030,0x300030,0x3007f0,0x300030,0x300030,0x300030,0x0,0x0,0x0},
                                         {0x0,0x0,0x7c00000,0x100830,0x180018,0xc0008,0xf0c000c,0x8180808,0x8180818,0x7c00c30,0x0,0x0,0x0},
                                         {0x0,0x0,0xc180000,0xc180c18,0xc180c18,0xc180c18,0xc180ff8,0xc180c18,0xc180c18,0xc180c18,0x0,0x0,0x0},
                                         {0x0,0x0,0x7f00000,0x800080,0x800080,0x800080,0x800080,0x800080,0x800080,0x7f00080,0x0,0x0,0x0},
                                         {0x0,0x0,0x2000000,0x2000200,0x2000200,0x2000200,0x2000200,0x2000200,0x3000300,0xf00308,0x0,0x0,0x0},
                                         {0x0,0x0,0x18180000,0x6180c18,0x1980318,0xf800d8,0x39801f8,0x6180318,0xc180e18,0x38181818,0x0,0x0,0x0},
                                         {0x0,0x0,0x300000,0x300030,0x300030,0x300030,0x300030,0x300030,0x300030,0xff00030,0x0,0x0,0x0},
                                         {0x0,0x0,0xc180000,0xe380c38,0xb780a78,0x9d809d8,0x8180998,0x8180818,0x8180818,0x8180818,0x0,0x0,0x0},
                                         {0x0,0x0,0xc180000,0xc380c38,0xc780c78,0xcd80cd8,0xd980c98,0xf180d18,0xe180e18,0xc180c18,0x0,0x0,0x0},
                                         {0x0,0x0,0x3e00000,0xc180630,0x8180c18,0x180c180c,0x180c180c,0x818180c,0xc180c18,0x3e00630,0x0,0x0,0x0},
                                         {0x0,0x0,0x3f00000,0xc300e30,0xc300c30,0x6300c30,0x3003f0,0x300030,0x300030,0x300030,0x0,0x0,0x0},
                                         {0x0,0x0,0x3e00000,0xc180630,0x8180c18,0x180c180c,0x180c180c,0x1818180c,0xc180c18,0x3e00630,0x6000300,0x1c00,0x0},
                                         {0x0,0x0,0x3f80000,0xc180618,0xc180c18,0x6180c18,0x19801f8,0x6180318,0xc180618,0x18181c18,0x0,0x0,0x0},
                                         {0x0,0x0,0x3c00000,0x100430,0x300018,0x1e00070,0x6000380,0xc000c00,0xc000c00,0x1e00610,0x0,0x0,0x0},
                                         {0x0,0x0,0x1ffc0000,0x1800180,0x1800180,0x1800180,0x1800180,0x1800180,0x1800180,0x1800180,0x0,0x0,0x0},
                                         {0x0,0x0,0xc180000,0xc180c18,0xc180c18,0xc180c18,0xc180c18,0xc180c18,0xc100c18,0x3e00630,0x0,0x0,0x0},
                                         {0x0,0x0,0x100c0000,0x180c180c,0xc180818,0x4300c18,0x6300630,0x3600260,0x1c00360,0x1c001c0,0x0,0x0,0x0},
                                         {0x0,0x0,0x30040000,0x10043004,0x100c100c,0x19cc198c,0x1b4819cc,0xa281b68,0xe380e38,0xc180c38,0x0,0x0,0x0},
                                         {0x0,0x0,0x180c0000,0xc300c18,0x6600630,0x1c003e0,0x1c00180,0x6600360,0xc100630,0x180c1818,0x0,0x0,0x0},
                                         {0x0,0x0,0x180c0000,0xc180c18,0x6300630,0x3e00360,0x18001c0,0x1800180,0x1800180,0x1800180,0x0,0x0,0x0},
                                         {0x0,0x0,0xff80000,0x6000c00,0x3000600,0x1800300,0xc00180,0x600040,0x300030,0xff80018,0x0,0x0,0x0},
                                         {0x0,0x0,0x7800000,0x800080,0x800080,0x800080,0x800080,0x800080,0x800080,0x800080,0x800080,0x780,0x0},
                                         {0x0,0x0,0x180000,0x300030,0x600020,0xc00040,0x1800080,0x1000180,0x2000300,0x4000600,0x0,0x0,0x0},
                                         {0x0,0x0,0xf00000,0x800080,0x800080,0x800080,0x800080,0x800080,0x800080,0x800080,0x800080,0xf0,0x0},
                                         {0x0,0x0,0x1400180,0x2200360,0xc100430,0x180c0818,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3ffe},
                                         {0x0,0x0,0xc000e0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x3e00000,0xc000610,0xc000c00,0xc700fc0,0xe180c18,0xde00f30,0x0,0x0,0x0},
                                         {0x0,0x0,0x180000,0x180018,0x7d80018,0xc180e38,0x18180818,0x18181818,0xc180818,0x3980638,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x7c00000,0x300c60,0x180018,0x180018,0x300018,0x7c00860,0x0,0x0,0x0},
                                         {0x0,0x0,0xc000000,0xc000c00,0xde00c00,0xc180e30,0xc080c18,0xc080c08,0xe180c18,0xde00f30,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x1c00000,0xc100630,0xc180c18,0x180ff8,0x100018,0x7c00c70,0x0,0x0,0x0},
                                         {0x0,0x0,0xf800000,0xc00080,0xff800c0,0xc000c0,0xc000c0,0xc000c0,0xc000c0,0xc000c0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xfe00000,0x6180730,0x6180618,0x1e00330,0x180030,0x1ff00ff8,0x8181810,0x3f00c18,0x0},
                                         {0x0,0x0,0x180000,0x180018,0x7980018,0xc180458,0xc180c18,0xc180c18,0xc180c18,0xc180c18,0x0,0x0,0x0},
                                         {0x0,0x0,0x1800000,0x180,0x1f00000,0x1800180,0x1800180,0x1800180,0x1800180,0x1800180,0x0,0x0,0x0},
                                         {0x0,0x0,0x1800000,0x180,0x1f00000,0x1800180,0x1800180,0x1800180,0x1800180,0x1800180,0x1800180,0xf00190,0x0},
                                         {0x0,0x0,0x180000,0x180018,0xc180018,0x1980718,0xf800d8,0x19800f8,0x6180318,0x1c180c18,0x0,0x0,0x0},
                                         {0x0,0x0,0xf00000,0x800080,0x800080,0x800080,0x800080,0x800080,0x800080,0x7800080,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xcec0000,0x198c19dc,0x188c188c,0x188c188c,0x188c188c,0x188c188c,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x7980000,0xc180458,0xc180c18,0xc180c18,0xc180c18,0xc180c18,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x3e00000,0xc180630,0x18080818,0x18081808,0xc180818,0x3e00630,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x7d80000,0xc180e38,0x18180818,0x18181818,0xc180818,0x3980638,0x180018,0x180018,0x0},
                                         {0x0,0x0,0x0,0x0,0xde00000,0xc180e30,0xc080c18,0xc080c08,0xc180c18,0xde00e30,0xc000c00,0xc000c00,0x0},
                                         {0x0,0x0,0x0,0x0,0x7300000,0x7008b0,0x300070,0x300030,0x300030,0x300030,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x3e00000,0x100430,0xf00030,0x70003c0,0xc000c00,0x3e00610,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x400040,0x7f00040,0x400040,0x400040,0x400040,0x400040,0x78008c0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xc180000,0xc180c18,0xc180c18,0xc180c18,0xe180c18,0xce00d30,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xc080000,0x4180c18,0x6300630,0x3600220,0x1c00360,0xc001c0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x180c0000,0x1808180c,0x19c81988,0xa580948,0xe380a78,0xc100c30,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xc180000,0x6300630,0x1c00360,0x1c001c0,0x6300360,0xc180610,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xc080000,0x4180c18,0x6300630,0x3600220,0x1c00360,0xc001c0,0xc000c0,0x3c0060,0x0},
                                         {0x0,0x0,0x0,0x0,0xff80000,0x2000600,0x1800300,0xc00080,0x300060,0xff80030,0x0,0x0,0x0},
                                         {0x0,0x0,0x7000000,0x1800180,0x1800180,0x1800180,0xc00080,0xc00060,0x1800080,0x1800180,0x1800180,0x7000180,0x0},
                                         {0x0,0x0,0x800000,0x800080,0x800080,0x800080,0x800080,0x800080,0x800080,0x800080,0x800080,0x800080,0x0},
                                         {0x0,0x0,0x700000,0xc000c0,0xc000c0,0x8000c0,0x1800080,0x1800300,0x800080,0xc000c0,0xc000c0,0x7000c0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x780000,0xe0011c4,0x0,0x0,0x0,0x0,0x0},
                                        };

uint32_t font_ANDALEMO_18x30[95][17] = {
                                         {0x0,0x0,0x0,0x380000,0x38000e0,0x38000e00,0x8000e000,0xc0003,0x400030,0x4000100,0x1000,0x0,0x38000c,0xc0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0xc40000,0xc400310,0xc4003100,0x40031000,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x3180000,0x31800c60,0x8c00c200,0xfc3fff01,0x6300ff,0x3180086,0xfff00c60,0xc0fffc3,0xc0063001,0x630018,0x184,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0xf8000c,0x137007f8,0x33000cc0,0x7000cc00,0xf8003,0x7c00078,0xcc001b00,0xc0033000,0xc03b000c,0xff007c,0x30000f8,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x3078000,0x19cc0c3f,0xd8406610,0xfc017300,0x9e006,0x400030,0xf2003980,0x980c6c01,0xc0c66031,0x7c30318,0xe06,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x3c0000,0xe3001f8,0xc30030c0,0x60018c00,0x78003,0x707c180e,0xd8706318,0x303c0c0,0xe0181c07,0x1e7f80f0,0x30f8,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x300000,0x30000c0,0x30000c00,0xc000,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x1000000,0xc000600,0x30001800,0x8000c000,0x60001,0x600018,0x6000180,0x60001800,0x18000,0x300006,0x60000c0,0x80003000,0x40001,0x0},
                                         {0x0,0x0,0x0,0x20000,0xc00018,0x18000600,0xc000,0x1c0003,0x1800060,0x18000600,0x80006000,0x70001,0x30000c,0x1800060,0x6000300,0x800,0x0},
                                         {0x0,0x0,0x0,0x300000,0x132000c0,0x78003d80,0x6001e000,0x4c800f,0xc00030,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x30000c00,0xc000,0x800c0003,0x1ffe07ff,0xc000300,0xc0003000,0x30000,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x38000c,0x20000c0,0x10000c00,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f800fe0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x38000c,0xc0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x1800000,0xc000600,0x40003000,0x18000,0xc0006,0x600030,0x2000180,0x30000c00,0x80006000,0x30001,0xc,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x7c0000,0x1c7003f8,0x380e0c0,0x180c0603,0x81cc6030,0x1de60779,0xc0607318,0xe030180,0xc038300c,0xfe0071,0x1e0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x300000,0x3e000f0,0x30000c80,0xc000,0xc0003,0xc00030,0xc000300,0xc0003000,0x30000,0x3ff000c,0xffc,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x3e0000,0x1e1003fc,0x80006000,0x60001,0x700018,0x38000c0,0xc000600,0x30001800,0xc0006000,0x1ff0000,0x7fc,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x3e0000,0x1c3003fc,0x80006000,0x60001,0x38001c,0x1f0007c,0x60001e00,0x18000,0x40180006,0xff0078,0xf8,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0xe00000,0xf000380,0xd8003c00,0xc0033000,0x31800c,0x30c00c6,0x30600c30,0xfe07ff80,0xc001f,0xc00030,0x300,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x1fe0000,0x6007f8,0x6000180,0x60001800,0x1f8000,0x70000fe,0xe0001800,0x38000,0x4018000e,0xff0070,0xf8,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x1f00000,0xe007f0,0x3000180,0x30000c00,0x803ee000,0xe1e01ff,0xc0c03038,0xc070300,0x8030600c,0x1fc00e3,0x3e0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x3ff0000,0x30000ffc,0x80006000,0x30001,0x30000c,0x1800060,0xc000300,0x60001800,0x1c000,0xc0003,0x18,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x7c0000,0x1c7007f8,0x300e0c0,0x600e0c03,0x3f001c,0x71c00fc,0xc0603030,0x6030180,0xc030380c,0x1fe00e1,0x1f0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x7c0000,0x1c7003f8,0x838060c0,0x380c0e03,0xc0c030,0xff80387,0xc00037c0,0x30000,0x18000e,0x7f0030,0xfc,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x8000c000,0xc0003,0x0,0x0,0x0,0x0,0x38000c,0xc0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x8000c000,0xc0003,0x0,0x0,0x0,0x0,0x38000c,0x20000c0,0x10000c00,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0xe0006000,0xc001e001,0x1c001,0x1c0003,0x1e0001c0,0x1e000,0x6,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xf81ffe00,0x7f,0x0,0xffe07ff8,0x1,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x100000,0x1e0001c0,0xe000,0xf0000e,0xf000300,0xe000e00,0x1c001e00,0x1000,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x7e0000,0x1c2003fc,0x80006000,0x60001,0x30000c,0xe00070,0x3000180,0xc00,0x0,0x1c0007,0x70,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x780000,0x30300618,0x1808040,0x8813c204,0xc133204c,0x13130cc4,0x31b04c6c,0x930644c1,0x201d880b,0x10000,0x1060000c,0x3e00,0x0,0x0},
                                         {0x0,0x0,0x0,0x380000,0x78001e0,0xec001f00,0xe0033000,0x71800c,0x61c0186,0xffc01ff0,0x6030300,0x6060180c,0x600c180,0x3003,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x7f0000,0x383007fc,0x300c0c0,0x300c0c03,0x70c030,0x3fc00ff,0xc0c03830,0xc060300,0xc0703018,0x1ff00e0,0x1fc,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x1f80000,0x30700ff8,0x38000c0,0x18000600,0x80006000,0x60001,0x600018,0xe000180,0xc0003000,0x3fe0083,0x7e0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x3f0000,0x1e3003fc,0x300e0c0,0x300c0c03,0x180c070,0x180c0603,0xc0c06030,0xc030301,0xc038300c,0xff0078,0xfc,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x3ff0000,0x300ffc,0x30000c0,0x30000c00,0xc000,0x7fc01ff,0xc00030,0xc000300,0xc0003000,0x3ff0000,0xffc,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x3ff0000,0x300ffc,0x30000c0,0x30000c00,0xc000,0x7fc01ff,0xc00030,0xc000300,0xc0003000,0x30000,0xc,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x1f80000,0x30700ff8,0x38000c0,0x18000600,0x80006000,0x1f860001,0xc0607e18,0xe070181,0xc070301c,0x3fe01c3,0x3e0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x3030000,0x30300c0c,0x300c0c0,0x300c0c03,0xc0c030,0xffc03ff,0xc0c03030,0xc030300,0xc030300c,0x30300c0,0xc0c,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x1fe0000,0x30007f8,0x30000c00,0xc000,0xc0003,0xc00030,0xc000300,0xc0003000,0x30000,0x1fe000c,0x7f8,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0xc00000,0xc000300,0xc0003000,0x30000,0x30000c,0x30000c0,0x30000c00,0xc000,0x600c0003,0x7f8018,0xfc,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0xe030000,0x38301c0c,0xc30060c0,0x30018c00,0x6c003,0x1dc003f,0x38c00630,0xc01c300,0xc0383006,0x60301c0,0x380c,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x30000,0x30000c,0x30000c0,0x30000c00,0xc000,0xc0003,0xc00030,0xc000300,0xc0003000,0x3ff0000,0xffc,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x7038000,0x78781e0e,0xcd81e1e0,0x981b3606,0x819e6064,0x18c60639,0x80606018,0x6060181,0x60601818,0x6018180,0x1806,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x3038000,0x30780c0e,0xf80c1e0,0x980c3603,0x80c66031,0xcc60331,0xd8603718,0x6036180,0x603c180f,0x38180e0,0xc06,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x7c0000,0x187007f8,0x380c0c0,0x181c0603,0x81806060,0x18060601,0x80606018,0xe070181,0xc030300c,0x1fe0061,0x1f0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0xff0000,0x383007fc,0x300c0c0,0x300c0c03,0xe0c030,0x1fc01ff,0xc00030,0xc000300,0xc0003000,0x30000,0xc,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x7c0000,0x187007f8,0x380c0c0,0x181c0603,0x81806060,0x18060601,0x80606018,0xe070181,0xc030300c,0x1fe0061,0xc0003f0,0x8001f000,0x7,0x0},
                                         {0x0,0x0,0x0,0x7f0000,0x383007fc,0x300c0c0,0x300c0c03,0x70c030,0x1fc00ff,0x38c00730,0xc00c300,0xc0383007,0x70300c0,0x380c,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0xf80000,0x107007f8,0x30000c0,0x70000c00,0x78000,0x3800078,0xe0001c00,0x30000,0x4030000c,0xff0070,0x1f8,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x7ffc000,0x3001fff,0x30000c00,0xc000,0xc0003,0xc00030,0xc000300,0xc0003000,0x30000,0x30000c,0xc0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x3030000,0x30300c0c,0x300c0c0,0x300c0c03,0xc0c030,0xc0c0303,0xc0c03030,0xc030300,0xc030300c,0x1fe0061,0x1f0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0xc00c000,0x601c1803,0x1818060,0x300c0e03,0x60c030,0x6180187,0x33800c60,0xb000cc00,0x7c001,0x78001e,0xe0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0xc00c000,0xc00c3003,0xc30030,0xc180304,0x818e3063,0x19a60678,0xb36064d8,0x1e02c581,0xe038780f,0x38300e1,0xc0c,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x601c000,0x30301c06,0x860061c0,0xc0033001,0x1e000f,0xe00030,0x3b000780,0x1800cc00,0xc0387006,0x60180c0,0x1807,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x601c000,0x30301c06,0x8600e0c0,0xc0033801,0x1f000c,0xe00078,0xc000300,0xc0003000,0x30000,0x30000c,0xc0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x3ff0000,0x38000ffc,0xc0006000,0x30001,0x180006,0xe00030,0x3000180,0x18000c00,0xc0007000,0x3ff8000,0xffe,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x1f00000,0x30007c0,0x30000c00,0xc000,0xc0003,0xc00030,0xc000300,0xc0003000,0x30000,0x30000c,0x30000c0,0xf0007c00,0x1,0x0},
                                         {0x0,0x0,0x0,0x30000,0x60000c,0xc000180,0x80003000,0x60000,0xc00018,0x18000300,0x6000,0xc0001,0x1800030,0x600,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x3e0000,0x30000f8,0x30000c00,0xc000,0xc0003,0xc00030,0xc000300,0xc0003000,0x30000,0x30000c,0x30000c0,0x3e000f80,0x0,0x0},
                                         {0x0,0x0,0x30000,0x78000e,0xc400330,0x83006180,0x180c0c01,0x1806020,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfe000000,0x7fff9ff},
                                         {0x0,0x0,0x0,0x180007,0x20000c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xf003f000,0xe0801f,0xc000300,0xff803f80,0xc030f00,0xc038300c,0x3ff00f0,0xcf0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x30000,0x30000c,0x30000c0,0xf003cc00,0xe1c01f,0x1c0c0303,0x80c06030,0xc060301,0xc030300c,0x1ff00e1,0x3cc,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xe00fe000,0x3c01f,0xc0003,0x600018,0xc000180,0xc0003000,0x3fe00c3,0x7e0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x3000000,0x30000c00,0xc000,0xe00cf003,0x80f1c03f,0xc060383,0xc0603018,0x6030180,0xc038380c,0x3ff00f1,0xcf0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xe001e000,0x61c00f,0xc0e0303,0xffe03ff8,0xe000180,0xc0003000,0x3fe0043,0x7e0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x3e00000,0x3800fc0,0x18000600,0xf00ffc00,0x6003f,0x600018,0x6000180,0x60001800,0x18000,0x180006,0x60,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xe01cf000,0x31c07f,0x60c0183,0x3f800c70,0xc003c00,0xc0003000,0x7fe00ff,0x6010180c,0x8381c060,0xc007fc03,0x7},
                                         {0x0,0x0,0x0,0x30000,0x30000c,0x30000c0,0xf003cc00,0xe3c01f,0xc0c0303,0xc0c03030,0xc030300,0xc030300c,0x30300c0,0xc0c,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x600000,0x60001c0,0x0,0xe001f800,0x180007,0x1800060,0x18000600,0x80006000,0x60001,0x600018,0x180,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x600000,0x60001c0,0x0,0xe001f800,0x180007,0x1800060,0x18000600,0x80006000,0x60001,0x600018,0x6000180,0x31001800,0xe000fc00,0x1},
                                         {0x0,0x0,0x0,0x30000,0x30000c,0x30000c0,0x300e0c00,0x38c01c,0xec0073,0x7c001f0,0x8c003300,0xc00e3001,0x3830070,0x1c0c,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x3f0000,0x30000fc,0x30000c00,0xc000,0xc0003,0xc00030,0xc000300,0xc0003000,0x30000,0x1f0000c,0x7c0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xf80e7600,0x81dee07f,0x18c60631,0x8c606318,0xc6063181,0x60631818,0x631818c,0x18c6,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xf003cc00,0xe3c01f,0xc0c0303,0xc0c03030,0xc030300,0xc030300c,0x30300c0,0xc0c,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xe001f000,0x80e1c01f,0x1c060303,0x80606018,0x6060181,0xc030380c,0x1fe00e1,0x1f0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xf003cc00,0xe1c01f,0x1c0c0303,0x80c06030,0xc060301,0xc030301c,0x1ff00e1,0x3003cc,0x30000c0,0x30000c00,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xf00cf000,0x80f1c03f,0xc060383,0xc0603018,0x6030180,0xc038380c,0x3ff00f1,0x30000cf0,0xc000,0xc0003,0x30},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x60079800,0x7803f,0x18000e,0x1800060,0x18000600,0x80006000,0x60001,0x18,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xe003e000,0x61c01f,0x1c0003,0x3e0003e0,0x1c000,0xc030000e,0x1ff0060,0x1f8,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x1800060,0x18000600,0xf007fc00,0x6001f,0x600018,0x6000180,0x60001800,0x18000,0x3f80086,0x7c0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x300c0c00,0xc0c030,0xc0c0303,0xc0c03030,0xc030300,0xc038300c,0x37f00f1,0xcf8,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x180c0600,0xe0c030,0x61c0183,0x31800c60,0xb000cc00,0x7c001,0x38000e,0xc0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x18180200,0x81806060,0x18c60601,0x9e606798,0x3c02cd01,0xc038700f,0x38300e1,0xc0c,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x300c0600,0x718018,0x1b000ce,0xe000380,0xb0003800,0x800ce001,0x1830071,0xc06,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x180c0600,0xe0c030,0x61c0183,0x31800c60,0xb000cc00,0x6c001,0x38000e,0x18000e0,0xc000600,0x38003e00,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xf00ffc00,0x60001f,0x18000c0,0xc000300,0x30001800,0x80006000,0x3ff0001,0xffc,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x1c00000,0x7000780,0x30000c00,0xc000,0xc0003,0x600030,0x30000c0,0xc0001800,0x30000,0x30000c,0x30000c0,0xe0001c00,0x70001,0x0},
                                         {0x0,0x0,0x0,0x300000,0x30000c0,0x30000c00,0xc000,0xc0003,0xc00030,0xc000300,0xc0003000,0x30000,0x30000c,0x30000c0,0x30000c00,0xc000,0x3},
                                         {0x0,0x0,0x0,0xe0000,0x1800078,0x18000600,0x80006000,0x40001,0xc00030,0x38000e00,0xc0007000,0x10000,0x180006,0x1800060,0x1e000600,0x3800,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3c0000,0xfe30c3fc,0x3c001,0x0,0x0,0x0,0x0,0x0,0x0},
                                        };

uint32_t font_ANDALEMO_20x36[95][23] = {
                                         {0x0,0x0,0x0,0x0,0x700000,0x70000700,0x70000,0x7000070,0x7000,0x600006,0x60000600,0x60000,0x2000060,0x0,0x0,0xf0000600,0xf0000,0x60,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x30c0000,0xc0030c0,0x30c003,0x30c0030c,0x80010800,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xc300000,0x3000c300,0xc3000c,0x61800618,0xfc3fffc0,0x71c03ff,0xc0030c0,0x30c003,0xfffc030c,0x603fffc3,0x1860018,0xc3001860,0xc3000,0xc3,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x3f00006,0x7e007fc0,0x66006,0x6700067,0x60006600,0x7c0006,0xe0000f80,0x760003,0xe6000660,0xc6000,0xe6000c6,0xe2006600,0x3fe007,0x60000fc,0x6000,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xc0f0000,0x19c0c1f8,0xc0630c06,0x330c0330,0x9c01b0c0,0xdf801d,0x600006f0,0xf30000,0x9d801fb0,0xc030d803,0x30cc030c,0xc6030c60,0x1f83039,0xf03,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x780000,0xc6000fe0,0x187001,0x18300183,0xe001c600,0x7c000e,0x3e0603c0,0x83877070,0xcc1818e3,0x1c0d81c0,0x701c070,0x8780f018,0x79ff01f,0x707c,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x600000,0x60000600,0x60000,0x6000060,0x6000,0x6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x80007000,0x180003,0xe0000c0,0x6000,0x300007,0x30000300,0x30000,0x3000038,0x3000,0x300003,0x60000700,0xe0000,0x180000c0,0x38000,0x70,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x20000,0x1c0000e0,0x18000,0x7000030,0x6000,0xc0000e,0xc0000c00,0xc0000,0xc0001c0,0xc000,0xc0000c,0x60000e00,0x70000,0x1800030,0xe0001c00,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x600000,0x66000600,0x76e006,0xf0001f8,0xe001f800,0x6660076,0x60000600,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x60000,0x6000060,0x6000,0x600006,0xff81fff8,0x6001f,0x6000060,0x6000,0x600006,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0000600,0xf0000,0x40000e0,0x6000,0x2,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3fe003fe,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0000600,0xf0000,0x60,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x6000000,0x7000,0x300003,0x18000180,0x1c000,0xe0000c,0x60000600,0x30000,0x3800030,0xc0001800,0xc0001,0x60000c0,0x6000,0x7,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xf00000,0xe003fc0,0x606007,0xc0300e07,0x380c0300,0x1c6381c0,0xf381cf38,0x81c6381c,0xc0381c03,0x300c0301,0xe0700c0,0xe006060,0x3fc007,0xf0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xe00000,0xfc000f80,0xee000,0xe0000e2,0xe000,0xe0000e,0xe0000e00,0xe0000,0xe0000e0,0xe000,0xe0000e,0xe0000e00,0xffe000,0xffe,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xfc0000,0x82001ff0,0x700003,0x70000700,0x70000,0x7000070,0x80003000,0x180003,0xe0000c0,0x80007000,0x180003,0x60000c0,0x7ff000,0x7ff,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xfc0000,0x82001fe0,0x700003,0x70000700,0x70000,0x1c00038,0xf8000f80,0x3c0001,0x60000700,0x60000,0x6000060,0x83007000,0x1ff003,0x7e,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x3800000,0xe0003c00,0x360003,0x33000370,0x80031800,0x30c0031,0x60030e0,0x307003,0x30180303,0xf81fff80,0x30001ff,0x3000,0x300003,0x300,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x7fe0000,0x6007fe0,0x6000,0x600006,0x60000600,0xfe0000,0x80003fc0,0x700003,0xe0000600,0xe0000,0x60000e0,0x82007000,0x1ff003,0x7c,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x3e00000,0x3c007f80,0xc004,0x60000e,0x70000700,0x30000,0xff001f30,0xf0f007,0xc0300e07,0x701c0700,0xc0601c0,0x1c00e0e0,0x7f800e,0x1e0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xfff0000,0xfff0,0x60000e,0x70000600,0x30000,0x1800038,0xc0001c00,0xc0000,0x60000e0,0x7000,0x380003,0x18000180,0x1c000,0xc,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xf80000,0xe003fc0,0x606007,0xe0700e07,0x600e0700,0x39c0060,0xf8001f80,0x79e001,0xc0300e07,0x380c0380,0xc0300c0,0xf00e070,0x7fe007,0x1f8,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xf80000,0x8e001fc0,0x607003,0xe0300603,0x300c0300,0xe0700c0,0xfe00f0e0,0xcf800f,0xc0000c00,0xe0000,0x70000e0,0xc2007000,0x1fe003,0x7c,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6000000,0xf000,0x60000f,0x0,0x0,0x0,0x0,0x0,0xf0000600,0xf0000,0x60,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6000000,0xf000,0x60000f,0x0,0x0,0x0,0x0,0x0,0xf0000600,0xf0000,0x40000e0,0x6000,0x2,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x78000600,0x1c000,0x3c0007,0x70000e0,0xe000,0x700003c,0x1c000,0x6000078,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8000000,0x1fff81ff,0x0,0x0,0xfff80000,0x1fff81,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x1c00006,0x7800,0x3c0000e,0x7000,0x70000e,0xe0003c0,0xc0007800,0x60001,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xfc0000,0x86003fe0,0x700003,0x60000600,0x30000,0x1c00038,0x70000e00,0x30000,0x1800018,0x0,0x0,0x38000380,0x38000,0x38,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x1f00000,0xe007fc0,0xc0600e,0x80101803,0x18100181,0x33f0833e,0xc833188,0xc318cc31,0x98cc118c,0x88198c81,0x73980ff,0x3000018,0x7000,0x7fc0060e,0x3f000,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xf00000,0xf0000f00,0x1f8000,0x198001f8,0xc0039c00,0x30c0039,0xe0070c0,0x606007,0xfff007fe,0x300c0300,0x1c0380c0,0x1818018,0xc3801c18,0x3000,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x1ff0000,0x3007ff0,0xe0300f,0xc0300c03,0x300e0300,0x3ff0070,0x3003ff0,0xe03007,0xc0301c03,0x301c0301,0x1c0301c0,0x300e030,0x3ff00f,0x1ff,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x7f00000,0x1e00ffc0,0x700c,0x300007,0x38000380,0x38000,0x1800018,0x80001800,0x380003,0x30000380,0x70000,0x1e000070,0x1ffc00c,0x7f0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x7f0000,0x83001ff0,0x703003,0xc0300e03,0x301c0300,0x1c0301c0,0x301c030,0x1c03018,0xc0301c03,0x301c0301,0xe0300c0,0x83007030,0x1ff003,0x7f,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x7fe0000,0x6007fe0,0x6000,0x600006,0x60000600,0x60000,0xfe007fe0,0x6007,0x600006,0x60000600,0x60000,0x6000060,0xffe000,0xffe,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xffe0000,0x600ffe0,0x6000,0x600006,0x60000600,0x60000,0xfe007fe0,0x6007,0x600006,0x60000600,0x60000,0x6000060,0x6000,0x6,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x7f00000,0x1e00ffc0,0x700c,0x300007,0x38000380,0x38000,0x1800018,0x81f81800,0xc0381f83,0x301c0381,0x1c0701c0,0x1e01c070,0xffc01c,0x3f0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xc030000,0x300c030,0xc0300c,0xc0300c03,0x300c0300,0xfff00c0,0x300fff0,0xc0300c,0xc0300c03,0x300c0300,0xc0300c0,0x300c030,0xc0300c,0xc03,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x7fe0000,0x60007fe0,0x60000,0x6000060,0x6000,0x600006,0x60000600,0x60000,0x6000060,0x6000,0x600006,0x60000600,0x7fe000,0x7fe,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x3800000,0x80003800,0x380003,0x38000380,0x38000,0x3800038,0x80003800,0x380003,0x38000380,0x38000,0x3800038,0xc1001800,0xff801,0x7e,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x38030000,0x301c030,0x60300e,0x18300303,0x3000c300,0x730006,0xff0007b0,0xef000,0x383001c7,0x30038300,0xe030070,0x300e030,0x380301c,0x3803,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x60000,0x6000060,0x6000,0x600006,0x60000600,0x60000,0x6000060,0x6000,0x600006,0x60000600,0x60000,0x6000060,0xffe000,0xffe,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x1e070000,0xf01e070,0x1f0f01e,0xd1b01f0f,0xb01d9b01,0x1cb301d9,0xf301cf30,0x1c6301c,0xc0301c03,0x301c0301,0x1c0301c0,0x301c030,0x1c0301c,0x1c03,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xc070000,0xf00c070,0xc0f00c,0xc1f00c0f,0x300c1b00,0xc3300c3,0x6300c730,0xce300c,0xdc300cc3,0x300d8300,0xf0300f8,0x300f030,0xe0300f,0xe03,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x1f80000,0xe003fc0,0xe07007,0xc0380c03,0x381c0380,0x1c0181c0,0x181c018,0x81c01818,0xc0381c01,0x381c0381,0xc0300c0,0xe00e070,0x3fc007,0x1f8,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x1fe0000,0x6007fe0,0xe0600f,0xc0600c06,0x600c0601,0xe0600c0,0xfe007060,0x1fe007,0x600006,0x60000600,0x60000,0x6000060,0x6000,0x6,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x1f80000,0xe003fc0,0xe07007,0xc0380c03,0x381c0380,0x1c0181c0,0x181c018,0x81c01818,0xc0381c01,0x381c0381,0xc0300c0,0xe00e070,0x3fc007,0x380001f8,0x1f0000,0x1e0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x1ff0000,0x3007ff0,0xe03007,0xc0300c03,0x300c0300,0x70300e0,0xff003ff0,0xe3000,0x183001c3,0x30038300,0x7030070,0x300e030,0x1c0301c,0x3803,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x3f00000,0x1e007fc0,0x6006,0x700007,0xe0000700,0x3c0000,0xe0000f80,0x780003,0xe0000600,0xc0000,0xe0000c0,0x82006000,0x3fe007,0xfc,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x3fffc000,0x6003fffc,0x60000,0x6000060,0x6000,0x600006,0x60000600,0x60000,0x6000060,0x6000,0x600006,0x60000600,0x60000,0x60,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xc030000,0x300c030,0xc0300c,0xc0300c03,0x300c0300,0xc0300c0,0x300c030,0xc0300c,0xc0300c03,0x700c0300,0xe0700e0,0xe006060,0x3fc007,0xf0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x3800c000,0x183801c,0x81801818,0xc0301c03,0x700c0300,0x60600e0,0xe006060,0x30e007,0x39c0030c,0x80039c00,0x1f80019,0xf0001f80,0xf0000,0xf0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x3000c000,0xc3000c,0xc3000c30,0x801c3000,0x183801c3,0x18f18186,0xf1818f18,0x81999818,0x99981999,0xf0190981,0xf0f00f0,0x700f0f0,0xe0700e,0xe07,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x38018000,0x701c038,0xe0700c,0x30c0070e,0x80039c00,0x1f0001b,0xe0000f00,0xf0000,0x1b8001f0,0xc0039c00,0x60e0070,0x300e070,0x81c0380c,0x3801,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x18018000,0x301c038,0xe0700c,0x70e0070e,0x80039c00,0x1f80019,0xf0000f00,0x60000,0x6000060,0x6000,0x600006,0x60000600,0x60000,0x60,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xfff0000,0xfff0,0x60000e,0x38000700,0x18000,0xc0001c,0x60000e00,0x70000,0x3800030,0xc0001c00,0xe0000,0x7000060,0xfff000,0xfff,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x3e00000,0x60003e00,0x60000,0x6000060,0x6000,0x600006,0x60000600,0x60000,0x6000060,0x6000,0x600006,0x60000600,0x60000,0x6000060,0x6000,0x3e0003e,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x70000,0x6000060,0xc000,0x1c0000c,0x80001800,0x300001,0x60000300,0x60000,0xc0000e0,0xc000,0x1800018,0x3000,0x700003,0x600,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x7e0000,0x600007e0,0x60000,0x6000060,0x6000,0x600006,0x60000600,0x60000,0x6000060,0x6000,0x600006,0x60000600,0x60000,0x6000060,0xe0006000,0x7e0007,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x6000,0xf0000f,0x9c001980,0x30c003,0x60600606,0x300c0300,0x180181c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffe00000,0x7fffe7f,0x0},
                                         {0x0,0x0,0x0,0x0,0x380000,0x60000300,0xc0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f800000,0x6007fe00,0xe000070,0xe000,0xc0000c,0xffc00fe0,0x700c1e00,0xe0700c0,0x8700f070,0xcfe00f,0xc7c,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x30000,0x3000030,0x3000,0x1e300003,0xf007ff00,0xe0700f0,0x300c030,0x1c0301c,0xc0301c03,0x301c0301,0xc0701c0,0x1f00e0f0,0x7f3007,0x1e3,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f000000,0xe00ff800,0xe0041,0x3000070,0x3000,0x300003,0x30000300,0x70000,0x1e0000e0,0xff800c,0x3f0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xc000000,0xc000,0xc0000c,0xc7800c00,0xe00ffe00,0xe0700f0,0x380c030,0x80c0380c,0xc0380c03,0x380c0380,0xe0300c0,0x8e00f070,0xcfe00f,0xc78,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f000000,0xe003fc00,0xe070070,0x300c030,0xfff00c,0x300fff,0x30000300,0x70000,0x1e0000e0,0xffc004,0x3f0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xfc00000,0x7000fe00,0x70000,0xfff00030,0xfff00,0x300003,0x30000300,0x30000,0x3000030,0x3000,0x300003,0x30000300,0x30000,0x30,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xcf800000,0xe01ffc01,0x3070038,0x3003030,0x307003,0x1fc0038e,0xe000fc00,0x30000,0xff000070,0x1ffc007,0x80301c06,0x30180301,0xf0701c0,0xfc007fe0,0x1,0x0},
                                         {0x0,0x0,0x0,0x0,0x30000,0x3000030,0x3000,0x3c300003,0xf007f300,0xe0f0071,0x300c070,0xc0300c,0xc0300c03,0x300c0300,0xc0300c0,0x300c030,0xc0300c,0xc03,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xc00000,0xc0001c00,0x0,0xfe00000,0xfe00,0xc0000c,0xc0000c00,0xc0000,0xc0000c0,0xc000,0xc0000c,0xc0000c00,0xc0000,0xc0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xc00000,0xc0001c00,0x0,0xfe00000,0xfe00,0xc0000c,0xc0000c00,0xc0000,0xc0000c0,0xc000,0xc0000c,0xc0000c00,0xc0000,0xc0000c0,0xc000,0xe2000c,0x3e0007f0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x30000,0x3000030,0x3000,0xe0300003,0x30070300,0x1c30038,0x3b000630,0x3f000,0x670007f,0x3000e300,0x383001c,0x3007030,0xe03007,0x1c03,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x7e0000,0x600007e0,0x60000,0x6000060,0x6000,0x600006,0x60000600,0x60000,0x6000060,0x6000,0x600006,0x60000600,0x7e0000,0x7e0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe3980000,0x781f3d80,0x18e381df,0x61818618,0x81861818,0x86181861,0x18186181,0x18618186,0x61818618,0x81861818,0x1861,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3c300000,0xf007f300,0xe0f0071,0x300c070,0xc0300c,0xc0300c03,0x300c0300,0xc0300c0,0x300c030,0xc0300c,0xc03,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f800000,0xe003fc00,0xe070070,0x380c030,0x81c0381c,0xc0381c03,0x381c0381,0xc0301c0,0xe00e070,0x3fc007,0x1f8,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1e300000,0xf007ff00,0xe0700f0,0x300c030,0x1c0301c,0xc0301c03,0x301c0301,0xc0701c0,0x1f00e0f0,0x7f3007,0x3001e3,0x30000300,0x30000,0x3000030,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc7800000,0xe00ffe00,0xe0700f0,0x380c030,0x80c0380c,0xc0380c03,0x380c0380,0xe0300c0,0x8e00f070,0xcfe00f,0xc0000c78,0xc0000,0xc0000c0,0xc000,0xc,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x78c00000,0xc00fec00,0x1c0047,0xc0000c0,0xc000,0xc0000c,0xc0000c00,0xc0000,0xc0000c0,0xc000,0xc,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f000000,0xe007fc00,0x60020,0x6000070,0x3e000,0x7c0001fc,0x70000,0xe0000e0,0x200e000,0x3fe007,0xfc,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x38000380,0x38000,0x7fe00038,0x8007fe00,0x380003,0x38000380,0x38000,0x3800038,0x80003800,0x380003,0x70000300,0xff000c,0x7e0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0300000,0x300c0300,0xc0300c0,0x300c030,0xc0300c,0xc0300c03,0x300c0300,0xe0700c0,0x8e00f070,0xcfe00f,0xc7c,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0380000,0x300c0300,0x60700e0,0x6006060,0x30e007,0x38c0038c,0x80019c00,0xf8001d,0xf0000f80,0x70000,0x60,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80180000,0x18380183,0x18018180,0xe3818018,0x18f3018,0xdb3018f3,0xb00d9b01,0xf0f00f1,0xf00f0f0,0xe0600e,0xc06,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0380000,0x60060700,0x30e0070,0xd80019c0,0xf0001,0x7000070,0x8000f000,0x19c001d,0x60030c0,0x80607007,0xc03,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0380000,0x300c0300,0x60700e0,0x6006060,0x30e007,0x38c0030c,0x80019c00,0xd80019,0xf0000f80,0x70000,0x7000070,0x80003000,0x1c0003,0x78000f8,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfff00000,0x7ff00,0x3000070,0xc0001800,0xc0001,0x7000060,0x80003000,0x1c0001,0x60000c0,0xfff000,0xfff,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x3800000,0xc0003c00,0xe0000,0xe0000e0,0xe000,0x600006,0x60000600,0x30000,0x1c0001c,0x3000,0x600006,0x60000600,0xe0000,0xe0000e0,0xe000,0x3c0000c,0x3800,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x600000,0x60000600,0x60000,0x6000060,0x6000,0x600006,0x60000600,0x60000,0x6000060,0x6000,0x600006,0x60000600,0x60000,0x6000060,0x6000,0x600006,0x600,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x1c0000,0x300003c0,0x70000,0x7000070,0x7000,0x600007,0x60000600,0xc0000,0x38000380,0xc000,0x600006,0x70000600,0x70000,0x7000070,0x7000,0x3c0003,0x1c0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8201f000,0xff0c30ff,0xf8041,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                        };

uint32_t font_ANDALEMO_24x40[95][30] = {
                                         {0x0,0x0,0x0,0x0,0x0,0xe0000,0xe00,0xe00000e,0xe0000,0xe00,0xe00000e,0xe0000,0xc00,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0x0,0x0,0xc0000,0x1e00,0xc00001e,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x618000,0x80006180,0x61800061,0x618000,0x80006180,0x61800061,0x618000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x3060000,0x30600,0x86000386,0x1870003,0x18300,0xfffc0183,0xffffc0f,0x8000c380,0xc18000c1,0xe18000,0xc000e1c0,0xfffc0061,0xffffc0f,0xe00070c0,0x30600030,0x306000,0x60003060,0x18700038,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0xc00000c,0x7e0000,0xc001ff80,0xce0008f,0xce000,0xe0000c60,0xce0000c,0xde000,0x80000fc0,0x7e00001f,0xfc0000,0x1fc00,0x8c0001cc,0x38c0003,0x38c00,0x8c00038c,0x1cc2001,0xc000fce0,0x1f80007f,0xc0000,0xc00,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x301f000,0x1c0383f8,0xc70c0187,0xc60c01,0xc00e60c,0x770c0066,0x371c00,0xf0003bf8,0x1c000019,0xc0000,0x3ce00,0x730007e6,0xc3b000e,0x801c3980,0x38c01c39,0xc38c01c,0x600e7060,0xc03007e0,0x3,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0xf0000,0xe0003fc0,0x70600070,0x606000,0x60006060,0x38e00070,0x1dc000,0x80000fc0,0x7c01807,0xe0fe01c,0x38060c70,0x3838071c,0x3701c03,0x1c01e01c,0xc03801c0,0x3e03801,0xe0077070,0xf801e3f,0x1c,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x800000,0x1c000,0x700000e0,0x300000,0x1800,0xc00001c,0xe0000,0xe00,0x600000e,0x70000,0x700,0x7000007,0x70000,0x600,0xe00000e,0xe0000,0xc00,0x1800001c,0x300000,0x7000,0xc00000e0,0x800001,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x4000,0x800000c0,0x3800001,0x70000,0xe00,0x1c00000e,0x1c0000,0x1800,0x38000038,0x380000,0x3800,0x38000038,0x380000,0x3800,0x18000038,0x1c0000,0x1c00,0xe00000e,0x70000,0x80000380,0xc00001,0x4000,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0xc0000,0x40000c00,0xccc0000c,0xff8001,0x3f00,0x3f00001e,0xffc000,0x4001ccc0,0xc00000c,0xc0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0xfff8000c,0x7fff807,0xc00,0xc00000c,0xc0000,0xc00,0xc00000c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000,0x1e00,0x1c00001e,0x180000,0x1800,0x400000c,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc000ffc0,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000,0x1e00,0xc00001e,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x1c00000,0x1c000,0xe00000c0,0x600000,0x7000,0x30000030,0x380000,0x1800,0xc00001c,0xe0000,0x600,0x7000006,0x30000,0x80000380,0x1c00001,0x1c000,0xe00000c0,0x600000,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x3e0000,0xc0007f80,0xc0e000e1,0x380e001,0x70038070,0x700380,0x7007003,0x38071c30,0x3e38071e,0x71e3807,0x30070c38,0x700700,0x3007007,0x70038070,0x80e00380,0x1c0e003,0x8000e1c0,0x3e00007f,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x1c0000,0xc0001f80,0x1fc0001f,0x184000,0x1800,0x18000018,0x180000,0x1800,0x18000018,0x180000,0x1800,0x18000018,0x180000,0x1800,0x18000018,0x180000,0xc0001800,0xffc003ff,0x3,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x1fc000,0x60007fe0,0xe00000f0,0x1c00000,0x1c000,0xc00001c0,0x1c00001,0xe000,0xe00000e0,0x700000,0x3800,0x1c000038,0xe0000,0x700,0x3800003,0x1c000,0xf00000e0,0xfff001ff,0x1,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x1f8000,0x60007fe0,0xe00000f0,0x1c00000,0x1c000,0xe00001c0,0xe00000,0x7800,0x3f00001f,0xf80000,0xe000,0xc00001c0,0x1c00001,0x1c000,0xc00001c0,0xe00001,0xf0007020,0xfc0003f,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0xf00000,0xf800,0xfc0000f8,0xec0000,0xee00,0xe70000e6,0xe38000,0xc000e180,0xe0c000e1,0xe0e000,0x7000e060,0xe03800e0,0x7fff800,0x7fff8,0xe00000e0,0xe00000,0xe000,0xe00000e0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x1ffc000,0xc001ffc0,0xc00000,0xc000,0xc00000c0,0xc00000,0xc000,0xc0001fc0,0xf0c0007f,0x1c00000,0x1c000,0x80000180,0x3800003,0x18000,0xc00001c0,0xe00001,0xe000f060,0x1fc0003f,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0xfc0000,0x8001ff00,0x1c00187,0x1c000,0xe00000e0,0xe00000,0x7000,0x70000070,0xff70007e,0x1c1f000,0x700380f0,0x700380,0x7006007,0xe00700e0,0x81c00700,0x381c003,0x1c380,0x7c0000ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x3fff000,0x3fff0,0x80000380,0x1c00001,0x1c000,0xe00000e0,0x600000,0x7000,0x38000070,0x380000,0x1c00,0xc00001c,0xe0000,0xe00,0x7000007,0x30000,0x80000380,0x1c00003,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x3f0000,0xc000ff80,0xc0e001e1,0x380e001,0x60038060,0x80e00380,0x1c0e003,0xe3c0,0x7f00007f,0xe3c000,0x7001c0e0,0x80700380,0x7007003,0x70070070,0x80700300,0x380e003,0xc001e1e0,0x3f0000ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x1f0000,0xc0007f80,0xc0e000e1,0x1c07001,0x70038070,0x80700380,0x3807003,0xe0030070,0xe1e00380,0x7ffc007,0x31f00,0x80000380,0x3800003,0x38000,0xc00001c0,0xe00001,0xe0007060,0xfc0003f,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1e00000c,0x1e0000,0xc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000,0x1e00,0xc00001e,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1e00000c,0x1e0000,0xc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000,0x1e00,0x1c00001e,0x180000,0x1800,0x400000c,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x18000,0x700001e0,0x3c0000,0x80000f00,0x1e00003,0xe000,0x800001e0,0xe000003,0x3c0000,0x7000,0x800001e0,0x1000001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fff800,0x7fff8,0x0,0x0,0x0,0xfff80000,0x7fff807,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc00000e0,0x7800001,0x1e0000,0x3800,0xc00000f0,0x3800001,0x1c000,0x380000f0,0x1e0000,0xc0000780,0xe00001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x1f8000,0x40007fe0,0xc00000f0,0x1c00000,0x1c000,0xc00001c0,0xe00000,0x7000,0x1c000038,0xe0000,0x600,0x3000007,0x30000,0x0,0x0,0x70000,0x700,0x7000007,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x3e0000,0xc000ff80,0xe001c1,0x6006003,0x30060030,0xfc180400,0xc7e180c,0x980c6318,0x61980c63,0xc61980c,0x880c6188,0x61980461,0x7719806,0x1803ff98,0x1800e7,0x3000,0xe0000070,0x81c00000,0x1ff8001,0x7e00,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x1e0000,0x1e00,0x3f00003e,0x3f0000,0x7700,0x73800073,0xe38000,0xc000e380,0xc1c000e1,0x1c1c001,0xe001c0e0,0xffe003ff,0x3807003,0x70030070,0x380700,0x6003807,0x1c0e0038,0x1c0e00,0xc,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x3ff000,0x7000fff0,0x807001e0,0x3807003,0x70038070,0x80700380,0x1807003,0xf001e070,0x7ff0007f,0x1e07000,0x70038070,0x700300,0x7007007,0x70070070,0x700700,0x3807007,0xf001e070,0x3ff000ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x1fe0000,0xc003ff80,0xe00303,0xe000,0x70000070,0x300000,0x3800,0x38000038,0x380000,0x3800,0x38000038,0x380000,0x3000,0x70000070,0xe00000,0x200e000,0x800783c0,0xfe0003ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0xff000,0x70003ff0,0xe07000f0,0x1c07001,0x70038070,0x700380,0x7007007,0x70070070,0x700700,0x7007007,0x70070070,0x700700,0x7007007,0x70038070,0xc0700380,0x1e07001,0xf000f070,0xff0003f,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x1ffe000,0xe001ffe0,0xe00000,0xe000,0xe00000e0,0xe00000,0xe000,0xe00000e0,0xffe001ff,0xe001,0xe00000e0,0xe00000,0xe000,0xe00000e0,0xe00000,0xe000,0xe00000e0,0xffe001ff,0x1,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x3ffe000,0xe003ffe0,0xe00000,0xe000,0xe00000e0,0xe00000,0xe000,0xe00000e0,0xffe001ff,0xe001,0xe00000e0,0xe00000,0xe000,0xe00000e0,0xe00000,0xe000,0xe00000e0,0xe00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0xfe0000,0xc003ff80,0xe00383,0xe002,0x70000070,0x300000,0x3800,0x38000038,0x380000,0x3800,0x3807f038,0x3807f0,0x7003007,0x70070070,0xe00700,0x700e007,0x800783c0,0xfe0003ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x3807000,0x70038070,0x80700380,0x3807003,0x70038070,0x80700380,0x3807003,0xf0038070,0xfff003ff,0x3807003,0x70038070,0x80700380,0x3807003,0x70038070,0x80700380,0x3807003,0x70038070,0x80700380,0x3,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0xffc000,0xffc0,0x1c00001c,0x1c0000,0x1c00,0x1c00001c,0x1c0000,0x1c00,0x1c00001c,0x1c0000,0x1c00,0x1c00001c,0x1c0000,0x1c00,0x1c00001c,0x1c0000,0xc0001c00,0xffc000ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x600000,0x6000,0x60000060,0x600000,0x6000,0x60000060,0x600000,0x6000,0x60000060,0x600000,0x6000,0x60000060,0x600000,0x6000,0x70000060,0x700000,0xf0003830,0xfe0001f,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0xe007000,0x70070070,0x80700380,0x1c07003,0x7000e070,0x38700070,0x1c7000,0x70000c70,0x1f70000e,0x1ff000,0xf00039f0,0x70700078,0xe07000,0x7001e070,0x807001c0,0x7807003,0x70070070,0x700e00,0x1e,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0xe000,0xe00000e0,0xe00000,0xe000,0xe00000e0,0xe00000,0xe000,0xe00000e0,0xe00000,0xe000,0xe00000e0,0xe00000,0xe000,0xe00000e0,0xe00000,0xe000,0xe00000e0,0xffe003ff,0x3,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x780f000,0xf00780f0,0xc1f007c0,0x7c1f007,0x300761b0,0x73300763,0x7373007,0x30073630,0x1e30071e,0x71c3007,0x30070030,0x300700,0x7003007,0x30070030,0x300700,0x7003007,0x30070030,0x300700,0x7,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x3007000,0xf00300f0,0x1f00300,0x301f003,0xf00303f0,0x7700303,0x3077003,0x70030670,0xc70030e,0x31c7003,0x70031870,0x38700338,0x3707003,0x70037070,0xe07003e0,0x3c07003,0x7003c070,0x80700380,0x3,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x3f0000,0xc000ff80,0xc0e001e1,0x3807001,0x70038070,0x300700,0x7003807,0x38070038,0x380700,0x7003807,0x38070038,0x380700,0x7003007,0x70070070,0x80700380,0x1c0e003,0x8001e1c0,0x3f0000ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x3fe000,0xe000ffe0,0x80e001e0,0x380e003,0xe00700e0,0xe00700,0x380e007,0xe00380e0,0xffe001c0,0x3fe000,0xe00000e0,0xe00000,0xe000,0xe00000e0,0xe00000,0xe000,0xe00000e0,0xe00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x3f0000,0xc000ff80,0xc0e001e1,0x3807001,0x70038070,0x300700,0x7003807,0x38070038,0x380700,0x7003807,0x38070038,0x380700,0x7003007,0x70070070,0x80700380,0x1c0e003,0x8001e1c0,0x7f0000ff,0x700000,0xe000,0x80000fc0,0xf,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x3ff000,0x7000fff0,0x807001e0,0x3807003,0x70038070,0x80700380,0x3807003,0x7001c070,0x7ff001e0,0x1ff000,0x70003870,0x70700038,0xf07000,0x7000e070,0xc07001c0,0x3807003,0x70070070,0x700f00,0xe,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x7e0000,0xc001ff80,0xe00083,0xe000,0xe0000060,0xe00000,0x1e000,0x800007c0,0x7e00001f,0xf80000,0x1e000,0x800001c0,0x3800003,0x38000,0x80000380,0x1c00003,0xe000e060,0x1f80007f,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0xffff800,0xffff8,0x1c00001c,0x1c0000,0x1c00,0x1c00001c,0x1c0000,0x1c00,0x1c00001c,0x1c0000,0x1c00,0x1c00001c,0x1c0000,0x1c00,0x1c00001c,0x1c0000,0x1c00,0x1c00001c,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x3807000,0x70038070,0x80700380,0x3807003,0x70038070,0x80700380,0x3807003,0x70038070,0x80700380,0x3807003,0x70038070,0x80700380,0x3807003,0x60038060,0x80e00380,0x1c0e003,0x8001e1c0,0x3f0000ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0xe001c00,0x380e001c,0x380e00,0x7003806,0x70070030,0x80700300,0x3806003,0xe00180e0,0xc0c001c0,0xc1c001,0xc000e1c0,0xe38000e1,0x738000,0x7380,0x3f000077,0x3f0000,0x3e00,0x1e00001e,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x1c000c00,0x1c1c001c,0x1c0c00,0xc001c0c,0x180e001c,0x180e00,0xe1c180e,0x180e1e18,0x3e38061e,0x6373806,0x38063338,0x63300673,0x761b007,0xf00761b0,0xc1f003c1,0x3c0f003,0xf003c0f0,0x80600380,0x3,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0xe003800,0x70070038,0x80e00700,0x1c0e003,0x8001c1c0,0x638000e3,0x770000,0x3f00,0x1c00003e,0x1c0000,0x3e00,0x7700003f,0xe38000,0xc000e1c0,0x80e001c1,0x380e003,0x38070070,0x380700,0xe,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0xe003800,0x70070038,0x80700700,0x3c0e003,0xc001c1e0,0xe38000e1,0x738000,0x7700,0x3e00003f,0x1e0000,0x1c00,0x1c00001c,0x1c0000,0x1c00,0x1c00001c,0x1c0000,0x1c00,0x1c00001c,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x3fff000,0x3fff0,0xc0000380,0x1c00001,0xe000,0x700000e0,0x700000,0x3800,0x1c00001c,0xe0000,0xe00,0x7000007,0x38000,0xc0000380,0xc00001,0xe000,0xf0000070,0xfff003ff,0x3,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0xfc0000,0xfc00,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0xfc0000fc,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x6000,0xc00000e0,0xc00000,0x1c000,0x80000180,0x3000003,0x70000,0x600,0xe000006,0xc0000,0x1c00,0x38000018,0x300000,0x3000,0x60000070,0xe00000,0xc000,0xc00001c0,0x1,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0xfc000,0xfc0,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0xc0000c00,0xfc0000f,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x1c000000,0x1e0000,0x3e00,0x63800033,0xe18000,0xc000c1c0,0x80600180,0x3007003,0x38070030,0x600,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfe1ffffe,0x1fff,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x78000,0xf00,0x1c00000e,0x180000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffc0007e,0x1e1c000,0x18040,0x80000380,0x3800003,0x8003fc00,0x87c003ff,0x381e003,0x600380e0,0x80600380,0x3c0e003,0xc003f1e0,0xf80033f,0x3,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x6000,0x60000060,0x600000,0x6000,0x60000060,0xfe60007c,0x1c3e000,0xe00381e0,0x600380,0x7006007,0x60070060,0x600700,0x7006007,0x60070060,0x80e00300,0x381e003,0x6001e3e0,0x7c6000ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff0000fc,0x103c003,0xe00001c0,0x700000,0x7000,0x70000070,0x700000,0x7000,0x70000070,0xe00000,0x1c000,0x103c0,0xfc0003ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x3800000,0x38000,0x80000380,0x3800003,0x38000,0xbfc0038f,0x3e1e003,0x7003c0e0,0x80700380,0x3803003,0x38038038,0x80380380,0x3803003,0x70038030,0xc0700380,0x3e0e003,0xc003f1e0,0x8f0003bf,0x3,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff80003e,0x1e1c000,0x6001c0e0,0x80700380,0x3007003,0xf003fff0,0x7003ff,0x7000,0x70000070,0xe00000,0x1e000,0x800103c0,0xfe0003ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x1f80000,0x3fc00,0xe00031e,0xe0000,0xe0000e00,0xffe001ff,0xe0001,0xe00,0xe00000e,0xe0000,0xe00,0xe00000e,0xe0000,0xe00,0xe00000e,0xe0000,0xe00,0xe00000e,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffc0079f,0xf1e007,0x6000e0e0,0xc06000e0,0xe06000,0xe000e0e0,0x3fc00071,0x1f8000,0x600000c0,0x700000,0x1ffe000,0xc003ffc0,0x600700,0x6007006,0x30070030,0x80700700,0x1e0e003,0x8000ffc0,0x3f,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x6000,0x60000060,0x600000,0x6000,0x60000060,0xfe600078,0x1c36001,0xe00381e0,0x80600380,0x3806003,0x60038060,0x80600380,0x3806003,0x60038060,0x80600380,0x3806003,0x60038060,0x80600380,0x3,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x180000,0x3800,0x18000038,0x0,0xc0000000,0x3fc0003f,0x380000,0x3800,0x38000038,0x380000,0x3800,0x38000038,0x380000,0x3800,0x38000038,0x380000,0x3800,0x38000038,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x180000,0x3800,0x18000038,0x0,0xc0000000,0x3fc0003f,0x380000,0x3800,0x38000038,0x380000,0x3800,0x38000038,0x380000,0x3800,0x38000038,0x380000,0x3800,0x38000038,0x380000,0x3800,0x18000018,0x1c2000,0xc0000fe0,0x7,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x6000,0x60000060,0x600000,0x6000,0x60000060,0xc0600380,0xe06001,0x60007060,0x1c600038,0xe6000,0xe00007e0,0xfe00007,0x1ce000,0x60003860,0xf0600078,0x1e06000,0x6001c060,0x600380,0x7,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0xfe000,0xfe0,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0xfc0001fc,0x1,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x38000000,0xefb80387,0x72e7803,0x38071c78,0xc38061c,0x60c3806,0x38060c38,0xc38060c,0x60c3806,0x38060c38,0xc38060c,0x60c3806,0x38060c38,0xc38060c,0x6,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60000000,0xfe600078,0x1c36001,0xe00381e0,0x80600380,0x3806003,0x60038060,0x80600380,0x3806003,0x60038060,0x80600380,0x3806003,0x60038060,0x80600380,0x3,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff80003f,0x1e1c000,0x700380e0,0x700380,0x7003003,0x38070038,0x380700,0x7003007,0x70070030,0x80700300,0x3c0e003,0x8001e1c0,0x3f0000ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60000000,0xfe60007c,0x1c3e000,0xe00381e0,0x600380,0x7006007,0x60070060,0x600700,0x7006007,0x60070060,0x80e00300,0x381e003,0x6001c3e0,0x7c6000ff,0x6000,0x60000060,0x600000,0x6000,0x60000060,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xbfc0038f,0x3f1e003,0x7003c0e0,0x807003c0,0x3803003,0x38038038,0x80380380,0x3803803,0x70038030,0x80700380,0x3c0e003,0xc003f1e0,0x8f0003bf,0x3800003,0x38000,0x80000380,0x3800003,0x38000,0x380,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0xf9c001f1,0x11dc003,0xc00007c0,0x3c00003,0x1c000,0xc00001c0,0x1c00001,0x1c000,0xc00001c0,0x1c00001,0x1c000,0xc00001c0,0x1c00001,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff80007e,0x81c001,0x600000e0,0xe00000,0x3e000,0x80001fc0,0xfe00007f,0x1f00000,0x1c000,0x80000380,0x1800003,0xe001e060,0x3fc000ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x700,0x7000007,0x70000,0xe0000700,0xffe001ff,0x70001,0x700,0x7000007,0x70000,0x700,0x7000007,0x70000,0x700,0x7000007,0x70000,0x30e00,0xf80003fe,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60000000,0x80600380,0x3806003,0x60038060,0x80600380,0x3806003,0x60038060,0x80600380,0x3806003,0x60038060,0x80600380,0x3c0e003,0xc003f0e0,0x8f8003bf,0x3,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x38000000,0x80700700,0x3807003,0xe0018070,0xc0e001c0,0xc0c001,0xc000e1c0,0x718000e1,0x738000,0x3380,0x3f00003f,0x1f0000,0x1e00,0xc00001e,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x38000000,0x380e00,0xe00380e,0x30060038,0x1c300600,0x61c3006,0x30073e30,0x37700736,0x3637007,0xe0036370,0xc1e003e1,0x3c1e003,0xe00380e0,0x80e00380,0x3,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70000000,0x80700380,0x1c0e001,0xc000e1c0,0x73800061,0x3f0000,0x1f00,0x1e00001e,0x1e0000,0x80003f00,0x61c00073,0xe1c000,0x7001c0e0,0x80700380,0x3,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x38000000,0x80700700,0x3807003,0xe0018070,0xc0e001c0,0xc0c001,0xc000e1c0,0x618000e1,0x738000,0x3380,0x3f000033,0x1f0000,0x1e00,0xe00001e,0xc0000,0xe00,0x7000006,0x38000,0xf80001f8,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0xffe003ff,0x1c00001,0xe000,0x70000060,0x380000,0x1800,0xe00001c,0x60000,0x80000700,0x1800003,0x1c000,0xe00000e0,0xfff003ff,0x3,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0xe00000,0xf800,0x18000038,0x1c0000,0x1c00,0x1c00001c,0x1c0000,0x1c00,0xc00001c,0xc0000,0x80000600,0x3800003,0x60000,0xc00,0x1c00000c,0x1c0000,0x1c00,0x1c00001c,0x1c0000,0x1c00,0x38000018,0xf80000,0xe000,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0xc00000c,0xc0000,0xc00,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x3c000,0x7c0,0xe000007,0xe0000,0xe00,0xe00000e,0xe0000,0xc00,0xc00000c,0x1c0000,0x3800,0x70000070,0x380000,0x1c00,0xc00000c,0xc0000,0xe00,0xe00000e,0xe0000,0xe00,0x700000e,0x7c000,0x3c0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf80001e0,0x3e1c0807,0x7f8040c,0x3e000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                        };

uint32_t font_ANDALEMO_26x44[95][36] = {
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x3c000000,0xf00000,0x3c000,0xf00,0xf000003c,0x3c00000,0xf0000,0x3c00,0x800000e0,0x6000003,0x180000,0x6000,0x180,0x18000006,0x600000,0x0,0x0,0x0,0x3800000,0xf0000,0x3c00,0x800000f0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xc3000000,0x70c0001,0x1c3000,0x70c0,0xc0001c3,0x18300007,0x60c000,0x18300,0x60c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x1c000000,0x3830000c,0xe0c000,0x38380,0x38000e0e,0x70e00018,0x1c18000,0xe03ffff8,0x7000ffff,0xe0c00030,0x3830000,0xe0e00,0xe0003838,0x83800060,0x7060001,0x3ffff80,0xc00ffffe,0x830000c1,0xe0c0003,0x383800,0x800060e0,0x6000183,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x380,0xfc00000e,0xffc0007,0x3ff800,0xc0000ff0,0xe7800039,0x38e0000,0xe3800,0x39e0,0xfc0000e7,0xfc00003,0x7e0000,0x7e000,0x3f80,0x380001ee,0x38e00007,0xe38000,0x38e00,0xe0000e38,0x7380003c,0x1fe3000,0x3ffc0,0xf80007ff,0xe000003,0x380000,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x1e00000,0x381fc00c,0x60f380,0x1c01c387,0x3070030c,0x18c1c00e,0x730700,0xe000ce1c,0x7f8003bc,0x1c780006,0x300000,0xe000,0x180,0xce0003e7,0xe3b8001f,0x30e7000,0x801c19c0,0xce007073,0x61c01c1,0xc383007,0x8038e0e0,0x7007f01,0xf8,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x3e000000,0x1fe0000,0xffc00,0xe0003878,0x38001c0,0xc0e0007,0x303800,0xe1c0,0xf80001c7,0x7c00003,0xf00f0038,0x3e07f00,0x1c0381ce,0x7038070e,0x3380e00c,0xfe0380,0x3801f00e,0xe00780,0xf807801c,0x7f83c00,0x80fcfff0,0xf803e1ff,0xf01,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x38000000,0xe00000,0x38000,0xe00,0xe0000038,0x3800000,0x60000,0x1800,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c000002,0x380000,0x7000,0xc00000e0,0x7000001,0xe0000,0x3800,0xc0000070,0x7000001,0x1c0000,0x7800,0x800000e0,0xe000003,0x380000,0x1e000,0x700,0x7000001c,0x1c00000,0xe0000,0x3800,0x1c0,0x38000007,0x1c00000,0xe0000,0x7000,0x80,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x70000,0x3800,0x1c0,0x3800000e,0x1c00000,0xe0000,0x3800,0xe0,0x1c000007,0x700000,0x1c000,0xf00,0xf000003c,0x3c00000,0x70000,0x1c00,0xc0000070,0x3800001,0xe0000,0x3800,0xe0000070,0x3800000,0x70000,0xe00,0x2000001c,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x18000000,0x600000,0x218000,0x8001c670,0xfc0003db,0x7c00007,0x1f0000,0x1ff00,0x9c000f6e,0x6000071,0x180000,0x6000,0x180,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000038,0x3800000,0xe0000,0x3800,0x800000e0,0xe000003,0x1ffff000,0x7fffc0,0x380,0x3800000e,0xe00000,0x38000,0xe00,0xe0000038,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3800000,0x1f0000,0x7c00,0x800001f0,0xc000007,0x300000,0x6000,0x80,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0xff8000ff,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3800000,0xf0000,0x7c00,0x800000f0,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc000007,0x380000,0xe000,0x1c0,0xc000007,0x380000,0xe000,0x1c0,0xe000007,0x380000,0x6000,0x1c0,0xe000007,0x380000,0x6000,0x1c0,0xe000003,0x380000,0x7000,0x1c0,0xe000003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x7c000000,0x7fc0000,0x3ff800,0xe001f0f0,0x3800701,0xe00e003c,0x3803c00,0xc01e0070,0x87007801,0x1f1c01c3,0x1c7c7007,0x71f1c0,0x1c01c7c7,0x70070e,0x7801c01c,0x1e00700,0xe003803c,0x3800e00,0x701e003c,0x1f0f000,0x3ff80,0xc00007fc,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x78000000,0x1f80000,0x7f800,0xc0001ff0,0xc0000071,0x7000001,0x1c0000,0x7000,0x1c0,0x1c000007,0x700000,0x1c000,0x700,0x7000001c,0x1c00000,0x70000,0x1c00,0xc0000070,0x7000001,0x1c0000,0xfffc0,0xfc003fff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x3f800000,0x3ff8000,0x1ffe00,0xf810,0x3c0,0x7800001e,0x1c00000,0x70000,0x1e00,0xe0000038,0x1c00000,0x70000,0xe00,0x70000038,0xe00000,0x1c000,0x380,0xe000007,0x380000,0x7000,0x8007ffe0,0xfe001fff,0x7f,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x3f800000,0x3ff0000,0x1ffc00,0xf830,0x380,0x7800001e,0x1e00000,0x78000,0xe00,0x7c00003c,0x7e0000,0x1f800,0x1fe0,0x800000f8,0x1c000007,0x700000,0x1c000,0x700,0x7800001c,0xf81800,0x8001ffe0,0xfc0003ff,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0xf800003,0x3f0000,0xfc00,0x700003b8,0x39c0000e,0xe38000,0x38e00,0x30000e1c,0xe0e00038,0x3818000,0xe0700,0x3800380e,0x807000e0,0xe01c003,0x1ffff80,0xf807fffe,0x1fff,0x3800000e,0xe00000,0x38000,0xe00,0x38,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xffc00000,0xfff0003,0x3ffc00,0xc0000070,0x7000001,0x1c0000,0x7000,0x1c0,0xfc000007,0x3ff00007,0x1ffc000,0xf0600,0x7800,0x1c0,0x1c000007,0xf00000,0x1c000,0x700,0x3800001c,0xf83000,0x8001ffe0,0xf80003ff,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xf8000000,0x1ff80003,0x7ff000,0x800183e0,0xf000003,0x1c0000,0x7800,0x800000e0,0xe000003,0x3f380000,0x3ffe000,0x1fffc0,0x7800f83e,0xe003c0,0x7803801e,0x1c00e00,0xc0070038,0x7001e01,0xe0380038,0x3e1e000,0x7ff00,0x80000ff8,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xffe00000,0x3fff800f,0xfffe00,0x38000,0x700,0x7800001c,0xe00000,0x38000,0x700,0x3800001c,0xe00000,0x3c000,0x700,0x3800001c,0xe00000,0x1c000,0x700,0x3800001e,0xe00000,0x1c000,0x700,0x3800000e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x7e000000,0x7fc0000,0x3ff800,0xe001f0f0,0x3800701,0xe00e003c,0x3803800,0x700e0,0x78001c07,0x7fc0003c,0xfe0000,0x7fe00,0x78007c7c,0xe001c0,0x3803c00e,0x1e00700,0x7007801c,0x3c01e00,0xf01e0038,0x1e0f800,0x7ffc0,0xe00007fe,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x3e000000,0x3fe0000,0x1ffc00,0xe000f0f0,0x3800781,0xf00f001c,0x3803c00,0xc00e00f0,0xe003803,0x807800e0,0x1f83e007,0x7fff00,0x8001fff8,0x39f,0x3800000e,0xe00000,0x3c000,0x700,0x3c00001e,0x783000,0x8001ffc0,0xf80001ff,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000,0x3c00,0xc00000f0,0xe000003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3800000,0xf0000,0x3c00,0x800000f0,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000,0x3c00,0xc00001f0,0xe000003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3800000,0x1f0000,0x7c00,0x800001f0,0xc000007,0x300000,0x6000,0x80,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x78000018,0x700000,0xf000,0xe00000e0,0x1e00001,0x3c000,0x380,0xc000001c,0x1e000001,0xe00000,0xf0000,0x7000,0x780,0x40000018,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0xff007fff,0x1ff,0x0,0x0,0x0,0xfff00000,0x7fffc01f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x3000000,0x3c0000,0x1c000,0x1e00,0xe0,0xf000000f,0x7000000,0x380000,0x7000,0xf0000070,0xe00000,0x1e000,0xc00001c0,0x3000003,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x7f000000,0x7ff0000,0x3ffc00,0xf030,0x380,0x7000001c,0xc00000,0x38000,0xf00,0x3c00001e,0x780000,0xf000,0x800000e0,0xe000003,0x180000,0x0,0x0,0x0,0xe00000,0x7c000,0x1f00,0xe000007c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xfc000000,0xffc0000,0x787800,0xc0038070,0x1800c00,0x80070060,0xe000c01,0xc031f830,0xe180c7f0,0x6186031c,0x31c3180c,0x80c70c60,0xe6031c31,0xc3980c70,0xc30e6030,0x18c3180,0x180638c6,0x7ce00ce7,0x38e3001f,0xc00,0x80000060,0x1c000003,0x80e00000,0x7ff0001,0x7f000,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x3c000000,0x1f00000,0x7c000,0x1f80,0xb80000fe,0xee00003,0x79c000,0x1c700,0x3800071c,0xe0e0003c,0x3838000,0x1e0700,0xf000701c,0xffe001ff,0x3fff800f,0xe00e00,0x7003803c,0x1c01c00,0xc0078070,0xf000e01,0xe0380038,0x1c0e000,0x780,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xffe00000,0xfff8000,0x7ffe00,0xe001e038,0x3800f00,0xe00e0038,0x3803800,0x800e00e0,0xe001c03,0xfff80078,0xffe000,0xfff80,0x3800780e,0xe003c0,0x7003801e,0x1c00e00,0xe0070038,0x3801c00,0xf00e0078,0x3e03800,0x8007ffe0,0xfe000fff,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xfc000000,0x3ffc0007,0xfff800,0xe00301f0,0x3800001,0xf0000,0x1c00,0xc0000070,0x7000001,0x1e0000,0x7800,0x800001e0,0x1e000007,0x700000,0x1c000,0x700,0xf000001c,0x3800000,0x801e0000,0x381f000,0x1fff80,0xc0003ffc,0x1f,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x1fe00000,0x3ff8000,0x1ffe00,0xe000f838,0x3800780,0xf00e003c,0x3803800,0x801e00e0,0xe007003,0x3801c0,0x1c00e007,0x700380,0x3801c00e,0xe00700,0x7003801c,0x1e00e00,0xe0038038,0x3800f00,0x780e003c,0xf83800,0x8001ffe0,0xfe0003ff,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xffc00000,0x1fff0007,0x7ffc00,0xc0000070,0x7000001,0x1c0000,0x7000,0x1c0,0x1c000007,0xfff00000,0x7ffc001,0x1fff00,0x7000001c,0x1c00000,0x70000,0x1c00,0xc0000070,0x7000001,0x1c0000,0x7000,0x7ffc0,0xfc001fff,0x7f,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xffc00000,0x3fff000f,0xfffc00,0xc0000070,0x7000001,0x1c0000,0x7000,0x1c0,0x1c000007,0x700000,0x7ffc000,0x1fff00,0x70007ffc,0x1c00000,0x70000,0x1c00,0xc0000070,0x7000001,0x1c0000,0x7000,0x1c0,0x1c000007,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xfc000000,0x3ffc0007,0xfff800,0xe00301f0,0x3800001,0xf0000,0x1c00,0xc0000070,0x7000001,0x1e0000,0x7800,0x800001e0,0x1e01fe07,0xe07007f8,0x7001c01f,0x1c00700,0xf007001c,0x7801c00,0xc01e0070,0x781f001,0x1fff80,0xc0001ffc,0x1f,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xe00000,0x3803800e,0xe00e00,0xe0038038,0x3800e00,0xe00e0038,0x3803800,0x800e00e0,0xe003803,0xfff800e0,0xfffe003,0x3fff80,0x3800e00e,0xe00380,0x3803800e,0xe00e00,0xe0038038,0x3800e00,0xe00e0038,0x3803800,0x800e00e0,0xe003803,0xe0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xffc00000,0xfff0003,0x3ffc00,0xe00,0xe0000038,0x3800000,0xe0000,0x3800,0x800000e0,0xe000003,0x380000,0xe000,0x380,0x3800000e,0xe00000,0x38000,0xe00,0xe0000038,0x3800000,0xe0000,0x3ffc0,0xfc000fff,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0x7000001,0x1c0000,0x7000,0x1c0,0x1c000007,0x700000,0x1c000,0x700,0x7000001c,0x1c00000,0x70000,0x1c00,0xc0000070,0x7000001,0x1c0000,0x7000,0x1c0,0x1e000007,0x3c0800,0xc000fff0,0xfc0001ff,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xe00000,0xf0038078,0x1e00e00,0xe0038038,0x3800700,0x1c0e000e,0x383800,0x800070e0,0x8e0001e3,0x7380003,0x3ee000,0xff80,0x780007be,0xf0e0003c,0x7838000,0x3c0e00,0xe000f038,0x3800780,0xf00e003c,0x7803800,0x803c00e0,0xe00e003,0x780,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x1c00000,0x70000,0x1c00,0xc0000070,0x7000001,0x1c0000,0x7000,0x1c0,0x1c000007,0x700000,0x1c000,0x700,0x7000001c,0x1c00000,0x70000,0x1c00,0xc0000070,0x7000001,0x1c0000,0x7000,0xfffc0,0xfc003fff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xf00000,0x7c07c01e,0x1f01f00,0xf007c07c,0xdc01f83,0xd8370076,0x771dc01,0xc01cc670,0xe7007319,0x1b1c01ce,0x1c7c7007,0x70e1c0,0x1c01c387,0x700700,0x7001c01c,0x1c00700,0x7007001c,0x1c01c00,0xc0070070,0x7001c01,0xc01c0070,0x7007001,0x1c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xf00000,0x3807c00e,0xe01f00,0xf003807c,0xfc00e03,0xe07f0038,0x381fc00,0xc00e0ef0,0xcf00383b,0x873c00e1,0xe18f003,0x38e3c0,0x3c00e38f,0x70f0039c,0x3b83c00e,0xee0f00,0xf003f03c,0x3c00fc0,0xf80f003f,0x3e03c00,0xc00f00f0,0xf003c03,0xe0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x7e000000,0x7fc0000,0x3ffc00,0xe001f0f0,0x3800f01,0xe00f0038,0x7801c00,0xc01c0070,0x7007001,0x1e01c0,0x1c007807,0x807001e0,0x1e01c007,0x700700,0x7001c01c,0x1c00700,0xf007801c,0x3800e00,0xf01e0038,0x1f0f000,0x3ffc0,0xe00007fc,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xffc00000,0xfff0000,0x7ffc00,0xc003e070,0x7000f01,0xe01c0038,0x7807001,0x1e01c0,0x1c003807,0xe07000f0,0x7ffc003,0xfff00,0x70000ffc,0x1c00000,0x70000,0x1c00,0xc0000070,0x7000001,0x1c0000,0x7000,0x1c0,0x1c000007,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x7e000000,0x7fc0000,0x3ffc00,0xe001f0f0,0x3800f01,0xe00f0038,0x7801c00,0xc01c0070,0x7007001,0x1e01c0,0x1c007807,0x807001e0,0x1e01c007,0x700700,0x7001c01c,0x1c00700,0xf007801c,0x3800e00,0xf01e0038,0x1f0f000,0x3ffc0,0xe00007fc,0xf000001f,0x3fc00000,0xfe0000,0x3f000,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xffe00000,0xfff8000,0x7ffe00,0xe001e038,0x3800f00,0xe00e0038,0x3803800,0x800e00e0,0xe003803,0xf0380070,0x3ffe001,0x3ff80,0x380007fe,0xf0e0001c,0x7838000,0x1c0e00,0xe000f038,0x3800780,0xf00e001e,0x3803800,0x801e00e0,0xe00f003,0x380,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xfc000000,0x1ffc0001,0x3ff800,0xc000c1f0,0x3800001,0xe0000,0x3800,0x1e0,0x7800000f,0x7c00000,0x7e0000,0x7e000,0x3e00,0x1e0,0x38000007,0xe00000,0x38000,0xe00,0x7000003c,0x1f03000,0x3ffc0,0xf80007ff,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xfff80000,0xffffe03f,0x3ffff80,0xe00,0xe0000038,0x3800000,0xe0000,0x3800,0x800000e0,0xe000003,0x380000,0xe000,0x380,0x3800000e,0xe00000,0x38000,0xe00,0xe0000038,0x3800000,0xe0000,0x3800,0x800000e0,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xe00000,0x3803800e,0xe00e00,0xe0038038,0x3800e00,0xe00e0038,0x3803800,0x800e00e0,0xe003803,0x803800e0,0xe00e003,0x380380,0x3800e00e,0xe00380,0x3803800e,0xe00e00,0xe0038038,0x7800e00,0x701c003c,0x1e0f000,0x3ff80,0xe00007fc,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x1c0000,0xe000f078,0x3800380,0x780f000e,0x1c01c00,0xc0070070,0x3803c01,0x800e00e0,0xe003803,0xc0700070,0x701c001,0xe0700,0xe0003838,0xc38000e0,0x71c0003,0x1c7000,0x79c0,0xb80000ef,0xfe00003,0x1f8000,0x7c00,0xc00001f0,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x1c0000,0xc0007070,0x70001c1,0x1c1c0007,0x703000,0x800180e0,0xe000e03,0xe0380038,0xc380e0e0,0x1f0e0383,0x187c380e,0x61b0e0,0x8c018ee3,0xc6300739,0x731dc01c,0x1dc3700,0xf00760dc,0xfc00d83,0xf81e003e,0x3c07800,0x800f01e0,0xe003c03,0xe0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x380000,0x7001c038,0x1c00f00,0xe0038038,0x7000f01,0x3838001c,0xf1e000,0x1c700,0xe00007b8,0x1f00000f,0x7c0000,0xe000,0x7c0,0xfe00003f,0x7bc0000,0x1c7000,0x8000e1e0,0x7000783,0xf01e001c,0x3803800,0xc01c0070,0x380f001,0x380,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x380000,0x7001c03c,0x1e00f00,0xe0038038,0x7000f01,0x783c001c,0xe0e000,0x3c780,0xf000071c,0x3f80000e,0x7e0000,0x1f000,0x380,0x3800000e,0xe00000,0x38000,0xe00,0xe0000038,0x3800000,0xe0000,0x3800,0x800000e0,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xffe00000,0x3fff800f,0xfffe00,0x3c000,0x700,0x3800001e,0x700000,0x1c000,0x380,0x1c00000f,0x380000,0xe000,0x1c0,0xe000007,0x3c0000,0x7000,0x800000e0,0x7000003,0x1c0000,0x3800,0xc00ffff0,0xff003fff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xf8000000,0xfe00003,0x38000,0xe00,0xe0000038,0x3800000,0xe0000,0x3800,0x800000e0,0xe000003,0x380000,0xe000,0x380,0x3800000e,0xe00000,0x38000,0xe00,0xe0000038,0x3800000,0xe0000,0x3800,0x800000e0,0xe000003,0x380000,0xfe000,0x3f80,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xe00000,0x30000,0x1c00,0x80000070,0xe000003,0x300000,0x1c000,0x600,0xe0000038,0x7000000,0x1c0000,0x6000,0x380,0x7000000e,0x1c00000,0x60000,0x3800,0xc0,0x1c000007,0xe00000,0x38000,0xc00,0x70,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x3fc00000,0xff0000,0x38000,0xe00,0xe0000038,0x3800000,0xe0000,0x3800,0x800000e0,0xe000003,0x380000,0xe000,0x380,0x3800000e,0xe00000,0x38000,0xe00,0xe0000038,0x3800000,0xe0000,0x3800,0x800000e0,0xe000003,0x380000,0xff00,0x3fc,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x380,0x7c00001f,0x3b80000,0xc6000,0x71c0,0x6000183,0x701c000e,0x1803000,0x800e00e0,0x7003001,0xe01c0,0xe,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffff800,0xfffffe3,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0xc0000000,0x1e000003,0x700000,0x38000,0xc00,0x60,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3fc000,0x3ffc0,0x18001fff,0xc0000078,0xe000003,0x380000,0xe000,0xff0003fc,0x3ffe000f,0xe0fc00,0xe0038078,0x3800e00,0xf80e003c,0x3f87800,0xeffc0,0xf00039fe,0xe1,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xe00000,0x38000,0xe00,0xe0000038,0x3800000,0xe0000,0x3e3800,0x8003fee0,0x7e001fff,0xc07800f8,0x1e00e003,0x700380,0x3801c00e,0xe00700,0x7003801c,0x1c00e00,0xe0070038,0x3801e00,0xf01e0038,0x1e1f800,0x8007ffe0,0x8e000ffb,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3fe0000,0x7fe00,0x7c001ffe,0xf00000,0x1e000,0x380,0x1c00000e,0x700000,0x1c000,0x700,0xe0000038,0x7800000,0x3c0000,0x103f000,0xfff80,0x80003ff8,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3800000e,0xe00000,0x38000,0xe00,0xe0000038,0x38f8000,0xe7f80,0x3e003fff,0xc07800fc,0xf00f003,0x3801c0,0x1c00e007,0x700380,0x3801c00e,0xe00700,0x7003801c,0x3c00e00,0xf80e0038,0x3f0f800,0xfffc0,0xf00039fe,0xe1,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f0000,0x1ff00,0x3c000ffe,0xc0780078,0xe00e003,0x380180,0xfc00ffff,0xfff003ff,0x1c00f,0x700,0xe000003c,0x7800000,0x3e0000,0x181f000,0x7ff80,0xc0003ffc,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0x3fe00007,0xff8000,0x10f00,0x7000001c,0x1c00000,0x1fff800,0x8007ffe0,0xc0001fff,0x7000001,0x1c0000,0x7000,0x1c0,0x1c000007,0x700000,0x1c000,0x700,0x7000001c,0x1c00000,0x70000,0x1c00,0xc0000070,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70f8000,0x1fff80,0x3c007fff,0xf038001e,0x380e000,0xe0380,0x3800380e,0xe3c000f0,0x7ff0001,0xff800,0xc0000fc0,0x3800001,0xe0000,0x1fff800,0xfffc0,0x1c007ffe,0x3801c0,0x1c006007,0x7001c0,0x7801e007,0xffe003e0,0xfff0007,0x7f000,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xe00000,0x38000,0xe00,0xe0000038,0x3800000,0xe0000,0x7c3800,0x8003fce0,0x7e001fff,0xc0f80078,0xe00e003,0x380380,0x3800e00e,0xe00380,0x3803800e,0xe00e00,0xe0038038,0x3800e00,0xe00e0038,0x3803800,0x800e00e0,0xe003803,0xe0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x70000000,0x3c00000,0xf0000,0x1c00,0x0,0x0,0x1ff000,0x7fc0,0x1ff,0x1c000007,0x700000,0x1c000,0x700,0x7000001c,0x1c00000,0x70000,0x1c00,0xc0000070,0x7000001,0x1c0000,0x7000,0x1c0,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x70000000,0x3c00000,0xf0000,0x1c00,0x0,0x0,0x1ff000,0x7fc0,0x1ff,0x1c000007,0x700000,0x1c000,0x700,0x7000001c,0x1c00000,0x70000,0x1c00,0xc0000070,0x7000001,0x1c0000,0x7000,0x1c0,0x1c000007,0x700000,0x1c000,0x10000700,0x3fe0001e,0xff8000,0xf800,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xe00000,0x38000,0xe00,0xe0000038,0x3800000,0xe0000,0x3c03800,0x800780e0,0xe000f03,0x3c38001e,0x78e000,0xf380,0xf80001ee,0x1fe00003,0xff8000,0x78e00,0xe0001c38,0x838000e0,0x3c0e0007,0x1e03800,0x800f00e0,0xe007803,0x1c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x1fc00000,0x7f0000,0x1fc00,0x600,0x60000018,0x1800000,0x60000,0x1800,0x80000060,0x6000001,0x180000,0x6000,0x180,0x18000006,0x600000,0x18000,0x600,0x60000018,0x1800000,0x60000,0x3f800,0x80000fe0,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3c38e00,0xe00f9fb8,0xcf807fff,0xe1e01cf,0x1c383807,0x8070e0e0,0xe018383,0x3838060e,0x60e0e018,0x1838380,0x38060e0e,0xe0e01838,0x83838060,0x60e0e01,0xe0183838,0x838060e0,0x183,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7c3800,0x8003fce0,0x7e001fff,0xc0f80078,0xe00e003,0x380380,0x3800e00e,0xe00380,0x3803800e,0xe00e00,0xe0038038,0x3800e00,0xe00e0038,0x3803800,0x800e00e0,0xe003803,0xe0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f8000,0x1ff80,0x3c000fff,0xc0780078,0xe00f003,0x7801c0,0x1c01c007,0x700700,0x7001c01c,0x1c00700,0x7007001c,0x3c01e00,0xf01e0038,0x1e0f000,0x3ffc0,0xe00007fe,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3e3800,0x8003fee0,0x7e001fff,0xc07800f8,0xe00e003,0x700380,0x3801c00e,0xe00700,0x7003801c,0x1c00e00,0xe0070038,0x3801e00,0xf01e0038,0x1e1f800,0x8007ffe0,0x8e000ffb,0x38000f,0xe000,0x380,0x3800000e,0xe00000,0x38000,0xe00,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x38f8000,0xe7f80,0x3e003fff,0xc07800fc,0xf00f003,0x3801c0,0x1c00e007,0x700380,0x3801c00e,0xe00700,0x7003801c,0x3c00e00,0xf80e003c,0x3f0f800,0xfffc0,0xf00039fe,0x800000e1,0xe000003,0x380000,0xe000,0x380,0x3800000e,0xe00000,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f0e000,0xff380,0xf8003fee,0x3e00043,0x78000,0xe00,0xe0000038,0x3800000,0xe0000,0x3800,0x800000e0,0xe000003,0x380000,0xe000,0x380,0x3800000e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f0000,0x3ff80,0x3c000fff,0x780030,0xe000,0x780,0xe000007c,0xff00000f,0xfe00000,0x7c0000,0x1c000,0xe00,0x70000038,0x1f03000,0x3ffc0,0xf80007ff,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe000,0x380,0x3800000e,0xe00000,0x1fff800,0x8007ffe0,0xe0001fff,0x3800000,0xe0000,0x3800,0x800000e0,0xe000003,0x380000,0xe000,0x380,0x3800000e,0xe00000,0x3078000,0xffc00,0x3ff0,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3803800,0x800e00e0,0xe003803,0x803800e0,0xe00e003,0x380380,0x3800e00e,0xe00380,0x3803800e,0xe00e00,0xe0038038,0x3800e00,0xf80e003c,0x3f87800,0xeffc0,0xf00039fe,0xe1,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7801c00,0xc00e0070,0xe003803,0xc0380070,0x701e001,0xe0700,0xe000381c,0xc38000e0,0x70e0001,0x1e7000,0x39c0,0xf80000ef,0x7e00001,0x1f0000,0x3c00,0x800000f0,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe000e00,0xe0380038,0x300e000,0xc0380,0x1800700e,0x60e1c0,0x1c01c787,0x6c70071f,0x73b9801c,0x1cc6600,0x60037198,0xf800d87,0xf83e003e,0x3c07800,0xf01c0,0xc003807,0x60,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3801c00,0x800f00e0,0x1c001c07,0x70e00038,0x1c78000,0x39c00,0x7e0,0x3c00001f,0xf00000,0x7c000,0x1f80,0x1e0000e7,0x3c380007,0xe07000,0x800701e0,0x7003c03,0xe0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7801c00,0xc00e0070,0xe003803,0xc0380070,0x701e001,0xe0700,0xe000381c,0xc38000e0,0x70e0001,0x1c7000,0x39c0,0xb80000e7,0x7e00001,0x1f8000,0x3c00,0x800000f0,0x6000003,0x1c0000,0x3000,0xc00000e0,0x7f00001,0xfe000,0x1f00,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3fff800,0x800fffe0,0x1fff,0xe0000038,0x1c00000,0x38000,0x600,0x3800001c,0x700000,0x1c000,0x380,0xe000007,0x380000,0x7000,0x800fffe0,0xfe003fff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0xf800003,0x70000,0x1c00,0xc0000030,0x3800000,0xe0000,0x3800,0x800000e0,0xe000003,0x380000,0xe000,0xc00001c0,0x7000003,0x3c0000,0x1c000,0xe00,0xe0000038,0x3800000,0xe0000,0x3800,0x800000e0,0xc000003,0x300000,0x1c000,0x700,0xc00000f8,0x3,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x38000000,0xe00000,0x38000,0xe00,0xe0000038,0x3800000,0xe0000,0x3800,0x800000e0,0xe000003,0x380000,0xe000,0x380,0x3800000e,0xe00000,0x38000,0xe00,0xe0000038,0x3800000,0xe0000,0x3800,0x800000e0,0xe000003,0x380000,0xe000,0x380,0x3800000e,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x7800000,0x3e0000,0x1e000,0x700,0x7000001c,0x1c00000,0x70000,0x1c00,0x80000070,0x6000001,0x380000,0xe000,0x700,0xc0000078,0x7800001,0x70000,0xe00,0x60000038,0x1800000,0x70000,0x1c00,0xc0000070,0x7000001,0x1c0000,0x7000,0xe00001e0,0x7800003,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8000000,0x1ff80000,0xe1f07000,0x3ff0040,0x3e000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                        };

uint32_t font_ANDALEMO_28x50[95][44] = {
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000078,0x78000007,0x7800000,0x780000,0x78000,0x7800,0x780,0x80000078,0x70000007,0x7000000,0x700000,0x70000,0x7000,0x700,0x30,0x30000003,0x3000000,0x0,0x0,0x0,0x0,0x80000070,0xf800000f,0xf800000,0x700000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70000707,0x7000070,0x70700007,0x7070000,0x707000,0x70700,0x7060,0x60000306,0x6000030,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80003838,0x18000383,0x81c00038,0x181c0003,0x1c1c000,0x1c1c00,0xf801c0c0,0xff81ffff,0xfff81fff,0xe0e001ff,0xe060000,0xe07000,0x70700,0x7070,0x38000707,0xfff80070,0xffff81ff,0xfffff81f,0x383801,0x381c0,0xc000181c,0x1c0001c1,0xc0c0001c,0x1c0e0001,0xe0e000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6000,0x600,0xe00007f8,0xff0000ff,0xc7f8000f,0x63c000,0x63c00,0x61c0,0xc000061c,0x3c000061,0x67800006,0x7f80000,0x7f0000,0x1fc000,0x7f000,0xfe00,0x1e60,0x600001c6,0x8600003c,0x38600003,0x3860000,0x3c6000,0x1c600,0x1c001e60,0xffc000fe,0x3ffc0007,0xff0000,0x60000,0x6000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0xff003803,0xe380380,0xc1c3801c,0xe1c1c01,0xe181c0,0xc007381c,0x1c007381,0xc1c00398,0xdc380039,0x1ce38001,0xeff000,0x63e00,0x7000,0x3e300,0x80007f38,0xdc000e39,0x1ce001c1,0xc1ce001c,0x1c1c7001,0x1c1c700,0x801c1c38,0x1c01c1c3,0x81c01c1c,0xf00e00e3,0x3e00e007,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf000007e,0xff80001f,0x3c3c0001,0x381c000,0x381c00,0x380e0,0xc000381c,0x3c0003c1,0xf380001e,0x7f00000,0x3f0000,0x3c01f003,0x3e03f80,0xe00e07bc,0x7007070,0xe078070e,0xbc038039,0x1f803803,0x1f00380,0x801e0038,0xf801e007,0x1f003f00,0xffe007fc,0xffc03f3,0xc03f003e,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70,0x70000007,0x7000000,0x700000,0x70000,0x7000,0x700,0x70,0x20000006,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0xc0,0x7000000e,0x3800000,0x1c0000,0x1e000,0xe00,0x70,0x78000007,0x3800000,0x380000,0x38000,0x3c00,0x3c0,0xc000003c,0x3c000003,0x3c00000,0x3c0000,0x3c000,0x3800,0x380,0x80000038,0x70000007,0x7000000,0xe00000,0x1e0000,0x1c000,0x3800,0x700,0xe0,0x8000000c,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x38000000,0x7800000,0xf00000,0xe0000,0x1c000,0x3800,0x380,0x70,0xe0000007,0xe000000,0xe00000,0x1e0000,0x1e000,0x1e00,0x1c0,0xc000001c,0x1c000001,0x1e00000,0x1e0000,0x1e000,0xe00,0xe0,0x7000000f,0x7000000,0x380000,0x38000,0x1c00,0xe0,0x7800000f,0x3800000,0x80000,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70,0x70000007,0x7000000,0xc738000,0xf77800,0x3fe00,0x1f80,0xe00001f8,0x7780003f,0xc718000f,0x700000,0x70000,0x7000,0x700,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0x700000,0x7ffff00,0x7ffff0,0x7ffff,0x70,0x70000007,0x7000000,0x700000,0x70000,0x7000,0x700,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000070,0xf800000f,0xf800000,0xf00000,0xc0000,0x6000,0x300,0x10,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0xf80007ff,0xff80007f,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000070,0xf800000f,0xf800000,0x700000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c00,0xe0,0x7000000e,0x7000000,0x700000,0x38000,0x3800,0x1c0,0xe000001c,0xe000000,0xe00000,0x70000,0x7000,0x380,0xc0000038,0x1c000001,0x1e00000,0xe0000,0xe000,0x700,0x80000070,0x38000003,0x3c00000,0x1c0000,0x1c000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe00000f8,0xff00003f,0xf078000f,0x1e03c000,0x1c01c00,0x3c01e0,0xe003800e,0xf003800,0xf00780,0x870f0078,0x78f8f007,0x78f8f00,0x70f8f0,0xf0078f8f,0xf007870,0xf00780,0x800f0078,0x3800e007,0x3800e00,0x3c01e0,0xc001c01c,0x78001e03,0xff0000f0,0x3fe0000f,0xf80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000f0,0xfe00000f,0xff80000,0xe78000,0xe3800,0xe080,0xe00,0xe0,0xe000000e,0xe000000,0xe00000,0xe0000,0xe000,0xe00,0xe0,0xe000000e,0xe000000,0xe00000,0xe0000,0xe000,0xe00,0xe0,0xff80000e,0xfff8003f,0x3fff8003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfc00007f,0xffc0001f,0x7c0c0007,0xf000000,0xe00000,0x1e0000,0x1e000,0x1e00,0x1e0,0xe000000e,0xf000000,0x700000,0x78000,0x3c00,0x1c0,0xf000001e,0x7800000,0x3c0000,0x1c000,0xe00,0x80000070,0x1c000003,0xffe00000,0xfffe001f,0x1fffe001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfc00007f,0xffc0001f,0xfc0c0007,0xf000000,0xe00000,0x1e0000,0x1e000,0xe00,0x800000f0,0x3e000007,0x1fc0000,0xfc000,0x3fc00,0x7c00,0xf00,0x1e0,0xc000001e,0x1c000001,0x1c00000,0x1e0000,0x1e000,0xc000f00,0xffe0007c,0x1ffe0003,0x7f8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x780,0xe000007c,0x7e000007,0x7700000,0x770000,0x73800,0x73c0,0xe000071c,0xe000070,0x70700007,0x7070000,0x703800,0x703c0,0xe000701c,0xe000700,0x700070,0xffff0007,0x7ffff807,0x7ffff80,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0xf8000fff,0xff8000ff,0x38000f,0x38000,0x3800,0x380,0x80000038,0x38000003,0x3800000,0xff80000,0x3ff8000,0x7ff800,0xf8300,0x1f000,0x1e00,0x1c0,0xc000001c,0x1c000001,0x1c00000,0x1e0000,0x1e000,0xc000f00,0xffc00078,0x1ffc0003,0x7f8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc00007f0,0xfe0001ff,0x81f0001f,0xf0001,0x7800,0x3c0,0xc000003c,0x1e000001,0x1e00000,0x1e0000,0x1f8e000,0x7ffe00,0x1fffe0,0xe001e07e,0x1e003c01,0x1e00380,0x801e0078,0x7801c007,0x7801c00,0x7803c0,0x80038038,0xf0003c07,0xfe0001e1,0xffc0001f,0x3f00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0xfe003fff,0xffe003ff,0xc000003f,0x1c000003,0x1c00000,0x1e0000,0xe000,0xf00,0x80000070,0x38000007,0x3800000,0x1c0000,0x1c000,0x1e00,0xe0,0x7000000f,0x7800000,0x380000,0x38000,0x3c00,0x1c0,0xe000001e,0xf000000,0x700000,0x70000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe00001fc,0xff80003f,0xf078000f,0x1e03c001,0x3c01c00,0x3c01c0,0xc003c01e,0x1c003c01,0x3c001c0,0xf8f8001e,0x7fe0000,0x1fc000,0x7ff00,0xc000f8f8,0x1e001e03,0xe003c0,0x800f0038,0x7800f007,0x7800f00,0x7800e0,0xe003c01e,0x7c003c03,0xff8001f0,0x7ff0000f,0x1fc0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf00000fc,0xff80003f,0xf87c0007,0xe03c000,0x1e01e00,0x1c01e0,0xe003c00e,0xe003800,0xe00380,0x801e0038,0x7c03e007,0x7f07c00,0x7fff80,0x7bff0,0x78fc,0x380,0x80000038,0x3c000003,0x1c00000,0x1e0000,0xe000,0xc000f00,0xffc0007c,0x1ffc0003,0x7f0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x700,0x800000f8,0xf800000f,0x7000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000070,0xf800000f,0xf800000,0x700000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x700,0x800000f8,0xf800000f,0x7000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000070,0xf800000f,0xf800000,0xf00000,0xc0000,0x6000,0x300,0x10,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x1800000,0x1e0000,0xf800,0x7c0,0x7c00001f,0x3e00000,0xf8000,0x3c00,0x1c0,0x8000003c,0xe000000f,0x7c000003,0x1f000000,0x7c00000,0xf80000,0x1e0000,0x18000,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff000000,0xfff007ff,0xffff007f,0x7,0x0,0x0,0x0,0xff000000,0xfff007ff,0xffff007f,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c00,0x7c0,0xf8,0x8000003e,0xf0000007,0x7c000001,0xf800000,0x3e00000,0x3c0000,0x3e000,0xf80,0xf000007c,0xf800001,0x3e0000,0xf800,0x7c0,0x1c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf80000fe,0xffc0003f,0xf83c0007,0xf008000,0xe00000,0x1e0000,0xe000,0xe00,0xf0,0x78000007,0x3e00000,0x1f0000,0x7800,0x380,0xc000001c,0x1c000001,0x1c00000,0x0,0x0,0x0,0x0,0xe000001c,0x3e000003,0x3e00000,0x1c0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe00001f8,0xf00007f,0xc038000e,0x3801c001,0x7000c00,0x6000e0,0x70060006,0x300e000,0xf8300c7f,0x71c300c7,0xc70e380c,0xc70e380,0x80c30618,0x180c3071,0x7180c307,0x87180c38,0x387180c3,0x6387180e,0x63c7380,0x33ce38,0x3001fbe3,0x7000f1c,0x600000,0xe0000,0x1c000,0x3800,0x1e0f00,0xffe0,0x3f8,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000f8,0xf800000f,0x1fc00000,0x1fc0000,0x1dc000,0x3de00,0x39e0,0xe000038e,0xf000078,0x70700007,0xf070000,0xe07800,0xe0380,0xc001e038,0xfc001fff,0xffc001ff,0x801e003f,0x3800e003,0x7800e00,0x7000f0,0x70070007,0x780f000,0x380f00,0x380e0,0xe0003c1e,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0xfe0001ff,0xffe0007f,0xf01e000f,0x3c01e001,0x3c01e00,0x3801e0,0xe003801e,0x1e003801,0x1e003c0,0xf01e001c,0x7ffe000,0x3ffe00,0xfffe0,0xe001f01e,0x1e003c01,0x1e00780,0x1e0078,0x7001e007,0x7001e00,0x7801e0,0xe007801e,0x1e003c01,0xffe003f0,0x7ffe001f,0x1ffe000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe00007f0,0xff0003ff,0xc0f8003f,0x2003c003,0x1e00,0x1e0,0xf000000e,0xf000000,0x700000,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0xf00000,0xf0000,0xf000,0xe00,0x1e0,0xc000001e,0xf8002003,0xff0003c0,0xffe0007f,0x7f00003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0xfe00007f,0xffe0001f,0xfc1e0007,0x1f01e000,0x1e01e00,0x3c01e0,0xe003c01e,0x1e007801,0x1e00780,0x1e0078,0x7001e007,0x7001e00,0xf001e0,0xe007001e,0x1e007001,0x1e00700,0x801e0070,0x7801e007,0x3c01e00,0x3c01e0,0xe001e01e,0x1e001f01,0xffe000fc,0x1ffe0007,0x7fe000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0xfc001fff,0xffc001ff,0x3c001f,0x3c000,0x3c00,0x3c0,0xc000003c,0x3c000003,0x3c00000,0x3c0000,0x1fffc000,0x1fffc00,0x1fffc0,0xc000003c,0x3c000003,0x3c00000,0x3c0000,0x3c000,0x3c00,0x3c0,0xc000003c,0x3c000003,0xffc00000,0xfffc001f,0x1fffc001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0xfc003fff,0xffc003ff,0x3c003f,0x3c000,0x3c00,0x3c0,0xc000003c,0x3c000003,0x3c00000,0x3c0000,0x1fffc000,0x1fffc00,0x1fffc0,0xc000003c,0x3c000003,0x3c00000,0x3c0000,0x3c000,0x3c00,0x3c0,0xc000003c,0x3c000003,0x3c00000,0x3c0000,0x3c000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe00007f8,0xff0003ff,0xc0f8003f,0x2003c003,0x1e00,0x1e0,0xf000000e,0xf000000,0x700000,0x70000,0x7000,0x700,0x70,0x7007fc07,0x7007fc0,0xf007fc,0xf0070,0x7000f007,0x7000e00,0x7001e0,0xc007001e,0xf8007003,0xff0007c0,0xffe0007f,0x7f80001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0x1e003801,0x1e00380,0x801e0038,0x3801e003,0x3801e00,0x3801e0,0xe003801e,0x1e003801,0x1e00380,0x801e0038,0x3fffe003,0x3fffe00,0x3fffe0,0xe003801e,0x1e003801,0x1e00380,0x801e0038,0x3801e003,0x3801e00,0x3801e0,0xe003801e,0x1e003801,0x1e00380,0x801e0038,0x3801e003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0xf8000fff,0xff8000ff,0x700000f,0x700000,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0x700000,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0x700000,0x70000,0x7000,0x700,0x70,0xff800007,0xfff8000f,0xfff8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x780,0x80000078,0x78000007,0x7800000,0x780000,0x78000,0x7800,0x780,0x80000078,0x78000007,0x7800000,0x780000,0x78000,0x7800,0x780,0x80000078,0x78000007,0x7800000,0x780000,0x78000,0x3800,0x60003c0,0xffe0003e,0xfff0001,0x3fc000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0x1e01e001,0x1e00f00,0xc01e0078,0x1c01e003,0xe01e00,0x701e0,0xe000381e,0x1e0001c1,0xf1e0001e,0x79e0000,0x39e000,0x7de00,0xffe0,0xe0000f7e,0x1e0001e3,0xc1e0003c,0x781e0003,0xf01e000,0x1f01e00,0x1e01e0,0xe003c01e,0x1e007c01,0x1e00780,0x1e00f0,0xe001e01f,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0x3c000003,0x3c00000,0x3c0000,0x3c000,0x3c00,0x3c0,0xc000003c,0x3c000003,0x3c00000,0x3c0000,0x3c000,0x3c00,0x3c0,0xc000003c,0x3c000003,0x3c00000,0x3c0000,0x3c000,0x3c00,0x3c0,0xc000003c,0x3c000003,0xffc00000,0xfffc003f,0x3fffc003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0x1e007c01,0x3e007c0,0xe03e007c,0x7e07e007,0x7607e00,0x7706e0,0xe00730ee,0xce00738e,0x9ce00738,0x1dce0071,0x71f8e007,0x70f8e00,0x70f0e0,0xe007070e,0xe007000,0xe00700,0xe0070,0x7000e007,0x7000e00,0x7000e0,0xe007000e,0xe007000,0xe00700,0xe0070,0x7000e007,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0x1e003801,0x3e00380,0x803e0038,0x3807e003,0x3807e00,0x380fe0,0xe00380ee,0xce00381e,0x1ce00381,0x838e0038,0x3838e003,0x3870e00,0x3870e0,0xe0038f0e,0xe0038e0,0xc0e0039e,0xbc0e0039,0x3b80e003,0x3b80e00,0x3f00e0,0xe003f00e,0xe003e00,0xe003e0,0xc00e003e,0x3c00e003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf00001fc,0xff80007f,0xf07c000f,0x1e03c001,0x3c01e00,0x3801e0,0xf007800f,0xf007800,0x700700,0x70070,0x70007007,0x7000700,0xf00070,0x70070007,0x7007000,0x700700,0xf0070,0x7800f007,0x7800f00,0x3801e0,0xc003c01e,0x7c001e03,0xff8001f0,0x7ff0000f,0x1fc0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0xfc0001ff,0xffc0007f,0xf03c001f,0x3c03c001,0x3c03c00,0x7803c0,0xc007803c,0x3c007803,0x3c00780,0xc03c0038,0x1f03c003,0x1fffc00,0x7ffc0,0xc0001ffc,0x3c000003,0x3c00000,0x3c0000,0x3c000,0x3c00,0x3c0,0xc000003c,0x3c000003,0x3c00000,0x3c0000,0x3c000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf00001fc,0xff80007f,0xf07c000f,0x1e03c001,0x3c01e00,0x3801e0,0xf007800f,0xf007800,0x700700,0x70070,0x70007007,0x7000700,0xf00070,0x70070007,0x7007000,0x700700,0xf0070,0x7800f007,0x7800f00,0x3801e0,0xc003c01e,0x7c001e03,0xff8001f0,0x7ff0000f,0x3fc0000,0x780000,0xf8000,0xff000,0xfe00,0xfc0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0xfe0001ff,0xffe0007f,0xf01e000f,0x3c01e001,0x3c01e00,0x3801e0,0xe003801e,0x1e003801,0x1e00380,0xe01e003c,0xf01e001,0x7ffe00,0x3ffe0,0xe0000ffe,0x1e0001e1,0xc1e0001e,0x781e0003,0x781e000,0xf01e00,0x1e01e0,0xe001e01e,0x1e003c01,0x1e00780,0x1e0078,0xe001e00f,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe00007f8,0xff0000ff,0xc0f8000f,0x3c000,0x1c00,0x1c0,0xc000001c,0x3c000001,0x7800000,0x1f80000,0x7f0000,0x1fc000,0x7f000,0xfc00,0x1f00,0x1e0,0xc000003c,0x38000003,0x3800000,0x3c0000,0x1c000,0x3c001e00,0xffc000f8,0x3ff80007,0xfe0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8000000,0xff80ffff,0xfff80fff,0x70000ff,0x700000,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0x700000,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0x700000,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0x700000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0x1e003801,0x1e00380,0x801e0038,0x3801e003,0x3801e00,0x3801e0,0xe003801e,0x1e003801,0x1e00380,0x801e0038,0x3801e003,0x3801e00,0x3801e0,0xe003801e,0x1e003801,0x1e00380,0x801e0038,0x3c01e003,0x3c01e00,0x3c01c0,0xc001c01c,0x78001e03,0xff8001f0,0x7ff0000f,0x1fc0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3c000000,0x381e000,0x381e00,0x780e0,0xf000700f,0x7000700,0x7800f0,0xe007800e,0x1e003800,0x1c003c0,0xc01c003c,0x1e03c001,0x1e03c00,0xe0380,0x8000f078,0x70000f07,0xf000070,0x78f00007,0x38e0000,0x39e000,0x3de00,0x1dc0,0xc00001fc,0xf800001f,0xf800000,0xf80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c000000,0x1c1c000,0x1c1c00,0x3c1c0,0xc0003c1c,0x1e000381,0x81e00038,0x380e0003,0x380e000,0xf8380e07,0xf8380e0,0xe0f8780e,0xe1d8700,0x61dc70,0x700719c7,0xe700718c,0x8e700738,0x30670073,0x77077007,0x7707600,0x3e07e0,0xe003e03e,0x3e003e03,0x1e003e0,0xc01e003c,0x3c01e003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x78000000,0xf00e000,0xf00f00,0x801e0078,0x3c01c003,0x1e03c00,0x1e0780,0xf070,0xe000070f,0xdc000079,0x1fc00003,0x1f80000,0xf8000,0xf000,0xf80,0xc00001f8,0x9e00003f,0x78e00003,0x70f0000,0xf07000,0x1e0780,0xc001c03c,0x1e003c01,0xf00780,0x70070,0xe000780f,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x78000000,0xf00f000,0xf00f00,0x801e0078,0x3c01e003,0x1c03c00,0x1e03c0,0xf078,0xf0000f07,0x8e000078,0x3de00007,0x3fc0000,0x1fc000,0xf800,0xf80,0x70,0x70000007,0x7000000,0x700000,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0x700000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0xfe003fff,0xffe003ff,0xc000003f,0x1c000003,0x1e00000,0xf0000,0x7000,0x780,0xc0000038,0x1e000003,0xe00000,0xf0000,0x7000,0x780,0xc0000038,0x1e000003,0xe00000,0xf0000,0x7000,0x780,0xc0000038,0x1e000001,0xffe00000,0xfffe003f,0x3fffe003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff0,0xf00000ff,0x700000f,0x700000,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0x700000,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0x700000,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0x700000,0x70000,0x7000,0xff00,0xff0,0xff,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0x1c000001,0x3c00000,0x380000,0x38000,0x7000,0x700,0xe0,0xe000000e,0x1c000001,0x1c00000,0x380000,0x38000,0x7000,0x700,0xe0,0xe000000e,0x1c000000,0x1c00000,0x380000,0x38000,0x7000,0x700,0x70,0xe000000e,0x1c000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0xf800007f,0x7f800007,0x7000000,0x700000,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0x700000,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0x700000,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0x700000,0x70000,0x7000,0x800007f8,0xf800007f,0x7,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7000,0xf00,0xc00000f8,0x9c00001d,0x38e00003,0x7070000,0xf07000,0xe0380,0xc001c038,0xe001c01,0xe00380,0x70070,0xe0007007,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffe000,0xfffffe3f,0x3fffffe3,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1e0,0x8000003c,0x70000003,0xe000000,0xc00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f80,0xf8000fff,0x78000ff,0xc008001f,0x3c000001,0x3c00000,0x380000,0x38000,0xe0003fe0,0xff0003ff,0x83f8003f,0x3807c003,0x3801c00,0x3c01e0,0xc003e01e,0x3c003f01,0xff8003f8,0x8ff8003b,0x383e0003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0x1e000001,0x1e00000,0x1e0000,0x1e000,0x1e00,0x1e0,0xe0003f1e,0xfe000ffd,0xfe001ff,0xc03e001f,0x3801e003,0x7801e00,0x7801e0,0xe007001e,0x1e007001,0x1e00700,0x1e0070,0x7001e007,0x7801e00,0x7801e0,0xe003c03e,0xfe003c07,0xfde001f0,0x7f9e000f,0x3e1e000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff00,0xf0003ffc,0x1f8001ff,0x7c0018,0x3c000,0x1e00,0x1e0,0xe000000e,0xe000000,0xe00000,0xe0000,0xe000,0x1e00,0x1e0,0xc000003c,0xf8000007,0xff000181,0xffc0003f,0xff00003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3800,0x380,0x80000038,0x38000003,0x3800000,0x380000,0x387e0,0xf80039ff,0x87c003ff,0xe03e003f,0x3c01e003,0x3800e00,0x3800f0,0x7003800f,0x7003800,0x700380,0x80070038,0x3800f003,0x3800f00,0x3c00e0,0xe003e01e,0x7c003f01,0xff8003f8,0x8ff00039,0x383e0003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f80,0xf00007fe,0x78000ff,0xe03c001f,0x3c01c001,0x3800e00,0x3800e0,0xe003fffe,0xfe003fff,0xe007ff,0xe0000,0xe000,0x1e00,0x1e0,0xc000003c,0xf8000007,0xff000181,0xffe0001f,0xff00003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfc0,0xf00003ff,0x780003f,0x380001,0x38000,0x3800,0xc001fffc,0xfc001fff,0x380001ff,0x3800000,0x380000,0x38000,0x3800,0x380,0x80000038,0x38000003,0x3800000,0x380000,0x38000,0x3800,0x380,0x80000038,0x38000003,0x3800000,0x380000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x707c0,0xf8007fff,0x87c007ff,0x701c0007,0xf01e000,0xe01e00,0xf01c0,0xc000701c,0xf8000787,0xff00003f,0x7f00001,0x38000,0x1c00,0xe0,0xc000001e,0xfc001fff,0xff0003ff,0x8038007f,0x7001c007,0x7000e00,0x7000e0,0xe007800e,0x3e007c00,0xffc003f0,0x7ff8001f,0x1fe0000,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0x1e000001,0x1e00000,0x1e0000,0x1e000,0x1e00,0x1e0,0xe0007e1e,0xde000ff9,0x1fe001ff,0xc07e001e,0x3c03e003,0x3801e00,0x3801e0,0xe003801e,0x1e003801,0x1e00380,0x801e0038,0x3801e003,0x3801e00,0x3801e0,0xe003801e,0x1e003801,0x1e00380,0x801e0038,0x3801e003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0,0xe000001e,0xc000001,0x0,0x0,0x0,0x80001ff8,0xf80001ff,0xe000001f,0x1e000001,0x1e00000,0x1e0000,0x1e000,0x1e00,0x1e0,0xe000001e,0x1e000001,0x1e00000,0x1e0000,0x1e000,0x1e00,0x1e0,0xe000001e,0x1e000001,0x1e00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0,0xe000001e,0xc000001,0x0,0x0,0x0,0x80001ff8,0xf80001ff,0xe000001f,0x1e000001,0x1e00000,0x1e0000,0x1e000,0x1e00,0x1e0,0xe000001e,0x1e000001,0x1e00000,0x1e0000,0x1e000,0x1e00,0x1e0,0xe000001e,0x1e000001,0x1e00000,0x1e0000,0x1e000,0xe00,0xc0000e0,0xffc0000f,0x7fc0000,0x1f8000,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0x1e000001,0x1e00000,0x1e0000,0x1e000,0x1e00,0x1e0,0xe003c01e,0x1e001e01,0x81e000f0,0x3c1e0007,0x1e1e000,0xf1e00,0x7de0,0xe00003fe,0xfe00001f,0x7be00003,0xf1e0000,0x1e1e000,0x3c1e00,0x3c1e0,0xe000781e,0x1e000f01,0x1e001e0,0x801e003c,0xf801e007,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0xfc00007f,0x7fc00007,0x7000000,0x700000,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0x700000,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0x700000,0x70000,0x7000,0x700,0x70,0xf0000007,0xff00000f,0xff00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7001c1c7,0xf7003e3f,0xf9f007f7,0x1f0f0079,0xf0f0f007,0xf070700,0xf07070,0x700f0707,0x700f070,0x70700f07,0x70700f0,0xf070700f,0xf070700,0xf07070,0x700f0707,0x700f070,0x70700f07,0x70700f0,0xf070700f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0007e1e,0xde000ff9,0x1fe001ff,0xc07e001e,0x3c03e003,0x3801e00,0x3801e0,0xe003801e,0x1e003801,0x1e00380,0x801e0038,0x3801e003,0x3801e00,0x3801e0,0xe003801e,0x1e003801,0x1e00380,0x801e0038,0x3801e003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fc0,0xf80007ff,0x7c000ff,0xe03c001f,0x3c01e003,0x7800e00,0x7800f0,0x7007000f,0x7007000,0x700700,0x70070,0x7000f007,0x7800f00,0x7800e0,0xc003c01e,0x7c003e03,0xff8001f0,0x7ff0000f,0x1fc0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0003f1e,0xfe000ffd,0xfe001ff,0xc03e001f,0x3801e003,0x7801e00,0x7801e0,0xe007001e,0x1e007001,0x1e00700,0x1e0070,0x7001e007,0x7801e00,0x7801e0,0xe003c03e,0xfe003c07,0xfde001f0,0x7f9e000f,0x3e1e000,0x1e00,0x1e0,0xe000001e,0x1e000001,0x1e00000,0x1e0000,0x1e000,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x387e0,0xf80039ff,0x87c003ff,0xe03e003f,0x3c01e003,0x3800e00,0x3800f0,0x7003800f,0x7003800,0x700380,0x80070038,0x3800f003,0x3800f00,0x3c00e0,0xe003e01e,0x7c003f01,0xff8003f8,0x8ff00039,0x383e0003,0x3800000,0x380000,0x38000,0x3800,0x380,0x80000038,0x38000003,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f870,0x70003fc7,0x770003fe,0x3f00010,0x1f0000,0xf000,0x700,0x70,0x70000007,0x7000000,0x700000,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0x700000,0x70000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f80,0xf8000fff,0x7c000ff,0x3c000c,0x1c000,0x1c00,0x3c0,0x800000f8,0xe00000ff,0xf000003f,0xf800000f,0x1e000001,0x1c00000,0x3c0000,0x1c000,0x8001e00,0xffc001f0,0x7ffc000f,0xff0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0x1c000001,0x1c00000,0x1c0000,0x1c000,0x1c00,0xc000fffc,0xfc000fff,0x1c0000ff,0x1c00000,0x1c0000,0x1c000,0x1c00,0x1c0,0xc000001c,0x1c000001,0x1c00000,0x1c0000,0x1c000,0x1c00,0x1c0,0xc000003c,0xf8000307,0xff00003f,0xfe00003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe003801e,0x1e003801,0x1e00380,0x801e0038,0x3801e003,0x3801e00,0x3801e0,0xe003801e,0x1e003801,0x1e00380,0x801e0038,0x3801e003,0x3801e00,0x3c01e0,0xc003e01e,0x3c003f01,0xffc003fc,0x8ff80039,0x383e0003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0078007,0xe003800,0x1e003c0,0xc01e003c,0x1e01c001,0xe03c00,0xe0380,0x8000f038,0x70000707,0x87000070,0x38f00007,0x3ce0000,0x3de000,0x1de00,0x1fc0,0x800000fc,0xf800000f,0x7800000,0x700000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x700e0007,0x700e000,0x700e00,0x700e0,0xe000700e,0xf000700,0x70f070,0xe0070f06,0x8e0071f8,0x9ce0071f,0x39ce0071,0x738ee007,0x370ee00,0x3f0fe0,0xc003e07c,0x3c003e07,0x3c003e0,0xc01c003c,0x1801c003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe003800f,0x1c003c01,0x3c001c0,0xf078000e,0x7870000,0x38f000,0x1de00,0x1fc0,0x800000fc,0x78000007,0xf800000,0x1fc0000,0x3de000,0x38f00,0x80007870,0x3c000f07,0x1c000e0,0xc00e001e,0x3800f003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0078007,0xe003800,0xe003c0,0xc01e003c,0x1e01c001,0xe03c00,0xe03c0,0x8000f038,0x70000707,0x87000070,0x38f00007,0x38e0000,0x3ce000,0x1de00,0x1dc0,0x800000fc,0xf800000f,0x7800000,0x700000,0x70000,0x3800,0x3c0,0xe100001c,0xff00000,0x7f0000,0x1f000,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe003fffe,0xfe003fff,0x1ff,0xf000000e,0x7000000,0x380000,0x3c000,0x1e00,0xe0,0x78000007,0x3800000,0x1c0000,0x1e000,0xf00,0x80000070,0x3c000003,0xffc00000,0xfffe003f,0x3fffe003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf80,0xe00000fc,0x1e00000f,0xe00000,0xe0000,0xe000,0xe00,0xe0,0xe000000e,0xe000000,0xf00000,0x70000,0x7000,0x780,0xf000003c,0xf000001,0x1f00000,0x3c0000,0x70000,0x7000,0x700,0xf0,0xe000000e,0xe000000,0xe00000,0xe0000,0xe000,0xe00,0x1e0,0xc00000fe,0xf800000f,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70,0x70000007,0x7000000,0x700000,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0x700000,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0x700000,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0x700000,0x70000,0x7000,0x700,0x70,0x70000007,0x7000000,0x700000,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0xf800000f,0x3f800001,0x3c00000,0x380000,0x38000,0x3800,0x780,0x80000078,0x78000007,0x7800000,0x700000,0x70000,0x7000,0xf00,0x1e0,0x8000007c,0x7c000007,0x1e00000,0xf0000,0x7000,0x700,0x80000070,0x78000007,0x7800000,0x780000,0x38000,0x3800,0x380,0xf800003c,0x1f800003,0xf80000,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf010007c,0xff81803f,0xf83c1e0f,0xfe00c0ff,0x1f000407,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                        };

uint32_t font_ANDALEMO_30x54[95][51] = {
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf000000,0x3c00000,0xf00000,0x3c0000,0xf0000,0x3c000,0xf000,0x3c00,0xf00,0x3c0,0xf0,0x38,0x8000000e,0xe0000003,0x38000000,0xe000000,0x3800000,0xe00000,0x380000,0xe0000,0x18000,0x0,0x0,0x0,0x0,0xe0,0x7c,0xc000001f,0xf0000007,0x38000001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0e00000,0x78380001,0x1e0e0000,0x7838000,0x1e0e000,0x783800,0xe0e00,0x38380,0xc0e0,0x3030,0xc0c,0x303,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7000000,0x81c0000e,0xe0700003,0x381e0000,0xf038000,0x1c0e000,0x703800,0x1c0e00,0xe00781c0,0xf81fffff,0xfe07ffff,0xe001ffff,0x38000381,0xe0000f0,0x380001c,0xc0e00007,0x703c0001,0x1e070000,0x381c000,0x7fffff80,0x1fffffe0,0x7fffff8,0x3c0e0,0x7038,0x80001c0e,0x70000703,0x1c0001c0,0x7000038,0x81c0000e,0xe0780003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0x30000000,0xff000000,0xfff00000,0x3ffe0000,0xc3fc000,0xc7800,0x30e00,0xc3c0,0x30f0,0xc3c,0x8000030f,0xe00000c7,0xf0000037,0xf800000f,0xfc000007,0xfc000003,0xfe000003,0xff000001,0x7ec00000,0x1e300000,0xf0c0000,0x3c30000,0xf0c000,0x3c3000,0xf0c00,0x1c300,0x200078c0,0x78001f30,0xff0003fc,0xff80007f,0x7f000007,0xc000000,0x3000000,0xc00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7c0000,0x803fc00e,0x701ff003,0x1c0f1e00,0x3838380,0xe1e070,0x1c781c,0xc0071c07,0x7000e781,0x380039e0,0x1e000738,0xff8001ef,0x3fc00039,0xc7c0000f,0x78000001,0xe000000,0xe1c00000,0xfe700003,0xffce0001,0x78738000,0x1c1e7000,0x7039c00,0x1c0e380,0x7038e0,0x1c0e1c,0xe0070387,0x3801c1e0,0x7007870,0x1c00ffc,0x3801fe,0x3e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfc00000,0xffc0000,0x7ff8000,0x1e1e000,0xf03c00,0x380700,0xe01c0,0x38070,0x703c,0x80001c0f,0xc0000387,0xf0000079,0xf800000f,0x3e000001,0x1fc01c00,0x7f807c0,0x3cf01f8,0xc1e1e01e,0x70f03c03,0xe7c0780,0x39e01e0,0x7f0078,0x801f801e,0xe007c007,0x7801e001,0x3c007c00,0x3e003f80,0xff003ef8,0xff807f1f,0x1f801f83,0x3c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1e000000,0x7800000,0x1e00000,0x780000,0x1e0000,0x78000,0xe000,0x3800,0xe00,0x300,0xc0,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0x3c000000,0x7800000,0xf00000,0x1c0000,0x38000,0xf000,0x1c00,0x780,0xe0,0x3c,0xc000000f,0x78000001,0x1e000000,0x7800000,0x1e00000,0x780000,0x1e0000,0x78000,0x1e000,0x7800,0x1e00,0x780,0x1c0,0xf0,0x3c,0x8000000e,0xc0000007,0xf0000001,0x38000000,0x1c000000,0xf000000,0x7800000,0x3c00000,0xe00000,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0xe0000,0x70000,0x38000,0x1c000,0xf000,0x7800,0x1c00,0xf00,0x380,0x1e0,0x70,0x3c,0xc000000f,0xe0000003,0x78000000,0x1e000000,0x7800000,0x1e00000,0x780000,0x1e0000,0x38000,0xe000,0x3c00,0xf00,0x3c0,0x70,0x8000001e,0xf0000003,0x1c000000,0x7800000,0xf00000,0x1c0000,0x38000,0x7000,0xe00,0x100,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc000000,0x3000000,0xc00000,0x8304000,0x38c3800,0xf33e00,0x1ffe00,0x1ff00,0x3f00,0xfc0,0x800007fc,0xf80007ff,0xe0003cc,0xc10000e3,0x30000020,0xc000000,0x3000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x38000,0xe000,0x3800,0xe00,0x380,0xe0,0x38,0x8000000e,0xfff00003,0xfffc01ff,0xffff007f,0x380001f,0xe00000,0x380000,0xe0000,0x38000,0xe000,0x3800,0xe00,0x380,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0,0x7c,0xc000003f,0xe000000f,0xf0000003,0x18000000,0x7000000,0xe00000,0x1c0000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fff0000,0x7ffc000,0x1fff000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0,0x7c,0xc000001f,0xf0000007,0x38000001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0xe0000007,0x3c000000,0x7000000,0x1c00000,0x780000,0xe0000,0x3c000,0x7000,0x1e00,0x380,0xe0,0x3c,0xe0000007,0x38000001,0xf000000,0x1c00000,0x700000,0x1e0000,0x38000,0xf000,0x1c00,0x780,0xe0,0x38,0xc0000007,0x78000001,0xe000000,0x3c00000,0x700000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f000000,0x3ff00000,0x1fff0000,0xf87c000,0x7c07800,0x1e00f00,0xf003c0,0x3c0070,0x800e001e,0xe0078007,0x3801e001,0xf007800,0xc3c01e0e,0xf8f00787,0xfe3c01e3,0x3f0f0078,0x87c3c01e,0xe0e0f007,0x78003c01,0x1e000e00,0x7800780,0x1e001e0,0x380078,0xf001c,0xc003c00f,0xe0007803,0xf0001f01,0xfc0003e1,0xfc00007f,0xfc00000f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3e000000,0xff00000,0x3ff0000,0xffc000,0x3ff000,0xf3c00,0x3c100,0xf000,0x3c00,0xf00,0x3c0,0xf0,0x3c,0xc000000f,0xf0000003,0x3c000000,0xf000000,0x3c00000,0xf00000,0x3c0000,0xf0000,0x3c000,0xf000,0x3c00,0xf00,0x3c0,0xf0,0xfe00003c,0xff8003ff,0xffe000ff,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fc00000,0x1ffe0000,0xfffc000,0x7e0f000,0x3e00800,0xf00000,0x3c0000,0xe0000,0x78000,0x1e000,0x3c00,0xf00,0x3c0,0xf0,0x8000001e,0xf0000007,0x1e000000,0x7800000,0xf00000,0x1e0000,0x3c000,0x7800,0x1e00,0x3c0,0x78,0xe000000f,0x3c000001,0xff000000,0xffc001ff,0xfff0007f,0x1f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfc00000,0x1ffe0000,0xfff8000,0x7c0e000,0x3e00800,0xf00000,0x3c0000,0xe0000,0x38000,0xf000,0x3c00,0x780,0x1f0,0xfc00003f,0xff000003,0xffc00000,0x7e000000,0x3e000000,0xf000000,0x7800000,0x1e00000,0x780000,0x1e0000,0x78000,0x1e000,0x10003c00,0x1c000f80,0xff0001f8,0xffc0003f,0x3f800003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0000000,0x7e000001,0x1f800000,0x7f00000,0x1fc0000,0x738000,0x1ce000,0x71c00,0x1c780,0x70e0,0x1c3c,0xe0000707,0x380001c1,0xf000070,0x1c0001c,0xc0380007,0x700f0001,0x1c01c000,0x7007800,0x1c00e00,0x7003c0,0x1fffff0,0x7ffffc,0x1fffff,0x7000,0x1c00,0x700,0x1c0,0x70,0x1c,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfff00000,0xfffc0003,0x3fff0000,0x1c000,0x7000,0x1c00,0x700,0x1c0,0x70,0x1c,0xc0000007,0xf0000001,0xfc00001f,0xff00001f,0xc180001f,0xc0000007,0xf0000003,0x78000001,0x1e000000,0x7800000,0x1c00000,0x700000,0x1e0000,0x78000,0x1e000,0x20003c00,0x3c000f80,0xff0001f0,0xff80003f,0x3f800003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfc000000,0xffe00001,0x7ffc0001,0x180f8000,0x1f000,0x3c00,0x780,0x1e0,0x3c,0xc000000f,0x70000003,0x1c000000,0xc7800000,0xfde0001f,0xfff8001f,0xc0fe000f,0xe00f8007,0xf001e003,0x78007800,0x1e001c00,0x7800f00,0x1e003c0,0x7800f0,0x1e0078,0x3801e,0xc000f00f,0xe0003e07,0xf00007c3,0xf80000ff,0xf800001f,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffe0000,0xffff800f,0xffffe003,0x3c000000,0x7000000,0x1e00000,0x780000,0xf0000,0x3c000,0x7000,0x1e00,0x380,0xf0,0x8000003c,0xe0000007,0x38000001,0xf000000,0x1c00000,0x780000,0x1e0000,0x3c000,0xf000,0x1c00,0x780,0xe0,0x3c,0xe000000f,0x78000001,0xe000000,0x3c00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f800000,0x3ff80000,0x1fff0000,0xf83e000,0x7807800,0x1e00f00,0xf003c0,0x3c00f0,0xf003c,0x8003c00f,0xe0007803,0xf0000f01,0xf80003f1,0xf800003f,0xff800007,0xf1f00003,0xf01e0003,0xf803c001,0x3c007800,0xe001e00,0x7800780,0x1e001e0,0x780078,0x801e001e,0xe003c007,0xf000f003,0xf8003e01,0xfc0007e0,0xfe0000ff,0xfe00000f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f800000,0x1ff80000,0xfff0000,0x7c3e000,0x3c07c00,0x1f00f00,0x7803c0,0x1c0078,0x800f001e,0xe003c007,0x7800f001,0x1e003800,0xf001e00,0x7c00780,0x3e001f0,0xfff0007f,0xbff8001f,0xe3f80007,0x38000001,0xf000000,0x3c00000,0xf00000,0x1c0000,0x78000,0xe000,0x3c00,0x18000780,0xfe0000f8,0xffc0001f,0x3fc00003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe00,0x7c0,0x1f0,0x7c,0x8000001f,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0,0x7c,0xc000001f,0xf0000007,0x38000001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe00,0x780,0x1f0,0x7c,0x8000001e,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0,0x7c,0xc000003f,0xe000000f,0xf0000003,0x18000000,0x7000000,0xe00000,0x1c0000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x1c00000,0x780000,0xf8000,0x1f000,0x1f00,0x1f0,0xe000003e,0x7c000003,0x7c00000,0xf00000,0x7c0000,0x7c0000,0x3e0000,0x3e0000,0x1e0000,0x1f0000,0x1f0000,0xf8000,0x78000,0x18000,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0000000,0xfc01ffff,0xff007fff,0x1fff,0x0,0x0,0x0,0x0,0x0,0x7ffffc00,0x1fffff00,0x7ffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x600,0x780,0x7c0,0x3e0,0x3e0,0x1f0,0x1f0,0x1f0,0xf8,0xf8,0x8000003c,0xf800000f,0x1f000000,0x1f00000,0x1f0000,0x3e000,0x3e00,0x7c0,0x78,0x80000006,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fc00000,0x1ffe0000,0x1fff8000,0x7c1e000,0x3c00800,0xf00000,0x380000,0xe0000,0x38000,0xf000,0x3e00,0x780,0xf0,0xc000001e,0x78000007,0xf000000,0x1e00000,0x380000,0xe0000,0x38000,0xe000,0x0,0x0,0x0,0x0,0x38,0xc000001f,0xf0000007,0x7c000001,0xe000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f000000,0x7ff00000,0x3c1e0000,0x1c01c000,0xe003800,0x3000700,0x1c000c0,0x600038,0x8038000e,0x700e0001,0x1c031fe0,0x8300c7fc,0x60c070e3,0x1c301c38,0x830e070e,0xe0e381c3,0x3838e070,0xe0e381c,0xc3838e07,0x30e0e380,0xc3838e0,0x3870e38,0x61c38e,0xc01c78e3,0x7003be70,0x18007efc,0x600070e,0x3800000,0x1c00000,0xe00000,0x780000,0xe07c0002,0x3ffc0001,0x1fc0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f000000,0xfc00000,0x3f00000,0xfc0000,0x7f8000,0x1fe000,0x7b800,0x1cf00,0xf3c0,0x3c70,0x80000e1e,0xe0000787,0x3c0001e0,0xf000070,0x1c0003c,0x8078000f,0xe01e0003,0x7fff8001,0x1ffff000,0xffffc00,0x3c00700,0xe001e0,0x780078,0xc01e001e,0xf0078003,0x3c03c000,0x780f000,0x1e03c00,0x781e00,0xf0780,0x1e0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3ffc0000,0x7fff0000,0x3fffc000,0x1f807000,0xf801c00,0x3c00700,0xf001c0,0x3c0070,0xf001c,0xc003c007,0x7000f001,0x1c001e00,0xff0003e0,0xffc0007f,0xfff00007,0xe01c0007,0xe0070007,0xf001c003,0x78007000,0x1e001c00,0x7800700,0x1e001c0,0x780070,0x1e001c,0xc0078007,0x7001f001,0x1c003e00,0xff0007e0,0xffc000ff,0xfff0001f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff000000,0xfff00001,0xfffe0003,0x3c07c000,0xc00f800,0xf00,0x3c0,0x78,0x8000001e,0xf0000003,0x3c000000,0xf000000,0x3c00000,0xf00000,0x3c0000,0xf0000,0x3c000,0xf000,0x3c00,0xf00,0x3c0,0x1e0,0x78,0x1e,0xc000000f,0xe0000007,0xf0002003,0xf8000f03,0xfc0007ff,0xf80000ff,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffc0000,0xfff0000,0xfffc000,0x7e07000,0x3e01c00,0x1f00700,0x7801c0,0x3c0070,0xf001c,0xc0078007,0x7001e001,0x1c007800,0x7001e00,0x1c00700,0x7003c0,0x1c00f0,0x7003c,0xc001c00f,0x78007001,0x1e001c00,0x7800700,0x1e001c0,0x3c0070,0xf001c,0xc001e007,0x70007c01,0x1c000f80,0xff0001f8,0xffc0003f,0x3ff00003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfff80000,0xfffe0007,0x7fff8001,0xe000,0x3800,0xe00,0x380,0xe0,0x38,0x8000000e,0xe0000003,0x38000000,0xfe000000,0xff8001ff,0xffe0007f,0x38001f,0xe0000,0x38000,0xe000,0x3800,0xe00,0x380,0xe0,0x38,0x8000000e,0xe0000003,0x38000000,0xfe000000,0xff8001ff,0xffe0007f,0x1f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfff80000,0xfffe000f,0xffff8003,0xe000,0x3800,0xe00,0x380,0xe0,0x38,0x8000000e,0xe0000003,0x38000000,0xe000000,0xff800000,0xffe0003f,0xfff8000f,0xe0003,0x38000,0xe000,0x3800,0xe00,0x380,0xe0,0x38,0x8000000e,0xe0000003,0x38000000,0xe000000,0x3800000,0xe00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff000000,0xfff00001,0xfffe0003,0x3c07c000,0xc00f800,0xf00,0x3c0,0x78,0x8000001e,0xf0000007,0x3c000000,0xf000000,0x3c00000,0xf00000,0x3c0000,0xf0000,0xfc03c000,0xff00f007,0x7fc03c01,0x1e000f00,0x78003c0,0x1e001e0,0x780078,0x1e001e,0xc007800f,0xe001e007,0xf0007803,0xf8001f03,0xfc0003ff,0xfc00007f,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c0000,0xc007000f,0xf001c003,0x3c007000,0xf001c00,0x3c00700,0xf001c0,0x3c0070,0xf001c,0xc003c007,0x7000f001,0x1c003c00,0xff000f00,0xffc003ff,0xfff000ff,0x1c003f,0xc007000f,0xf001c003,0x3c007000,0xf001c00,0x3c00700,0xf001c0,0x3c0070,0xf001c,0xc003c007,0x7000f001,0x1c003c00,0x7000f00,0x1c003c0,0x7000f0,0x3c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfff80000,0xfffe0003,0x3fff8000,0x780000,0x1e0000,0x78000,0x1e000,0x7800,0x1e00,0x780,0x1e0,0x78,0x8000001e,0xe0000007,0x78000001,0x1e000000,0x7800000,0x1e00000,0x780000,0x1e0000,0x78000,0x1e000,0x7800,0x1e00,0x780,0x1e0,0x78,0xfe00001e,0xff8000ff,0xffe0003f,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0x38000000,0xe000000,0x3800000,0xe00000,0x380000,0xe0000,0x38000,0xe000,0x3800,0xe00,0x380,0xe0,0x38,0x8000000e,0xe0000003,0x38000000,0xe000000,0x3800000,0xe00000,0x380000,0xe0000,0x38000,0xe000,0x3c00,0xf00,0x60003e0,0xff80007c,0xffe0000f,0x1fe00001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c0000,0x70078,0xe001c00f,0x3c007001,0xf801c00,0x1e00700,0x3c01c0,0x78070,0xf01c,0xc0001e07,0x700003c1,0x1c000078,0xe700000f,0xf9c00003,0x7ff00000,0x1ffc0000,0xf3f0000,0x7c7c000,0x1e0f000,0xf01c00,0x7c0700,0x3e01c0,0xf0070,0x7c01c,0xc003e007,0x7000f001,0x1c007c00,0x7003e00,0x1c00f00,0x7007c0,0x3e0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x380000,0xe0000,0x38000,0xe000,0x3800,0xe00,0x380,0xe0,0x38,0x8000000e,0xe0000003,0x38000000,0xe000000,0x3800000,0xe00000,0x380000,0xe0000,0x38000,0xe000,0x3800,0xe00,0x380,0xe0,0x38,0x8000000e,0xe0000003,0x38000000,0xfe000000,0xff8003ff,0xffe000ff,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3e0000,0xc00f801f,0xf807e007,0x7e01f801,0x1f807e00,0x7f03f80,0x1fc0ee0,0x7f03b8,0x801ee1ce,0xe007b873,0x3801e61c,0x8e0079ce,0xc3801e73,0xf0e0078e,0xfc3801e3,0x1e0e0078,0x8783801e,0xe000e007,0x78003801,0x1e000e00,0x7800380,0x1e000e0,0x780038,0x801e000e,0xe0078003,0x3801e000,0xe007800,0x3801e00,0xe00780,0x3801e0,0x78,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3e0000,0x800f800e,0xe003e003,0x3801f800,0xe007e00,0x3803f80,0xe00fe0,0x3807f8,0x800e01de,0xe00380f7,0x7800e039,0x9e00381e,0xc7800e07,0xf1e00381,0x387800e0,0x1e1e0038,0x8707800e,0xe3c1e003,0x38e07800,0xe781e00,0x39c0780,0xef01e0,0x3bc078,0x800fe01e,0xe003f807,0x7800fc01,0x1e003f00,0x7800f80,0x1e003e0,0x7800f0,0x3c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f800000,0x3ff80000,0x1fff0000,0xf87e000,0x7807c00,0x3e00f00,0xf003e0,0x380078,0xc01e001e,0xf0078003,0x3c01e000,0xf007800,0x3c01c00,0xf00f00,0x3c03c0,0xf00f0,0x3c03c,0xc000f00f,0x70003c03,0x1e000f00,0x78003c0,0x1e000f0,0x780078,0x800e001e,0xc003c007,0xf000f803,0xf8001e01,0xfc0003e0,0xfe0000ff,0xfe00000f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7ff80000,0x7ffe0000,0x3fff8000,0x1f80e000,0xf803800,0x3c00e00,0x1f00380,0x7800e0,0x1e0038,0x8007800e,0xe001e003,0x38003800,0xe000f00,0x38003e0,0xffe0007c,0xfff8000f,0xffe0001,0x38000,0xe000,0x3800,0xe00,0x380,0xe0,0x38,0x8000000e,0xe0000003,0x38000000,0xe000000,0x3800000,0xe00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f800000,0x3ff80000,0x1fff0000,0xf87e000,0x7807c00,0x3e00f00,0xf003e0,0x380078,0xc01e001e,0xf0078003,0x3c01e000,0xf007800,0x3c01c00,0xf00f00,0x3c03c0,0xf00f0,0x3c03c,0xc000f00f,0x70003c03,0x1e000f00,0x78003c0,0x1e000f0,0x780078,0x800e001e,0xc003c007,0xf000f803,0xf8001e01,0xfc0003e0,0xfe0000ff,0xfe00000f,0xf0000003,0x78000001,0xfe000000,0xff000003,0x3f000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3ffc0000,0x7fff0000,0x3fffc000,0x1f807000,0xf801c00,0x3c00700,0xf001c0,0x380070,0xe001c,0xc003c007,0x7000f001,0x1c003c00,0x7000780,0xffc000f8,0xfff0001f,0x3ffc0001,0xf070000,0x7c1c000,0x1e07000,0xf01c00,0x7c0700,0x1e01c0,0xf8070,0x7c01c,0xc001e007,0x7000f801,0x1c003c00,0x7001e00,0x1c00f80,0x7003c0,0x1f0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff000000,0xfff00000,0x3ffe0000,0xc07c000,0x7800,0xe00,0x3c0,0xf0,0x3c,0x8000000f,0xe0000007,0xf0000007,0xf8000003,0xfc000003,0xfc000003,0xfc000003,0xfc000001,0x7e000000,0x1e000000,0xf000000,0x3c00000,0xf00000,0x3c0000,0xf0000,0x3c000,0x20007800,0x78001f00,0xff0003e0,0xff80007f,0x7f000007,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffff8000,0xffffe03f,0xfffff80f,0x780003,0x1e0000,0x78000,0x1e000,0x7800,0x1e00,0x780,0x1e0,0x78,0x8000001e,0xe0000007,0x78000001,0x1e000000,0x7800000,0x1e00000,0x780000,0x1e0000,0x78000,0x1e000,0x7800,0x1e00,0x780,0x1e0,0x78,0x8000001e,0xe0000007,0x78000001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c0000,0xc007000f,0xf001c003,0x3c007000,0xf001c00,0x3c00700,0xf001c0,0x3c0070,0xf001c,0xc003c007,0x7000f001,0x1c003c00,0x7000f00,0x1c003c0,0x7000f0,0x1c003c,0xc007000f,0xf001c003,0x3c007000,0xf001c00,0x3c00700,0xf001c0,0x3c00f0,0xf003c,0xc001c00f,0xe0007803,0xf8001e01,0xfc0003e1,0xfe0000ff,0xfe00000f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3c000,0x1e078,0x8000781e,0xf0001e03,0x3c000700,0xf0003c0,0x1e000f0,0x780038,0x801e001e,0xc003c007,0xf000f001,0x3c003c00,0xe000780,0x78001e0,0x1e00078,0xc070000f,0xf03c0003,0x1c0f0000,0x783c000,0x1e1e000,0x387800,0xf1e00,0x3cf00,0x73c0,0x1ef0,0x7f8,0x800000fe,0xc000003f,0xf000000f,0x7c000001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3c000,0xf0f0,0x3c1c,0xc0000f07,0x70000381,0x1e0000e0,0x7800038,0x81e0000e,0xe0780003,0x780e0001,0x1e0381e0,0x700e078,0xc1c0381f,0xf0700e0f,0xee1c0383,0x738700f0,0x1ce1c03c,0xc71cf007,0x71873c01,0x1ce1cf00,0x7387380,0x1ce0ee0,0x7703b8,0x801fc0ee,0xe003f01f,0xf800f807,0x3e003e01,0xf000f80,0x3c003e0,0xf000f0,0x3c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8000,0x3c078,0xe001e00f,0x78007801,0xf003c00,0x1e01f00,0x780780,0xf03c0,0x3c0f0,0x7878,0xf3c,0x800003cf,0xc000007f,0xf000000f,0x78000003,0x1e000000,0xfc00000,0x7f80000,0x1fe0000,0xf3c000,0x7cf000,0x1e1e00,0xf03c0,0x3c0f0,0xc001e01e,0xf000f003,0x1e003c00,0x7801e00,0xf00f80,0x1e03c0,0x1e0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8000,0x3c03c,0xe001f00f,0x7c007801,0xf003c00,0x3e00f00,0x780780,0xf01e0,0x3c0f0,0x783c,0x80001e1e,0xc00003cf,0xe00000f3,0xf800001f,0xfc000007,0x1f000000,0x7800000,0x1e00000,0x780000,0x1e0000,0x78000,0x1e000,0x7800,0x1e00,0x780,0x1e0,0x78,0x8000001e,0xe0000007,0x78000001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffc0000,0xffff000f,0xffffc003,0x3c000000,0x7800000,0x1e00000,0x3c0000,0x70000,0x1e000,0x3c00,0xf00,0x1e0,0x78,0xc000000f,0x78000003,0xf000000,0x3c00000,0x780000,0x1e0000,0x3c000,0xf000,0x1e00,0x380,0xf0,0x8000001e,0xf0000007,0x3c000000,0xff800000,0xffe003ff,0xfff800ff,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfe000000,0x7f800001,0x1fe00000,0x380000,0xe0000,0x38000,0xe000,0x3800,0xe00,0x380,0xe0,0x38,0x8000000e,0xe0000003,0x38000000,0xe000000,0x3800000,0xe00000,0x380000,0xe0000,0x38000,0xe000,0x3800,0xe00,0x380,0xe0,0x38,0x8000000e,0xe0000003,0x38000000,0xe000000,0x3800000,0xe00000,0x7f80000,0x1fe0000,0x7f8000,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c0000,0xf0000,0x38000,0x1e000,0x7000,0x1c00,0xe00,0x380,0x1e0,0x70,0x3c,0x8000000e,0xc0000003,0x70000001,0x3c000000,0xe000000,0x7800000,0x1c00000,0x700000,0x380000,0xe0000,0x78000,0x1c000,0xf000,0x3800,0x1e00,0x700,0x1c0,0xf0,0x38,0x1e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff80000,0x3fe0000,0xff8000,0x380000,0xe0000,0x38000,0xe000,0x3800,0xe00,0x380,0xe0,0x38,0x8000000e,0xe0000003,0x38000000,0xe000000,0x3800000,0xe00000,0x380000,0xe0000,0x38000,0xe000,0x3800,0xe00,0x380,0xe0,0x38,0x8000000e,0xe0000003,0x38000000,0xe000000,0x3800000,0xe00000,0x3fe000,0xff800,0x3fe00,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0xe0000007,0xfc000001,0x3f800000,0x1ce00000,0xf1c0000,0x3870000,0x1e0e000,0x703800,0x380700,0xe01e0,0x70038,0xc003c007,0x3800e001,0xf007000,0x1c01c00,0xe00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0xe7ffffff,0xf9ffffff,0x7fffff,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf800000,0x7c00000,0x1e00000,0xf00000,0x780000,0x1c0000,0xe0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f00,0x80007ffc,0xe0003fff,0x10001f83,0x780,0x3c0,0xf0,0x3c,0xc000000f,0xff800003,0x3fff0000,0xffff000,0x3c3fe00,0xf00f80,0x3c00f0,0xf003c,0xc003c00f,0xf000f803,0x78003f00,0xfe000ff0,0xff00039f,0x3f0000e3,0x38,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c0000,0x70000,0x1c000,0x7000,0x1c00,0x700,0x1c0,0x70,0x7c1c,0xc0007fc7,0xf0003ff9,0xfc001f07,0x1f000f80,0x3c003c0,0x7001e0,0x1c0078,0x8007001e,0xc001c007,0x70007001,0x1c001c00,0x7000700,0x1e001c0,0x780070,0x1e003c,0xc003c00f,0xf000f007,0xfc001e03,0xe70007c1,0xf1c000ff,0xf070001f,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3fe00,0x3ffe0,0xc0007ffe,0xf800180f,0x1e000000,0x3c00000,0xf00000,0x1e0000,0x78000,0x1e000,0x7800,0x1e00,0x780,0x1e0,0x78,0x3c,0x8000000f,0xe0000007,0xf0000003,0xf8000603,0xf80001ff,0xf80000ff,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc000000f,0xf0000003,0x3c000000,0xf000000,0x3c00000,0xf00000,0x3c0000,0xf0fc0,0x8003cff8,0xe000f7ff,0x7c003fc3,0xf800fc0,0x1e003e0,0x7800f0,0xe003c,0xc003c00f,0xf000f003,0x3c003c00,0xf000f00,0x3c003c0,0xf000f0,0x3c0038,0x800f001e,0xc003e007,0xf000f803,0xf8003f00,0xfe000ff0,0xff0003df,0x3f0000f3,0x3c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f00,0x3ff0,0xe0001fff,0x78000f87,0xf000780,0x1c001c0,0x7800f0,0x1e0038,0xffff800e,0xffffe003,0x7ffff801,0x1e00,0x780,0x1e0,0x78,0x3c,0xc000000f,0xe0000007,0xf0000003,0xf8000603,0xfc0001ff,0xf80000ff,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8000000,0xff000003,0xffe00003,0x107c0000,0xf0000,0x3c000,0x7000,0x1c00,0x7fffc,0xc001ffff,0x7fff,0x1c,0xc0000007,0x70000001,0x1c000000,0x7000000,0x1c00000,0x700000,0x1c0000,0x70000,0x1c000,0x7000,0x1c00,0x700,0x1c0,0x70,0x1c,0xc0000007,0x70000001,0x1c000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c1f80,0x7fff8,0xe001ffff,0x3c0007c3,0xf0001e0,0x1c00070,0x70001c,0xc01c000f,0x700f0001,0x1e038000,0x3c3e000,0xfff000,0xff800,0x1fe00,0x1e0,0x3c,0xc0000007,0xf0000003,0xf8001fff,0xfc000fff,0x70007ff,0xf001e0,0x1c00f0,0x3803c,0xc000e00f,0x78007801,0xf001e00,0x1f81f00,0x3fff80,0x7ffc0,0x3fc0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c0000,0x70000,0x1c000,0x7000,0x1c00,0x700,0x1c0,0x70,0xf81c,0xc000ffc7,0xf0007ff9,0xfc001f0f,0x1f000780,0x3c003c0,0x7000f0,0x1c003c,0xc007000f,0xf001c003,0x3c007000,0xf001c00,0x3c00700,0xf001c0,0x3c0070,0xf001c,0xc003c007,0x7000f001,0x1c003c00,0x7000f00,0x1c003c0,0x7000f0,0x3c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x38000000,0xf000000,0x7c00000,0xf00000,0x380000,0x0,0x0,0x0,0x3ff0,0xffc,0x3ff,0xe0,0x38,0x8000000e,0xe0000003,0x38000000,0xe000000,0x3800000,0xe00000,0x380000,0xe0000,0x38000,0xe000,0x3800,0xe00,0x380,0xe0,0x38,0x8000000e,0xe0000003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x38000000,0xf000000,0x7c00000,0xf00000,0x380000,0x0,0x0,0x0,0x3ff0,0xffc,0x3ff,0xe0,0x38,0x8000000e,0xe0000003,0x38000000,0xe000000,0x3800000,0xe00000,0x380000,0xe0000,0x38000,0xe000,0x3800,0xe00,0x380,0xe0,0x38,0x8000000e,0xe0000003,0x38000000,0xf000000,0x3c00000,0xf00000,0x3c0000,0x78200,0x1ffc0,0x3ff0,0x3f0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c0000,0x70000,0x1c000,0x7000,0x1c00,0x700,0x1c0,0x70,0xf001c,0xc001e007,0x70003c01,0x1c0007c0,0x70000f8,0xe1c0001f,0x3c700003,0x79c0000,0xff0000,0x7fc000,0x3ff000,0x1f7c00,0x78f00,0x3c1c0,0x1e070,0xf81c,0xc0007c07,0x70003e01,0x1c000f00,0x7000780,0x1c003e0,0x7001f0,0xf8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffc0000,0x3ff0000,0xffc000,0x380000,0xe0000,0x38000,0xe000,0x3800,0xe00,0x380,0xe0,0x38,0x8000000e,0xe0000003,0x38000000,0xe000000,0x3800000,0xe00000,0x380000,0xe0000,0x38000,0xe000,0x3800,0xe00,0x380,0xe0,0x38,0x8000000e,0xe00000ff,0xf800003f,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0070387,0x7003f1f9,0xfc01feff,0x1f0079bc,0x83c01c3e,0xe0f00f07,0x781c03c1,0x1e0700f0,0x781c03c,0xc1e0700f,0xf0781c03,0x3c1e0700,0xf0781c0,0x3c1e070,0xf0781c,0xc03c1e07,0x700f0781,0x1c03c1e0,0x700f078,0x81c03c1e,0xe0700f07,0x781c03c1,0xf0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf81c,0xc000ffc7,0xf0007ff9,0xfc001f0f,0x1f000780,0x3c003c0,0x7000f0,0x1c003c,0xc007000f,0xf001c003,0x3c007000,0xf001c00,0x3c00700,0xf001c0,0x3c0070,0xf001c,0xc003c007,0x7000f001,0x1c003c00,0x7000f00,0x1c003c0,0x7000f0,0x3c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f00,0x3ff8,0xe0003fff,0x7c001f83,0xf000780,0x1e003c0,0x7800f0,0xe0078,0x8003c01e,0xc000f007,0x70003c01,0x1c000f00,0x70003c0,0x1e000f0,0x780038,0x801e001e,0xc003c007,0xf000f003,0xf8001e01,0xfc0007e0,0xfe0000ff,0xfe00000f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7c1c,0xc0007fc7,0xf0003ff9,0xfc001f07,0x1f000f80,0x3c003c0,0x7001e0,0x1c0078,0x8007001e,0xc001c007,0x70007001,0x1c001c00,0x7000700,0x1e001c0,0x780070,0x1e003c,0xc003c00f,0xf000f007,0xfc001e03,0xe70007c1,0xf1c000ff,0xf070001f,0x1c0001,0x70000,0x1c000,0x7000,0x1c00,0x700,0x1c0,0x70,0x1c,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0fc0,0x8003cff8,0xe000f7ff,0x7c003fc3,0xf800fc0,0x1e003e0,0x7800f0,0xe003c,0xc003c00f,0xf000f003,0x3c003c00,0xf000f00,0x3c003c0,0xf000f0,0x3c0038,0x800f001e,0xe003c007,0xf000f803,0xf8003f00,0xfe000ff0,0xff0003df,0x3f0000f3,0x3c,0xc000000f,0xf0000003,0x3c000000,0xf000000,0x3c00000,0xf00000,0x3c0000,0xf0000,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f0f0,0x3fe3c,0xc000ffcf,0xf000387b,0xfc000407,0x1f000000,0x7c00000,0xf00000,0x3c0000,0xf0000,0x3c000,0xf000,0x3c00,0xf00,0x3c0,0xf0,0x3c,0xc000000f,0xf0000003,0x3c000000,0xf000000,0x3c00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff00,0xfff8,0xe0003fff,0x38000e03,0xf000000,0x3c00000,0x1f00000,0x1f80000,0x1fe0000,0x3ff0000,0x3ff0000,0x1ff0000,0xff0000,0x7e0000,0x1e0000,0x70000,0x1c000,0x7000,0x18001e00,0xfe0003e0,0xff80007f,0xffc0000f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x380000,0xe0000,0x38000,0xe000,0x3800,0xe00,0x3fffc,0xc000ffff,0x3fff,0x8000000e,0xe0000003,0x38000000,0xe000000,0x3800000,0xe00000,0x380000,0xe0000,0x38000,0xe000,0x3800,0xe00,0x380,0xe0,0x78,0x8000001e,0xc0000c0f,0xe00003ff,0xf00000ff,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf001c,0xc003c007,0x7000f001,0x1c003c00,0x7000f00,0x1c003c0,0x7000f0,0x1c003c,0xc007000f,0xf001c003,0x3c007000,0xf001c00,0x3c00700,0xf001c0,0x3c0070,0xf001c,0xc003c00f,0xf000f803,0x78003f80,0xfe000ff0,0xff0003df,0x1f0000f1,0x3c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x801e000f,0xe0038003,0x7800f001,0x1c003c00,0xf000780,0x3c001e0,0x1e00078,0xc078000f,0x701c0003,0x1e0f0000,0x783c000,0xe0e000,0x3c7800,0xf1e00,0x1e700,0x7bc0,0xef0,0x3f8,0xfe,0xc000001f,0xf0000007,0x38000001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0780007,0x700e0001,0x1c038000,0xf00e000,0x3c03800,0xf00f00,0x783803c0,0x3e0e00f0,0xfc3801c,0xc3f0e007,0x71de3801,0x1c738e00,0x73ce780,0x1ee1dc0,0x3b8770,0xfc1fc,0xc003f03f,0xf000fc0f,0x7c003e01,0x1e000f80,0x38003c0,0xe00070,0x1c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800e001e,0xc003c007,0xe0007803,0x78000e01,0x3c0003c0,0x1e000078,0xc780000f,0x7bc00001,0xfe00000,0x1f00000,0x7c0000,0x1f0000,0xfc000,0x3f800,0x1ef00,0xf1e0,0x3c78,0xe0001e0f,0x38000f01,0xf0003c0,0x1e001e0,0x3800f0,0x3c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x801e000f,0xe0038003,0x7800f001,0x1c003c00,0xf000700,0x3c001e0,0xe00078,0xc078000f,0x701e0003,0x1e0f0000,0x783c000,0xe0e000,0x3c7800,0xf1e00,0x1c700,0x7bc0,0xef0,0x3f8,0xfe,0xc000001f,0xf0000007,0x38000001,0xe000000,0x1c00000,0x700000,0x1e0000,0x3c000,0x7840,0x1ff0,0x3fc,0x3e,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffc,0xc003ffff,0x7fff,0xe00,0x3c0,0x78,0xc000000f,0x78000003,0xf000000,0x1c00000,0x780000,0xf0000,0x1c000,0x7800,0xf00,0x1e0,0x78,0xe000000f,0x78000001,0xff000000,0xffc003ff,0xfff000ff,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0xfe000003,0x3f800000,0x1f00000,0x3c0000,0x70000,0x1c000,0x7000,0x1c00,0x700,0x1c0,0x70,0x1c,0xe0000007,0x78000001,0xe000000,0x3c00000,0x780000,0xf8000,0x1e000,0xf800,0x7800,0x3c00,0xe00,0x780,0x1e0,0x70,0x1c,0xc0000007,0x70000001,0x1c000000,0x7000000,0x1c00000,0xf00000,0x7c0000,0xfe0000,0x3f8000,0xf8000,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe000000,0x3800000,0xe00000,0x380000,0xe0000,0x38000,0xe000,0x3800,0xe00,0x380,0xe0,0x38,0x8000000e,0xe0000003,0x38000000,0xe000000,0x3800000,0xe00000,0x380000,0xe0000,0x38000,0xe000,0x3800,0xe00,0x380,0xe0,0x38,0x8000000e,0xe0000003,0x38000000,0xe000000,0x3800000,0xe00000,0x380000,0xe0000,0x38000,0xe000,0x3800,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f00000,0xfc0000,0x7f0000,0x1e0000,0x70000,0x3c000,0xf000,0x3c00,0xf00,0x3c0,0xf0,0x3c,0x8000000f,0xe0000003,0x38000000,0x1e000000,0x7000000,0x3c00000,0x3e00000,0xe00000,0x3e0000,0x3c000,0x7000,0x1e00,0x380,0xe0,0x38,0xc000000f,0xf0000003,0x3c000000,0xf000000,0x3c00000,0xf00000,0x1c0000,0x78000,0x1fc00,0x3f00,0x7c0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf80000,0xffc000,0xfff810,0xe0fe1f06,0x3ffe01c1,0x7fe0010,0x7c0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                        };

uint32_t font_ANDALEMO_32x56[95][56] = {
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1c000,0xc000,0xc000,0xc000,0xc000,0xc000,0x0,0x0,0x0,0x0,0x0,0x1c000,0x3e000,0x3f000,0x3f000,0x3e000,0x1c000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c1e00,0x1c1e00,0x1c1e00,0x1c1e00,0x1c1e00,0x1c1e00,0x1c1e00,0x1c1c00,0x1c1c00,0x1c0c00,0x180c00,0x180c00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c0f000,0x1c0f000,0x1c07000,0x1e07000,0x1e07000,0xe07800,0xe03800,0xe03800,0xf03800,0xffffff8,0xffffff8,0xffffff8,0x781c00,0x781c00,0x381e00,0x381e00,0x380e00,0x3c0e00,0x3c0e00,0x1c0f00,0x1c0f00,0xffffff8,0xffffff8,0xffffff8,0xe0780,0xe0780,0xe0380,0xf0380,0xf0380,0x703c0,0x703c0,0x701c0,0x781c0,0x781c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c000,0x1c000,0x1fe000,0x7ffc00,0x7ffe00,0x61ff00,0x1cf80,0x1c780,0x1c380,0x1c3c0,0x1c3c0,0x1c3c0,0x1c780,0x1cf80,0x1df80,0x1ff00,0x1fe00,0x7f800,0x1ff000,0x3fc000,0x7fc000,0xfdc000,0xf1c000,0x1f1c000,0x1e1c000,0x1e1c000,0x1e1c000,0x1e1c000,0x1e1c000,0xe1c000,0xf1c000,0x79c080,0x7fc780,0x1fff80,0xfff00,0x1fc00,0x1c000,0x1c000,0x1c000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c007c0,0x1c01fe0,0xe03ff0,0xe03c78,0x707838,0x70703c,0x38703c,0x38701c,0x1c701c,0x1c703c,0xe703c,0xf7838,0x73c78,0x7bff0,0x39fe0,0x3c7c0,0x1c000,0x1e000,0x1f0e000,0x3fcf000,0x7fe7000,0xf0f7800,0xe073800,0xe073c00,0x1e079c00,0x1e079e00,0x1e078e00,0x1e078f00,0xe070700,0xe070780,0xf0f0380,0x7fe01c0,0x3fc01c0,0x1f800e0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f800,0x3fe00,0x7ff00,0xf0f80,0xe0380,0x1e03c0,0x1c03c0,0x1e03c0,0xe03c0,0xe03c0,0xf0780,0x78780,0x3cf00,0x1fe00,0x3800fe00,0x3c007c00,0x3e007f00,0xf00ff80,0x781e3c0,0x383e1e0,0x383c0f0,0x1c780f0,0x1cf0078,0xff0078,0xfe0078,0xfc0078,0x780078,0xf80078,0x1f800f0,0x3fe01f0,0x7df83e0,0x3f8fffc0,0x3f03ff80,0x3e00fe00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0xc000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x700000,0x780000,0x3c0000,0x1e0000,0xf0000,0x70000,0x78000,0x3c000,0x3c000,0x1e000,0x1e000,0xe000,0xf000,0xf000,0xf000,0xf000,0xf800,0x7800,0x7800,0x7800,0x7800,0x7800,0xf000,0xf000,0xf000,0xf000,0xf000,0xe000,0x1e000,0x1c000,0x3c000,0x38000,0x78000,0x70000,0xe0000,0x1e0000,0x3c0000,0x780000,0x700000,0x200000,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x700,0xf00,0x1e00,0x3c00,0x3800,0x7800,0xf000,0xe000,0x1e000,0x1c000,0x3c000,0x3c000,0x38000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x38000,0x3c000,0x3c000,0x1c000,0x1e000,0xe000,0xf000,0x7800,0x3800,0x3c00,0x1e00,0xf00,0x700,0x100,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c000,0x1c000,0x1c000,0x1c100,0x71c700,0x7dcf80,0x3ffe00,0xff800,0x7f000,0x7f000,0xff800,0x3ffe00,0x79cf80,0x71c700,0x1c100,0x1c000,0x1c000,0x1c000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x3fffff0,0x3fffff0,0x3fffff0,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c000,0x3e000,0x3e000,0x7e000,0x7e000,0x3c000,0x38000,0x38000,0x1c000,0xe000,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3fff00,0x3fff00,0x3fff00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c000,0x3e000,0x3f000,0x3f000,0x3e000,0x1c000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf00000,0x700000,0x780000,0x380000,0x3c0000,0x3c0000,0x1c0000,0x1e0000,0xe0000,0xf0000,0x70000,0x70000,0x78000,0x38000,0x3c000,0x1c000,0x1e000,0xe000,0xe000,0xf000,0x7000,0x7800,0x3800,0x3c00,0x3c00,0x1c00,0x1e00,0xe00,0xf00,0x700,0x700,0x780,0x380,0x3c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f000,0x1ffc00,0x3ffe00,0x7c1f00,0x780f80,0xf00780,0xe003c0,0x1e003c0,0x1e001c0,0x1e001e0,0x3c001e0,0x3c001e0,0x3c001e0,0x3c1c1e0,0x3c3f1e0,0x3c7f1e0,0x3c7f1f0,0x3c7f1f0,0x3c3f1e0,0x3c1c1e0,0x3c001e0,0x3c001e0,0x3c001e0,0x3c001e0,0x1e001e0,0x1e001c0,0x1e003c0,0xe003c0,0xf00780,0x780f80,0x7c1f00,0x3ffe00,0x1ffc00,0x7f000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3c000,0x3f000,0x3fc00,0x3ff00,0x3ff00,0x3df00,0x3c700,0x3c100,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x1ffff80,0x1ffff80,0x1ffff80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fc00,0x7ff80,0x1fffc0,0x3f0380,0x3c0080,0x7c0000,0x780000,0x780000,0x780000,0xf80000,0x780000,0x780000,0x780000,0x780000,0x3c0000,0x3c0000,0x1e0000,0x1e0000,0xf0000,0xf8000,0x78000,0x3c000,0x1e000,0x1f000,0xf800,0x7800,0x3c00,0x1e00,0xf00,0x780,0x780,0xffffc0,0xffffc0,0xffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fc00,0x7ff00,0x1fff80,0x3f0380,0x7c0080,0x780000,0x780000,0x780000,0x780000,0x780000,0x780000,0x3c0000,0x3e0000,0x1f8000,0x7f800,0x3f800,0xff800,0x1f8000,0x3e0000,0x7c0000,0xf80000,0xf00000,0xf00000,0xf00000,0xf00000,0xf00000,0xf00000,0x780000,0x7c0000,0x3e0040,0x1f03c0,0xfffc0,0x7ff80,0xfe00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3e0000,0x3f0000,0x3f8000,0x3f8000,0x3fc000,0x3dc000,0x3de000,0x3ce000,0x3cf000,0x3c7000,0x3c7800,0x3c3c00,0x3c1c00,0x3c1e00,0x3c0e00,0x3c0f00,0x3c0700,0x3c0780,0x3c0380,0x3c03c0,0x3c01e0,0x3c01e0,0x3c00f0,0x3fffff0,0x3fffff0,0x3fffff0,0x3c0000,0x3c0000,0x3c0000,0x3c0000,0x3c0000,0x3c0000,0x3c0000,0x3c0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fff00,0x7fff00,0x7fff00,0x700,0x700,0x700,0x700,0x700,0x700,0x700,0x700,0x700,0x700,0x3ff00,0xfff00,0x1fff00,0x3e0600,0x7c0000,0x780000,0xf00000,0xf00000,0xf00000,0xf00000,0xf00000,0xf00000,0xf00000,0xf00000,0xf80000,0x780000,0x3c0080,0x3f0380,0xfffc0,0x7ff80,0x1fc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fc000,0x7ff000,0xfff800,0xf07c00,0x803e00,0x1f00,0xf00,0x780,0x780,0x780,0x3c0,0x3c0,0x3c0,0x3c0,0x7e3c0,0x3ffbc0,0x7fffe0,0xf81fe0,0x1f007e0,0x1e003c0,0x3e003c0,0x3c003c0,0x3c003c0,0x3c003c0,0x3c003c0,0x3c00780,0x3c00780,0x1e00f00,0x1e00f00,0x1f01e00,0xf87e00,0x7ffc00,0x3ff000,0xfc000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1ffffc0,0x1ffffc0,0x1ffffc0,0x1e00000,0xe00000,0xf00000,0xf00000,0x780000,0x780000,0x3c0000,0x3c0000,0x3c0000,0x1e0000,0x1e0000,0xf0000,0xf0000,0x70000,0x78000,0x78000,0x3c000,0x3c000,0x1e000,0x1e000,0x1e000,0xf000,0xf000,0x7800,0x7800,0x3800,0x3c00,0x3c00,0x1e00,0x1e00,0xf00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f000,0x1ffc00,0x3ffe00,0x7c1f00,0xf80f80,0xf00780,0x1f003c0,0x1e003c0,0x1e003c0,0x1e003c0,0xf003c0,0xf00780,0x780f00,0x3e3f00,0x1ffc00,0x7f800,0x1ffc00,0x7e3f00,0xf80f80,0xf007c0,0x1e003c0,0x1e001e0,0x3c001e0,0x3c001e0,0x3c001e0,0x3c001e0,0x3c001e0,0x1e003e0,0x1e003c0,0xf007c0,0xfc1f80,0x7fff00,0x1ffe00,0x7f000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f000,0xffc00,0x1fff00,0x3e1f00,0x7c0780,0x7807c0,0xf003c0,0xf003c0,0x1e001e0,0x1e001e0,0x1e001e0,0x1e001e0,0x1c003e0,0x3c003c0,0x3e003c0,0x3f007c0,0x3fc1f80,0x3ffff00,0x3cffe00,0x3c3f000,0x1e00000,0x1e00000,0x1e00000,0x1e00000,0xf00000,0xf00000,0xf00000,0x780000,0x7c0000,0x3e0080,0x1f0380,0xfff80,0x7ff80,0x1fc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c000,0x3e000,0x3e000,0x3e000,0x3e000,0x1c000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c000,0x3e000,0x3e000,0x3e000,0x3e000,0x1c000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c000,0x3e000,0x3e000,0x3e000,0x3e000,0x1c000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c000,0x3e000,0x3e000,0x7e000,0x7e000,0x3c000,0x38000,0x38000,0x1c000,0xe000,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0xe00000,0xf00000,0xfc0000,0x3f0000,0xfc000,0x3e000,0x1f800,0x7e00,0x1f80,0xfc0,0x3c0,0xfc0,0x1f80,0x7e00,0x1f800,0x3e000,0xfc000,0x3f0000,0xfc0000,0xf00000,0xe00000,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3fffff0,0x3fffff0,0x3fffff0,0x0,0x0,0x0,0x0,0x0,0x0,0x3fffff0,0x3fffff0,0x3fffff0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x380,0x780,0x1f00,0x7e00,0x1f800,0x3e000,0xfc000,0x3f0000,0x7c0000,0x1f00000,0x1e00000,0x1f00000,0xfc0000,0x3f0000,0xfc000,0x3e000,0x1f800,0x7e00,0x1f00,0xf80,0x380,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f800,0xfff00,0x1fff80,0x3e0780,0x7c0100,0x780000,0x780000,0x700000,0x780000,0x780000,0x780000,0x3c0000,0x3e0000,0x1f0000,0xf8000,0x7c000,0x3e000,0x1f000,0xf000,0x7800,0x3800,0x3800,0x3800,0x0,0x0,0x0,0x0,0x0,0x7800,0xf800,0xfc00,0xfc00,0x7800,0x7000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7e000,0x3ff800,0x7ffe00,0xf81f00,0x1e00780,0x1c00380,0x38001c0,0x38001c0,0x70000e0,0x70000e0,0x6000060,0x63fc070,0xe1ff070,0xe1c7030,0xe1c3830,0xe1c1c30,0xe1c1c38,0xe1c0c38,0xe1c0e38,0x61c0e38,0x61e0e38,0x60e0e38,0x70e0e38,0x30e0e30,0x38f1e30,0x1cf1c70,0xfcfc70,0x3c7070,0xe0,0xe0,0x1c0,0x3c0,0x780,0x601f00,0xfffe00,0x7ffc00,0xfe000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3e000,0x3e000,0x7f000,0x7f000,0x7f000,0xff800,0xf7800,0xf7800,0xf3c00,0x1e3c00,0x1e3c00,0x1e1e00,0x3c1e00,0x3c1e00,0x3c1e00,0x780f00,0x780f00,0x780f00,0xf00780,0xffff80,0xffff80,0x1ffffc0,0x1e003c0,0x1e003c0,0x3c001e0,0x3c001e0,0x3c001e0,0x78000f0,0x78000f0,0x78000f0,0x7800078,0xf000078,0xf000078,0xf00003c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7ffc0,0x1fffc0,0x7fffc0,0xfc03c0,0xf003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0xf003c0,0xf003c0,0x7c03c0,0x3fffc0,0xfffc0,0x3fffc0,0x7c03c0,0xf003c0,0x1e003c0,0x3c003c0,0x3c003c0,0x3c003c0,0x3c003c0,0x3c003c0,0x3c003c0,0x3c003c0,0x3c003c0,0x1e003c0,0x1f003c0,0xfc03c0,0x7fffc0,0x1fffc0,0x7ffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3fe000,0x1fff800,0x1fffe00,0x1e03f00,0x1800f80,0x780,0x3c0,0x3c0,0x1e0,0x1e0,0x1e0,0x1f0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x1f0,0x1e0,0x1e0,0x1e0,0x3c0,0x3c0,0x780,0x1000f80,0x3e03f00,0x3fffe00,0x1fff800,0x3fe000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffc0,0x7ffc0,0x1fffc0,0x3f83c0,0x7e03c0,0x7803c0,0xf003c0,0x1f003c0,0x1e003c0,0x3e003c0,0x3c003c0,0x3c003c0,0x3c003c0,0x7c003c0,0x78003c0,0x78003c0,0x78003c0,0x78003c0,0x78003c0,0x78003c0,0x7c003c0,0x3c003c0,0x3c003c0,0x3c003c0,0x3e003c0,0x1e003c0,0x1f003c0,0xf003c0,0xf803c0,0x7c03c0,0x3f83c0,0x1fffc0,0x7ffc0,0xffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffff80,0xffff80,0xffff80,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0xffff80,0xffff80,0xffff80,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0xffff80,0xffff80,0xffff80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1ffff80,0x1ffff80,0x1ffff80,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x7fff80,0x7fff80,0x7fff80,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3fe000,0x1fff800,0x1fffe00,0x1e03f00,0x1800f80,0x780,0x3c0,0x3c0,0x1e0,0x1e0,0x1e0,0x1f0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x3ff00f0,0x3ff00f0,0x3ff00f0,0x3c000f0,0x3c001f0,0x3c001e0,0x3c001e0,0x3c001e0,0x3c003c0,0x3c003c0,0x3c00780,0x3c00f80,0x3f03f00,0x1fffe00,0xfff800,0x1fe000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1ffffc0,0x1ffffc0,0x1ffffc0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fff00,0x7fff00,0x7fff00,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x7fff00,0x7fff00,0x7fff00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0x1e0000,0xf0000,0xf80c0,0x7ffe0,0x3ffe0,0xff80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0003c0,0x78003c0,0x7c003c0,0x3e003c0,0x1e003c0,0xf003c0,0x7803c0,0x3c03c0,0x1e03c0,0xf03c0,0x783c0,0x3c3c0,0x1c3c0,0x1e3c0,0xf3c0,0x1fbc0,0x3ffc0,0x3ffc0,0x7cfc0,0xf87c0,0xf83c0,0x1f03c0,0x3e03c0,0x3e03c0,0x7c03c0,0xf803c0,0xf803c0,0x1f003c0,0x3e003c0,0x3e003c0,0x7c003c0,0xf8003c0,0xf8003c0,0x1f0003c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x1ffff80,0x1ffff80,0x1ffff80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3e003e0,0x3e007e0,0x3f007e0,0x3f007e0,0x3f80fe0,0x3f80fe0,0x3f80fe0,0x3dc1de0,0x3dc1de0,0x3dc1de0,0x3ce39e0,0x3ce39e0,0x3ce39e0,0x3c771e0,0x3c771e0,0x3c7f1e0,0x3c3e1e0,0x3c3e1e0,0x3c3c1e0,0x3c001e0,0x3c001e0,0x3c001e0,0x3c001e0,0x3c001e0,0x3c001e0,0x3c001e0,0x3c001e0,0x3c001e0,0x3c001e0,0x3c001e0,0x3c001e0,0x3c001e0,0x3c001e0,0x3c001e0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c003e0,0x1c003e0,0x1c007e0,0x1c007e0,0x1c00fe0,0x1c00fe0,0x1c01fe0,0x1c01fe0,0x1c03de0,0x1c03de0,0x1c039e0,0x1c079e0,0x1c071e0,0x1c0f1e0,0x1c0f1e0,0x1c1e1e0,0x1c1e1e0,0x1c3c1e0,0x1c3c1e0,0x1c381e0,0x1c781e0,0x1c701e0,0x1cf01e0,0x1cf01e0,0x1de01e0,0x1fe01e0,0x1fc01e0,0x1fc01e0,0x1f801e0,0x1f801e0,0x1f001e0,0x1f001e0,0x1f001e0,0x1e001e0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f000,0x1ffc00,0x3fff00,0x7c1f00,0xf80f80,0xf007c0,0x1e003c0,0x1e003e0,0x3c001e0,0x3c001e0,0x3c001e0,0x3c000f0,0x3c000f0,0x78000f0,0x78000f0,0x78000f0,0x78000f0,0x78000f0,0x78000f0,0x78000f0,0x78000f0,0x3c000f0,0x3c000f0,0x3c001e0,0x3c001e0,0x3c001e0,0x1e003e0,0x1e003c0,0xf007c0,0xf80f80,0x7c1f00,0x3fff00,0x1ffc00,0x7f000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7ff80,0x3fff80,0x7fff80,0xfc0780,0x1f00780,0x1f00780,0x1e00780,0x3e00780,0x3c00780,0x3c00780,0x3c00780,0x3c00780,0x1e00780,0x1e00780,0x1f00780,0xfc0780,0x7fff80,0x1fff80,0x7ff80,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f000,0x1ffc00,0x3fff00,0x7c1f00,0xf80f80,0xf007c0,0x1e003c0,0x1e003e0,0x3c001e0,0x3c001e0,0x3c001e0,0x3c000f0,0x3c000f0,0x78000f0,0x78000f0,0x78000f0,0x78000f0,0x78000f0,0x78000f0,0x78000f0,0x78000f0,0x3c000f0,0x3c000f0,0x3c001e0,0x3c001e0,0x3c001e0,0x1e003e0,0x1e003c0,0x1f007c0,0xf80f80,0x7c1f00,0x3fff00,0x1ffc00,0x1ff000,0x1e0000,0x3c0000,0x7fc0000,0x7f80000,0x7e00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7ffc0,0x1fffc0,0x7fffc0,0xfc03c0,0xf003c0,0x1f003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0xf003c0,0xf803c0,0x7e03c0,0x3fffc0,0xfffc0,0x3ffc0,0x7c3c0,0xf83c0,0xf03c0,0x1f03c0,0x3e03c0,0x3c03c0,0x7c03c0,0xf803c0,0xf003c0,0x1f003c0,0x3e003c0,0x3e003c0,0x7c003c0,0xf8003c0,0xf8003c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fe000,0x7ff800,0x7ffe00,0x603f00,0xf80,0x780,0x380,0x3c0,0x3c0,0x3c0,0x780,0xf80,0x1f80,0x7f00,0x1fe00,0x7f800,0x1fe000,0x3f8000,0x7f0000,0xfc0000,0xf80000,0x1f00000,0x1e00000,0x1e00000,0x1e00000,0x1e00000,0x1e00000,0xe00000,0xf00000,0x780080,0x7e0780,0x3fff80,0xfff00,0x3fc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffff8,0xffffff8,0xffffff8,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0xf003c0,0xf00780,0xf80f80,0x7c1f00,0x3ffe00,0x1ffc00,0x7f000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf00003c,0xf000078,0xf000078,0x7800078,0x78000f0,0x78000f0,0x3c000f0,0x3c001e0,0x3c001e0,0x1e001e0,0x1e003c0,0x1e003c0,0xe003c0,0xf00780,0xf00780,0xf00780,0x780780,0x780f00,0x780f00,0x3c0f00,0x3c1e00,0x3c1e00,0x1e1e00,0x1e3c00,0x1e3c00,0xf3c00,0xf7800,0xf7800,0x7f800,0x7f000,0x7f000,0x3f000,0x3e000,0x3e000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1e00003c,0x1e00003c,0xe00003c,0xe00003c,0xe000038,0xf000038,0xf000038,0xf000078,0xf000078,0xf000078,0x7000078,0x701e078,0x703e070,0x703e070,0x703f070,0x787f070,0x7877070,0x78770f0,0x78f38f0,0x38e38f0,0x38e38f0,0x38e1ce0,0x39c1ce0,0x39c1ce0,0x39c1ce0,0x3f80ee0,0x3f80fe0,0x1f80fe0,0x1f807e0,0x1f007c0,0x1f007c0,0x1f007c0,0x1e003c0,0x1e003c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8000f8,0x78000f0,0x3c001e0,0x3c003e0,0x1e003c0,0x1f007c0,0xf00780,0x780f00,0x781f00,0x3c1e00,0x3e3c00,0x1e3c00,0xf7800,0xff800,0x7f000,0x3e000,0x3e000,0x3e000,0x7e000,0x7f000,0xff800,0x1f7800,0x1e3c00,0x3c3c00,0x3c1e00,0x780f00,0xf80f00,0xf00780,0x1e007c0,0x3e003c0,0x3c001e0,0x7c001e0,0x78000f0,0xf0000f8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x78000f8,0x78000f0,0x3c001e0,0x3e001e0,0x1e003c0,0x1f007c0,0xf00780,0xf80f80,0x780f00,0x7c1f00,0x3c1e00,0x1e3e00,0x1e3c00,0xf7800,0xff800,0x7f000,0x7f000,0x3e000,0x3e000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x1c000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1ffffc0,0x1ffffc0,0x1ffffc0,0x1e00000,0xf00000,0xf00000,0x780000,0x7c0000,0x3c0000,0x1e0000,0x1e0000,0xf0000,0xf0000,0x78000,0x78000,0x3c000,0x3c000,0x1e000,0x1f000,0xf000,0x7800,0x7800,0x3c00,0x3c00,0x1e00,0x1e00,0xf00,0xf80,0x780,0x3c0,0x3c0,0x1ffffe0,0x1ffffe0,0x1ffffe0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3fe000,0x3fe000,0x3fe000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x3fe000,0x3fe000,0x3fe000,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3c0,0x380,0x780,0x780,0x700,0xf00,0xe00,0x1e00,0x1c00,0x1c00,0x3c00,0x3800,0x7800,0x7000,0xf000,0xe000,0xe000,0x1e000,0x1c000,0x3c000,0x38000,0x78000,0x78000,0x70000,0xf0000,0xe0000,0x1e0000,0x1c0000,0x1c0000,0x3c0000,0x380000,0x780000,0x700000,0xf00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1ff00,0x1ff00,0x1ff00,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1ff00,0x1ff00,0x1ff00,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c000,0x3e000,0x3e000,0x7f000,0xf7800,0xe3800,0x1e3c00,0x1c1c00,0x3c0e00,0x380e00,0x700700,0xf00780,0xe00380,0x1e003c0,0x1c001c0,0x38000e0,0x38000f0,0x7000070,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3ffffffe,0x3ffffffe,0x3ffffffe,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7c00,0x7800,0xf000,0x1e000,0x1c000,0x38000,0x70000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff000,0x3ffe00,0x7fff80,0xfc0f00,0xf00100,0xf00000,0x1e00000,0x1e00000,0x1e00000,0x1e00000,0x1ff0000,0x1fff800,0x1fffe00,0x1e1ff00,0x1e01f80,0x1e00780,0x1e003c0,0x1e003c0,0x1f003c0,0x1f803c0,0x1fc07c0,0x1ef0f80,0x1e7ff00,0x1c3fe00,0x1c0fc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3c0,0x3c0,0x3c0,0x3c0,0x3c0,0x3c0,0x3c0,0x3c0,0x3c0,0xfc3c0,0x3ff3c0,0x7ffbc0,0xf83fc0,0x1f00fc0,0x1e007c0,0x3e007c0,0x3c003c0,0x3c003c0,0x3c003c0,0x3c003c0,0x38003c0,0x38003c0,0x3c003c0,0x3c003c0,0x3c003c0,0x3c003c0,0x3c003c0,0x1e007c0,0x1e007c0,0xf00fc0,0xfc3fc0,0x7ffbc0,0x3ff3c0,0xfc3c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3fc000,0x1fff800,0xfffc00,0xc07e00,0x1f00,0x780,0x7c0,0x3c0,0x3c0,0x1e0,0x1e0,0x1e0,0x1e0,0x1e0,0x1e0,0x1e0,0x3c0,0x3c0,0x7c0,0xf80,0x1f00,0xc07e00,0xfffc00,0x1fff800,0x7fc000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1e00000,0x1e00000,0x1e00000,0x1e00000,0x1e00000,0x1e00000,0x1e00000,0x1e00000,0x1e00000,0x1e1f800,0x1e7fe00,0x1efff00,0x1fe1f80,0x1f807c0,0x1f003c0,0x1e003e0,0x1e001e0,0x1e001e0,0x1e001e0,0x1e000f0,0x1e000f0,0x1e000f0,0x1e000f0,0x1e000e0,0x1e001e0,0x1e001e0,0x1e001e0,0x1f003e0,0x1f803c0,0x1fc07c0,0x1fe0f80,0x1efff00,0x1e3fe00,0x1e0f800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7e000,0x1ffc00,0x3ffe00,0x7c1f00,0xf80f80,0xf00780,0x1e003c0,0x1e003c0,0x1e001e0,0x1c001e0,0x3ffffe0,0x3ffffe0,0x3ffffe0,0x1e0,0x1e0,0x1e0,0x1c0,0x3c0,0x3c0,0x780,0xf80,0xc03f00,0xfffe00,0x1fff800,0x7fe000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f0000,0x1ffc000,0x1ffc000,0xc1e000,0x1e000,0xe000,0xf000,0xf000,0xf000,0xffffc0,0xffffc0,0xffffc0,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x381f800,0x3fffe00,0x3ffff00,0x3f0f80,0x3c0780,0x3c03c0,0x3803c0,0x3803c0,0x3803c0,0x3803c0,0x3c03c0,0x3c0780,0x1f0f80,0xfff00,0x7fe00,0x1fe00,0xf00,0x380,0x1c0,0x3c0,0x7fffc0,0x1ffff80,0x3fffe00,0x3c00700,0x7800380,0x78001c0,0x78001e0,0x78001e0,0x3c001e0,0x3e001e0,0x1f003c0,0xfc07c0,0x7fff80,0x1fff00,0x3f800,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3c0,0x3c0,0x3c0,0x3c0,0x3c0,0x3c0,0x3c0,0x3c0,0x3c0,0x1f83c0,0x7fe3c0,0x7ffbc0,0xf87fc0,0xf01fc0,0x1e007c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30000,0x78000,0x78000,0x78000,0x30000,0x0,0x0,0x0,0x0,0x7ff00,0x7ff00,0x7ff00,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30000,0x78000,0x78000,0x78000,0x30000,0x0,0x0,0x0,0x0,0x7ff00,0x7ff00,0x7ff00,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x78000,0x38000,0x3c180,0x3ff80,0x1ffc0,0x7f00,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3c0,0x3c0,0x3c0,0x3c0,0x3c0,0x3c0,0x3c0,0x3c0,0x3c0,0x1e003c0,0xf003c0,0x7c03c0,0x3e03c0,0x1f03c0,0xf83c0,0x7c3c0,0x3e3c0,0x1f3c0,0xfbc0,0x7fc0,0xffc0,0x1ffc0,0x1e7c0,0x3c3c0,0x7c3c0,0xf83c0,0x1f03c0,0x3e03c0,0x7c03c0,0x7803c0,0xf803c0,0x1f003c0,0x3e003c0,0x7c003c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1ff80,0x1ff80,0x1ff80,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x7fe000,0x7fe000,0x7fe000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf078f0,0x1f8fcf0,0x3fcfef0,0x3cff3f0,0x387e1f0,0x783e1f0,0x781e0f0,0x781c0f0,0x781c0f0,0x781c0f0,0x781c0f0,0x781c0f0,0x781c0f0,0x781c0f0,0x781c0f0,0x781c0f0,0x781c0f0,0x781c0f0,0x781c0f0,0x781c0f0,0x781c0f0,0x781c0f0,0x781c0f0,0x781c0f0,0x781c0f0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f83c0,0x7fe3c0,0x7ffbc0,0xf87fc0,0xf01fc0,0x1e007c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f000,0x1ffc00,0x3fff00,0x7c1f80,0xf00780,0x1f003c0,0x1e003c0,0x3c001e0,0x3c001e0,0x3c001e0,0x3c000e0,0x3c000f0,0x38000f0,0x3c000f0,0x3c000e0,0x3c001e0,0x3c001e0,0x3c001e0,0x1e003c0,0x1f003c0,0xf80780,0x7c1f80,0x3fff00,0x1ffc00,0x7f000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfc3c0,0x3ff3c0,0x7ffbc0,0xfc3fc0,0x1f00fc0,0x1e007c0,0x3e007c0,0x3c003c0,0x3c003c0,0x3c003c0,0x3c003c0,0x38003c0,0x38003c0,0x3c003c0,0x3c003c0,0x3c003c0,0x3c003c0,0x3c003c0,0x1e007c0,0x1e007c0,0xf00fc0,0xfc3fc0,0x7ffbc0,0x3ff3c0,0xfc3c0,0x3c0,0x3c0,0x3c0,0x3c0,0x3c0,0x3c0,0x3c0,0x3c0,0x3c0,0x3c0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1e1f800,0x1e7fe00,0x1efff00,0x1fe1f80,0x1fc07c0,0x1f803c0,0x1f003e0,0x1e001e0,0x1e001e0,0x1e001e0,0x1e000e0,0x1e000f0,0x1e000f0,0x1e000f0,0x1e000e0,0x1e001e0,0x1e001e0,0x1e001e0,0x1f001e0,0x1f003c0,0x1fc07c0,0x1fe0f80,0x1efff00,0x1e3fe00,0x1e0f800,0x1e00000,0x1e00000,0x1e00000,0x1e00000,0x1e00000,0x1e00000,0x1e00000,0x1e00000,0x1e00000,0x1e00000,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7e0e00,0xff0e00,0x1ff8e00,0x1e3ce00,0x80ee00,0x7e00,0x3e00,0x3e00,0x1e00,0xe00,0xe00,0xe00,0xe00,0xe00,0xe00,0xe00,0xe00,0xe00,0xe00,0xe00,0xe00,0xe00,0xe00,0xe00,0xe00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1ff000,0x7ffc00,0x7fff00,0x301f80,0x780,0x380,0x3c0,0x780,0xf80,0x7f80,0x1ff00,0xffe00,0x3ff800,0x7fc000,0xff0000,0xf80000,0xf00000,0x1e00000,0xe00000,0xe00000,0xf00000,0x7c0380,0x3fff80,0x1fff80,0x3fe00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7800,0x7800,0x7800,0x7800,0x7800,0x7800,0x7800,0x7fff80,0x7fff80,0x7fff80,0x7800,0x7800,0x7800,0x7800,0x7800,0x7800,0x7800,0x7800,0x7800,0x7800,0x7800,0x7800,0x7800,0x7800,0x7800,0x7800,0x7800,0xf000,0x1c1f000,0x1fff000,0x1ffe000,0x7f8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1e003c0,0x1f003c0,0x1fc07c0,0x1ff0f80,0x1e7ff80,0x1e3ff00,0x1e0fc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3c000f0,0x1e001e0,0x1e001e0,0x1e001e0,0xf003c0,0xf003c0,0xf00780,0x780780,0x780780,0x380f00,0x3c0f00,0x3c0f00,0x1e1e00,0x1e1e00,0x1e1c00,0xf3c00,0xf3c00,0x77800,0x7f800,0x7f800,0x3f000,0x3f000,0x3f000,0x1e000,0x1e000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf000070,0xf000070,0x70000f0,0x70000f0,0x70000f0,0x78000f0,0x78000e0,0x78000e0,0x783c0e0,0x383e0e0,0x387e0e0,0x387f1e0,0x38771e0,0x38e79c0,0x3ce39c0,0x3de39c0,0x1dc3dc0,0x1fc1dc0,0x1f81fc0,0x1f80fc0,0x1f00f80,0x1f00780,0x1f00780,0xe00780,0xe00380,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1e001e0,0x1e003e0,0xf003c0,0x780780,0x780f00,0x3c0f00,0x1e1e00,0xe3c00,0xf3c00,0x7f800,0x3f000,0x3f000,0x1e000,0x3f000,0x7f000,0x7f800,0xf3c00,0x1e3c00,0x1e1e00,0x3c0f00,0x780700,0x780780,0xf003c0,0x1e001e0,0x1e001e0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3c000f0,0x1e001e0,0x1e001e0,0x1e001e0,0xf003c0,0xf003c0,0xf00380,0x780780,0x780780,0x380700,0x3c0f00,0x3c0f00,0x1c0e00,0x1e1e00,0x1e1e00,0xe3c00,0xf3c00,0x73c00,0x77800,0x7f800,0x3f000,0x3f000,0x3f000,0x1e000,0x1e000,0x1e000,0xe000,0xf000,0x7000,0x7800,0x3800,0x3e10,0x1ff0,0xff0,0x3e0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1ffffc0,0x1ffffc0,0xffffc0,0x780000,0x780000,0x3c0000,0x1e0000,0x1e0000,0xf0000,0x78000,0x38000,0x3c000,0x1e000,0xf000,0xf000,0x7800,0x3c00,0x3c00,0x1e00,0xf00,0xf00,0x780,0x1ffffc0,0x1ffffc0,0x1ffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3c0000,0x3f0000,0x3f8000,0x78000,0x38000,0x38000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x1c000,0x1c000,0x1e000,0xe000,0xf000,0x7e00,0x1e00,0x7e00,0xf000,0xe000,0x1e000,0x1c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x3c000,0x38000,0x78000,0x3f8000,0x3f0000,0x3c0000,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x1e000,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f00,0x7f00,0x7f00,0xf800,0xf000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0x1e000,0x1e000,0x1e000,0x1c000,0x1c000,0x3c000,0x78000,0x1f0000,0x1e0000,0x1f0000,0x78000,0x3c000,0x1c000,0x1e000,0x1e000,0x1e000,0x1e000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xf000,0xf800,0x7f00,0x7f00,0x1f00,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf80,0x8007fe0,0xc01fff8,0xf07f87c,0x7ffc01c,0x3ff0000,0xf80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                        };

uint32_t font_ANDALEMO_36x64[95][72] = {
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0xf,0xf8,0xf80,0xf800,0xf8000,0xf80000,0xf800000,0xf8000000,0x80000000,0xf,0xf8,0xf80,0xf800,0xf8000,0xf80000,0xf800000,0xf8000000,0x80000000,0xf,0x78,0x780,0x7800,0x70000,0x700000,0x7000000,0x70000000,0x0,0x7,0x70,0x700,0x7000,0x0,0x0,0x0,0x0,0x0,0x0,0x70,0xf80,0x1fc00,0x1fc000,0x1fc0000,0xf800000,0x70000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x78000000,0x800001e0,0x1e07,0x1e078,0x1e0780,0x1e07800,0x1e078000,0xe0780000,0x7800001,0x7800001e,0x800001e0,0xe07,0xe038,0xe0380,0xe03000,0xc030000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0x1c03,0x1e03c,0x1e03c0,0x1e03c00,0x1e01c000,0xe01e0000,0x1e00000,0x1e00000f,0xe00000f0,0xf01,0xf00e,0x800780f0,0xfffffff,0xfffffff8,0xffffff80,0xfffff80f,0x78000ff,0x78000038,0x800003c0,0x3c07,0x3c078,0x3c03c0,0x1e03c00,0x1e03c000,0xe03c0000,0x1c00001,0xfff8001e,0xff80ffff,0xf80fffff,0x80ffffff,0xfffffff,0xf00e00,0x780f000,0x780f0000,0x80f00000,0xf000007,0x78000078,0x80000780,0x3c07,0x3c078,0x3c0780,0x3c07800,0x1c03c000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0000,0xf00000,0xf000000,0xf8000000,0xe000001f,0x800007ff,0x7fff,0x3fffc,0x30ffe0,0xf3f00,0xf1f000,0xf0f0000,0xf0f80000,0xf800000,0xf800000f,0x800000f0,0xf0f,0xf0f8,0xf0f00,0xf1f000,0xf3e0000,0xffc00000,0xf8000000,0xf,0x1ff,0x7fc0,0x1ff000,0x3ff0000,0x7ef00000,0x8f000000,0xf0000007,0xf8,0xf0f,0x1f0f0,0x1f0f00,0x1e0f000,0x1e0f0000,0xf0f00000,0xf000001,0xf000001f,0xf0,0xf8f,0xf8f0,0x7ef03,0x3ff1f0,0x1ffff00,0xffff000,0x7ffe0000,0xff000000,0x0,0xf,0xf0,0xf00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f80000,0x7fe00000,0xff003c00,0xf001e00f,0x800e00f0,0xf01e07,0x701e078,0x781c0380,0x83c03c00,0x3c03c003,0xc03c003c,0x3c001c3,0x38001e3c,0x8000f1c0,0xf1e07,0x79e078,0x78f0f00,0x3cfff000,0xc7fe0000,0x1f800003,0x1e,0x1e0,0xf00,0xf000,0x78000,0x780000,0x83c00000,0x3c00000f,0xe00003fe,0x7ff1,0xf8f8e,0xf078f0,0x1e03c700,0xe03c7800,0x3c38001,0x3c3c001e,0xc1c001e0,0x1e001e03,0xf001e03c,0x1e03c0,0x1e03c0f,0xf078078,0xf8f80780,0xff003c00,0xe003c007,0x3f,0xf8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7e000000,0xf8000000,0xe000001f,0x3ff,0x7ffe,0x7c3f0,0xf80f80,0xf007800,0xf0078000,0x780000,0x780000f,0x780000f0,0x80000f00,0x780f,0x7c0f0,0x3e1f00,0x1f1e000,0xfbe0000,0x7fc00000,0xf8000000,0x80070003,0x7c001f,0x7e001fc,0x7f003fe0,0xf007df80,0x80f8fc01,0xf07c007,0xf03e0078,0x1f003c1,0xf003c3e,0xf001e7c0,0x801ef800,0xff000f,0xff000f8,0x7e000f80,0xc000f800,0xf8007,0x1f000f8,0x1f000fc0,0xe001fe00,0x7ff003,0x7fcfc0fe,0xf87fffc0,0x3fff807,0xffe007f,0x3f8003c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0x700,0x7000,0x60000,0x600000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x700,0x7800,0x3c000,0x1e0000,0xf00000,0x7800000,0x3c000000,0xe0000000,0x3,0x1e,0x1f0,0xf00,0xf800,0x78000,0x780000,0x7c00000,0x3c000000,0xc0000000,0x3,0x3c,0x3e0,0x3e00,0x3e000,0x3e0000,0x3e00000,0x3e000000,0xe0000000,0x3,0x3e,0x3e0,0x3c00,0x3c000,0x3c0000,0x7c00000,0x78000000,0x80000000,0x7,0xf8,0xf00,0x1f000,0x1e0000,0x3c00000,0x7c000000,0x80000000,0x7,0xf0,0x1e00,0x3c000,0x780000,0x7000000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0xe000000,0xe0000000,0x1,0x3c,0x780,0xf800,0x1f0000,0x1e00000,0x3c000000,0xc0000000,0x7,0x78,0xf00,0xf000,0x1f0000,0x1e00000,0x1e000000,0xe0000000,0x3,0x3e,0x3e0,0x3c00,0x3c000,0x3c0000,0x3c00000,0x7c000000,0xc0000000,0x3,0x3c,0x3c0,0x3c00,0x3e000,0x3e0000,0x3e00000,0x1e000000,0xe0000000,0x1,0x1f,0xf0,0xf80,0x7800,0x7c000,0x3c0000,0x1e00000,0x1f000000,0xf0000000,0x80000000,0x7,0x3c,0x1e0,0xe00,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7,0x70,0x700,0x207000,0x7070e00,0x7c71f000,0xe77e0000,0xff800003,0xe000001f,0x7f,0x1fc,0x1fc0,0x7fe00,0x1fff800,0x3e77e000,0xc71f0000,0x70e00007,0x70,0x207,0x70,0x700,0x7000,0x70000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xfe00000f,0xe007ffff,0x7fffff,0x7fffffe,0x7fffffe0,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70,0x1f80,0x1f800,0x1f8000,0x1f80000,0x1f800000,0xf0000000,0x1,0x1c,0xe0,0xe00,0x7800,0x38000,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffe0000,0xffe00003,0xfe00003f,0xe00003ff,0x3fff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70,0xf80,0x1fc00,0x1fc000,0x1fc0000,0xf800000,0x70000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x78,0x780,0x7800,0x3c000,0x3c0000,0x1e00000,0x1e000000,0xe0000000,0x1,0xf,0xf0,0x780,0x7800,0x7c000,0x3c0000,0x3c00000,0x1e000000,0xe0000000,0x1,0x1f,0xf0,0xf00,0x7800,0x78000,0x3c0000,0x3c00000,0x3c000000,0xe0000000,0x1,0x1e,0xf0,0xf00,0xf000,0x78000,0x780000,0x3c00000,0x3c000000,0xc0000000,0x3,0x1e,0x1e0,0xf00,0xf000,0xf8000,0x780000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfc000000,0xf0000001,0x8000007f,0x1fff,0x3fffc,0x7f07e0,0x7c03f00,0xf801f000,0x800f8000,0xf8000f,0x78001f0,0x7c001f00,0xc001e000,0x3e0007,0x3e0003c,0x3e0003c0,0xe0003e00,0x3e003,0xf03e003e,0xc3e003c0,0x3e003c1f,0xe003c1fc,0x3c3fc3,0x3c3fc3e,0x3c1fc3e0,0xc1f83e00,0xf03e003,0x3e003c,0x3e003c0,0x3e003e00,0xc003e000,0x3e0003,0x3e0003c,0x3e0007c0,0xe0007c00,0x7c001,0xf8001f,0xf8001f0,0xf0000f80,0xf801,0x7c03f,0x7f07e0,0x3fffc00,0x1fff8000,0x7ff00000,0xfc000000,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0000000,0x80000001,0x1f,0x1fe,0x1ff8,0x1ffe0,0x1e7e00,0x1e3e000,0x1e0e0000,0xe0200000,0x1,0x1e,0x1e0,0x1e00,0x1e000,0x1e0000,0x1e00000,0x1e000000,0xe0000000,0x1,0x1e,0x1e0,0x1e00,0x1e000,0x1e0000,0x1e00000,0x1e000000,0xe0000000,0x1,0x1e,0x1e0,0x1e00,0x1e000,0x1e0000,0x1e00000,0x1e000000,0xe0000000,0x1,0x1e,0x1e0,0x1e00,0x1ffffe0,0x1ffffe00,0xffffe000,0xfffe0001,0x1f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff800000,0xff000000,0xf800003f,0x80000fff,0x1ffff,0x1fc0f0,0x3f00100,0x3e000000,0xc0000000,0x7,0x7c,0x7c0,0x7c00,0x7c000,0x7c0000,0x7c00000,0x7c000000,0xc0000000,0x7,0x3c,0x3e0,0x1e00,0x1f000,0xf0000,0xf80000,0x7800000,0x3c000000,0xe0000000,0x3,0x1f,0xf0,0x780,0x3c00,0x1e000,0xf0000,0xf80000,0x7c00000,0x3e000000,0xe0000000,0x1,0xf,0xfffff8,0xfffff80,0xfffff800,0xffff8000,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f000000,0xfe000000,0xf000003f,0x7ff,0x1ffff,0x1fc0f0,0x3f00100,0x7e000000,0xc0000000,0x7,0x7c,0x7c0,0x7c00,0x7c000,0x7c0000,0x3e00000,0x3f000000,0xf8000000,0xe0000001,0xf000000f,0x7f,0x1ff,0x3ff0,0xfff00,0x1fe0000,0x3f000000,0xe0000000,0x7,0x7c,0xfc0,0xf800,0xf8000,0xf80000,0xf800000,0xf8000000,0x80000000,0xf,0x7c,0x7c0,0x80003e00,0x3f000,0x1fc078,0xffff80,0x7fff800,0x1fff8000,0x3fc00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f8,0x3f80,0x3fc00,0x3fc000,0x3fe0000,0x3ef00000,0xef000000,0x78000003,0x8000003e,0x3e7,0x3e3c,0x3e3c0,0x3e1e00,0x3e1f000,0x3e0f0000,0xe0780000,0x7800003,0x3c00003e,0xe00003e0,0x3e03,0x3e01e,0x3e01f0,0x3e00f00,0x3e007800,0xe0078000,0x3c0003,0x3e0003e,0x1e0003e0,0xf0003e00,0x3fffff,0x3ffffff,0x3ffffff0,0xffffff00,0xe0000003,0x3,0x3e,0x3e0,0x3e00,0x3e000,0x3e0000,0x3e00000,0x3e000000,0xe0000000,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfe000000,0xe00007ff,0x7fff,0x7fffe,0x7fffe0,0x1e00,0x1e000,0x1e0000,0x1e00000,0x1e000000,0xe0000000,0x1,0x1e,0x1e0,0x1e00,0x1e000,0x1e0000,0xffe00000,0xfe000000,0xe000007f,0xfff,0x1fffe,0x3f8180,0x7e00000,0x7c000000,0x80000000,0xf,0xf8,0xf80,0xf800,0xf0000,0xf00000,0xf000000,0xf8000000,0x80000000,0xf,0xf8,0x7c0,0x7c00,0x3f001,0x1f80f0,0xffff80,0x7fff800,0x3fff0000,0x7f800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0xc000003f,0xfff,0xfffe,0xffff0,0x603f80,0xfc00,0x7c000,0x3e0000,0x1e00000,0x1f000000,0xf0000000,0x80000000,0xf,0xf8,0xf80,0x7800,0x78000,0x7c0000,0x7c00000,0x7c00003f,0xc0001ffe,0x3fff7,0x7ffffc,0xfe0ffc0,0xf801fc00,0xfc001,0x7c001f,0x7c003e0,0x78003e00,0x8003e000,0x3e0007,0x3e000f8,0x3e000f80,0xe000f000,0x1f0003,0x1f0003e,0x3e0003e0,0xe0001e00,0x1f003,0x1f807c,0xfc1f80,0x7fff000,0x3ffe0000,0xffc00000,0xf0000001,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffc00000,0xfc001fff,0xc001ffff,0x1fffff,0x1fffffc,0x1f000000,0xf0000000,0x80000000,0xf,0xf8,0x780,0x7c00,0x3c000,0x3e0000,0x1e00000,0x1f000000,0xf0000000,0x1,0xf,0xf8,0x780,0x7c00,0x3c000,0x3e0000,0x3e00000,0x1e000000,0xf0000000,0x1,0xf,0xf8,0x780,0x7c00,0x7c000,0x3c0000,0x3e00000,0x1e000000,0xf0000000,0x1,0xf,0xf8,0xf80,0x7800,0x7c000,0x3c0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfc000000,0xf0000001,0x8000007f,0x1fff,0x3fffc,0x7f07e0,0x7c03f00,0xf801f000,0x800f8000,0xf8000f,0x78001f0,0x78001f00,0x8001f000,0x1f0007,0xf000f8,0xf800f00,0xf801f000,0xe03e0000,0x8fc00007,0xf800003f,0x1ff,0x7fe,0x7ff0,0x1fffc0,0x3f8fe00,0x7c03f000,0x801f8000,0xf8000f,0x7c001f0,0x7c001f00,0xc003e000,0x3e0003,0x3e0003c,0x3e0003c0,0xe0003c00,0x3c003,0x7c003e,0x7c003e0,0xf8001f00,0x8001f800,0xfc01f,0xfe07f0,0x7fffe00,0x3fffc000,0xfff80000,0xfc000000,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfc000000,0xf0000000,0xc000007f,0xfff,0x1fffe,0x3f07f0,0x3e01f00,0x7c00f800,0x800f8000,0x7c0007,0x7c000f8,0x7c000f00,0xc001f000,0x1f0007,0x1e0007c,0x1e0007c0,0xe0007c00,0x7c001,0xfc003e,0xf8003e0,0xf8003f00,0x3f801,0x3fe07f,0x3ffffe0,0x3efffc00,0xe7ff8000,0x1fc00003,0x3e,0x3e0,0x1e00,0x1e000,0x1f0000,0x1f00000,0xf000000,0xf8000000,0x80000000,0xf,0x7c,0x7c0,0x3e00,0x1f000,0x1fc070,0xffff00,0x7fff000,0x1fff0000,0x7fc00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70,0xf80,0x1fc00,0x1fc000,0x1fc0000,0xf800000,0x70000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70,0xf80,0x1fc00,0x1fc000,0x1fc0000,0xf800000,0x70000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70,0xf80,0x1f800,0x1f8000,0x1f80000,0xf800000,0x70000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70,0x1f80,0x1f800,0x1f8000,0x1f80000,0x1f800000,0xf0000000,0x1,0x1c,0xe0,0xe00,0x7800,0x38000,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0xe0,0xf80,0xfe00,0x7f000,0x3fc000,0xff0000,0x3fc0000,0xff00000,0x3f800000,0xfe000000,0xf8000001,0x80000007,0x1f,0xf8,0x1f80,0x7f800,0x1fe0000,0x7fc00000,0xf0000000,0xf,0x3fc,0xff00,0x3fc000,0x7f80000,0xfe000000,0x80000000,0xf,0xe0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fffffe0,0xfffffe00,0xffffe007,0xfffe007f,0x7ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffe0000,0xffe007ff,0xfe007fff,0xe007ffff,0x7fffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x700000,0x1f000000,0xf0000000,0x7,0xfe,0x3fc0,0xff000,0x3fc0000,0x7f000000,0xc0000000,0x1f,0x7f8,0x1fe00,0x1f8000,0x1f00000,0x1f800000,0xfe000000,0xf8000001,0xe0000007,0x3f,0xff,0x3fc,0xff0,0x3fc0,0xfe00,0x7f000,0x1f0000,0x700000,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff000000,0xfe000000,0xf000007f,0xfff,0x1ffff,0x3f81f0,0x3e00200,0x7c000000,0xc0000000,0x7,0x78,0x780,0x7800,0x7c000,0x7c0000,0x3c00000,0x3e000000,0xf0000000,0x80000001,0xf,0xfc,0x7e0,0x3f00,0xf800,0x7c000,0x3c0000,0x1e00000,0x1e000000,0xe0000000,0x1,0xe,0xe0,0xe00,0x0,0x0,0x0,0x0,0x0,0x0,0x1e,0x3f0,0x3f00,0x3f000,0x3f0000,0x3f00000,0x1e000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8000000,0xe0000003,0x800000ff,0x3fff,0x7c0fc,0xf003e0,0x1e000f00,0xc0007000,0x78001,0x380038,0x1c00380,0x1c007000,0xe0070000,0x700001,0xe1ff00e,0xe1ff80e0,0x1ffc0e00,0xf1e0700e,0xf0700e1,0x70700e0e,0x8700e0e0,0x700e0e07,0xe0e078,0xe0e0387,0xe0f03870,0xf038700,0xf03c700e,0x3c700e0,0x3c700e0f,0xc70070f0,0x70070703,0x387038,0x3878787,0x1cfc7870,0xff7f0700,0xf7f0e001,0x1c0e000f,0xe0003e,0x1c000000,0xc0000000,0x1,0x38,0x780,0xf000,0x1e0000,0x7c00004,0xf8000078,0x7ff,0x3fff,0x7f80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x1f,0x1f8,0x1fc0,0x3fc00,0x3fc000,0x3fe0000,0x7fe00000,0xde000000,0xf0000007,0x79,0xf9f,0xf8f0,0xf0f80,0x1f0f800,0x1f078000,0xe07c0000,0x7c00001,0x3c00003e,0xc00003e0,0x3c03,0x7c03e,0x7c01e0,0x7801e00,0xfffff000,0xffff0000,0xfff0000f,0xff8000ff,0x78000fff,0x8001f000,0x1e0007,0x1e0007c,0x3e0003c0,0xc0003c00,0x3e003,0x3e003c,0x1e007c0,0x1f007c00,0xf0078000,0xf80001,0xf80000f,0xf00000f8,0xf80,0x781f,0x1f0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff800000,0xf800003f,0x80001fff,0x3ffff,0x7ffff8,0xfe00780,0xf8007800,0x78001,0x78001f,0x78001f0,0x78001e00,0x8001e000,0x1e0007,0x1f00078,0xf000780,0xf8007800,0xe0078000,0xfff80007,0xff80003f,0xf80000ff,0x80000fff,0x3ffff,0x7f0078,0xfc00780,0xf0007800,0x78001,0x78003e,0x78003e0,0x78003c00,0x8007c000,0x7c0007,0x7c00078,0x7c000780,0xc0007800,0x78003,0x78003e,0x78003e0,0x78001f00,0x8001fc00,0xff007,0x7ffff8,0x3ffff80,0xffff800,0x1fff8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0000000,0xe000001f,0x80001fff,0x3ffff,0x1ffffc,0x1f01fe0,0x8003f00,0x1f000,0xf8000,0xf80000,0x7c00000,0x7c000000,0xc0000000,0x3,0x3e,0x3e0,0x3e00,0x3e000,0x1e0000,0x1e00000,0x1e000000,0xf0000000,0x1,0x1f,0x1f0,0x1e00,0x1e000,0x1e0000,0x3e00000,0x3e000000,0xe0000000,0x3,0x3e,0x3e0,0x7c00,0x7c000,0xf80000,0xf800000,0xf0000000,0x10001,0x1c003f,0x3f80fe0,0x3ffffc00,0xffff8000,0xffe00001,0xf0000007,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff800000,0xf8000007,0x800003ff,0x7fff,0x1ffff8,0x3fc0780,0x7f007800,0xe0078000,0x780007,0x78000fc,0x78001f80,0x8001f000,0x3f0007,0x3e00078,0x3e000780,0xc0007800,0x78003,0x78007c,0x78007c0,0x78007c00,0x8007c000,0x7c0007,0x7c00078,0x7c000780,0xc0007800,0x78007,0x78007c,0x78007c0,0x78007c00,0x8003c000,0x3e0007,0x3e00078,0x3f000780,0xf0007800,0x80078001,0x78001f,0x78000f8,0x78000fc0,0x80007f00,0x3fc07,0x1ffff8,0x7fff80,0x3fff800,0x7ff8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff000000,0xf0000fff,0xffff,0xfffff,0xfffff0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xff000000,0xf00007ff,0x7fff,0x7ffff,0x7ffff0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xfffff0,0xfffff00,0xfffff000,0xffff0000,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff000000,0xf0000fff,0xffff,0xfffff,0xfffff0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x7fff,0x7ffff,0x7ffff0,0x7ffff00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8000000,0xe000001f,0x80001fff,0x3ffff,0x1ffffc,0x1f01fe0,0x8003f00,0x1f000,0xf8000,0xf80000,0x7c00000,0x7c000000,0xc0000000,0x3,0x3e,0x3e0,0x3e00,0x3e000,0x1e0000,0x1e00000,0x1e000000,0xf0000000,0x1,0x1f,0x1f0,0xff801e00,0xf801e003,0x801e003f,0x3e003ff,0x3e003ff8,0xe003c000,0x3c0003,0x3c0003e,0x3c0003e0,0xc0007c00,0x7c003,0xfc003c,0xf8003c0,0xf0003c00,0x3c001,0x3e003f,0x3f80fe0,0x3ffffc00,0xffff8000,0xffe00001,0xf0000007,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7800000,0x78001f00,0x8001f000,0x1f0007,0x1f00078,0x1f000780,0xf0007800,0x78001,0x78001f,0x78001f0,0x78001f00,0x8001f000,0x1f0007,0x1f00078,0x1f000780,0xf0007800,0x78001,0x78001f,0xff8001f0,0xf8001fff,0x8001ffff,0x1fffff,0x1fffff8,0x1f000780,0xf0007800,0x78001,0x78001f,0x78001f0,0x78001f00,0x8001f000,0x1f0007,0x1f00078,0x1f000780,0xf0007800,0x78001,0x78001f,0x78001f0,0x78001f00,0x8001f000,0x1f0007,0x1f00078,0x1f000780,0xf0007800,0x78001,0x1f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfe000000,0xe00003ff,0x3fff,0x3fffe,0x3fffe0,0xf8000,0xf80000,0xf800000,0xf8000000,0x80000000,0xf,0xf8,0xf80,0xf800,0xf8000,0xf80000,0xf800000,0xf8000000,0x80000000,0xf,0xf8,0xf80,0xf800,0xf8000,0xf80000,0xf800000,0xf8000000,0x80000000,0xf,0xf8,0xf80,0xf800,0xf8000,0xf80000,0xf800000,0xf8000000,0x80000000,0xf,0xf8,0xf80,0x3fffe0,0x3fffe00,0x3fffe000,0xfffe0000,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f0,0x1f00,0x1f000,0x1f0000,0x1f00000,0x1f000000,0xf0000000,0x1,0x1f,0x1f0,0x1f00,0x1f000,0x1f0000,0x1f00000,0x1f000000,0xf0000000,0x1,0x1f,0x1f0,0x1f00,0x1f000,0x1f0000,0x1f00000,0x1f000000,0xf0000000,0x1,0x1f,0x1f0,0x1f00,0x1f000,0x1f0000,0x1f00000,0x1f000000,0xf0000000,0x1,0xf,0xf0,0xc0000f80,0xfc00,0x7e03c,0x3fffc0,0x1fffe00,0xfffc000,0x3fe00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7800000,0x7801f000,0x800f8000,0x7c0007,0x3e00078,0x1f000780,0xf8007800,0xc0078000,0x780007,0x780003e,0x780003f0,0x80001f00,0xf807,0x7c078,0x3e0780,0x1f07800,0xf878000,0x7c780000,0xe7800000,0x78000007,0x8000007f,0xfff,0x1fff8,0x1f3f80,0x3e3f800,0x7e1f8000,0xc0f80000,0x7800007,0x780000f8,0x80001f80,0x1f007,0x3e0078,0x7e00780,0xfc007800,0x80078000,0x78000f,0x78001f8,0x78003f00,0x8003e000,0x7e0007,0xfc00078,0xf8000780,0x80007800,0x7801f,0x3f0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0x1fffff0,0x1fffff00,0xfffff000,0xffff0001,0x1f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfc00000,0xfc003f00,0xc003f000,0x3f000f,0x3f801fc,0x3f801fc0,0xfc01fc00,0xc03fc003,0x3bc003f,0x7bc003dc,0xbc003de0,0xc003de07,0x3ce073,0x3cf0f3c,0x3cf0f3c0,0xc70e3c00,0x79e3c003,0x9e3c003c,0xc3c003c3,0x3c003c39,0xc003c3fc,0x3c1f83,0x3c1f83c,0x3c1f83c0,0xc0f03c00,0x3c003,0x3c003c,0x3c003c0,0x3c003c00,0xc003c000,0x3c0003,0x3c0003c,0x3c0003c0,0xc0003c00,0x3c003,0x3c003c,0x3c003c0,0x3c003c00,0xc003c000,0x3c0003,0x3c0003c,0x3c0003c0,0xc0003c00,0x3c003,0x3c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7c00000,0xfc001e00,0xc001e000,0x1e000f,0x1e001fc,0x1e001fc0,0xe003fc00,0x3fc001,0x7fc001e,0x7fc001e0,0xfc001e00,0xc001e007,0x1e00f7,0x1e00f7c,0x1e01e7c0,0xe01e7c00,0x3e7c001,0x3c7c001e,0xc7c001e0,0x7c001e07,0xc001e078,0x1e0f87,0x1e0f07c,0x1e0f07c0,0xe1e07c00,0x1e07c001,0xe07c001e,0x7c001e3,0x7c001e3c,0xc001e7c0,0x1e7807,0x1ef807c,0x1ef007c0,0xff007c00,0xe007c001,0x7c001f,0x7c001fe,0x7c001fc0,0xc001fc00,0x1fc007,0x1f8007c,0x1f8007c0,0xf0007c00,0x7c001,0x1f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfc000000,0xf0000001,0xc00000ff,0x1fff,0x3fffe,0x7f07f0,0xfc03f00,0xf801f800,0xf8000,0x7c001f,0x7c001f0,0x7c003e00,0xe003e000,0x3e0003,0x3c0003e,0x7c0003e0,0xc0003e00,0x3e007,0x1e007c,0x1e007c0,0x1e007c00,0xf007c000,0x7c0001,0x7c0001f,0x7c0001f0,0xc0001e00,0x1e007,0x1e007c,0x3e007c0,0x3e007c00,0xe007c000,0x7c0003,0x3c0003e,0x3e0003e0,0xe0003c00,0x7c003,0x7c003e,0xf8001f0,0xf8001f00,0xf801,0xfc01f,0x7f07f0,0x3fffe00,0x1fffc000,0xfff00000,0xfc000000,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff000000,0xf000003f,0x1fff,0x3ffff,0x7ffff0,0xfe00f00,0xf800f000,0xf0001,0xf0001f,0xf0003f0,0xf0003e00,0x3e000,0x3e000f,0x3e000f0,0x3e000f00,0xe000f000,0xf0003,0xf0001f,0xf0001f8,0xf0000fe0,0x7fff,0x3ffff,0x1ffff0,0x3fff00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfc000000,0xf0000001,0xc00000ff,0x1fff,0x3fffe,0x7f07f0,0xfc03f00,0xf801f800,0xf8000,0x7c001f,0x7c001f0,0x7c003e00,0xe003e000,0x3e0003,0x3c0003e,0x7c0003e0,0xc0003e00,0x3e007,0x1e007c,0x1e007c0,0x1e007c00,0xf007c000,0x7c0001,0x7c0001f,0x7c0001f0,0xc0001e00,0x1e007,0x1e007c,0x3e007c0,0x3e007c00,0xe007c000,0x7c0003,0x3c0003e,0x3e0003e0,0xe0003c00,0x7c003,0x7c003e,0xf8001f0,0xf8001f00,0xf801,0xfc01f,0x7f07f0,0x3fffe00,0x1fffc000,0xfff00000,0xfc000000,0xf,0x1f0,0x3f00,0x7fe000,0xffe0000,0xffc00000,0xf0000000,0x7,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff800000,0xf800003f,0x80001fff,0x3ffff,0x7ffff8,0xfe00780,0xf8007800,0x78001,0x78001f,0x78001f0,0x78001e00,0x8001e000,0x1e0007,0x1e00078,0x1f000780,0xf0007800,0x80078001,0x78000f,0x78000fc,0xf80007f0,0x80003fff,0xffff,0x3fff8,0x1fff80,0x3f07800,0x3e078000,0xc0780000,0x7800007,0x780000fc,0x80000f80,0x1f007,0x3f0078,0x3e00780,0x7c007800,0xc0078000,0x78000f,0x78000f8,0x78001f80,0x8003f000,0x3e0007,0x7e00078,0x7c000780,0x80007800,0x7800f,0x1f8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8000000,0xe000001f,0x800007ff,0x7fff,0x3fffc,0x300fe0,0x3f00,0x1f000,0xf0000,0xf80000,0xf800000,0xf8000000,0x80000000,0xf,0xf8,0x1f00,0x3f000,0x7e0000,0x1fc00000,0xf8000000,0x7,0x1ff,0x7fc0,0x1ff000,0x3fc0000,0x7f000000,0xe0000000,0x7,0xf8,0xf80,0x1f000,0x1f0000,0x1e00000,0x1e000000,0xf0000000,0x1,0x1f,0xf0,0xf80,0xf800,0x7c003,0x3f81f0,0x1ffff00,0xffff000,0x7ffe0000,0xff000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfff00000,0xff00ffff,0xf00fffff,0xffffff,0xfffffff,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7800000,0x78001f00,0x8001f000,0x1f0007,0x1f00078,0x1f000780,0xf0007800,0x78001,0x78001f,0x78001f0,0x78001f00,0x8001f000,0x1f0007,0x1f00078,0x1f000780,0xf0007800,0x78001,0x78001f,0x78001f0,0x78001f00,0x8001f000,0x1f0007,0x1f00078,0x1f000780,0xf0007800,0x78001,0x78001f,0x78001f0,0x78001f00,0x8001f000,0x1f0007,0x1f00078,0x1f000780,0xf0007800,0xf8001,0xf8001f,0xf8000f0,0xf0000f80,0xf801,0xfc03f,0x7e07e0,0x3fffe00,0x1fffc000,0xfff00000,0xfc000000,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x780000,0xf81f000,0xf81f0000,0xf00000,0xf80000f,0xf80001f0,0x80001f00,0x1e007,0x3e007c,0x3e007c0,0x3c003c00,0xc003e000,0x3e0007,0x1e0007c,0x1f0007c0,0xf0007800,0xf8001,0xf8000f,0xf0000f8,0xf0000f80,0x7801,0x7c01f,0x7c01e0,0x3c03e00,0x3e03e000,0xe03c0000,0x7c00003,0x7c00001e,0x800001f0,0x1f07,0xf0f8,0xf0f80,0xf8f000,0xf9f0000,0x79f00000,0xde000000,0xe0000007,0x7f,0x3fe,0x3fc0,0x3fc00,0x1fc000,0x1f80000,0x1f800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7c0000,0x7c1e000,0x7c1e0000,0x81e00000,0x1e000007,0xe0000078,0x781,0x781f,0x781f0,0x780f00,0xf80f000,0xf80f0000,0xf00000,0xf00000f,0xf00000f0,0xf80f00,0xf80f00f,0xf80f00f0,0xc0f00781,0xf00781f,0xf00781fc,0x783dc1,0x783dc1e,0x7839e1e0,0x879e1e00,0x78e1e007,0xf1e0078,0xf1e00387,0x1e003cf0,0xe003cf07,0x3ce079,0x3ce079c,0x3de03bc0,0xde03fc00,0xc03fc003,0x3fc003d,0x1fc001fc,0xfc001fc0,0xc001f801,0x1f801f,0x1f800f8,0x1f000f80,0xf000f800,0x78001,0x1f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f00000,0x1f00f800,0xe00f8000,0x7c0003,0x3e0007c,0x3e0007c0,0xf000f800,0x1f0001,0x1f0000f,0x3e0000f8,0xe00007c0,0x7c03,0x3e07c,0x1f0f80,0x1f0f800,0xf9f0000,0x7be00000,0xfe000000,0xc0000007,0x3f,0x3fc,0x1f80,0x1f000,0x1f8000,0x3fc0000,0x3fc00000,0xfe000000,0xf0000007,0xf9,0xf9f,0x1f0f8,0x3e0780,0x3e07c00,0x7c03e000,0x803e0000,0x1f00007,0xf8000f8,0xf8001f00,0xc001f000,0x3e0007,0x7c0003c,0x7c0003e0,0x80001f00,0x1f00f,0xf0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f00000,0x1f00f800,0xe007c000,0x7c0003,0x3e0003e,0x3e0007c0,0xf000fc00,0xf8001,0x1f0001f,0x1f0000f8,0xe0000f80,0x7c03,0x7c03e,0x3e07c0,0x3f07c00,0x1f0f8000,0xf8f80000,0x9f000000,0xf000000f,0x7d,0x7fe,0x3fe0,0x3fc00,0x1fc000,0x1f80000,0xf800000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff800000,0xf8001fff,0x8001ffff,0x1fffff,0x1fffff8,0x1f000000,0xf8000000,0x80000000,0xf,0x7c,0x3c0,0x3e00,0x1e000,0x1f0000,0xf80000,0xf800000,0x7c000000,0xc0000000,0x3,0x3e,0x1f0,0x1f00,0xf800,0x78000,0x7c0000,0x3c00000,0x3e000000,0xf0000000,0x1,0x1f,0xf8,0x780,0x7c00,0x3c000,0x3e0000,0x1f00000,0x1f000000,0xf8000000,0x80000000,0x7,0x1fffffc,0x1fffffc0,0xfffffc00,0xffffc001,0x1f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x3ff,0x3ff8,0x3ff80,0x3ff800,0xf8000,0xf80000,0xf800000,0xf8000000,0x80000000,0xf,0xf8,0xf80,0xf800,0xf8000,0xf80000,0xf800000,0xf8000000,0x80000000,0xf,0xf8,0xf80,0xf800,0xf8000,0xf80000,0xf800000,0xf8000000,0x80000000,0xf,0xf8,0xf80,0xf800,0xf8000,0xf80000,0xf800000,0xf8000000,0x80000000,0xf,0xf8,0xf80,0xf800,0xf8000,0xf80000,0xf800000,0xf8000000,0x80000000,0xf,0xf8,0x3ff80,0x3ff800,0x3ff8000,0x3ff80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x780000,0xf800000,0xf0000000,0x0,0xf,0x1e0,0x1e00,0x3c000,0x3c0000,0x3c00000,0x78000000,0x80000000,0x7,0xf0,0xf00,0x1f000,0x1e0000,0x1e00000,0x3c000000,0xc0000000,0x3,0x78,0x780,0x7800,0xf0000,0xf00000,0x1e000000,0xe0000000,0x1,0x3e,0x3c0,0x3c00,0x78000,0x780000,0xf000000,0xf0000000,0x0,0xf,0x1e0,0x1e00,0x3c000,0x3c0000,0x7800000,0x78000000,0x80000000,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfe000000,0xe000000f,0xff,0xffe,0xffe0,0xf8000,0xf80000,0xf800000,0xf8000000,0x80000000,0xf,0xf8,0xf80,0xf800,0xf8000,0xf80000,0xf800000,0xf8000000,0x80000000,0xf,0xf8,0xf80,0xf800,0xf8000,0xf80000,0xf800000,0xf8000000,0x80000000,0xf,0xf8,0xf80,0xf800,0xf8000,0xf80000,0xf800000,0xf8000000,0x80000000,0xf,0xf8,0xf80,0xf800,0xf8000,0xf80000,0xf800000,0xf8000000,0x80000000,0xf,0xf8,0xffe,0xffe0,0xffe00,0xffe000,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf00000,0x1f800000,0xf8000000,0xc0000001,0x3f,0x3fc,0x79e0,0xf8f00,0xf0f000,0x1e078000,0xe07c0000,0x3c00001,0x1e00003c,0xe00007c0,0x7801,0xf000f,0xf00078,0x1e000780,0xc0003c00,0x3c003,0x1e003c,0xf00780,0x7000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffe000,0xfffe7fff,0xffe7ffff,0xfe7fffff,0x7ffffff,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f800000,0xf0000000,0x3,0x3e,0x7c0,0xf800,0xf0000,0x1e00000,0x3c000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fc,0x1fffc,0x3ffff0,0x7fffe00,0xfe03e000,0xc0060000,0xf,0xf8,0x1f00,0x1f000,0x1f0000,0x1e00000,0x1e000000,0xe0000000,0xf8000001,0xfc00001f,0xf80001ff,0xc0001fff,0x1ffff,0x1e0ffe,0x1e007f0,0x1e001f80,0xe000f800,0xf8001,0x78001e,0x78001f0,0xf8001f80,0x8001fc00,0x1fe00f,0x1ff83f0,0x1effff00,0xe3ffe000,0x1ffc0001,0x7f00001e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7800000,0x78000000,0x80000000,0x7,0x78,0x780,0x7800,0x78000,0x780000,0x7800000,0x78000000,0x800007e0,0x1ffc7,0x3ffe78,0x7ffff80,0xfe0ff800,0x803f8000,0x1f8001f,0xf8001f0,0x78001f00,0x8003e000,0x3e0007,0x3c00078,0x3c000780,0xc0007800,0x78003,0x78007c,0x78007c0,0x78007c00,0x8007c000,0x3c0007,0x3c00078,0x3c000780,0xe0007800,0x78003,0xf8003e,0x1f8001e0,0xf8001f00,0x8001f803,0xf807f,0xfe0ff8,0x7fff780,0x3ffe7800,0xff878000,0xe0000001,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3ff0,0xfffc0,0xffff00,0xffff800,0xe01fc000,0x7e0000,0x3f00000,0x1f000000,0xf8000000,0x80000000,0xf,0x7c,0x7c0,0x7c00,0x3c000,0x3c0000,0x3c00000,0x3c000000,0xc0000000,0x3,0x7c,0x7c0,0x7c00,0xf8000,0xf80000,0x1f000000,0xf0000000,0x3,0x7e,0xe01fc0,0xffff800,0xffff0000,0xffc00000,0xf000001f,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f00,0x1f000,0x1f0000,0x1f00000,0x1f000000,0xf0000000,0x1,0x1f,0x1f0,0x1f00,0x1f07e,0x1f1ff8,0x1f7ffe0,0x1ffffe00,0xff07f000,0xc01f8001,0xf8001f,0x7c001f8,0x7c001f00,0xc001f000,0x1f0003,0x1f0003e,0x1f0003e0,0xf0003e00,0x3e001,0x3e001f,0x1e001f0,0x3e001f00,0xe001f000,0x1f0003,0x1f0003e,0x1f0003e0,0xf0003c00,0x3c001,0x7c001f,0x7c001f0,0xf8001f80,0x8001fc00,0x1fe01f,0x1ff83f0,0x1f7ffe00,0xf3ffe000,0x1ff80001,0x7e00001f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f8,0x7ff0,0x1fff80,0x3fffc00,0x7e0fe000,0xc03f0000,0x1f00007,0xf8000f8,0x78000f00,0xc001f000,0x1e0007,0x1e0007c,0x1e0003c0,0xfffffc00,0xffffc003,0xfffc003f,0xffc003ff,0x3c003fff,0xc0000000,0x3,0x3c,0x7c0,0x7c00,0x78000,0xf80000,0x1f800000,0xf0000000,0x3,0x7e,0xe01fe0,0xffffc00,0xffff8000,0xffe00000,0xf000000f,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f8,0x1ffe0,0x1fff00,0xfff800,0xc0f8000,0x780000,0x7c00000,0x7c000000,0xc0000000,0x7,0x8000007c,0xfffff,0xfffff8,0xfffff80,0xfffff800,0x7c00000,0x7c000000,0xc0000000,0x7,0x7c,0x7c0,0x7c00,0x7c000,0x7c0000,0x7c00000,0x7c000000,0xc0000000,0x7,0x7c,0x7c0,0x7c00,0x7c000,0x7c0000,0x7c00000,0x7c000000,0xc0000000,0x7,0x7c,0x7c0,0x7c00,0x7c000,0x7c0000,0x7c00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x380fe,0x3ffff8,0x3ffffc0,0x3ffffe00,0x1f83f000,0xf01f0000,0xf80001,0x780003e,0x780003e0,0x80003c00,0x3c007,0x3c0078,0x3e00780,0x3e00f800,0xf01f0000,0x83f00001,0xfe00001f,0xc00000ff,0x7ff,0x3ff8,0xffc0,0x3e00,0xf000,0x78000,0x780000,0xf800000,0xf8000000,0x7fff,0x1fffff,0x3ffffe0,0x3ffffc00,0xe001e000,0xf0007,0x78007c,0x3c00780,0x3c007800,0xc007c000,0x7c0003,0x3e0003c,0x1f8007c0,0xfe01f800,0xffff8001,0xfff0000f,0xfc00003f,0xff,0x1ff,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7800000,0x78000000,0x80000000,0x7,0x78,0x780,0x7800,0x78000,0x780000,0x7800000,0x78000000,0x80000fc0,0x3ff87,0x7ffc78,0x7ffe780,0xfc1ff800,0x807f8000,0x3f8000f,0x1f8001f0,0xf8001f00,0x8001f000,0x1f0007,0x1e00078,0x1e000780,0xe0007800,0x78001,0x78001e,0x78001e0,0x78001e00,0x8001e000,0x1e0007,0x1e00078,0x1e000780,0xe0007800,0x78001,0x78001e,0x78001e0,0x78001e00,0x8001e000,0x1e0007,0x1e00078,0x1e000780,0xe0007800,0x78001,0x1e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0x1,0x3e,0x3e0,0x3e00,0x3e000,0x1c0000,0x0,0x0,0x0,0x0,0x0,0x0,0x3ffe,0x3ffe0,0x3ffe00,0x3ffe000,0x3e000000,0xe0000000,0x3,0x3e,0x3e0,0x3e00,0x3e000,0x3e0000,0x3e00000,0x3e000000,0xe0000000,0x3,0x3e,0x3e0,0x3e00,0x3e000,0x3e0000,0x3e00000,0x3e000000,0xe0000000,0x3,0x3e,0x3e0,0x3e00,0x3e000,0x3e0000,0x3e00000,0x3e000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0x1,0x3e,0x3e0,0x3e00,0x3e000,0x1c0000,0x0,0x0,0x0,0x0,0x0,0x0,0x3ffe,0x3ffe0,0x3ffe00,0x3ffe000,0x3e000000,0xe0000000,0x3,0x3e,0x3e0,0x3e00,0x3e000,0x3e0000,0x3e00000,0x3e000000,0xe0000000,0x3,0x3e,0x3e0,0x3e00,0x3e000,0x3e0000,0x3e00000,0x3e000000,0xe0000000,0x3,0x3e,0x3e0,0x3e00,0x3e000,0x3e0000,0x3e00000,0x3e000000,0xe0000000,0x3,0x3e,0x3e0,0x3e00,0x1e000,0x1e0000,0x1f03000,0x1fff0000,0xfff80000,0xff800000,0xe0000007,0x1f,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7800000,0x78000000,0x80000000,0x7,0x78,0x780,0x7800,0x78000,0x780000,0x7800000,0x78000000,0x80000000,0x1f0007,0xf80078,0x7c00780,0x3e007800,0xf0078000,0xc0780001,0x780000f,0x7800007e,0x800003f0,0x1f87,0x7c78,0x3e780,0x1f7800,0x3ff8000,0x3ff80000,0xff800000,0xf8000007,0x800000f9,0x1f0f,0x3f078,0x7e0780,0xfc07800,0xf8078000,0x780000,0x780001f,0x780003e0,0x80007e00,0xfc007,0x1f80078,0x3f000780,0xe0007800,0x78003,0x7c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff000000,0xf0000007,0x7f,0x7ff,0x7ff0,0x78000,0x780000,0x7800000,0x78000000,0x80000000,0x7,0x78,0x780,0x7800,0x78000,0x780000,0x7800000,0x78000000,0x80000000,0x7,0x78,0x780,0x7800,0x78000,0x780000,0x7800000,0x78000000,0x80000000,0x7,0x78,0x780,0x7800,0x78000,0x780000,0x7800000,0x78000000,0x80000000,0x7,0x78,0x780,0x7ff800,0x7ff8000,0x7ff80000,0xff800000,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe000f01e,0x1f83f9,0x3fc7fde,0x3fe7fde0,0xe7fcfe00,0x3f87e007,0xf83e007c,0x83e007c1,0x1e00781f,0xe00780f0,0x780f01,0x780f01e,0x780f01e0,0x80f01e00,0xf01e007,0xf01e0078,0x1e00780,0x1e00780f,0xe00780f0,0x780f01,0x780f01e,0x780f01e0,0x80f01e00,0xf01e007,0xf01e0078,0x1e00780,0x1e00780f,0xe00780f0,0x780f01,0x780f01e,0x780f01e0,0x80f01e00,0xf01e007,0x78,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000fc0,0x3ff87,0x7ffc78,0x7ffe780,0xfc1ff800,0x807f8000,0x3f8000f,0x1f8001f0,0xf8001f00,0x8001f000,0x1f0007,0x1e00078,0x1e000780,0xe0007800,0x78001,0x78001e,0x78001e0,0x78001e00,0x8001e000,0x1e0007,0x1e00078,0x1e000780,0xe0007800,0x78001,0x78001e,0x78001e0,0x78001e00,0x8001e000,0x1e0007,0x1e00078,0x1e000780,0xe0007800,0x78001,0x1e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fc,0xfff0,0x1fffc0,0x3fffe00,0x7f07f000,0xc01f0000,0xf8000f,0x78001f8,0x7c001f00,0xc001e000,0x3e0003,0x3e0003c,0x3c0003e0,0xc0003e00,0x3e003,0x3e003c,0x1e007c0,0x3e007c00,0xe007c000,0x3c0003,0x3c0003e,0x3c0003e0,0xe0003c00,0x7c003,0x7c003e,0xf8001e0,0xf8001f00,0x1f800,0xfc01f,0x7f07f0,0x3fffe00,0x1fffc000,0xfff00000,0xfc000000,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800007e0,0x1ffc7,0x3ffe78,0x7ffff80,0xfe0ff800,0x803f8000,0x1f8000f,0xf8001f0,0x78001f00,0x8003e000,0x3e0007,0x3c00078,0x3c000780,0xc0007800,0x78003,0x78007c,0x78007c0,0x78007c00,0x8007c000,0x3c0007,0x3c00078,0x3c000780,0xe0007800,0x78003,0xf8003e,0x1f8001e0,0xf8001f00,0x8001f803,0xf807f,0xfe0ff8,0x7fff780,0x3ffe7800,0xff878000,0xe0780001,0x7800007,0x78000000,0x80000000,0x7,0x78,0x780,0x7800,0x78000,0x780000,0x7800000,0x78000000,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7e,0x1f1ff8,0x1f7ffe0,0x1ffffe00,0xff07f000,0xc01f8001,0xf8001f,0x7c001f8,0x7c001f00,0xc001f000,0x1f0003,0x1f0003e,0x1f0003e0,0xf0003e00,0x3e001,0x3e001f,0x1e001f0,0x3e001f00,0xe001f000,0x1f0003,0x1f0003e,0x1f0003e0,0xf0003e00,0x3c001,0x7c001f,0x7c001f0,0xf8001f80,0x8001fc00,0x1fe01f,0x1ff83f0,0x1f7fff00,0xf3ffe000,0x1ff80001,0x7e00001f,0x1f0,0x1f00,0x1f000,0x1f0000,0x1f00000,0x1f000000,0xf0000000,0x1,0x1f,0x1f0,0x1f00,0x1f000,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f00,0xffc3c,0x1ffe3c0,0x1fff3c00,0xe0fbc000,0x3fc0000,0x1fc00008,0xfc000000,0xc0000000,0x7,0x3c,0x3c0,0x3c00,0x3c000,0x3c0000,0x3c00000,0x3c000000,0xc0000000,0x3,0x3c,0x3c0,0x3c00,0x3c000,0x3c0000,0x3c00000,0x3c000000,0xc0000000,0x3,0x3c,0x3c0,0x3c00,0x3c000,0x3c0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff8,0x7fff0,0x3fffc0,0x3fffe00,0x3007f000,0x1f0000,0xf00000,0xf800000,0xf8000000,0x80000000,0xf,0x1f0,0x3f00,0x1fe000,0x1ffc0000,0xff800000,0xe0000007,0x1ff,0x3fe0,0x7f000,0xfc0000,0xf800000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf800,0xfc003,0x7f00f0,0x3ffff00,0x1ffff000,0x7ffe0000,0xff000000,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1e0,0x1e00,0x1e000,0x1e0000,0x1e00000,0x1e000000,0xe0000000,0x1,0x1e,0x7ffff,0x7ffff0,0x7ffff00,0x7ffff000,0x1e00000,0x1e000000,0xe0000000,0x1,0x1e,0x1e0,0x1e00,0x1e000,0x1e0000,0x1e00000,0x1e000000,0xe0000000,0x1,0x1e,0x1e0,0x1e00,0x1e000,0x1e0000,0x1e00000,0x1e000000,0xe0000000,0x1,0x3e,0x803e0,0x1e07c00,0x1fffc000,0xfff80000,0xff000001,0xe000000f,0x1f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x1e0007,0x1e00078,0x1e000780,0xe0007800,0x78001,0x78001e,0x78001e0,0x78001e00,0x8001e000,0x1e0007,0x1e00078,0x1e000780,0xe0007800,0x78001,0x78001e,0x78001e0,0x78001e00,0x8001e000,0x1e0007,0x1e00078,0x1e000780,0xe0007800,0x78001,0x78001e,0xf8001f0,0xf8001f80,0x8001fc00,0x1fe01f,0x1ff83f0,0x1e7fff00,0xe3ffe000,0xffc0001,0x3f00001e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0x3e0003,0x3e0003e,0x1e0003c0,0xf0007c00,0x7c001,0x78000f,0xf8000f8,0xf8000f80,0x7800,0x7c00f,0x7c01f0,0x3c01e00,0x3e03e000,0xe03e0000,0x3c00001,0x7c00001e,0xc00001f0,0xf07,0xf878,0xf8f80,0x78f000,0x7cf0000,0x3df00000,0xfe000000,0xe0000003,0x3f,0x1fe,0x1fc0,0x1fc00,0xf8000,0xf80000,0xf800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0000000,0xf00000,0xf00001f,0xf00001f0,0x80001e00,0x1e00f,0x1e00f8,0x1e00780,0x1e007800,0xe0078000,0x780001,0x781f01e,0x781f83c0,0x81f83c00,0x3fc3c007,0xfc3c003c,0xe3c003c3,0x3c003c79,0xc003c79e,0x3cf1e3,0x3cf0f38,0x3df0f780,0xfe07f800,0xe07f8001,0x7f8001f,0x3f8001fc,0xf8001fc0,0x1f803,0x1f801f,0x1f801f0,0xf000f00,0xf000f000,0xf0000,0xe,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0x1e0003,0x1f0007c,0xf000f80,0x7800f800,0xc01f0000,0x3e00007,0x3e00003e,0xc00001e0,0x1f07,0xf8f8,0x78f00,0x3df000,0x3fe0000,0x1fc00000,0xfc000000,0x80000000,0xf,0x1fc,0x1fc0,0x3fe00,0x7df000,0x78f0000,0xf8f80000,0x7c00000,0x3c00001f,0xe00001e0,0x3e01,0x7c01f,0x7800f8,0xf800780,0xf0007c00,0x3e001,0x3e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0x3e0003,0x3e0003e,0x1e0003c0,0xf0007c00,0x7c001,0x78000f,0xf8000f0,0xf8000f80,0x7800,0x7c00f,0x7c01f0,0x3c01e00,0x3e01e000,0xe03e0000,0x3c00001,0x3c00001e,0xc00001f0,0xf07,0xf078,0xf8f80,0x78f000,0x78f0000,0x3df00000,0xde000000,0xe0000003,0x3f,0x1fe,0x1fc0,0x1fc00,0xfc000,0xf80000,0xf800000,0x78000000,0x80000000,0x7,0x3c,0x3c0,0x1e00,0x1f000,0xf8200,0x7fe000,0x7ff0000,0x1ff00000,0xfc000000,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0xfffff,0xfffff8,0xfffff80,0xfffff800,0xc0000000,0x7,0x3c,0x1e0,0x1f00,0xf000,0x78000,0x7c0000,0x3e00000,0x1e000000,0xf0000000,0x80000000,0xf,0x78,0x3c0,0x3e00,0x1f000,0xf0000,0x780000,0x7c00000,0x3e000000,0xe0000000,0x1,0x1f,0xfffff8,0xfffff80,0xfffff800,0xffff8000,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3e0,0x3f80,0x3fc00,0x3fe000,0x7e0000,0x1e00000,0x1e000000,0xe0000000,0x1,0x1e,0x1f0,0x1f00,0x1f000,0x1f0000,0x1f00000,0x1f000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf800,0x78000,0x3e0000,0x1f80000,0xf800000,0xf8000000,0x80000000,0x1f,0x3e0,0x7800,0xf8000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0x1f0,0x1f00,0x1f000,0x1f0000,0x1f00000,0x1f000000,0xe0000000,0x1,0x1e,0x1e0,0x1e00,0x7e000,0x3fe0000,0x3fc00000,0xf8000000,0x3,0x3e,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0xf0,0xf00,0xf000,0xf0000,0xf00000,0xf000000,0xf0000000,0x0,0xf,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7e000000,0xe0000000,0x1f,0x1fe,0x3fe0,0x3e000,0x7c0000,0x7c00000,0x78000000,0x80000000,0x7,0x78,0x780,0x7800,0x78000,0x780000,0x7800000,0x78000000,0x80000000,0x7,0x78,0xf00,0xf000,0x1f0000,0x3e00000,0xfc000000,0x1,0x1f,0x1f0,0x1fc0,0x3e00,0x1f000,0xf0000,0xf00000,0x7800000,0x78000000,0x80000000,0x7,0x78,0x780,0x7800,0x78000,0x780000,0x7800000,0x78000000,0x80000000,0x7,0x7c,0x7c0,0x3e00,0x3fe00,0x3fe000,0x1fe0000,0x7e00000,0x0,0x0,0x0,0x0,0x0},
                                         {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f000,0x1ffc000,0x7fff0180,0xfff81e00,0xf81f83f,0x380ffffe,0x807fff00,0x1ff8001,0x7c00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
                                        };

void getFont(FontProperty *pProp, int fontSize)
{
    // Add/Modify the width of new font here
    int supportedSize[] = {12,14,16,18,20,24,26,28,30,32,36};

    int minDiff = -1;
    int pos;
    int diff;
    for (long unsigned int i=0; i < sizeof(supportedSize)/sizeof(supportedSize[0]); i++)
    {
        diff = supportedSize[i]-fontSize;
        if (diff < 0)
        {
            diff = -diff;
        }
        if (minDiff < 0 || diff < minDiff)
        {
            minDiff = diff;
            pos = i;    
        }
    }

    /* Add/modify the case for your font.
     * case number depends on position in
     * supportedSize array.
     */
    switch(pos)
    {
        case 0:
            pProp->width  = 12;
            pProp->height = 18;
            pProp->addr  = font_ANDALEMO_12x18[0];
            break;
        case 1:
            pProp->width  = 14;
            pProp->height = 22;
            pProp->addr  = font_ANDALEMO_14x22[0];
            break;
        case 2:
            pProp->width  = 16;
            pProp->height = 26;
            pProp->addr  = font_ANDALEMO_16x26[0];
            break;
        case 3:
            pProp->width  = 18;
            pProp->height = 30;
            pProp->addr  = font_ANDALEMO_18x30[0];
            break;
        case 4:
            pProp->width  = 20;
            pProp->height = 36;
            pProp->addr  = font_ANDALEMO_20x36[0];
            break;
        case 5:
            pProp->width  = 24;
            pProp->height = 40;
            pProp->addr  = font_ANDALEMO_24x40[0];
            break;
        case 6:
            pProp->width  = 26;
            pProp->height = 44;
            pProp->addr  = font_ANDALEMO_26x44[0];
            break;
        case 7:
            pProp->width  = 28;
            pProp->height = 50;
            pProp->addr  = font_ANDALEMO_28x50[0];
            break;
        case 8:
            pProp->width  = 30;
            pProp->height = 54;
            pProp->addr  = font_ANDALEMO_30x54[0];
            break;
        case 9:
            pProp->width  = 32;
            pProp->height = 56;
            pProp->addr  = font_ANDALEMO_32x56[0];
            break;
        case 10:
            pProp->width  = 36;
            pProp->height = 64;
            pProp->addr  = font_ANDALEMO_36x64[0];
            break;
        default:
            break;
    }
}
