/*
 *
 * Copyright (c) 2019 Texas Instruments Incorporated
 *
 * All rights reserved not granted herein.
 *
 * Limited License.
 *
 * Texas Instruments Incorporated grants a world-wide, royalty-free, non-exclusive
 * license under copyrights and patents it now or hereafter owns or controls to make,
 * have made, use, import, offer to sell and sell ("Utilize") this software subject to the
 * terms herein.  With respect to the foregoing patent license, such license is granted
 * solely to the extent that any such patent is necessary to Utilize the software alone.
 * The patent license shall not apply to any combinations which include this software,
 * other than combinations with devices manufactured by or for TI ("TI Devices").
 * No hardware patent is licensed hereunder.
 *
 * Redistributions must preserve existing copyright notices and reproduce this license
 * (including the above copyright notice and the disclaimer and (if applicable) source
 * code license limitations below) in the documentation and/or other materials provided
 * with the distribution
 *
 * Redistribution and use in binary form, without modification, are permitted provided
 * that the following conditions are met:
 *
 * *       No reverse engineering, decompilation, or disassembly of this software is
 * permitted with respect to any software provided in binary form.
 *
 * *       any redistribution and use are licensed by TI for use only with TI Devices.
 *
 * *       Nothing shall obligate TI to provide you with source code for the software
 * licensed and provided to you in object code.
 *
 * If software source code is provided to you, modification and redistribution of the
 * source code are permitted provided that the following conditions are met:
 *
 * *       any redistribution and use of the source code, including any resulting derivative
 * works, are licensed by TI for use only with TI Devices.
 *
 * *       any redistribution and use of any object code compiled from the source code
 * and any resulting derivative works, are licensed by TI for use only with TI Devices.
 *
 * Neither the name of Texas Instruments Incorporated nor the names of its suppliers
 *
 * may be used to endorse or promote products derived from this software without
 * specific prior written permission.
 *
 * DISCLAIMER.
 *
 * THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
#ifndef _OBSTACLE_FROM_DISPARITY_H
#define _OBSTACLE_FROM_DISPARITY_H

#include <perception/perception.h>
#include "perception/algos/stereo/object_detection/stereo_object_detect.h"



/**
 * \brief Main function for obstacle detection
 *
 * \param [in]  cntxt              algorithm handle
 * \param [out] oda                array of detected obstacels
 *
 * \ingroup group_ptk_algos_stereo_od
 */
int32_t PTK_Alg_StereoAlgo_findObstacleFromDisparity(PTK_Alg_StereoAlgo_ObjectDetectObj * cntxt,
                                                     PTK_Alg_StereoAlgo_obsDetectionArray * oda);

/**
 * \brief Find closed dispairty for obstacles
 * 
 * \param [in]  cntxt              algorithm handle
 *
 * \ingroup group_ptk_algos_stereo_od
 */
void    PTK_Alg_StereoAlgo_findClosestDisparity(PTK_Alg_StereoAlgo_ObjectDetectObj * cntxt);


/**
 * \brief Create final bounding boxes for detected obstacles
 *
 * \param [in]  cntxt              algorithm handle
 * \param [out] oda                array of detected obstacels
 *
 * \ingroup group_ptk_algos_stereo_od
 */
void    PTK_Alg_StereoAlgo_detectObstacle(PTK_Alg_StereoAlgo_ObjectDetectObj * cntxt,
                                          PTK_Alg_StereoAlgo_obsDetectionArray * oda);


/**
 * \brief Update a line model with offset and dx
 *
 * \param [in] offset             slope of V-disparity ground model
 * \param [in] dx                 offset of V-disparity ground model
 *
 * \return 
 *        line model
 *
 * \ingroup group_ptk_algos_stereo_od
 */
PTK_Alg_StereoAlgo_lineModel    PTK_Alg_StereoAlgo_getlineModel(float offset, float dx);


/**
 * \brief Compute drivable distance in front of a camera
 *
 * \param [in]  cntxt            algorithm handle
 *
 * \return
 *        drivable distance in front of a camera
 *
 * \ingroup group_ptk_algos_stereo_od
 */
int32_t PTK_Alg_StereoAlgo_searchFreeDriveDistance(PTK_Alg_StereoAlgo_ObjectDetectObj * cntxt);


/**
 * \brief Find free space for every column
 *
 * \param [in]  cntxt            algorithm handle
 *
 * \ingroup group_ptk_algos_stereo_od
 */
void    PTK_Alg_StereoAlgo_searchFreeSpace(PTK_Alg_StereoAlgo_ObjectDetectObj * cntxt, int32_t horizon);

#endif // #ifndef _OBSTACLE_FROM_DISPARITY_H
