/*
* The MIT License (MIT)
*
* Copyright (C) 2024 Define Design Deploy Corp.
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the “Software”), to deal in
* the Software without restriction, including without limitation the rights to use,
* copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
* Software, and to permit persons to whom the Software is furnished to do so,
* subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND,
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
* OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
* HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
* WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 *  \file dcc_viss_imx390_discovery_wide_wdr_dcc.h
 *
 *  \brief Sensor DCC Cfg file.
 *
 */

#ifndef DCC_VISS_IMX390_DISCOVERY_WIDE_WDR_DCC_H_
#define DCC_VISS_IMX390_DISCOVERY_WIDE_WDR_DCC_H_

#define DCC_VISS_IMX390_DISCOVERY_WIDE_WDR_DCC_CFG_NUM_ELEM       (34819u)

#define DCC_VISS_IMX390_DISCOVERY_WIDE_WDRDCC_CFG \
    { \
0x86,0x01,0x00,0x00,0x09,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x23,0x8e,0x35,0x31,0x6d,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xdc,0x25,0x00,0x00,0x64,0x26,0x00,0x00,\
0x01,0x00,0x00,0x00,0xff,0x03,0x00,0x00,0x60,0x00,0x00,0x00,0x04,0x26,0x00,0x00,\
0x02,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x80,0x84,0x1e,0x00,0xa0,0x86,0x01,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0xaf,0x00,0x00,0x00,0x5f,0x00,0x00,0x00,0x5f,0x00,0x00,0x00,0xaf,0x00,0x00,0x00,\
0xaf,0x00,0x00,0x00,0x5f,0x00,0x00,0x00,0x5f,0x00,0x00,0x00,0xaf,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x03,0x00,0x00,0x00,\
0x04,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x07,0x00,0x00,0x00,\
0xf4,0x01,0x00,0x00,0x58,0x02,0x00,0x00,0xbc,0x02,0x00,0x00,0x20,0x03,0x00,0x00,\
0x84,0x03,0x00,0x00,0xe8,0x03,0x00,0x00,0x4c,0x04,0x00,0x00,0xaf,0x00,0x00,0x00,\
0x5f,0x00,0x00,0x00,0x5f,0x00,0x00,0x00,0xaf,0x00,0x00,0x00,0x14,0x01,0x00,0x00,\
0xc4,0x00,0x00,0x00,0xc4,0x00,0x00,0x00,0x14,0x01,0x00,0x00,0x08,0x00,0x00,0x00,\
0x09,0x00,0x00,0x00,0x0a,0x00,0x00,0x00,0x0b,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,\
0x0d,0x00,0x00,0x00,0x0e,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x64,0x00,0x00,0x00,0xc8,0x00,0x00,0x00,0x2c,0x01,0x00,0x00,0x90,0x01,0x00,0x00,\
0xf4,0x01,0x00,0x00,0x58,0x02,0x00,0x00,0x02,0x00,0x00,0x00,0x02,0x00,0x00,0x00,\
0x02,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x03,0x00,0x00,0x00,\
0xe9,0xff,0xff,0xff,0x12,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,\
0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0xf7,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x06,0x00,0x00,0x00,\
0xdf,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,\
0xfd,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,\
0x27,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0x06,0x00,0x00,0x00,0x05,0x00,0x00,0x00,\
0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,\
0x12,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,0x27,0x00,0x00,0x00,\
0x20,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,0x05,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0xcf,0xff,0xff,0xff,0x27,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xfc,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0x27,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,\
0x06,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xe9,0xff,0xff,0xff,0x06,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,0x20,0x00,0x00,0x00,\
0x27,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xcf,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x02,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x12,0x00,0x00,0x00,\
0xfc,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,\
0x05,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0x27,0x00,0x00,0x00,\
0xf7,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,\
0xfd,0xff,0xff,0xff,0x27,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,\
0xfe,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,0x12,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,\
0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x05,0x00,0x00,0x00,\
0xe9,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,\
0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xf7,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0xcf,0xff,0xff,0xff,\
0xdf,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0x12,0x00,0x00,0x00,\
0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xcf,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,\
0x27,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x03,0x00,0x00,0x00,\
0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,\
0xfd,0xff,0xff,0xff,0xe9,0xff,0xff,0xff,0x05,0x00,0x00,0x00,0x02,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x27,0x00,0x00,0x00,\
0x20,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0xe9,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0xfd,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xfc,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0x27,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0xe9,0xff,0xff,0xff,0xcf,0xff,0xff,0xff,0xdf,0x00,0x00,0x00,0x20,0x00,0x00,0x00,\
0x27,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x02,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,\
0xfc,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,\
0x03,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x27,0x00,0x00,0x00,\
0xf7,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,\
0x12,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,\
0xcf,0xff,0xff,0xff,0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,\
0xfe,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xe9,0xff,0xff,0xff,\
0x05,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0xdf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x27,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x27,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,\
0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe2,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0xfb,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x19,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x8f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf1,0xff,0xff,0xff,\
0xf1,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x8f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x19,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfb,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0xe2,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,\
0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xfb,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xe2,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0xf1,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x8f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x19,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x19,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8f,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xf1,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xe2,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xfb,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xfb,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xe2,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0xf1,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x8f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x19,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x19,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8f,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xf1,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xe2,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xfb,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,\
0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe2,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0xfb,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x19,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x8f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf1,0xff,0xff,0xff,\
0xf1,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x8f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x19,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfb,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0xe2,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,\
0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xf1,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,\
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x19,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xfb,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe2,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x8f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xe2,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfb,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x19,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xf1,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0xf1,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xfb,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x19,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x8f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe2,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xe2,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x8f,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x19,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfb,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf1,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0xf1,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xfb,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x19,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x8f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe2,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xe2,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x8f,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x19,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfb,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf1,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xf1,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,\
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x19,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xfb,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe2,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x8f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xe2,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfb,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x19,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xf1,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xf9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x86,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf9,0xff,0xff,0xff,\
0xf9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x86,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xf9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0xf9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x86,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x86,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xf9,0xff,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf9,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xf9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0xf9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x86,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x86,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xf9,0xff,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf9,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xf9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x86,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf9,0xff,0xff,0xff,\
0xf9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x86,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,\
0x05,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0x27,0x00,0x00,0x00,\
0xf7,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,\
0xfd,0xff,0xff,0xff,0x27,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,\
0xfe,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,0x12,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,\
0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xfc,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0x27,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,\
0x06,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xe9,0xff,0xff,0xff,0x06,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,0x20,0x00,0x00,0x00,\
0x27,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xcf,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x02,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x12,0x00,0x00,0x00,\
0xfc,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,\
0x12,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,0x27,0x00,0x00,0x00,\
0x20,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,0x05,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0xcf,0xff,0xff,0xff,0x27,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0x02,0x00,0x00,0x00,0x03,0x00,0x00,0x00,\
0xe9,0xff,0xff,0xff,0x12,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,\
0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0xf7,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x06,0x00,0x00,0x00,\
0xdf,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,\
0xfd,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,\
0x27,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0x06,0x00,0x00,0x00,0x05,0x00,0x00,0x00,\
0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,\
0x03,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x27,0x00,0x00,0x00,\
0xf7,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,\
0x12,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,\
0xcf,0xff,0xff,0xff,0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,\
0xfe,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xe9,0xff,0xff,0xff,\
0x05,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0xfd,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xfc,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0x27,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0xe9,0xff,0xff,0xff,0xcf,0xff,0xff,0xff,0xdf,0x00,0x00,0x00,0x20,0x00,0x00,0x00,\
0x27,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x02,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,\
0xfc,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,\
0xfd,0xff,0xff,0xff,0xe9,0xff,0xff,0xff,0x05,0x00,0x00,0x00,0x02,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x27,0x00,0x00,0x00,\
0x20,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0xe9,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0x02,0x00,0x00,0x00,0x05,0x00,0x00,0x00,\
0xe9,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,\
0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xf7,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0xcf,0xff,0xff,0xff,\
0xdf,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0x12,0x00,0x00,0x00,\
0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xcf,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,\
0x27,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x03,0x00,0x00,0x00,\
0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x27,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x27,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0xdf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x03,0x00,0x00,0x00,\
0xe9,0xff,0xff,0xff,0x12,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,\
0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0xf7,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x06,0x00,0x00,0x00,\
0xdf,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,\
0xfd,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,\
0x27,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0x06,0x00,0x00,0x00,0x05,0x00,0x00,0x00,\
0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,\
0x12,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,0x27,0x00,0x00,0x00,\
0x20,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,0x05,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0xcf,0xff,0xff,0xff,0x27,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xfc,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0x27,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,\
0x06,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xe9,0xff,0xff,0xff,0x06,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,0x20,0x00,0x00,0x00,\
0x27,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xcf,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x02,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x12,0x00,0x00,0x00,\
0xfc,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,\
0x05,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0x27,0x00,0x00,0x00,\
0xf7,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,\
0xfd,0xff,0xff,0xff,0x27,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,\
0xfe,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,0x12,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,\
0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x05,0x00,0x00,0x00,\
0xe9,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,\
0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xf7,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0xcf,0xff,0xff,0xff,\
0xdf,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0x12,0x00,0x00,0x00,\
0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xcf,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,\
0x27,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x03,0x00,0x00,0x00,\
0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,\
0xfd,0xff,0xff,0xff,0xe9,0xff,0xff,0xff,0x05,0x00,0x00,0x00,0x02,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x27,0x00,0x00,0x00,\
0x20,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0xe9,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0xfd,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xfc,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0x27,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0xe9,0xff,0xff,0xff,0xcf,0xff,0xff,0xff,0xdf,0x00,0x00,0x00,0x20,0x00,0x00,0x00,\
0x27,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x02,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,\
0xfc,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xfd,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,\
0x03,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x27,0x00,0x00,0x00,\
0xf7,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,\
0x12,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,\
0xcf,0xff,0xff,0xff,0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,\
0xfe,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xe9,0xff,0xff,0xff,\
0x05,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0xdf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x27,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,\
0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x27,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xdf,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xe9,0xff,0xff,0xff,\
0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0x02,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x02,0x00,0x00,0x00,\
0x03,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x04,0x00,0x00,0x00,\
0x04,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x05,0x00,0x00,0x00,\
0x06,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x07,0x00,0x00,0x00,\
0x08,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x09,0x00,0x00,0x00,\
0x09,0x00,0x00,0x00,0x0a,0x00,0x00,0x00,0x0a,0x00,0x00,0x00,0x0b,0x00,0x00,0x00,\
0x0b,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x0d,0x00,0x00,0x00,\
0x0d,0x00,0x00,0x00,0x0e,0x00,0x00,0x00,0x0e,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,\
0x0f,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x11,0x00,0x00,0x00,\
0x12,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x13,0x00,0x00,0x00,0x13,0x00,0x00,0x00,\
0x14,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x15,0x00,0x00,0x00,0x16,0x00,0x00,0x00,\
0x16,0x00,0x00,0x00,0x17,0x00,0x00,0x00,0x17,0x00,0x00,0x00,0x18,0x00,0x00,0x00,\
0x19,0x00,0x00,0x00,0x19,0x00,0x00,0x00,0x1a,0x00,0x00,0x00,0x1b,0x00,0x00,0x00,\
0x1b,0x00,0x00,0x00,0x1c,0x00,0x00,0x00,0x1c,0x00,0x00,0x00,0x1d,0x00,0x00,0x00,\
0x1e,0x00,0x00,0x00,0x1e,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x20,0x00,0x00,0x00,\
0x20,0x00,0x00,0x00,0x21,0x00,0x00,0x00,0x22,0x00,0x00,0x00,0x22,0x00,0x00,0x00,\
0x23,0x00,0x00,0x00,0x24,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x25,0x00,0x00,0x00,\
0x26,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0x28,0x00,0x00,0x00,\
0x29,0x00,0x00,0x00,0x2a,0x00,0x00,0x00,0x2a,0x00,0x00,0x00,0x2b,0x00,0x00,0x00,\
0x2c,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x2d,0x00,0x00,0x00,0x2e,0x00,0x00,0x00,\
0x2f,0x00,0x00,0x00,0x2f,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x31,0x00,0x00,0x00,\
0x32,0x00,0x00,0x00,0x32,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x34,0x00,0x00,0x00,\
0x35,0x00,0x00,0x00,0x36,0x00,0x00,0x00,0x36,0x00,0x00,0x00,0x37,0x00,0x00,0x00,\
0x38,0x00,0x00,0x00,0x39,0x00,0x00,0x00,0x39,0x00,0x00,0x00,0x3a,0x00,0x00,0x00,\
0x3b,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x3d,0x00,0x00,0x00,0x3e,0x00,0x00,0x00,\
0x3e,0x00,0x00,0x00,0x3f,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x41,0x00,0x00,0x00,\
0x42,0x00,0x00,0x00,0x42,0x00,0x00,0x00,0x43,0x00,0x00,0x00,0x44,0x00,0x00,0x00,\
0x45,0x00,0x00,0x00,0x46,0x00,0x00,0x00,0x47,0x00,0x00,0x00,0x47,0x00,0x00,0x00,\
0x48,0x00,0x00,0x00,0x49,0x00,0x00,0x00,0x4a,0x00,0x00,0x00,0x4b,0x00,0x00,0x00,\
0x4c,0x00,0x00,0x00,0x4d,0x00,0x00,0x00,0x4d,0x00,0x00,0x00,0x51,0x00,0x00,0x00,\
0x55,0x00,0x00,0x00,0x58,0x00,0x00,0x00,0x5c,0x00,0x00,0x00,0x5f,0x00,0x00,0x00,\
0x63,0x00,0x00,0x00,0x67,0x00,0x00,0x00,0x6b,0x00,0x00,0x00,0x6f,0x00,0x00,0x00,\
0x73,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x7a,0x00,0x00,0x00,0x7e,0x00,0x00,0x00,\
0x82,0x00,0x00,0x00,0x87,0x00,0x00,0x00,0x8b,0x00,0x00,0x00,0x8f,0x00,0x00,0x00,\
0x93,0x00,0x00,0x00,0x97,0x00,0x00,0x00,0x9c,0x00,0x00,0x00,0xa0,0x00,0x00,0x00,\
0xa4,0x00,0x00,0x00,0xa9,0x00,0x00,0x00,0xad,0x00,0x00,0x00,0xb1,0x00,0x00,0x00,\
0xb6,0x00,0x00,0x00,0xba,0x00,0x00,0x00,0xbf,0x00,0x00,0x00,0xc4,0x00,0x00,0x00,\
0xc8,0x00,0x00,0x00,0xcd,0x00,0x00,0x00,0xd1,0x00,0x00,0x00,0xd6,0x00,0x00,0x00,\
0xdb,0x00,0x00,0x00,0xe0,0x00,0x00,0x00,0xe4,0x00,0x00,0x00,0xe9,0x00,0x00,0x00,\
0xee,0x00,0x00,0x00,0xf3,0x00,0x00,0x00,0xf8,0x00,0x00,0x00,0xfd,0x00,0x00,0x00,\
0x02,0x01,0x00,0x00,0x07,0x01,0x00,0x00,0x0c,0x01,0x00,0x00,0x11,0x01,0x00,0x00,\
0x16,0x01,0x00,0x00,0x1b,0x01,0x00,0x00,0x20,0x01,0x00,0x00,0x25,0x01,0x00,0x00,\
0x2b,0x01,0x00,0x00,0x30,0x01,0x00,0x00,0x35,0x01,0x00,0x00,0x3a,0x01,0x00,0x00,\
0x40,0x01,0x00,0x00,0x45,0x01,0x00,0x00,0x4a,0x01,0x00,0x00,0x50,0x01,0x00,0x00,\
0x55,0x01,0x00,0x00,0x5b,0x01,0x00,0x00,0x60,0x01,0x00,0x00,0x66,0x01,0x00,0x00,\
0x6b,0x01,0x00,0x00,0x71,0x01,0x00,0x00,0x76,0x01,0x00,0x00,0x7c,0x01,0x00,0x00,\
0x81,0x01,0x00,0x00,0x87,0x01,0x00,0x00,0x8d,0x01,0x00,0x00,0x92,0x01,0x00,0x00,\
0x98,0x01,0x00,0x00,0x9e,0x01,0x00,0x00,0xa4,0x01,0x00,0x00,0xa9,0x01,0x00,0x00,\
0xaf,0x01,0x00,0x00,0xb5,0x01,0x00,0x00,0xbb,0x01,0x00,0x00,0xc1,0x01,0x00,0x00,\
0xc7,0x01,0x00,0x00,0xcd,0x01,0x00,0x00,0xd3,0x01,0x00,0x00,0xd8,0x01,0x00,0x00,\
0xde,0x01,0x00,0x00,0xe4,0x01,0x00,0x00,0xeb,0x01,0x00,0x00,0xf1,0x01,0x00,0x00,\
0xf7,0x01,0x00,0x00,0xfd,0x01,0x00,0x00,0x03,0x02,0x00,0x00,0x09,0x02,0x00,0x00,\
0x0f,0x02,0x00,0x00,0x15,0x02,0x00,0x00,0x1c,0x02,0x00,0x00,0x22,0x02,0x00,0x00,\
0x28,0x02,0x00,0x00,0x2e,0x02,0x00,0x00,0x35,0x02,0x00,0x00,0x3b,0x02,0x00,0x00,\
0x41,0x02,0x00,0x00,0x48,0x02,0x00,0x00,0x4e,0x02,0x00,0x00,0x54,0x02,0x00,0x00,\
0x5b,0x02,0x00,0x00,0x61,0x02,0x00,0x00,0x68,0x02,0x00,0x00,0x6e,0x02,0x00,0x00,\
0x75,0x02,0x00,0x00,0x7b,0x02,0x00,0x00,0x82,0x02,0x00,0x00,0x88,0x02,0x00,0x00,\
0x8f,0x02,0x00,0x00,0x96,0x02,0x00,0x00,0x9c,0x02,0x00,0x00,0xa3,0x02,0x00,0x00,\
0xaa,0x02,0x00,0x00,0xb0,0x02,0x00,0x00,0xb7,0x02,0x00,0x00,0xbe,0x02,0x00,0x00,\
0xc4,0x02,0x00,0x00,0xcb,0x02,0x00,0x00,0xd2,0x02,0x00,0x00,0xd9,0x02,0x00,0x00,\
0xe0,0x02,0x00,0x00,0xe6,0x02,0x00,0x00,0xed,0x02,0x00,0x00,0xf4,0x02,0x00,0x00,\
0xfb,0x02,0x00,0x00,0x02,0x03,0x00,0x00,0x09,0x03,0x00,0x00,0x10,0x03,0x00,0x00,\
0x17,0x03,0x00,0x00,0x1e,0x03,0x00,0x00,0x25,0x03,0x00,0x00,0x2c,0x03,0x00,0x00,\
0x33,0x03,0x00,0x00,0x3a,0x03,0x00,0x00,0x41,0x03,0x00,0x00,0x48,0x03,0x00,0x00,\
0x4f,0x03,0x00,0x00,0x56,0x03,0x00,0x00,0x5d,0x03,0x00,0x00,0x65,0x03,0x00,0x00,\
0x6c,0x03,0x00,0x00,0x73,0x03,0x00,0x00,0x7a,0x03,0x00,0x00,0x81,0x03,0x00,0x00,\
0x89,0x03,0x00,0x00,0x90,0x03,0x00,0x00,0x97,0x03,0x00,0x00,0x9f,0x03,0x00,0x00,\
0xa6,0x03,0x00,0x00,0xad,0x03,0x00,0x00,0xb5,0x03,0x00,0x00,0xbc,0x03,0x00,0x00,\
0xc3,0x03,0x00,0x00,0xcb,0x03,0x00,0x00,0xd2,0x03,0x00,0x00,0xda,0x03,0x00,0x00,\
0xe1,0x03,0x00,0x00,0xe9,0x03,0x00,0x00,0xf0,0x03,0x00,0x00,0xf8,0x03,0x00,0x00,\
0xff,0x03,0x00,0x00,0x07,0x04,0x00,0x00,0x0e,0x04,0x00,0x00,0x16,0x04,0x00,0x00,\
0x1d,0x04,0x00,0x00,0x25,0x04,0x00,0x00,0x2d,0x04,0x00,0x00,0x34,0x04,0x00,0x00,\
0x3c,0x04,0x00,0x00,0x44,0x04,0x00,0x00,0x4b,0x04,0x00,0x00,0x53,0x04,0x00,0x00,\
0x5b,0x04,0x00,0x00,0x63,0x04,0x00,0x00,0x6a,0x04,0x00,0x00,0x72,0x04,0x00,0x00,\
0x7a,0x04,0x00,0x00,0x82,0x04,0x00,0x00,0x89,0x04,0x00,0x00,0x91,0x04,0x00,0x00,\
0x99,0x04,0x00,0x00,0xa1,0x04,0x00,0x00,0xa9,0x04,0x00,0x00,0xb1,0x04,0x00,0x00,\
0xb9,0x04,0x00,0x00,0xc1,0x04,0x00,0x00,0xc9,0x04,0x00,0x00,0xd1,0x04,0x00,0x00,\
0xd9,0x04,0x00,0x00,0xe1,0x04,0x00,0x00,0xe9,0x04,0x00,0x00,0xf1,0x04,0x00,0x00,\
0xf9,0x04,0x00,0x00,0x01,0x05,0x00,0x00,0x09,0x05,0x00,0x00,0x11,0x05,0x00,0x00,\
0x19,0x05,0x00,0x00,0x21,0x05,0x00,0x00,0x29,0x05,0x00,0x00,0x31,0x05,0x00,0x00,\
0x3a,0x05,0x00,0x00,0x42,0x05,0x00,0x00,0x4a,0x05,0x00,0x00,0x52,0x05,0x00,0x00,\
0x5a,0x05,0x00,0x00,0x63,0x05,0x00,0x00,0x6b,0x05,0x00,0x00,0x73,0x05,0x00,0x00,\
0x7b,0x05,0x00,0x00,0x84,0x05,0x00,0x00,0x8c,0x05,0x00,0x00,0x94,0x05,0x00,0x00,\
0x9d,0x05,0x00,0x00,0xa5,0x05,0x00,0x00,0xad,0x05,0x00,0x00,0xb6,0x05,0x00,0x00,\
0xbe,0x05,0x00,0x00,0xc7,0x05,0x00,0x00,0xcf,0x05,0x00,0x00,0xd7,0x05,0x00,0x00,\
0xe0,0x05,0x00,0x00,0xe8,0x05,0x00,0x00,0xf1,0x05,0x00,0x00,0xf9,0x05,0x00,0x00,\
0x02,0x06,0x00,0x00,0x0a,0x06,0x00,0x00,0x13,0x06,0x00,0x00,0x1b,0x06,0x00,0x00,\
0x24,0x06,0x00,0x00,0x2d,0x06,0x00,0x00,0x35,0x06,0x00,0x00,0x3e,0x06,0x00,0x00,\
0x46,0x06,0x00,0x00,0x4f,0x06,0x00,0x00,0x58,0x06,0x00,0x00,0x60,0x06,0x00,0x00,\
0x69,0x06,0x00,0x00,0x72,0x06,0x00,0x00,0x7a,0x06,0x00,0x00,0x83,0x06,0x00,0x00,\
0x8c,0x06,0x00,0x00,0x95,0x06,0x00,0x00,0x9d,0x06,0x00,0x00,0xa6,0x06,0x00,0x00,\
0xaf,0x06,0x00,0x00,0xb8,0x06,0x00,0x00,0xc1,0x06,0x00,0x00,0xc9,0x06,0x00,0x00,\
0xd2,0x06,0x00,0x00,0xdb,0x06,0x00,0x00,0xe4,0x06,0x00,0x00,0xed,0x06,0x00,0x00,\
0xf6,0x06,0x00,0x00,0xff,0x06,0x00,0x00,0x08,0x07,0x00,0x00,0x10,0x07,0x00,0x00,\
0x19,0x07,0x00,0x00,0x22,0x07,0x00,0x00,0x2b,0x07,0x00,0x00,0x34,0x07,0x00,0x00,\
0x3d,0x07,0x00,0x00,0x46,0x07,0x00,0x00,0x4f,0x07,0x00,0x00,0x58,0x07,0x00,0x00,\
0x62,0x07,0x00,0x00,0x6b,0x07,0x00,0x00,0x74,0x07,0x00,0x00,0x7d,0x07,0x00,0x00,\
0x86,0x07,0x00,0x00,0x8f,0x07,0x00,0x00,0x98,0x07,0x00,0x00,0xa1,0x07,0x00,0x00,\
0xaa,0x07,0x00,0x00,0xb4,0x07,0x00,0x00,0xbd,0x07,0x00,0x00,0xc6,0x07,0x00,0x00,\
0xcf,0x07,0x00,0x00,0xd8,0x07,0x00,0x00,0xe2,0x07,0x00,0x00,0xeb,0x07,0x00,0x00,\
0xf4,0x07,0x00,0x00,0xfd,0x07,0x00,0x00,0x07,0x08,0x00,0x00,0x10,0x08,0x00,0x00,\
0x19,0x08,0x00,0x00,0x23,0x08,0x00,0x00,0x2c,0x08,0x00,0x00,0x35,0x08,0x00,0x00,\
0x3f,0x08,0x00,0x00,0x48,0x08,0x00,0x00,0x51,0x08,0x00,0x00,0x5b,0x08,0x00,0x00,\
0x64,0x08,0x00,0x00,0x6e,0x08,0x00,0x00,0x77,0x08,0x00,0x00,0x81,0x08,0x00,0x00,\
0x8a,0x08,0x00,0x00,0x93,0x08,0x00,0x00,0x9d,0x08,0x00,0x00,0xa6,0x08,0x00,0x00,\
0xb0,0x08,0x00,0x00,0xb9,0x08,0x00,0x00,0xc3,0x08,0x00,0x00,0xcd,0x08,0x00,0x00,\
0xd6,0x08,0x00,0x00,0xe0,0x08,0x00,0x00,0xe9,0x08,0x00,0x00,0xf3,0x08,0x00,0x00,\
0xfc,0x08,0x00,0x00,0x06,0x09,0x00,0x00,0x10,0x09,0x00,0x00,0x19,0x09,0x00,0x00,\
0x23,0x09,0x00,0x00,0x2d,0x09,0x00,0x00,0x36,0x09,0x00,0x00,0x40,0x09,0x00,0x00,\
0x4a,0x09,0x00,0x00,0x53,0x09,0x00,0x00,0x5d,0x09,0x00,0x00,0x67,0x09,0x00,0x00,\
0x71,0x09,0x00,0x00,0x7a,0x09,0x00,0x00,0x84,0x09,0x00,0x00,0x8e,0x09,0x00,0x00,\
0x98,0x09,0x00,0x00,0xa2,0x09,0x00,0x00,0xab,0x09,0x00,0x00,0xb5,0x09,0x00,0x00,\
0xbf,0x09,0x00,0x00,0xc9,0x09,0x00,0x00,0xd3,0x09,0x00,0x00,0xdd,0x09,0x00,0x00,\
0xe7,0x09,0x00,0x00,0xf0,0x09,0x00,0x00,0xfa,0x09,0x00,0x00,0x04,0x0a,0x00,0x00,\
0x0e,0x0a,0x00,0x00,0x18,0x0a,0x00,0x00,0x22,0x0a,0x00,0x00,0x2c,0x0a,0x00,0x00,\
0x36,0x0a,0x00,0x00,0x40,0x0a,0x00,0x00,0x4a,0x0a,0x00,0x00,0x54,0x0a,0x00,0x00,\
0x5e,0x0a,0x00,0x00,0x68,0x0a,0x00,0x00,0x72,0x0a,0x00,0x00,0x7c,0x0a,0x00,0x00,\
0x86,0x0a,0x00,0x00,0x90,0x0a,0x00,0x00,0x9b,0x0a,0x00,0x00,0xa5,0x0a,0x00,0x00,\
0xaf,0x0a,0x00,0x00,0xb9,0x0a,0x00,0x00,0xc3,0x0a,0x00,0x00,0xcd,0x0a,0x00,0x00,\
0xd7,0x0a,0x00,0x00,0xe1,0x0a,0x00,0x00,0xec,0x0a,0x00,0x00,0xf6,0x0a,0x00,0x00,\
0x00,0x0b,0x00,0x00,0x0a,0x0b,0x00,0x00,0x15,0x0b,0x00,0x00,0x1f,0x0b,0x00,0x00,\
0x29,0x0b,0x00,0x00,0x33,0x0b,0x00,0x00,0x3e,0x0b,0x00,0x00,0x48,0x0b,0x00,0x00,\
0x52,0x0b,0x00,0x00,0x5c,0x0b,0x00,0x00,0x67,0x0b,0x00,0x00,0x71,0x0b,0x00,0x00,\
0x7b,0x0b,0x00,0x00,0x86,0x0b,0x00,0x00,0x90,0x0b,0x00,0x00,0x9a,0x0b,0x00,0x00,\
0xa5,0x0b,0x00,0x00,0xaf,0x0b,0x00,0x00,0xba,0x0b,0x00,0x00,0xc4,0x0b,0x00,0x00,\
0xcf,0x0b,0x00,0x00,0xd9,0x0b,0x00,0x00,0xe3,0x0b,0x00,0x00,0xee,0x0b,0x00,0x00,\
0xf8,0x0b,0x00,0x00,0x03,0x0c,0x00,0x00,0x0d,0x0c,0x00,0x00,0x18,0x0c,0x00,0x00,\
0x22,0x0c,0x00,0x00,0x2d,0x0c,0x00,0x00,0x37,0x0c,0x00,0x00,0x42,0x0c,0x00,0x00,\
0x4c,0x0c,0x00,0x00,0x57,0x0c,0x00,0x00,0x62,0x0c,0x00,0x00,0x6c,0x0c,0x00,0x00,\
0x77,0x0c,0x00,0x00,0x81,0x0c,0x00,0x00,0x8c,0x0c,0x00,0x00,0x97,0x0c,0x00,0x00,\
0xa1,0x0c,0x00,0x00,0xac,0x0c,0x00,0x00,0xb7,0x0c,0x00,0x00,0xc1,0x0c,0x00,0x00,\
0xcc,0x0c,0x00,0x00,0xd7,0x0c,0x00,0x00,0xe1,0x0c,0x00,0x00,0xec,0x0c,0x00,0x00,\
0xf7,0x0c,0x00,0x00,0x02,0x0d,0x00,0x00,0x0c,0x0d,0x00,0x00,0x17,0x0d,0x00,0x00,\
0x22,0x0d,0x00,0x00,0x2d,0x0d,0x00,0x00,0x37,0x0d,0x00,0x00,0x42,0x0d,0x00,0x00,\
0x4d,0x0d,0x00,0x00,0x58,0x0d,0x00,0x00,0x63,0x0d,0x00,0x00,0x6d,0x0d,0x00,0x00,\
0x78,0x0d,0x00,0x00,0x83,0x0d,0x00,0x00,0x8e,0x0d,0x00,0x00,0x99,0x0d,0x00,0x00,\
0xa4,0x0d,0x00,0x00,0xaf,0x0d,0x00,0x00,0xba,0x0d,0x00,0x00,0xc4,0x0d,0x00,0x00,\
0xcf,0x0d,0x00,0x00,0xda,0x0d,0x00,0x00,0xe5,0x0d,0x00,0x00,0xf0,0x0d,0x00,0x00,\
0xfb,0x0d,0x00,0x00,0x06,0x0e,0x00,0x00,0x11,0x0e,0x00,0x00,0x1c,0x0e,0x00,0x00,\
0x27,0x0e,0x00,0x00,0x32,0x0e,0x00,0x00,0x3d,0x0e,0x00,0x00,0x48,0x0e,0x00,0x00,\
0x53,0x0e,0x00,0x00,0x5e,0x0e,0x00,0x00,0x69,0x0e,0x00,0x00,0x75,0x0e,0x00,0x00,\
0x80,0x0e,0x00,0x00,0x8b,0x0e,0x00,0x00,0x96,0x0e,0x00,0x00,0xa1,0x0e,0x00,0x00,\
0xac,0x0e,0x00,0x00,0xb7,0x0e,0x00,0x00,0xc2,0x0e,0x00,0x00,0xce,0x0e,0x00,0x00,\
0xd9,0x0e,0x00,0x00,0xe4,0x0e,0x00,0x00,0xef,0x0e,0x00,0x00,0xfa,0x0e,0x00,0x00,\
0x05,0x0f,0x00,0x00,0x11,0x0f,0x00,0x00,0x1c,0x0f,0x00,0x00,0x27,0x0f,0x00,0x00,\
0x32,0x0f,0x00,0x00,0x3e,0x0f,0x00,0x00,0x49,0x0f,0x00,0x00,0x54,0x0f,0x00,0x00,\
0x5f,0x0f,0x00,0x00,0x6b,0x0f,0x00,0x00,0x76,0x0f,0x00,0x00,0x81,0x0f,0x00,0x00,\
0x8d,0x0f,0x00,0x00,0x98,0x0f,0x00,0x00,0xa3,0x0f,0x00,0x00,0xaf,0x0f,0x00,0x00,\
0xba,0x0f,0x00,0x00,0xc5,0x0f,0x00,0x00,0xd1,0x0f,0x00,0x00,0xdc,0x0f,0x00,0x00,\
0xe8,0x0f,0x00,0x00,0xf3,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,\
0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,\
0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,\
0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,\
0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,\
0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,\
0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,\
0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,\
0xff,0x0f,0x00,0x00,0x86,0x01,0x00,0x00,0x0a,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x44,0x08,0xf1,0x18,0x6d,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1e,0x00,0x00,0x00,\
0x60,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0xff,0x03,0x00,0x00,0x60,0x00,0x00,0x00,\
0x00,0x01,0x00,0x00,0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe4,0x0c,0x00,0x00,\
0x80,0x96,0x98,0x00,0x00,0x04,0x00,0x00,0x01,0x00,0x00,0x00,0xe5,0x0c,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x11,0x00,0x00,0x80,0x96,0x98,0x00,\
0x00,0x04,0x00,0x00,0x02,0x00,0x00,0x00,0x31,0x11,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x7c,0x15,0x00,0x00,0x80,0x96,0x98,0x00,0x00,0x04,0x00,0x00,\
0x03,0x00,0x00,0x00,0x7d,0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x20,0x4e,0x00,0x00,0x80,0x96,0x98,0x00,0x00,0x04,0x00,0x00,0xc5,0x01,0x5a,0xff,\
0xe1,0xff,0x00,0x00,0x6b,0xff,0xa4,0x01,0xf1,0xff,0x00,0x00,0x11,0x00,0xb9,0xfe,\
0x36,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9b,0x01,0x78,0xff,0xed,0xff,\
0x00,0x00,0x63,0xff,0xb8,0x01,0xe5,0xff,0x00,0x00,0xfc,0xff,0x43,0xff,0xc1,0x01,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x89,0x01,0x99,0xff,0xde,0xff,0x00,0x00,\
0x85,0xff,0xac,0x01,0xcf,0xff,0x00,0x00,0xf3,0xff,0x4d,0xff,0xc0,0x01,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x9d,0x01,0x78,0xff,0xeb,0xff,0x00,0x00,0x92,0xff,\
0xab,0x01,0xc3,0xff,0x00,0x00,0xfa,0xff,0x57,0xff,0xaf,0x01,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x86,0x01,0x00,0x00,0x04,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0d,0xe7,0xc5,0x0d,0x6d,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x05,0x00,0x00,\
0x90,0x05,0x00,0x00,0x01,0x00,0x00,0x00,0xff,0x03,0x00,0x00,0x60,0x00,0x00,0x00,\
0x30,0x05,0x00,0x00,0x02,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x80,0x84,0x1e,0x00,0xa0,0x86,0x01,0x00,0x01,0x00,0xff,0x0f,\
0x00,0x00,0x0c,0x00,0xff,0xff,0x00,0x00,0x81,0x00,0xd2,0x00,0x16,0x01,0x54,0x01,\
0x8e,0x01,0xc4,0x01,0xf8,0x01,0x29,0x02,0x59,0x02,0x87,0x02,0xb3,0x02,0xdf,0x02,\
0x09,0x03,0x32,0x03,0x5b,0x03,0x83,0x03,0x1a,0x04,0xa9,0x04,0x31,0x05,0xb4,0x05,\
0x31,0x06,0xaa,0x06,0x20,0x07,0x93,0x07,0x02,0x08,0x70,0x08,0xdb,0x08,0x43,0x09,\
0xaa,0x09,0x0f,0x0a,0x72,0x0a,0xd4,0x0a,0x34,0x0b,0x93,0x0b,0xf1,0x0b,0x4e,0x0c,\
0xa9,0x0c,0x03,0x0d,0x5c,0x0d,0xb4,0x0d,0x0c,0x0e,0x62,0x0e,0xb7,0x0e,0x0c,0x0f,\
0x57,0x10,0x97,0x11,0xce,0x12,0xfc,0x13,0x23,0x15,0x43,0x16,0x5d,0x17,0x72,0x18,\
0x81,0x19,0x8c,0x1a,0x92,0x1b,0x94,0x1c,0x92,0x1d,0x8c,0x1e,0x84,0x1f,0x78,0x20,\
0x69,0x21,0x57,0x22,0x42,0x23,0x2b,0x24,0x11,0x25,0xf5,0x25,0xd6,0x26,0xb6,0x27,\
0x6c,0x2e,0xbe,0x34,0xc1,0x3a,0x82,0x40,0x0e,0x46,0x6a,0x4b,0x9e,0x50,0xae,0x55,\
0x9e,0x5a,0x72,0x5f,0x2b,0x64,0xcc,0x68,0x57,0x6d,0xcd,0x71,0x31,0x76,0x83,0x7a,\
0xc5,0x7e,0xf7,0x82,0x1b,0x87,0x31,0x8b,0x39,0x8f,0x36,0x93,0x27,0x97,0x0d,0x9b,\
0xe8,0x9e,0xb9,0xa2,0x80,0xa6,0x3e,0xaa,0xf3,0xad,0x9f,0xb1,0x43,0xb5,0xdf,0xb8,\
0x74,0xbc,0x01,0xc0,0x87,0xc3,0x06,0xc7,0x7e,0xca,0xf0,0xcd,0x5b,0xd1,0xc1,0xd4,\
0x20,0xd8,0x7a,0xdb,0xce,0xde,0x1d,0xe2,0x67,0xe5,0xab,0xe8,0xeb,0xeb,0x25,0xef,\
0x5b,0xf2,0x8c,0xf5,0xb9,0xf8,0xe1,0xfb,0x05,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,\
0xff,0xff,0xff,0xff,0x86,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0xa5,0x7e,0x3c,0x6d,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,\
0xac,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0xff,0x03,0x00,0x00,0x60,0x00,0x00,0x00,\
0x4c,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0x02,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x00,0x00,\
0x80,0x96,0x98,0x00,0x10,0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x86,0x01,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x25,0xa9,0x70,0x9a,0x6d,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x26,0x20,0x00,0x00,0xfc,0x40,0x00,0x00,\
0x01,0x00,0x00,0x00,0xff,0x03,0x00,0x00,0x60,0x00,0x00,0x00,0x9c,0x40,0x00,0x00,\
0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x02,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x4e,0x00,0x00,0x80,0x96,0x98,0x00,\
0x1d,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x1e,0x00,0x00,0x00,0x20,0x4e,0x00,0x00,0x80,0x96,0x98,0x00,0x64,0x00,0x00,0x00,\
0x01,0x00,0x01,0x00,0xfe,0xff,0xfa,0xff,0xf6,0xff,0xfa,0xff,0x00,0x00,0x0c,0x00,\
0xf6,0xff,0x0c,0x00,0x30,0x00,0x00,0x00,0x10,0x00,0xa0,0x00,0x40,0x00,0x00,0x28,\
0x00,0x02,0x60,0x00,0x80,0x01,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x81,0xfa,0x82,0xfa,0x82,0xfa,0x83,0xfa,\
0x84,0xfa,0x85,0xfa,0x86,0xfa,0x86,0xfa,0x87,0xfa,0x88,0xfa,0x89,0xfa,0x8a,0xfa,\
0x8a,0xfa,0x8b,0xfa,0x8c,0xfa,0x8d,0xfa,0x8e,0xfa,0x8e,0xfa,0x8f,0xfa,0x90,0xfa,\
0x91,0xfa,0x92,0xfa,0x92,0xfa,0x93,0xfa,0x94,0xfa,0x95,0xfa,0x96,0xfa,0x96,0xfa,\
0x97,0xfa,0x98,0xfa,0x99,0xfa,0x9a,0xfa,0x9a,0xfa,0x9b,0xfa,0x9c,0xfa,0x9d,0xfa,\
0x9e,0xfa,0x9e,0xfa,0x9f,0xfa,0xa0,0xfa,0xa1,0xfa,0xa2,0xfa,0xa2,0xfa,0xa3,0xfa,\
0xa4,0xfa,0xa5,0xfa,0xa6,0xfa,0xa6,0xfa,0xa7,0xfa,0xa8,0xfa,0xa9,0xfa,0xaa,0xfa,\
0xaa,0xfa,0xab,0xfa,0xac,0xfa,0xad,0xfa,0xae,0xfa,0xae,0xfa,0xaf,0xfa,0xb0,0xfa,\
0xb1,0xfa,0xb2,0xfa,0xb2,0xfa,0xb3,0xfa,0xb4,0xfa,0xb5,0xfa,0xb6,0xfa,0xb6,0xfa,\
0xb7,0xfa,0xb8,0xfa,0xb9,0xfa,0xba,0xfa,0xba,0xfa,0xbb,0xfa,0xbc,0xfa,0xbd,0xfa,\
0xbe,0xfa,0xbe,0xfa,0xbf,0xfa,0xc0,0xfa,0xc1,0xfa,0xc2,0xfa,0xc2,0xfa,0xc3,0xfa,\
0xc4,0xfa,0xc5,0xfa,0xc6,0xfa,0xc6,0xfa,0xc7,0xfa,0xc8,0xfa,0xc9,0xfa,0xca,0xfa,\
0xca,0xfa,0xcb,0xfa,0xcc,0xfa,0xcd,0xfa,0xce,0xfa,0xce,0xfa,0xcf,0xfa,0xd0,0xfa,\
0xd1,0xfa,0xd2,0xfa,0xd2,0xfa,0xd3,0xfa,0xd4,0xfa,0xd5,0xfa,0xd6,0xfa,0xd6,0xfa,\
0xd7,0xfa,0xd8,0xfa,0xd9,0xfa,0xda,0xfa,0xda,0xfa,0xdb,0xfa,0xdc,0xfa,0xdd,0xfa,\
0xde,0xfa,0xde,0xfa,0xdf,0xfa,0xe0,0xfa,0xe1,0xfa,0xe2,0xfa,0xe2,0xfa,0xe3,0xfa,\
0xe4,0xfa,0xe5,0xfa,0xe6,0xfa,0xe6,0xfa,0xe7,0xfa,0xe8,0xfa,0xe9,0xfa,0xea,0xfa,\
0xea,0xfa,0xeb,0xfa,0xec,0xfa,0xed,0xfa,0xee,0xfa,0xee,0xfa,0xef,0xfa,0xf0,0xfa,\
0xf1,0xfa,0xf2,0xfa,0xf2,0xfa,0xf3,0xfa,0xf4,0xfa,0xf5,0xfa,0xf6,0xfa,0xf6,0xfa,\
0xf7,0xfa,0xf8,0xfa,0xf9,0xfa,0xfa,0xfa,0xfa,0xfa,0xfb,0xfa,0xfc,0xfa,0xfd,0xfa,\
0xfe,0xfa,0xfe,0xfa,0xff,0xfa,0x00,0xfb,0x01,0xfb,0x02,0xfb,0x02,0xfb,0x03,0xfb,\
0x04,0xfb,0x05,0xfb,0x06,0xfb,0x06,0xfb,0x07,0xfb,0x08,0xfb,0x09,0xfb,0x0a,0xfb,\
0x0a,0xfb,0x0b,0xfb,0x0c,0xfb,0x0d,0xfb,0x0e,0xfb,0x0e,0xfb,0x0f,0xfb,0x10,0xfb,\
0x11,0xfb,0x12,0xfb,0x12,0xfb,0x13,0xfb,0x14,0xfb,0x15,0xfb,0x16,0xfb,0x16,0xfb,\
0x17,0xfb,0x18,0xfb,0x19,0xfb,0x1a,0xfb,0x1a,0xfb,0x1b,0xfb,0x1c,0xfb,0x1d,0xfb,\
0x1e,0xfb,0x1e,0xfb,0x1f,0xfb,0x20,0xfb,0x21,0xfb,0x22,0xfb,0x22,0xfb,0x23,0xfb,\
0x24,0xfb,0x25,0xfb,0x26,0xfb,0x26,0xfb,0x27,0xfb,0x28,0xfb,0x29,0xfb,0x2a,0xfb,\
0x2a,0xfb,0x2b,0xfb,0x2c,0xfb,0x2d,0xfb,0x2e,0xfb,0x2e,0xfb,0x2f,0xfb,0x30,0xfb,\
0x31,0xfb,0x32,0xfb,0x32,0xfb,0x33,0xfb,0x34,0xfb,0x35,0xfb,0x36,0xfb,0x36,0xfb,\
0x37,0xfb,0x38,0xfb,0x39,0xfb,0x3a,0xfb,0x3a,0xfb,0x3b,0xfb,0x3c,0xfb,0x3d,0xfb,\
0x3e,0xfb,0x3e,0xfb,0x3f,0xfb,0x40,0xfb,0x41,0xfb,0x42,0xfb,0x42,0xfb,0x43,0xfb,\
0x44,0xfb,0x45,0xfb,0x46,0xfb,0x46,0xfb,0x47,0xfb,0x48,0xfb,0x49,0xfb,0x4a,0xfb,\
0x4a,0xfb,0x4b,0xfb,0x4c,0xfb,0x4d,0xfb,0x4e,0xfb,0x4e,0xfb,0x4f,0xfb,0x50,0xfb,\
0x51,0xfb,0x52,0xfb,0x52,0xfb,0x53,0xfb,0x54,0xfb,0x55,0xfb,0x56,0xfb,0x56,0xfb,\
0x57,0xfb,0x58,0xfb,0x59,0xfb,0x5a,0xfb,0x5a,0xfb,0x5b,0xfb,0x5c,0xfb,0x5d,0xfb,\
0x5e,0xfb,0x5e,0xfb,0x5f,0xfb,0x60,0xfb,0x61,0xfb,0x62,0xfb,0x62,0xfb,0x63,0xfb,\
0x64,0xfb,0x65,0xfb,0x66,0xfb,0x66,0xfb,0x67,0xfb,0x68,0xfb,0x69,0xfb,0x6a,0xfb,\
0x6a,0xfb,0x6b,0xfb,0x6c,0xfb,0x6d,0xfb,0x6e,0xfb,0x6e,0xfb,0x6f,0xfb,0x70,0xfb,\
0x71,0xfb,0x72,0xfb,0x72,0xfb,0x73,0xfb,0x74,0xfb,0x75,0xfb,0x76,0xfb,0x76,0xfb,\
0x77,0xfb,0x78,0xfb,0x79,0xfb,0x7a,0xfb,0x7a,0xfb,0x7b,0xfb,0x7c,0xfb,0x7d,0xfb,\
0x7e,0xfb,0x7e,0xfb,0x7f,0xfb,0x80,0xfb,0x81,0xfb,0x82,0xfb,0x82,0xfb,0x83,0xfb,\
0x84,0xfb,0x85,0xfb,0x86,0xfb,0x86,0xfb,0x87,0xfb,0x88,0xfb,0x89,0xfb,0x8a,0xfb,\
0x8a,0xfb,0x8b,0xfb,0x8c,0xfb,0x8d,0xfb,0x8e,0xfb,0x8e,0xfb,0x8f,0xfb,0x90,0xfb,\
0x91,0xfb,0x92,0xfb,0x92,0xfb,0x93,0xfb,0x94,0xfb,0x95,0xfb,0x96,0xfb,0x96,0xfb,\
0x97,0xfb,0x98,0xfb,0x99,0xfb,0x9a,0xfb,0x9a,0xfb,0x9b,0xfb,0x9c,0xfb,0x9d,0xfb,\
0x9e,0xfb,0x9e,0xfb,0x9f,0xfb,0xa0,0xfb,0xa1,0xfb,0xa2,0xfb,0xa2,0xfb,0xa3,0xfb,\
0xa4,0xfb,0xa5,0xfb,0xa6,0xfb,0xa6,0xfb,0xa7,0xfb,0xa8,0xfb,0xa9,0xfb,0xaa,0xfb,\
0xaa,0xfb,0xab,0xfb,0xac,0xfb,0xad,0xfb,0xae,0xfb,0xae,0xfb,0xaf,0xfb,0xb0,0xfb,\
0xb1,0xfb,0xb2,0xfb,0xb2,0xfb,0xb3,0xfb,0xb4,0xfb,0xb5,0xfb,0xb6,0xfb,0xb6,0xfb,\
0xb7,0xfb,0xb8,0xfb,0xb9,0xfb,0xba,0xfb,0xba,0xfb,0xbb,0xfb,0xbc,0xfb,0xbd,0xfb,\
0xbe,0xfb,0xbe,0xfb,0xbf,0xfb,0xc0,0xfb,0xc1,0xfb,0xc2,0xfb,0xc2,0xfb,0xc3,0xfb,\
0xc4,0xfb,0xc5,0xfb,0xc6,0xfb,0xc6,0xfb,0xc7,0xfb,0xc8,0xfb,0xc9,0xfb,0xca,0xfb,\
0xca,0xfb,0xcb,0xfb,0xcc,0xfb,0xcd,0xfb,0xce,0xfb,0xce,0xfb,0xcf,0xfb,0xd0,0xfb,\
0xd1,0xfb,0xd2,0xfb,0xd2,0xfb,0xd3,0xfb,0xd4,0xfb,0xd5,0xfb,0xd6,0xfb,0xd6,0xfb,\
0xd7,0xfb,0xd8,0xfb,0xd9,0xfb,0xda,0xfb,0xda,0xfb,0xdb,0xfb,0xdc,0xfb,0xdd,0xfb,\
0xde,0xfb,0xde,0xfb,0xdf,0xfb,0xe0,0xfb,0xe1,0xfb,0xe2,0xfb,0xe2,0xfb,0xe3,0xfb,\
0xe4,0xfb,0xe5,0xfb,0xe6,0xfb,0xe6,0xfb,0xe7,0xfb,0xe8,0xfb,0xe9,0xfb,0xea,0xfb,\
0xea,0xfb,0xeb,0xfb,0xec,0xfb,0xed,0xfb,0xee,0xfb,0xee,0xfb,0xef,0xfb,0xf0,0xfb,\
0xf1,0xfb,0xf2,0xfb,0xf2,0xfb,0xf3,0xfb,0xf4,0xfb,0xf5,0xfb,0xf6,0xfb,0xf6,0xfb,\
0xf7,0xfb,0xf8,0xfb,0xf9,0xfb,0xfa,0xfb,0xfa,0xfb,0xfb,0xfb,0xfc,0xfb,0xfd,0xfb,\
0xfe,0xfb,0xfe,0xfb,0xff,0xfb,0x00,0xfc,0x01,0xfc,0x02,0xfc,0x02,0xfc,0x03,0xfc,\
0x04,0xfc,0x05,0xfc,0x06,0xfc,0x06,0xfc,0x07,0xfc,0x08,0xfc,0x09,0xfc,0x0a,0xfc,\
0x0a,0xfc,0x0b,0xfc,0x0c,0xfc,0x0d,0xfc,0x0e,0xfc,0x0e,0xfc,0x0f,0xfc,0x10,0xfc,\
0x11,0xfc,0x12,0xfc,0x12,0xfc,0x13,0xfc,0x14,0xfc,0x15,0xfc,0x16,0xfc,0x16,0xfc,\
0x17,0xfc,0x18,0xfc,0x19,0xfc,0x1a,0xfc,0x1a,0xfc,0x1b,0xfc,0x1c,0xfc,0x1d,0xfc,\
0x1e,0xfc,0x1e,0xfc,0x1f,0xfc,0x20,0xfc,0x21,0xfc,0x22,0xfc,0x22,0xfc,0x23,0xfc,\
0x24,0xfc,0x25,0xfc,0x26,0xfc,0x26,0xfc,0x27,0xfc,0x28,0xfc,0x29,0xfc,0x2a,0xfc,\
0x2a,0xfc,0x2b,0xfc,0x2c,0xfc,0x2d,0xfc,0x2e,0xfc,0x2e,0xfc,0x2f,0xfc,0x30,0xfc,\
0x31,0xfc,0x32,0xfc,0x32,0xfc,0x33,0xfc,0x34,0xfc,0x35,0xfc,0x36,0xfc,0x36,0xfc,\
0x37,0xfc,0x38,0xfc,0x39,0xfc,0x3a,0xfc,0x3a,0xfc,0x3b,0xfc,0x3c,0xfc,0x3d,0xfc,\
0x3e,0xfc,0x3e,0xfc,0x3f,0xfc,0x40,0xfc,0x41,0xfc,0x42,0xfc,0x42,0xfc,0x43,0xfc,\
0x44,0xfc,0x45,0xfc,0x46,0xfc,0x46,0xfc,0x47,0xfc,0x48,0xfc,0x49,0xfc,0x4a,0xfc,\
0x4a,0xfc,0x4b,0xfc,0x4c,0xfc,0x4d,0xfc,0x4e,0xfc,0x4e,0xfc,0x4f,0xfc,0x50,0xfc,\
0x51,0xfc,0x52,0xfc,0x52,0xfc,0x53,0xfc,0x54,0xfc,0x55,0xfc,0x56,0xfc,0x56,0xfc,\
0x57,0xfc,0x58,0xfc,0x59,0xfc,0x5a,0xfc,0x5a,0xfc,0x5b,0xfc,0x5c,0xfc,0x5d,0xfc,\
0x5e,0xfc,0x5e,0xfc,0x5f,0xfc,0x60,0xfc,0x61,0xfc,0x62,0xfc,0x62,0xfc,0x63,0xfc,\
0x64,0xfc,0x65,0xfc,0x66,0xfc,0x66,0xfc,0x67,0xfc,0x68,0xfc,0x69,0xfc,0x6a,0xfc,\
0x6a,0xfc,0x6b,0xfc,0x6c,0xfc,0x6d,0xfc,0x6e,0xfc,0x6e,0xfc,0x6f,0xfc,0x70,0xfc,\
0x71,0xfc,0x72,0xfc,0x72,0xfc,0x73,0xfc,0x74,0xfc,0x75,0xfc,0x76,0xfc,0x76,0xfc,\
0x77,0xfc,0x78,0xfc,0x79,0xfc,0x7a,0xfc,0x7a,0xfc,0x7b,0xfc,0x7c,0xfc,0x7d,0xfc,\
0x7e,0xfc,0x7e,0xfc,0x7f,0xfc,0x80,0xfc,0x81,0xfc,0x82,0xfc,0x82,0xfc,0x83,0xfc,\
0x84,0xfc,0x85,0xfc,0x86,0xfc,0x86,0xfc,0x87,0xfc,0x88,0xfc,0x89,0xfc,0x8a,0xfc,\
0x8a,0xfc,0x8b,0xfc,0x8c,0xfc,0x8d,0xfc,0x8e,0xfc,0x8e,0xfc,0x8f,0xfc,0x90,0xfc,\
0x91,0xfc,0x92,0xfc,0x92,0xfc,0x93,0xfc,0x94,0xfc,0x95,0xfc,0x96,0xfc,0x96,0xfc,\
0x97,0xfc,0x98,0xfc,0x99,0xfc,0x9a,0xfc,0x9a,0xfc,0x9b,0xfc,0x9c,0xfc,0x9d,0xfc,\
0x9e,0xfc,0x9e,0xfc,0x9f,0xfc,0xa0,0xfc,0xa1,0xfc,0xa2,0xfc,0xa2,0xfc,0xa3,0xfc,\
0xa4,0xfc,0xa5,0xfc,0xa6,0xfc,0xa6,0xfc,0xa7,0xfc,0xa8,0xfc,0xa9,0xfc,0xaa,0xfc,\
0xaa,0xfc,0xab,0xfc,0xac,0xfc,0xad,0xfc,0xae,0xfc,0xae,0xfc,0xaf,0xfc,0xb0,0xfc,\
0xb1,0xfc,0xb2,0xfc,0xb2,0xfc,0xb3,0xfc,0xb4,0xfc,0xb5,0xfc,0xb6,0xfc,0xb6,0xfc,\
0xb7,0xfc,0xb8,0xfc,0xb9,0xfc,0xba,0xfc,0xba,0xfc,0xbb,0xfc,0xbc,0xfc,0xbd,0xfc,\
0xbe,0xfc,0xbe,0xfc,0xbf,0xfc,0xc0,0xfc,0xc1,0xfc,0xc2,0xfc,0xc2,0xfc,0xc3,0xfc,\
0xc4,0xfc,0xc5,0xfc,0xc6,0xfc,0xc6,0xfc,0xc7,0xfc,0xc8,0xfc,0xc9,0xfc,0xca,0xfc,\
0xca,0xfc,0xcb,0xfc,0xcc,0xfc,0xcd,0xfc,0xce,0xfc,0xce,0xfc,0xcf,0xfc,0xd0,0xfc,\
0xd1,0xfc,0xd2,0xfc,0xd2,0xfc,0xd3,0xfc,0xd4,0xfc,0xd5,0xfc,0xd6,0xfc,0xd6,0xfc,\
0xd7,0xfc,0xd8,0xfc,0xd9,0xfc,0xda,0xfc,0xda,0xfc,0xdb,0xfc,0xdc,0xfc,0xdd,0xfc,\
0xde,0xfc,0xde,0xfc,0xdf,0xfc,0xe0,0xfc,0xe1,0xfc,0xe2,0xfc,0xe2,0xfc,0xe3,0xfc,\
0xe4,0xfc,0xe5,0xfc,0xe6,0xfc,0xe6,0xfc,0xe7,0xfc,0xe8,0xfc,0xe9,0xfc,0xea,0xfc,\
0xea,0xfc,0xeb,0xfc,0xec,0xfc,0xed,0xfc,0xee,0xfc,0xee,0xfc,0xef,0xfc,0xf0,0xfc,\
0xf1,0xfc,0xf2,0xfc,0xf2,0xfc,0xf3,0xfc,0xf4,0xfc,0xf5,0xfc,0xf6,0xfc,0xf6,0xfc,\
0xf7,0xfc,0xf8,0xfc,0xf9,0xfc,0xfa,0xfc,0xfa,0xfc,0xfb,0xfc,0xfc,0xfc,0xfd,0xfc,\
0xfe,0xfc,0xfe,0xfc,0xff,0xfc,0x00,0xfd,0x01,0xfd,0x02,0xfd,0x02,0xfd,0x03,0xfd,\
0x04,0xfd,0x05,0xfd,0x06,0xfd,0x06,0xfd,0x07,0xfd,0x08,0xfd,0x09,0xfd,0x0a,0xfd,\
0x0a,0xfd,0x0b,0xfd,0x0c,0xfd,0x0d,0xfd,0x0e,0xfd,0x0e,0xfd,0x0f,0xfd,0x10,0xfd,\
0x11,0xfd,0x12,0xfd,0x12,0xfd,0x13,0xfd,0x14,0xfd,0x15,0xfd,0x16,0xfd,0x16,0xfd,\
0x17,0xfd,0x18,0xfd,0x19,0xfd,0x1a,0xfd,0x1a,0xfd,0x1b,0xfd,0x1c,0xfd,0x1d,0xfd,\
0x1e,0xfd,0x1e,0xfd,0x1f,0xfd,0x20,0xfd,0x21,0xfd,0x22,0xfd,0x22,0xfd,0x23,0xfd,\
0x24,0xfd,0x25,0xfd,0x26,0xfd,0x26,0xfd,0x27,0xfd,0x28,0xfd,0x29,0xfd,0x2a,0xfd,\
0x2a,0xfd,0x2b,0xfd,0x2c,0xfd,0x2d,0xfd,0x2e,0xfd,0x2e,0xfd,0x2f,0xfd,0x30,0xfd,\
0x31,0xfd,0x32,0xfd,0x32,0xfd,0x33,0xfd,0x34,0xfd,0x35,0xfd,0x36,0xfd,0x36,0xfd,\
0x37,0xfd,0x38,0xfd,0x39,0xfd,0x3a,0xfd,0x3a,0xfd,0x3b,0xfd,0x3c,0xfd,0x3d,0xfd,\
0x3e,0xfd,0x3e,0xfd,0x3f,0xfd,0x40,0xfd,0x41,0xfd,0x42,0xfd,0x42,0xfd,0x43,0xfd,\
0x44,0xfd,0x45,0xfd,0x46,0xfd,0x46,0xfd,0x47,0xfd,0x48,0xfd,0x49,0xfd,0x4a,0xfd,\
0x4a,0xfd,0x4b,0xfd,0x4c,0xfd,0x4d,0xfd,0x4e,0xfd,0x4e,0xfd,0x4f,0xfd,0x50,0xfd,\
0x51,0xfd,0x52,0xfd,0x52,0xfd,0x53,0xfd,0x54,0xfd,0x55,0xfd,0x56,0xfd,0x56,0xfd,\
0x57,0xfd,0x58,0xfd,0x59,0xfd,0x5a,0xfd,0x5a,0xfd,0x5b,0xfd,0x5c,0xfd,0x5d,0xfd,\
0x5e,0xfd,0x5e,0xfd,0x5f,0xfd,0x60,0xfd,0x61,0xfd,0x62,0xfd,0x62,0xfd,0x63,0xfd,\
0x64,0xfd,0x65,0xfd,0x66,0xfd,0x66,0xfd,0x67,0xfd,0x68,0xfd,0x69,0xfd,0x6a,0xfd,\
0x6a,0xfd,0x6b,0xfd,0x6c,0xfd,0x6d,0xfd,0x6e,0xfd,0x6e,0xfd,0x6f,0xfd,0x70,0xfd,\
0x71,0xfd,0x72,0xfd,0x72,0xfd,0x73,0xfd,0x74,0xfd,0x75,0xfd,0x76,0xfd,0x76,0xfd,\
0x77,0xfd,0x78,0xfd,0x79,0xfd,0x7a,0xfd,0x7a,0xfd,0x7b,0xfd,0x7c,0xfd,0x7d,0xfd,\
0x7e,0xfd,0x7e,0xfd,0x7f,0xfd,0x80,0xfd,0x81,0xfd,0x82,0xfd,0x82,0xfd,0x83,0xfd,\
0x84,0xfd,0x85,0xfd,0x86,0xfd,0x86,0xfd,0x87,0xfd,0x88,0xfd,0x89,0xfd,0x8a,0xfd,\
0x8a,0xfd,0x8b,0xfd,0x8c,0xfd,0x8d,0xfd,0x8e,0xfd,0x8e,0xfd,0x8f,0xfd,0x90,0xfd,\
0x91,0xfd,0x92,0xfd,0x92,0xfd,0x93,0xfd,0x94,0xfd,0x95,0xfd,0x96,0xfd,0x96,0xfd,\
0x97,0xfd,0x98,0xfd,0x99,0xfd,0x9a,0xfd,0x9a,0xfd,0x9b,0xfd,0x9c,0xfd,0x9d,0xfd,\
0x9e,0xfd,0x9e,0xfd,0x9f,0xfd,0xa0,0xfd,0xa1,0xfd,0xa2,0xfd,0xa2,0xfd,0xa3,0xfd,\
0xa4,0xfd,0xa5,0xfd,0xa6,0xfd,0xa6,0xfd,0xa7,0xfd,0xa8,0xfd,0xa9,0xfd,0xaa,0xfd,\
0xaa,0xfd,0xab,0xfd,0xac,0xfd,0xad,0xfd,0xae,0xfd,0xae,0xfd,0xaf,0xfd,0xb0,0xfd,\
0xb1,0xfd,0xb2,0xfd,0xb2,0xfd,0xb3,0xfd,0xb4,0xfd,0xb5,0xfd,0xb6,0xfd,0xb6,0xfd,\
0xb7,0xfd,0xb8,0xfd,0xb9,0xfd,0xba,0xfd,0xba,0xfd,0xbb,0xfd,0xbc,0xfd,0xbd,0xfd,\
0xbe,0xfd,0xbe,0xfd,0xbf,0xfd,0xc0,0xfd,0xc1,0xfd,0xc2,0xfd,0xc2,0xfd,0xc3,0xfd,\
0xc4,0xfd,0xc5,0xfd,0xc6,0xfd,0xc6,0xfd,0xc7,0xfd,0xc8,0xfd,0xc9,0xfd,0xca,0xfd,\
0xca,0xfd,0xcb,0xfd,0xcc,0xfd,0xcd,0xfd,0xce,0xfd,0xce,0xfd,0xcf,0xfd,0xd0,0xfd,\
0xd1,0xfd,0xd2,0xfd,0xd2,0xfd,0xd3,0xfd,0xd4,0xfd,0xd5,0xfd,0xd6,0xfd,0xd6,0xfd,\
0xd7,0xfd,0xd8,0xfd,0xd9,0xfd,0xda,0xfd,0xda,0xfd,0xdb,0xfd,0xdc,0xfd,0xdd,0xfd,\
0xde,0xfd,0xde,0xfd,0xdf,0xfd,0xe0,0xfd,0xe1,0xfd,0xe2,0xfd,0xe2,0xfd,0xe3,0xfd,\
0xe4,0xfd,0xe5,0xfd,0xe6,0xfd,0xe6,0xfd,0xe7,0xfd,0xe8,0xfd,0xe9,0xfd,0xea,0xfd,\
0xea,0xfd,0xeb,0xfd,0xec,0xfd,0xed,0xfd,0xee,0xfd,0xee,0xfd,0xef,0xfd,0xf0,0xfd,\
0xf1,0xfd,0xf2,0xfd,0xf2,0xfd,0xf3,0xfd,0xf4,0xfd,0xf5,0xfd,0xf6,0xfd,0xf6,0xfd,\
0xf7,0xfd,0xf8,0xfd,0xf9,0xfd,0xfa,0xfd,0xfa,0xfd,0xfb,0xfd,0xfc,0xfd,0xfd,0xfd,\
0xfe,0xfd,0xfe,0xfd,0xff,0xfd,0x00,0xfe,0x01,0xfe,0x02,0xfe,0x02,0xfe,0x03,0xfe,\
0x04,0xfe,0x05,0xfe,0x06,0xfe,0x06,0xfe,0x07,0xfe,0x08,0xfe,0x09,0xfe,0x0a,0xfe,\
0x0a,0xfe,0x0b,0xfe,0x0c,0xfe,0x0d,0xfe,0x0e,0xfe,0x0e,0xfe,0x0f,0xfe,0x10,0xfe,\
0x11,0xfe,0x12,0xfe,0x12,0xfe,0x13,0xfe,0x14,0xfe,0x15,0xfe,0x16,0xfe,0x16,0xfe,\
0x17,0xfe,0x18,0xfe,0x19,0xfe,0x1a,0xfe,0x1a,0xfe,0x1b,0xfe,0x1c,0xfe,0x1d,0xfe,\
0x1e,0xfe,0x1e,0xfe,0x1f,0xfe,0x20,0xfe,0x21,0xfe,0x22,0xfe,0x22,0xfe,0x23,0xfe,\
0x24,0xfe,0x25,0xfe,0x26,0xfe,0x26,0xfe,0x27,0xfe,0x28,0xfe,0x29,0xfe,0x2a,0xfe,\
0x2a,0xfe,0x2b,0xfe,0x2c,0xfe,0x2d,0xfe,0x2e,0xfe,0x2e,0xfe,0x2f,0xfe,0x30,0xfe,\
0x31,0xfe,0x32,0xfe,0x32,0xfe,0x33,0xfe,0x34,0xfe,0x35,0xfe,0x36,0xfe,0x36,0xfe,\
0x37,0xfe,0x38,0xfe,0x39,0xfe,0x3a,0xfe,0x3a,0xfe,0x3b,0xfe,0x3c,0xfe,0x3d,0xfe,\
0x3e,0xfe,0x3e,0xfe,0x3f,0xfe,0x40,0xfe,0x41,0xfe,0x42,0xfe,0x42,0xfe,0x43,0xfe,\
0x44,0xfe,0x45,0xfe,0x46,0xfe,0x46,0xfe,0x47,0xfe,0x48,0xfe,0x49,0xfe,0x4a,0xfe,\
0x4a,0xfe,0x4b,0xfe,0x4c,0xfe,0x4d,0xfe,0x4e,0xfe,0x4e,0xfe,0x4f,0xfe,0x50,0xfe,\
0x51,0xfe,0x52,0xfe,0x52,0xfe,0x53,0xfe,0x54,0xfe,0x55,0xfe,0x56,0xfe,0x56,0xfe,\
0x57,0xfe,0x58,0xfe,0x59,0xfe,0x5a,0xfe,0x5a,0xfe,0x5b,0xfe,0x5c,0xfe,0x5d,0xfe,\
0x5e,0xfe,0x5e,0xfe,0x5f,0xfe,0x60,0xfe,0x61,0xfe,0x62,0xfe,0x62,0xfe,0x63,0xfe,\
0x64,0xfe,0x65,0xfe,0x66,0xfe,0x66,0xfe,0x67,0xfe,0x68,0xfe,0x69,0xfe,0x6a,0xfe,\
0x6a,0xfe,0x6b,0xfe,0x6c,0xfe,0x6d,0xfe,0x6e,0xfe,0x6e,0xfe,0x6f,0xfe,0x70,0xfe,\
0x71,0xfe,0x72,0xfe,0x72,0xfe,0x73,0xfe,0x74,0xfe,0x75,0xfe,0x76,0xfe,0x76,0xfe,\
0x77,0xfe,0x78,0xfe,0x79,0xfe,0x7a,0xfe,0x7a,0xfe,0x7b,0xfe,0x7c,0xfe,0x7d,0xfe,\
0x7e,0xfe,0x7e,0xfe,0x7f,0xfe,0x80,0xfe,0x81,0xfe,0x82,0xfe,0x82,0xfe,0x83,0xfe,\
0x84,0xfe,0x85,0xfe,0x86,0xfe,0x86,0xfe,0x87,0xfe,0x88,0xfe,0x89,0xfe,0x8a,0xfe,\
0x8a,0xfe,0x8b,0xfe,0x8c,0xfe,0x8d,0xfe,0x8e,0xfe,0x8e,0xfe,0x8f,0xfe,0x90,0xfe,\
0x91,0xfe,0x92,0xfe,0x92,0xfe,0x93,0xfe,0x94,0xfe,0x95,0xfe,0x96,0xfe,0x96,0xfe,\
0x97,0xfe,0x98,0xfe,0x99,0xfe,0x9a,0xfe,0x9a,0xfe,0x9b,0xfe,0x9c,0xfe,0x9d,0xfe,\
0x9e,0xfe,0x9e,0xfe,0x9f,0xfe,0xa0,0xfe,0xa1,0xfe,0xa2,0xfe,0xa2,0xfe,0xa3,0xfe,\
0xa4,0xfe,0xa5,0xfe,0xa6,0xfe,0xa6,0xfe,0xa7,0xfe,0xa8,0xfe,0xa9,0xfe,0xaa,0xfe,\
0xaa,0xfe,0xab,0xfe,0xac,0xfe,0xad,0xfe,0xae,0xfe,0xae,0xfe,0xaf,0xfe,0xb0,0xfe,\
0xb1,0xfe,0xb2,0xfe,0xb2,0xfe,0xb3,0xfe,0xb4,0xfe,0xb5,0xfe,0xb6,0xfe,0xb6,0xfe,\
0xb7,0xfe,0xb8,0xfe,0xb9,0xfe,0xba,0xfe,0xba,0xfe,0xbb,0xfe,0xbc,0xfe,0xbd,0xfe,\
0xbe,0xfe,0xbe,0xfe,0xbf,0xfe,0xc0,0xfe,0xc1,0xfe,0xc2,0xfe,0xc2,0xfe,0xc3,0xfe,\
0xc4,0xfe,0xc5,0xfe,0xc6,0xfe,0xc6,0xfe,0xc7,0xfe,0xc8,0xfe,0xc9,0xfe,0xca,0xfe,\
0xca,0xfe,0xcb,0xfe,0xcc,0xfe,0xcd,0xfe,0xce,0xfe,0xce,0xfe,0xcf,0xfe,0xd0,0xfe,\
0xd1,0xfe,0xd2,0xfe,0xd2,0xfe,0xd3,0xfe,0xd4,0xfe,0xd5,0xfe,0xd6,0xfe,0xd6,0xfe,\
0xd7,0xfe,0xd8,0xfe,0xd9,0xfe,0xda,0xfe,0xda,0xfe,0xdb,0xfe,0xdc,0xfe,0xdd,0xfe,\
0xde,0xfe,0xde,0xfe,0xdf,0xfe,0xe0,0xfe,0xe1,0xfe,0xe2,0xfe,0xe2,0xfe,0xe3,0xfe,\
0xe4,0xfe,0xe5,0xfe,0xe6,0xfe,0xe6,0xfe,0xe7,0xfe,0xe8,0xfe,0xe9,0xfe,0xea,0xfe,\
0xea,0xfe,0xeb,0xfe,0xec,0xfe,0xed,0xfe,0xee,0xfe,0xee,0xfe,0xef,0xfe,0xf0,0xfe,\
0xf1,0xfe,0xf2,0xfe,0xf2,0xfe,0xf3,0xfe,0xf4,0xfe,0xf5,0xfe,0xf6,0xfe,0xf6,0xfe,\
0xf7,0xfe,0xf8,0xfe,0xf9,0xfe,0xfa,0xfe,0xfa,0xfe,0xfb,0xfe,0xfc,0xfe,0xfd,0xfe,\
0xfe,0xfe,0xfe,0xfe,0xff,0xfe,0x00,0xff,0x01,0xff,0x02,0xff,0x02,0xff,0x03,0xff,\
0x04,0xff,0x05,0xff,0x06,0xff,0x06,0xff,0x07,0xff,0x08,0xff,0x09,0xff,0x0a,0xff,\
0x0a,0xff,0x0b,0xff,0x0c,0xff,0x0d,0xff,0x0e,0xff,0x0e,0xff,0x0f,0xff,0x10,0xff,\
0x11,0xff,0x12,0xff,0x12,0xff,0x13,0xff,0x14,0xff,0x15,0xff,0x16,0xff,0x16,0xff,\
0x17,0xff,0x18,0xff,0x19,0xff,0x1a,0xff,0x1a,0xff,0x1b,0xff,0x1c,0xff,0x1d,0xff,\
0x1e,0xff,0x1e,0xff,0x1f,0xff,0x20,0xff,0x21,0xff,0x22,0xff,0x22,0xff,0x23,0xff,\
0x24,0xff,0x25,0xff,0x26,0xff,0x26,0xff,0x27,0xff,0x28,0xff,0x29,0xff,0x2a,0xff,\
0x2a,0xff,0x2b,0xff,0x2c,0xff,0x2d,0xff,0x2e,0xff,0x2e,0xff,0x2f,0xff,0x30,0xff,\
0x31,0xff,0x32,0xff,0x32,0xff,0x33,0xff,0x34,0xff,0x35,0xff,0x36,0xff,0x36,0xff,\
0x37,0xff,0x38,0xff,0x39,0xff,0x3a,0xff,0x3a,0xff,0x3b,0xff,0x3c,0xff,0x3d,0xff,\
0x3e,0xff,0x3e,0xff,0x3f,0xff,0x40,0xff,0x41,0xff,0x42,0xff,0x42,0xff,0x43,0xff,\
0x44,0xff,0x45,0xff,0x46,0xff,0x46,0xff,0x47,0xff,0x48,0xff,0x49,0xff,0x4a,0xff,\
0x4a,0xff,0x4b,0xff,0x4c,0xff,0x4d,0xff,0x4e,0xff,0x4e,0xff,0x4f,0xff,0x50,0xff,\
0x51,0xff,0x52,0xff,0x52,0xff,0x53,0xff,0x54,0xff,0x55,0xff,0x56,0xff,0x56,0xff,\
0x57,0xff,0x58,0xff,0x59,0xff,0x5a,0xff,0x5a,0xff,0x5b,0xff,0x5c,0xff,0x5d,0xff,\
0x5e,0xff,0x5e,0xff,0x5f,0xff,0x60,0xff,0x61,0xff,0x62,0xff,0x62,0xff,0x63,0xff,\
0x64,0xff,0x65,0xff,0x66,0xff,0x66,0xff,0x67,0xff,0x68,0xff,0x69,0xff,0x6a,0xff,\
0x6a,0xff,0x6b,0xff,0x6c,0xff,0x6d,0xff,0x6e,0xff,0x6e,0xff,0x6f,0xff,0x70,0xff,\
0x71,0xff,0x72,0xff,0x72,0xff,0x73,0xff,0x74,0xff,0x75,0xff,0x76,0xff,0x76,0xff,\
0x77,0xff,0x78,0xff,0x79,0xff,0x7a,0xff,0x7a,0xff,0x7b,0xff,0x7c,0xff,0x7d,0xff,\
0x7e,0xff,0x7e,0xff,0x7f,0xff,0x80,0xff,0x81,0xff,0x82,0xff,0x82,0xff,0x83,0xff,\
0x84,0xff,0x85,0xff,0x86,0xff,0x86,0xff,0x87,0xff,0x88,0xff,0x89,0xff,0x8a,0xff,\
0x8a,0xff,0x8b,0xff,0x8c,0xff,0x8d,0xff,0x8e,0xff,0x8e,0xff,0x8f,0xff,0x90,0xff,\
0x91,0xff,0x92,0xff,0x92,0xff,0x93,0xff,0x94,0xff,0x95,0xff,0x96,0xff,0x96,0xff,\
0x97,0xff,0x98,0xff,0x99,0xff,0x9a,0xff,0x9a,0xff,0x9b,0xff,0x9c,0xff,0x9d,0xff,\
0x9e,0xff,0x9e,0xff,0x9f,0xff,0xa0,0xff,0xa1,0xff,0xa2,0xff,0xa2,0xff,0xa3,0xff,\
0xa4,0xff,0xa5,0xff,0xa6,0xff,0xa6,0xff,0xa7,0xff,0xa8,0xff,0xa9,0xff,0xaa,0xff,\
0xaa,0xff,0xab,0xff,0xac,0xff,0xad,0xff,0xae,0xff,0xae,0xff,0xaf,0xff,0xb0,0xff,\
0xb1,0xff,0xb2,0xff,0xb2,0xff,0xb3,0xff,0xb4,0xff,0xb5,0xff,0xb6,0xff,0xb6,0xff,\
0xb7,0xff,0xb8,0xff,0xb9,0xff,0xba,0xff,0xba,0xff,0xbb,0xff,0xbc,0xff,0xbd,0xff,\
0xbe,0xff,0xbe,0xff,0xbf,0xff,0xc0,0xff,0xc1,0xff,0xc2,0xff,0xc2,0xff,0xc3,0xff,\
0xc4,0xff,0xc5,0xff,0xc6,0xff,0xc6,0xff,0xc7,0xff,0xc8,0xff,0xc9,0xff,0xca,0xff,\
0xca,0xff,0xcb,0xff,0xcc,0xff,0xcd,0xff,0xce,0xff,0xce,0xff,0xcf,0xff,0xd0,0xff,\
0xd1,0xff,0xd2,0xff,0xd2,0xff,0xd3,0xff,0xd4,0xff,0xd5,0xff,0xd6,0xff,0xd6,0xff,\
0xd7,0xff,0xd8,0xff,0xd9,0xff,0xda,0xff,0xda,0xff,0xdb,0xff,0xdc,0xff,0xdd,0xff,\
0xde,0xff,0xde,0xff,0xdf,0xff,0xe0,0xff,0xe1,0xff,0xe2,0xff,0xe2,0xff,0xe3,0xff,\
0xe4,0xff,0xe5,0xff,0xe6,0xff,0xe6,0xff,0xe7,0xff,0xe8,0xff,0xe9,0xff,0xea,0xff,\
0xea,0xff,0xeb,0xff,0xec,0xff,0xed,0xff,0xee,0xff,0xee,0xff,0xef,0xff,0xf0,0xff,\
0xf1,0xff,0xf2,0xff,0xf2,0xff,0xf3,0xff,0xf4,0xff,0xf5,0xff,0xf6,0xff,0xf6,0xff,\
0xf7,0xff,0xf8,0xff,0xf9,0xff,0xfa,0xff,0xfa,0xff,0xfb,0xff,0xfc,0xff,0xfd,0xff,\
0xfe,0xff,0xfe,0xff,0xff,0xff,0x00,0x00,0x01,0x00,0x02,0x00,0x02,0x00,0x03,0x00,\
0x04,0x00,0x05,0x00,0x06,0x00,0x06,0x00,0x07,0x00,0x08,0x00,0x09,0x00,0x0a,0x00,\
0x0a,0x00,0x0b,0x00,0x0c,0x00,0x0d,0x00,0x0e,0x00,0x0e,0x00,0x0f,0x00,0x10,0x00,\
0x11,0x00,0x12,0x00,0x12,0x00,0x13,0x00,0x14,0x00,0x15,0x00,0x16,0x00,0x16,0x00,\
0x17,0x00,0x18,0x00,0x19,0x00,0x1a,0x00,0x1a,0x00,0x1b,0x00,0x1c,0x00,0x1d,0x00,\
0x1e,0x00,0x1e,0x00,0x1f,0x00,0x20,0x00,0x21,0x00,0x22,0x00,0x22,0x00,0x23,0x00,\
0x24,0x00,0x25,0x00,0x26,0x00,0x26,0x00,0x27,0x00,0x28,0x00,0x29,0x00,0x2a,0x00,\
0x2a,0x00,0x2b,0x00,0x2c,0x00,0x2d,0x00,0x2e,0x00,0x2e,0x00,0x2f,0x00,0x30,0x00,\
0x31,0x00,0x32,0x00,0x32,0x00,0x33,0x00,0x34,0x00,0x35,0x00,0x36,0x00,0x36,0x00,\
0x37,0x00,0x38,0x00,0x39,0x00,0x3a,0x00,0x3a,0x00,0x3b,0x00,0x3c,0x00,0x3d,0x00,\
0x3e,0x00,0x3e,0x00,0x3f,0x00,0x40,0x00,0x41,0x00,0x42,0x00,0x42,0x00,0x43,0x00,\
0x44,0x00,0x45,0x00,0x46,0x00,0x46,0x00,0x47,0x00,0x48,0x00,0x49,0x00,0x4a,0x00,\
0x4a,0x00,0x4b,0x00,0x4c,0x00,0x4d,0x00,0x4e,0x00,0x4e,0x00,0x4f,0x00,0x50,0x00,\
0x51,0x00,0x52,0x00,0x52,0x00,0x53,0x00,0x54,0x00,0x55,0x00,0x56,0x00,0x56,0x00,\
0x57,0x00,0x58,0x00,0x59,0x00,0x5a,0x00,0x5a,0x00,0x5b,0x00,0x5c,0x00,0x5d,0x00,\
0x5e,0x00,0x5e,0x00,0x5f,0x00,0x60,0x00,0x61,0x00,0x62,0x00,0x62,0x00,0x63,0x00,\
0x64,0x00,0x65,0x00,0x66,0x00,0x66,0x00,0x67,0x00,0x68,0x00,0x69,0x00,0x6a,0x00,\
0x6a,0x00,0x6b,0x00,0x6c,0x00,0x6d,0x00,0x6e,0x00,0x6e,0x00,0x6f,0x00,0x70,0x00,\
0x71,0x00,0x72,0x00,0x72,0x00,0x73,0x00,0x74,0x00,0x75,0x00,0x76,0x00,0x76,0x00,\
0x77,0x00,0x78,0x00,0x79,0x00,0x7a,0x00,0x7a,0x00,0x7b,0x00,0x7c,0x00,0x7d,0x00,\
0x7e,0x00,0x7e,0x00,0x7f,0x00,0x80,0x00,0x81,0x00,0x82,0x00,0x82,0x00,0x83,0x00,\
0x84,0x00,0x85,0x00,0x86,0x00,0x86,0x00,0x87,0x00,0x88,0x00,0x89,0x00,0x8a,0x00,\
0x8a,0x00,0x8b,0x00,0x8c,0x00,0x8d,0x00,0x8e,0x00,0x8e,0x00,0x8f,0x00,0x90,0x00,\
0x91,0x00,0x92,0x00,0x92,0x00,0x93,0x00,0x94,0x00,0x95,0x00,0x96,0x00,0x96,0x00,\
0x97,0x00,0x98,0x00,0x99,0x00,0x9a,0x00,0x9a,0x00,0x9b,0x00,0x9c,0x00,0x9d,0x00,\
0x9e,0x00,0x9e,0x00,0x9f,0x00,0xa0,0x00,0xa1,0x00,0xa2,0x00,0xa2,0x00,0xa3,0x00,\
0xa4,0x00,0xa5,0x00,0xa6,0x00,0xa6,0x00,0xa7,0x00,0xa8,0x00,0xa9,0x00,0xaa,0x00,\
0xaa,0x00,0xab,0x00,0xac,0x00,0xad,0x00,0xae,0x00,0xae,0x00,0xaf,0x00,0xb0,0x00,\
0xb1,0x00,0xb2,0x00,0xb2,0x00,0xb3,0x00,0xb4,0x00,0xb5,0x00,0xb6,0x00,0xb6,0x00,\
0xb7,0x00,0xb8,0x00,0xb9,0x00,0xba,0x00,0xba,0x00,0xbb,0x00,0xbc,0x00,0xbd,0x00,\
0xbe,0x00,0xbe,0x00,0xbf,0x00,0xc0,0x00,0xc1,0x00,0xc2,0x00,0xc2,0x00,0xc3,0x00,\
0xc4,0x00,0xc5,0x00,0xc6,0x00,0xc6,0x00,0xc7,0x00,0xc8,0x00,0xc9,0x00,0xca,0x00,\
0xca,0x00,0xcb,0x00,0xcc,0x00,0xcd,0x00,0xce,0x00,0xce,0x00,0xcf,0x00,0xd0,0x00,\
0xd1,0x00,0xd2,0x00,0xd2,0x00,0xd3,0x00,0xd4,0x00,0xd5,0x00,0xd6,0x00,0xd6,0x00,\
0xd7,0x00,0xd8,0x00,0xd9,0x00,0xda,0x00,0xda,0x00,0xdb,0x00,0xdc,0x00,0xdd,0x00,\
0xde,0x00,0xde,0x00,0xdf,0x00,0xe0,0x00,0xe1,0x00,0xe2,0x00,0xe2,0x00,0xe3,0x00,\
0xe4,0x00,0xe5,0x00,0xe6,0x00,0xe6,0x00,0xe7,0x00,0xe8,0x00,0xe9,0x00,0xea,0x00,\
0xea,0x00,0xeb,0x00,0xec,0x00,0xed,0x00,0xee,0x00,0xee,0x00,0xef,0x00,0xf0,0x00,\
0xf1,0x00,0xf2,0x00,0xf2,0x00,0xf3,0x00,0xf4,0x00,0xf5,0x00,0xf6,0x00,0xf6,0x00,\
0xf7,0x00,0xf8,0x00,0xf9,0x00,0xfa,0x00,0xfa,0x00,0xfb,0x00,0xfc,0x00,0xfd,0x00,\
0xfe,0x00,0xfe,0x00,0xff,0x00,0x00,0x01,0x01,0x01,0x02,0x01,0x02,0x01,0x03,0x01,\
0x04,0x01,0x05,0x01,0x06,0x01,0x06,0x01,0x07,0x01,0x08,0x01,0x09,0x01,0x0a,0x01,\
0x0a,0x01,0x0b,0x01,0x0c,0x01,0x0d,0x01,0x0e,0x01,0x0e,0x01,0x0f,0x01,0x10,0x01,\
0x11,0x01,0x12,0x01,0x12,0x01,0x13,0x01,0x14,0x01,0x15,0x01,0x16,0x01,0x16,0x01,\
0x17,0x01,0x18,0x01,0x19,0x01,0x1a,0x01,0x1a,0x01,0x1b,0x01,0x1c,0x01,0x1d,0x01,\
0x1e,0x01,0x1e,0x01,0x1f,0x01,0x20,0x01,0x21,0x01,0x22,0x01,0x22,0x01,0x23,0x01,\
0x24,0x01,0x25,0x01,0x26,0x01,0x26,0x01,0x27,0x01,0x28,0x01,0x29,0x01,0x2a,0x01,\
0x2a,0x01,0x2b,0x01,0x2c,0x01,0x2d,0x01,0x2e,0x01,0x2e,0x01,0x2f,0x01,0x30,0x01,\
0x31,0x01,0x32,0x01,0x32,0x01,0x33,0x01,0x34,0x01,0x35,0x01,0x36,0x01,0x36,0x01,\
0x37,0x01,0x38,0x01,0x39,0x01,0x3a,0x01,0x3a,0x01,0x3b,0x01,0x3c,0x01,0x3d,0x01,\
0x3e,0x01,0x3e,0x01,0x3f,0x01,0x40,0x01,0x41,0x01,0x42,0x01,0x42,0x01,0x43,0x01,\
0x44,0x01,0x45,0x01,0x46,0x01,0x46,0x01,0x47,0x01,0x48,0x01,0x49,0x01,0x4a,0x01,\
0x4a,0x01,0x4b,0x01,0x4c,0x01,0x4d,0x01,0x4e,0x01,0x4e,0x01,0x4f,0x01,0x50,0x01,\
0x51,0x01,0x52,0x01,0x52,0x01,0x53,0x01,0x54,0x01,0x55,0x01,0x56,0x01,0x56,0x01,\
0x57,0x01,0x58,0x01,0x59,0x01,0x5a,0x01,0x5a,0x01,0x5b,0x01,0x5c,0x01,0x5d,0x01,\
0x5e,0x01,0x5e,0x01,0x5f,0x01,0x60,0x01,0x61,0x01,0x62,0x01,0x62,0x01,0x63,0x01,\
0x64,0x01,0x65,0x01,0x66,0x01,0x66,0x01,0x67,0x01,0x68,0x01,0x69,0x01,0x6a,0x01,\
0x6a,0x01,0x6b,0x01,0x6c,0x01,0x6d,0x01,0x6e,0x01,0x6e,0x01,0x6f,0x01,0x70,0x01,\
0x71,0x01,0x72,0x01,0x72,0x01,0x73,0x01,0x74,0x01,0x75,0x01,0x76,0x01,0x76,0x01,\
0x77,0x01,0x78,0x01,0x79,0x01,0x7a,0x01,0x7a,0x01,0x7b,0x01,0x7c,0x01,0x7d,0x01,\
0x7e,0x01,0x7e,0x01,0x7f,0x01,0x80,0x01,0x81,0x01,0x82,0x01,0x82,0x01,0x83,0x01,\
0x84,0x01,0x85,0x01,0x86,0x01,0x86,0x01,0x87,0x01,0x88,0x01,0x89,0x01,0x8a,0x01,\
0x8a,0x01,0x8b,0x01,0x8c,0x01,0x8d,0x01,0x8e,0x01,0x8e,0x01,0x8f,0x01,0x90,0x01,\
0x91,0x01,0x92,0x01,0x92,0x01,0x93,0x01,0x94,0x01,0x95,0x01,0x96,0x01,0x96,0x01,\
0x97,0x01,0x98,0x01,0x99,0x01,0x9a,0x01,0x9a,0x01,0x9b,0x01,0x9c,0x01,0x9d,0x01,\
0x9e,0x01,0x9e,0x01,0x9f,0x01,0xa0,0x01,0xa1,0x01,0xa2,0x01,0xa2,0x01,0xa3,0x01,\
0xa4,0x01,0xa5,0x01,0xa6,0x01,0xa6,0x01,0xa7,0x01,0xa8,0x01,0xa9,0x01,0xaa,0x01,\
0xaa,0x01,0xab,0x01,0xac,0x01,0xad,0x01,0xae,0x01,0xae,0x01,0xaf,0x01,0xb0,0x01,\
0xb1,0x01,0xb2,0x01,0xb2,0x01,0xb3,0x01,0xb4,0x01,0xb5,0x01,0xb6,0x01,0xb6,0x01,\
0xb7,0x01,0xb8,0x01,0xb9,0x01,0xba,0x01,0xba,0x01,0xbb,0x01,0xbc,0x01,0xbd,0x01,\
0xbe,0x01,0xbe,0x01,0xbf,0x01,0xc0,0x01,0xc1,0x01,0xc2,0x01,0xc2,0x01,0xc3,0x01,\
0xc4,0x01,0xc5,0x01,0xc6,0x01,0xc6,0x01,0xc7,0x01,0xc8,0x01,0xc9,0x01,0xca,0x01,\
0xca,0x01,0xcb,0x01,0xcc,0x01,0xcd,0x01,0xce,0x01,0xce,0x01,0xcf,0x01,0xd0,0x01,\
0xd1,0x01,0xd2,0x01,0xd2,0x01,0xd3,0x01,0xd4,0x01,0xd5,0x01,0xd6,0x01,0xd6,0x01,\
0xd7,0x01,0xd8,0x01,0xd9,0x01,0xda,0x01,0xda,0x01,0xdb,0x01,0xdc,0x01,0xdd,0x01,\
0xde,0x01,0xde,0x01,0xdf,0x01,0xe0,0x01,0xe1,0x01,0xe2,0x01,0xe2,0x01,0xe3,0x01,\
0xe4,0x01,0xe5,0x01,0xe6,0x01,0xe6,0x01,0xe7,0x01,0xe8,0x01,0xe9,0x01,0xea,0x01,\
0xea,0x01,0xeb,0x01,0xec,0x01,0xed,0x01,0xee,0x01,0xee,0x01,0xef,0x01,0xf0,0x01,\
0xf1,0x01,0xf2,0x01,0xf2,0x01,0xf3,0x01,0xf4,0x01,0xf5,0x01,0xf6,0x01,0xf6,0x01,\
0xf7,0x01,0xf8,0x01,0xf9,0x01,0xfa,0x01,0xfa,0x01,0xfb,0x01,0xfc,0x01,0xfd,0x01,\
0xfe,0x01,0xfe,0x01,0xff,0x01,0x00,0x02,0x01,0x02,0x02,0x02,0x02,0x02,0x03,0x02,\
0x04,0x02,0x05,0x02,0x06,0x02,0x06,0x02,0x07,0x02,0x08,0x02,0x09,0x02,0x0a,0x02,\
0x0a,0x02,0x0b,0x02,0x0c,0x02,0x0d,0x02,0x0e,0x02,0x0e,0x02,0x0f,0x02,0x10,0x02,\
0x11,0x02,0x12,0x02,0x12,0x02,0x13,0x02,0x14,0x02,0x15,0x02,0x16,0x02,0x16,0x02,\
0x17,0x02,0x18,0x02,0x19,0x02,0x1a,0x02,0x1a,0x02,0x1b,0x02,0x1c,0x02,0x1d,0x02,\
0x1e,0x02,0x1e,0x02,0x1f,0x02,0x20,0x02,0x21,0x02,0x22,0x02,0x22,0x02,0x23,0x02,\
0x24,0x02,0x25,0x02,0x26,0x02,0x26,0x02,0x27,0x02,0x28,0x02,0x29,0x02,0x2a,0x02,\
0x2a,0x02,0x2b,0x02,0x2c,0x02,0x2d,0x02,0x2e,0x02,0x2e,0x02,0x2f,0x02,0x30,0x02,\
0x31,0x02,0x32,0x02,0x32,0x02,0x33,0x02,0x34,0x02,0x35,0x02,0x36,0x02,0x36,0x02,\
0x37,0x02,0x38,0x02,0x39,0x02,0x3a,0x02,0x3a,0x02,0x3b,0x02,0x3c,0x02,0x3d,0x02,\
0x3e,0x02,0x3e,0x02,0x3f,0x02,0x40,0x02,0x41,0x02,0x42,0x02,0x42,0x02,0x43,0x02,\
0x44,0x02,0x45,0x02,0x46,0x02,0x46,0x02,0x47,0x02,0x48,0x02,0x49,0x02,0x4a,0x02,\
0x4a,0x02,0x4b,0x02,0x4c,0x02,0x4d,0x02,0x4e,0x02,0x4e,0x02,0x4f,0x02,0x50,0x02,\
0x51,0x02,0x52,0x02,0x52,0x02,0x53,0x02,0x54,0x02,0x55,0x02,0x56,0x02,0x56,0x02,\
0x57,0x02,0x58,0x02,0x59,0x02,0x5a,0x02,0x5a,0x02,0x5b,0x02,0x5c,0x02,0x5d,0x02,\
0x5e,0x02,0x5e,0x02,0x5f,0x02,0x60,0x02,0x61,0x02,0x62,0x02,0x62,0x02,0x63,0x02,\
0x64,0x02,0x65,0x02,0x66,0x02,0x66,0x02,0x67,0x02,0x68,0x02,0x69,0x02,0x6a,0x02,\
0x6a,0x02,0x6b,0x02,0x6c,0x02,0x6d,0x02,0x6e,0x02,0x6e,0x02,0x6f,0x02,0x70,0x02,\
0x71,0x02,0x72,0x02,0x72,0x02,0x73,0x02,0x74,0x02,0x75,0x02,0x76,0x02,0x76,0x02,\
0x77,0x02,0x78,0x02,0x79,0x02,0x7a,0x02,0x7a,0x02,0x7b,0x02,0x7c,0x02,0x7d,0x02,\
0x7e,0x02,0x7e,0x02,0x7f,0x02,0x80,0x02,0x81,0x02,0x82,0x02,0x82,0x02,0x83,0x02,\
0x84,0x02,0x85,0x02,0x86,0x02,0x86,0x02,0x87,0x02,0x88,0x02,0x89,0x02,0x8a,0x02,\
0x8a,0x02,0x8b,0x02,0x8c,0x02,0x8d,0x02,0x8e,0x02,0x8e,0x02,0x8f,0x02,0x90,0x02,\
0x91,0x02,0x92,0x02,0x92,0x02,0x93,0x02,0x94,0x02,0x95,0x02,0x96,0x02,0x96,0x02,\
0x97,0x02,0x98,0x02,0x99,0x02,0x9a,0x02,0x9a,0x02,0x9b,0x02,0x9c,0x02,0x9d,0x02,\
0x9e,0x02,0x9e,0x02,0x9f,0x02,0xa0,0x02,0xa1,0x02,0xa2,0x02,0xa2,0x02,0xa3,0x02,\
0xa4,0x02,0xa5,0x02,0xa6,0x02,0xa6,0x02,0xa7,0x02,0xa8,0x02,0xa9,0x02,0xaa,0x02,\
0xaa,0x02,0xab,0x02,0xac,0x02,0xad,0x02,0xae,0x02,0xae,0x02,0xaf,0x02,0xb0,0x02,\
0xb1,0x02,0xb2,0x02,0xb2,0x02,0xb3,0x02,0xb4,0x02,0xb5,0x02,0xb6,0x02,0xb6,0x02,\
0xb7,0x02,0xb8,0x02,0xb9,0x02,0xba,0x02,0xba,0x02,0xbb,0x02,0xbc,0x02,0xbd,0x02,\
0xbe,0x02,0xbe,0x02,0xbf,0x02,0xc0,0x02,0xc1,0x02,0xc2,0x02,0xc2,0x02,0xc3,0x02,\
0xc4,0x02,0xc5,0x02,0xc6,0x02,0xc6,0x02,0xc7,0x02,0xc8,0x02,0xc9,0x02,0xca,0x02,\
0xca,0x02,0xcb,0x02,0xcc,0x02,0xcd,0x02,0xce,0x02,0xce,0x02,0xcf,0x02,0xd0,0x02,\
0xd1,0x02,0xd2,0x02,0xd2,0x02,0xd3,0x02,0xd4,0x02,0xd5,0x02,0xd6,0x02,0xd6,0x02,\
0xd7,0x02,0xd8,0x02,0xd9,0x02,0xda,0x02,0xda,0x02,0xdb,0x02,0xdc,0x02,0xdd,0x02,\
0xde,0x02,0xde,0x02,0xdf,0x02,0xe0,0x02,0xe1,0x02,0xe2,0x02,0xe2,0x02,0xe3,0x02,\
0xe4,0x02,0xe5,0x02,0xe6,0x02,0xe6,0x02,0xe7,0x02,0xe8,0x02,0xe9,0x02,0xea,0x02,\
0xea,0x02,0xeb,0x02,0xec,0x02,0xed,0x02,0xee,0x02,0xee,0x02,0xef,0x02,0xf0,0x02,\
0xf1,0x02,0xf2,0x02,0xf2,0x02,0xf3,0x02,0xf4,0x02,0xf5,0x02,0xf6,0x02,0xf6,0x02,\
0xf7,0x02,0xf8,0x02,0xf9,0x02,0xfa,0x02,0xfa,0x02,0xfb,0x02,0xfc,0x02,0xfd,0x02,\
0xfe,0x02,0xfe,0x02,0xff,0x02,0x00,0x03,0x01,0x03,0x02,0x03,0x02,0x03,0x03,0x03,\
0x04,0x03,0x05,0x03,0x06,0x03,0x06,0x03,0x07,0x03,0x08,0x03,0x09,0x03,0x0a,0x03,\
0x0a,0x03,0x0b,0x03,0x0c,0x03,0x0d,0x03,0x0e,0x03,0x0e,0x03,0x0f,0x03,0x10,0x03,\
0x11,0x03,0x12,0x03,0x12,0x03,0x13,0x03,0x14,0x03,0x15,0x03,0x16,0x03,0x16,0x03,\
0x17,0x03,0x18,0x03,0x19,0x03,0x1a,0x03,0x1a,0x03,0x1b,0x03,0x1c,0x03,0x1d,0x03,\
0x1e,0x03,0x1e,0x03,0x1f,0x03,0x20,0x03,0x21,0x03,0x22,0x03,0x22,0x03,0x23,0x03,\
0x24,0x03,0x25,0x03,0x26,0x03,0x26,0x03,0x27,0x03,0x28,0x03,0x29,0x03,0x2a,0x03,\
0x2a,0x03,0x2b,0x03,0x2c,0x03,0x2d,0x03,0x2e,0x03,0x2e,0x03,0x2f,0x03,0x30,0x03,\
0x31,0x03,0x32,0x03,0x32,0x03,0x33,0x03,0x34,0x03,0x35,0x03,0x36,0x03,0x36,0x03,\
0x37,0x03,0x38,0x03,0x39,0x03,0x3a,0x03,0x3a,0x03,0x3b,0x03,0x3c,0x03,0x3d,0x03,\
0x3e,0x03,0x3e,0x03,0x3f,0x03,0x40,0x03,0x41,0x03,0x42,0x03,0x42,0x03,0x43,0x03,\
0x44,0x03,0x45,0x03,0x46,0x03,0x46,0x03,0x47,0x03,0x48,0x03,0x49,0x03,0x4a,0x03,\
0x4a,0x03,0x4b,0x03,0x4c,0x03,0x4d,0x03,0x4e,0x03,0x4e,0x03,0x4f,0x03,0x50,0x03,\
0x51,0x03,0x52,0x03,0x52,0x03,0x53,0x03,0x54,0x03,0x55,0x03,0x56,0x03,0x56,0x03,\
0x57,0x03,0x58,0x03,0x59,0x03,0x5a,0x03,0x5a,0x03,0x5b,0x03,0x5c,0x03,0x5d,0x03,\
0x5e,0x03,0x5e,0x03,0x5f,0x03,0x60,0x03,0x61,0x03,0x62,0x03,0x62,0x03,0x63,0x03,\
0x64,0x03,0x65,0x03,0x66,0x03,0x66,0x03,0x67,0x03,0x68,0x03,0x69,0x03,0x6a,0x03,\
0x6a,0x03,0x6b,0x03,0x6c,0x03,0x6d,0x03,0x6e,0x03,0x6e,0x03,0x6f,0x03,0x70,0x03,\
0x71,0x03,0x72,0x03,0x72,0x03,0x73,0x03,0x74,0x03,0x75,0x03,0x76,0x03,0x76,0x03,\
0x77,0x03,0x78,0x03,0x79,0x03,0x7a,0x03,0x7a,0x03,0x7b,0x03,0x7c,0x03,0x7d,0x03,\
0x7e,0x03,0x7e,0x03,0x7f,0x03,0x80,0x03,0x81,0x03,0x82,0x03,0x82,0x03,0x83,0x03,\
0x84,0x03,0x85,0x03,0x86,0x03,0x86,0x03,0x87,0x03,0x88,0x03,0x89,0x03,0x8a,0x03,\
0x8a,0x03,0x8b,0x03,0x8c,0x03,0x8d,0x03,0x8e,0x03,0x8e,0x03,0x8f,0x03,0x90,0x03,\
0x91,0x03,0x92,0x03,0x92,0x03,0x93,0x03,0x94,0x03,0x95,0x03,0x96,0x03,0x96,0x03,\
0x97,0x03,0x98,0x03,0x99,0x03,0x9a,0x03,0x9a,0x03,0x9b,0x03,0x9c,0x03,0x9d,0x03,\
0x9e,0x03,0x9e,0x03,0x9f,0x03,0xa0,0x03,0xa1,0x03,0xa2,0x03,0xa2,0x03,0xa3,0x03,\
0xa4,0x03,0xa5,0x03,0xa6,0x03,0xa6,0x03,0xa7,0x03,0xa8,0x03,0xa9,0x03,0xaa,0x03,\
0xaa,0x03,0xab,0x03,0xac,0x03,0xad,0x03,0xae,0x03,0xae,0x03,0xaf,0x03,0xb0,0x03,\
0xb1,0x03,0xb2,0x03,0xb2,0x03,0xb3,0x03,0xb4,0x03,0xb5,0x03,0xb6,0x03,0xb6,0x03,\
0xb7,0x03,0xb8,0x03,0xb9,0x03,0xba,0x03,0xba,0x03,0xbb,0x03,0xbc,0x03,0xbd,0x03,\
0xbe,0x03,0xbe,0x03,0xbf,0x03,0xc0,0x03,0xc1,0x03,0xc2,0x03,0xc2,0x03,0xc3,0x03,\
0xc4,0x03,0xc5,0x03,0xc6,0x03,0xc6,0x03,0xc7,0x03,0xc8,0x03,0xc9,0x03,0xca,0x03,\
0xca,0x03,0xcb,0x03,0xcc,0x03,0xcd,0x03,0xce,0x03,0xce,0x03,0xcf,0x03,0xd0,0x03,\
0xd1,0x03,0xd2,0x03,0xd2,0x03,0xd3,0x03,0xd4,0x03,0xd5,0x03,0xd6,0x03,0xd6,0x03,\
0xd7,0x03,0xd8,0x03,0xd9,0x03,0xda,0x03,0xda,0x03,0xdb,0x03,0xdc,0x03,0xdd,0x03,\
0xde,0x03,0xde,0x03,0xdf,0x03,0xe0,0x03,0xe1,0x03,0xe2,0x03,0xe2,0x03,0xe3,0x03,\
0xe4,0x03,0xe5,0x03,0xe6,0x03,0xe6,0x03,0xe7,0x03,0xe8,0x03,0xe9,0x03,0xea,0x03,\
0xea,0x03,0xeb,0x03,0xec,0x03,0xed,0x03,0xee,0x03,0xee,0x03,0xef,0x03,0xf0,0x03,\
0xf1,0x03,0xf2,0x03,0xf2,0x03,0xf3,0x03,0xf4,0x03,0xf5,0x03,0xf6,0x03,0xf6,0x03,\
0xf7,0x03,0xf8,0x03,0xf9,0x03,0xfa,0x03,0xfa,0x03,0xfb,0x03,0xfc,0x03,0xfd,0x03,\
0xfe,0x03,0xfe,0x03,0xff,0x03,0x00,0x04,0x01,0x04,0x02,0x04,0x02,0x04,0x03,0x04,\
0x04,0x04,0x05,0x04,0x06,0x04,0x06,0x04,0x07,0x04,0x08,0x04,0x09,0x04,0x0a,0x04,\
0x0a,0x04,0x0b,0x04,0x0c,0x04,0x0d,0x04,0x0e,0x04,0x0e,0x04,0x0f,0x04,0x10,0x04,\
0x11,0x04,0x12,0x04,0x12,0x04,0x13,0x04,0x14,0x04,0x15,0x04,0x16,0x04,0x16,0x04,\
0x17,0x04,0x18,0x04,0x19,0x04,0x1a,0x04,0x1a,0x04,0x1b,0x04,0x1c,0x04,0x1d,0x04,\
0x1e,0x04,0x1e,0x04,0x1f,0x04,0x20,0x04,0x21,0x04,0x22,0x04,0x22,0x04,0x23,0x04,\
0x24,0x04,0x25,0x04,0x26,0x04,0x26,0x04,0x27,0x04,0x28,0x04,0x29,0x04,0x2a,0x04,\
0x2a,0x04,0x2b,0x04,0x2c,0x04,0x2d,0x04,0x2e,0x04,0x2e,0x04,0x2f,0x04,0x30,0x04,\
0x31,0x04,0x32,0x04,0x32,0x04,0x33,0x04,0x34,0x04,0x35,0x04,0x36,0x04,0x36,0x04,\
0x37,0x04,0x38,0x04,0x39,0x04,0x3a,0x04,0x3a,0x04,0x3b,0x04,0x3c,0x04,0x3d,0x04,\
0x3e,0x04,0x3e,0x04,0x3f,0x04,0x40,0x04,0x41,0x04,0x42,0x04,0x42,0x04,0x43,0x04,\
0x44,0x04,0x45,0x04,0x46,0x04,0x46,0x04,0x47,0x04,0x48,0x04,0x49,0x04,0x4a,0x04,\
0x4a,0x04,0x4b,0x04,0x4c,0x04,0x4d,0x04,0x4e,0x04,0x4e,0x04,0x4f,0x04,0x50,0x04,\
0x51,0x04,0x52,0x04,0x52,0x04,0x53,0x04,0x54,0x04,0x55,0x04,0x56,0x04,0x56,0x04,\
0x57,0x04,0x58,0x04,0x59,0x04,0x5a,0x04,0x5a,0x04,0x5b,0x04,0x5c,0x04,0x5d,0x04,\
0x5e,0x04,0x5e,0x04,0x5f,0x04,0x60,0x04,0x61,0x04,0x62,0x04,0x62,0x04,0x63,0x04,\
0x64,0x04,0x65,0x04,0x66,0x04,0x66,0x04,0x67,0x04,0x68,0x04,0x69,0x04,0x6a,0x04,\
0x6a,0x04,0x6b,0x04,0x6c,0x04,0x6d,0x04,0x6e,0x04,0x6e,0x04,0x6f,0x04,0x70,0x04,\
0x71,0x04,0x72,0x04,0x72,0x04,0x73,0x04,0x74,0x04,0x75,0x04,0x76,0x04,0x76,0x04,\
0x77,0x04,0x78,0x04,0x79,0x04,0x7a,0x04,0x7a,0x04,0x7b,0x04,0x7c,0x04,0x7d,0x04,\
0x7e,0x04,0x7e,0x04,0x7f,0x04,0x80,0x04,0x81,0x04,0x82,0x04,0x82,0x04,0x83,0x04,\
0x84,0x04,0x85,0x04,0x86,0x04,0x86,0x04,0x87,0x04,0x88,0x04,0x89,0x04,0x8a,0x04,\
0x8a,0x04,0x8b,0x04,0x8c,0x04,0x8d,0x04,0x8e,0x04,0x8e,0x04,0x8f,0x04,0x90,0x04,\
0x91,0x04,0x92,0x04,0x92,0x04,0x93,0x04,0x94,0x04,0x95,0x04,0x96,0x04,0x96,0x04,\
0x97,0x04,0x98,0x04,0x99,0x04,0x9a,0x04,0x9a,0x04,0x9b,0x04,0x9c,0x04,0x9d,0x04,\
0x9e,0x04,0x9e,0x04,0x9f,0x04,0xa0,0x04,0xa1,0x04,0xa2,0x04,0xa2,0x04,0xa3,0x04,\
0xa4,0x04,0xa5,0x04,0xa6,0x04,0xa6,0x04,0xa7,0x04,0xa8,0x04,0xa9,0x04,0xaa,0x04,\
0xaa,0x04,0xab,0x04,0xac,0x04,0xad,0x04,0xae,0x04,0xae,0x04,0xaf,0x04,0xb0,0x04,\
0xb1,0x04,0xb2,0x04,0xb2,0x04,0xb3,0x04,0xb4,0x04,0xb5,0x04,0xb6,0x04,0xb6,0x04,\
0xb7,0x04,0xb8,0x04,0xb9,0x04,0xba,0x04,0xba,0x04,0xbb,0x04,0xbc,0x04,0xbd,0x04,\
0xbe,0x04,0xbe,0x04,0xbf,0x04,0xc0,0x04,0xc1,0x04,0xc2,0x04,0xc2,0x04,0xc3,0x04,\
0xc4,0x04,0xc5,0x04,0xc6,0x04,0xc6,0x04,0xc7,0x04,0xc8,0x04,0xc9,0x04,0xca,0x04,\
0xca,0x04,0xcb,0x04,0xcc,0x04,0xcd,0x04,0xce,0x04,0xce,0x04,0xcf,0x04,0xd0,0x04,\
0xd1,0x04,0xd2,0x04,0xd2,0x04,0xd3,0x04,0xd4,0x04,0xd5,0x04,0xd6,0x04,0xd6,0x04,\
0xd7,0x04,0xd8,0x04,0xd9,0x04,0xda,0x04,0xda,0x04,0xdb,0x04,0xdc,0x04,0xdd,0x04,\
0xde,0x04,0xde,0x04,0xdf,0x04,0xe0,0x04,0xe1,0x04,0xe2,0x04,0xe2,0x04,0xe3,0x04,\
0xe4,0x04,0xe5,0x04,0xe6,0x04,0xe6,0x04,0xe7,0x04,0xe8,0x04,0xe9,0x04,0xea,0x04,\
0xea,0x04,0xeb,0x04,0xec,0x04,0xed,0x04,0xee,0x04,0xee,0x04,0xef,0x04,0xf0,0x04,\
0xf1,0x04,0xf2,0x04,0xf2,0x04,0xf3,0x04,0xf4,0x04,0xf5,0x04,0xf6,0x04,0xf6,0x04,\
0xf7,0x04,0xf8,0x04,0xf9,0x04,0xfa,0x04,0xfa,0x04,0xfb,0x04,0xfc,0x04,0xfd,0x04,\
0xfe,0x04,0xfe,0x04,0xff,0x04,0x00,0x05,0x01,0x05,0x02,0x05,0x02,0x05,0x03,0x05,\
0x04,0x05,0x05,0x05,0x06,0x05,0x06,0x05,0x07,0x05,0x08,0x05,0x09,0x05,0x0a,0x05,\
0x0a,0x05,0x0b,0x05,0x0c,0x05,0x0d,0x05,0x0e,0x05,0x0e,0x05,0x0f,0x05,0x10,0x05,\
0x11,0x05,0x12,0x05,0x12,0x05,0x13,0x05,0x14,0x05,0x15,0x05,0x16,0x05,0x16,0x05,\
0x17,0x05,0x18,0x05,0x19,0x05,0x1a,0x05,0x1a,0x05,0x1b,0x05,0x1c,0x05,0x1d,0x05,\
0x1e,0x05,0x1e,0x05,0x1f,0x05,0x20,0x05,0x21,0x05,0x22,0x05,0x22,0x05,0x23,0x05,\
0x24,0x05,0x25,0x05,0x26,0x05,0x26,0x05,0x27,0x05,0x28,0x05,0x29,0x05,0x2a,0x05,\
0x2a,0x05,0x2b,0x05,0x2c,0x05,0x2d,0x05,0x2e,0x05,0x2e,0x05,0x2f,0x05,0x30,0x05,\
0x31,0x05,0x32,0x05,0x32,0x05,0x33,0x05,0x34,0x05,0x35,0x05,0x36,0x05,0x36,0x05,\
0x37,0x05,0x38,0x05,0x39,0x05,0x3a,0x05,0x3a,0x05,0x3b,0x05,0x3c,0x05,0x3d,0x05,\
0x3e,0x05,0x3e,0x05,0x3f,0x05,0x40,0x05,0x41,0x05,0x42,0x05,0x42,0x05,0x43,0x05,\
0x44,0x05,0x45,0x05,0x46,0x05,0x46,0x05,0x47,0x05,0x48,0x05,0x49,0x05,0x4a,0x05,\
0x4a,0x05,0x4b,0x05,0x4c,0x05,0x4d,0x05,0x4e,0x05,0x4e,0x05,0x4f,0x05,0x50,0x05,\
0x51,0x05,0x52,0x05,0x52,0x05,0x53,0x05,0x54,0x05,0x55,0x05,0x56,0x05,0x56,0x05,\
0x57,0x05,0x58,0x05,0x59,0x05,0x5a,0x05,0x5a,0x05,0x5b,0x05,0x5c,0x05,0x5d,0x05,\
0x5e,0x05,0x5e,0x05,0x5f,0x05,0x60,0x05,0x61,0x05,0x62,0x05,0x62,0x05,0x63,0x05,\
0x64,0x05,0x65,0x05,0x66,0x05,0x66,0x05,0x67,0x05,0x68,0x05,0x69,0x05,0x6a,0x05,\
0x6a,0x05,0x6b,0x05,0x6c,0x05,0x6d,0x05,0x6e,0x05,0x6e,0x05,0x6f,0x05,0x70,0x05,\
0x71,0x05,0x72,0x05,0x72,0x05,0x73,0x05,0x74,0x05,0x75,0x05,0x76,0x05,0x76,0x05,\
0x77,0x05,0x78,0x05,0x79,0x05,0x7a,0x05,0x7a,0x05,0x7b,0x05,0x7c,0x05,0x7d,0x05,\
0x7e,0x05,0x7e,0x05,0x7f,0x05,0x80,0x05,0x81,0x05,0x82,0x05,0x82,0x05,0x83,0x05,\
0x84,0x05,0x85,0x05,0x86,0x05,0x86,0x05,0x87,0x05,0x88,0x05,0x89,0x05,0x8a,0x05,\
0x8a,0x05,0x8b,0x05,0x8c,0x05,0x8d,0x05,0x8e,0x05,0x8e,0x05,0x8f,0x05,0x90,0x05,\
0x91,0x05,0x92,0x05,0x92,0x05,0x93,0x05,0x94,0x05,0x95,0x05,0x96,0x05,0x96,0x05,\
0x97,0x05,0x98,0x05,0x99,0x05,0x9a,0x05,0x9a,0x05,0x9b,0x05,0x9c,0x05,0x9d,0x05,\
0x9e,0x05,0x9e,0x05,0x9f,0x05,0xa0,0x05,0xa1,0x05,0xa2,0x05,0xa2,0x05,0xa3,0x05,\
0xa4,0x05,0xa5,0x05,0xa6,0x05,0xa6,0x05,0xa7,0x05,0xa8,0x05,0xa9,0x05,0xaa,0x05,\
0xaa,0x05,0xab,0x05,0xac,0x05,0xad,0x05,0xae,0x05,0xae,0x05,0xaf,0x05,0xb0,0x05,\
0xb1,0x05,0xb2,0x05,0xb2,0x05,0xb3,0x05,0xb4,0x05,0xb5,0x05,0xb6,0x05,0xb6,0x05,\
0xb7,0x05,0xb8,0x05,0xb9,0x05,0xba,0x05,0xba,0x05,0xbb,0x05,0xbc,0x05,0xbd,0x05,\
0xbe,0x05,0xbe,0x05,0xbf,0x05,0xc0,0x05,0xc1,0x05,0xc2,0x05,0xc2,0x05,0xc3,0x05,\
0xc4,0x05,0xc5,0x05,0xc6,0x05,0xc6,0x05,0xc7,0x05,0xc8,0x05,0xc9,0x05,0xca,0x05,\
0xca,0x05,0xcb,0x05,0xcc,0x05,0xcd,0x05,0xce,0x05,0xce,0x05,0xcf,0x05,0xd0,0x05,\
0xd1,0x05,0xd2,0x05,0xd2,0x05,0xd3,0x05,0xd4,0x05,0xd5,0x05,0xd6,0x05,0xd6,0x05,\
0xd7,0x05,0xd8,0x05,0xd9,0x05,0xda,0x05,0xda,0x05,0xdb,0x05,0xdc,0x05,0xdd,0x05,\
0xde,0x05,0xde,0x05,0xdf,0x05,0xe0,0x05,0xe1,0x05,0xe2,0x05,0xe2,0x05,0xe3,0x05,\
0xe4,0x05,0xe5,0x05,0xe6,0x05,0xe6,0x05,0xe7,0x05,0xe8,0x05,0xe9,0x05,0xea,0x05,\
0xea,0x05,0xeb,0x05,0xec,0x05,0xed,0x05,0xee,0x05,0xee,0x05,0xef,0x05,0xf0,0x05,\
0xf1,0x05,0xf2,0x05,0xf2,0x05,0xf3,0x05,0xf4,0x05,0xf5,0x05,0xf6,0x05,0xf6,0x05,\
0xf7,0x05,0xf8,0x05,0xf9,0x05,0xfa,0x05,0xfa,0x05,0xfb,0x05,0xfc,0x05,0xfd,0x05,\
0xfe,0x05,0xfe,0x05,0xff,0x05,0x00,0x06,0x01,0x06,0x02,0x06,0x02,0x06,0x03,0x06,\
0x04,0x06,0x05,0x06,0x06,0x06,0x06,0x06,0x07,0x06,0x08,0x06,0x09,0x06,0x0a,0x06,\
0x0a,0x06,0x0b,0x06,0x0c,0x06,0x0d,0x06,0x0e,0x06,0x0e,0x06,0x0f,0x06,0x10,0x06,\
0x11,0x06,0x12,0x06,0x12,0x06,0x13,0x06,0x14,0x06,0x15,0x06,0x16,0x06,0x16,0x06,\
0x17,0x06,0x18,0x06,0x19,0x06,0x1a,0x06,0x1a,0x06,0x1b,0x06,0x1c,0x06,0x1d,0x06,\
0x1e,0x06,0x1e,0x06,0x1f,0x06,0x20,0x06,0x21,0x06,0x22,0x06,0x22,0x06,0x23,0x06,\
0x24,0x06,0x25,0x06,0x26,0x06,0x26,0x06,0x27,0x06,0x28,0x06,0x29,0x06,0x2a,0x06,\
0x2a,0x06,0x2b,0x06,0x2c,0x06,0x2d,0x06,0x2e,0x06,0x2e,0x06,0x2f,0x06,0x30,0x06,\
0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,\
0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,\
0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,\
0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,\
0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,\
0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,\
0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,\
0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,\
0x30,0x06,0x30,0x06,0x30,0x06,0x01,0x00,0x01,0x00,0xfe,0xff,0xfa,0xff,0xf6,0xff,\
0xfa,0xff,0x00,0x00,0x0c,0x00,0xf6,0xff,0x0c,0x00,0x30,0x00,0x00,0x00,0x05,0x00,\
0x20,0x01,0x00,0x00,0xc0,0x24,0x80,0x01,0x5c,0x00,0x00,0x01,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,\
0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x80,0xfa,0x81,0xfa,\
0x82,0xfa,0x82,0xfa,0x83,0xfa,0x84,0xfa,0x85,0xfa,0x86,0xfa,0x86,0xfa,0x87,0xfa,\
0x88,0xfa,0x89,0xfa,0x8a,0xfa,0x8a,0xfa,0x8b,0xfa,0x8c,0xfa,0x8d,0xfa,0x8e,0xfa,\
0x8e,0xfa,0x8f,0xfa,0x90,0xfa,0x91,0xfa,0x92,0xfa,0x92,0xfa,0x93,0xfa,0x94,0xfa,\
0x95,0xfa,0x96,0xfa,0x96,0xfa,0x97,0xfa,0x98,0xfa,0x99,0xfa,0x9a,0xfa,0x9a,0xfa,\
0x9b,0xfa,0x9c,0xfa,0x9d,0xfa,0x9e,0xfa,0x9e,0xfa,0x9f,0xfa,0xa0,0xfa,0xa1,0xfa,\
0xa2,0xfa,0xa2,0xfa,0xa3,0xfa,0xa4,0xfa,0xa5,0xfa,0xa6,0xfa,0xa6,0xfa,0xa7,0xfa,\
0xa8,0xfa,0xa9,0xfa,0xaa,0xfa,0xaa,0xfa,0xab,0xfa,0xac,0xfa,0xad,0xfa,0xae,0xfa,\
0xae,0xfa,0xaf,0xfa,0xb0,0xfa,0xb1,0xfa,0xb2,0xfa,0xb2,0xfa,0xb3,0xfa,0xb4,0xfa,\
0xb5,0xfa,0xb6,0xfa,0xb6,0xfa,0xb7,0xfa,0xb8,0xfa,0xb9,0xfa,0xba,0xfa,0xba,0xfa,\
0xbb,0xfa,0xbc,0xfa,0xbd,0xfa,0xbe,0xfa,0xbe,0xfa,0xbf,0xfa,0xc0,0xfa,0xc1,0xfa,\
0xc2,0xfa,0xc2,0xfa,0xc3,0xfa,0xc4,0xfa,0xc5,0xfa,0xc6,0xfa,0xc6,0xfa,0xc7,0xfa,\
0xc8,0xfa,0xc9,0xfa,0xca,0xfa,0xca,0xfa,0xcb,0xfa,0xcc,0xfa,0xcd,0xfa,0xce,0xfa,\
0xce,0xfa,0xcf,0xfa,0xd0,0xfa,0xd1,0xfa,0xd2,0xfa,0xd2,0xfa,0xd3,0xfa,0xd4,0xfa,\
0xd5,0xfa,0xd6,0xfa,0xd6,0xfa,0xd7,0xfa,0xd8,0xfa,0xd9,0xfa,0xda,0xfa,0xda,0xfa,\
0xdb,0xfa,0xdc,0xfa,0xdd,0xfa,0xde,0xfa,0xde,0xfa,0xdf,0xfa,0xe0,0xfa,0xe1,0xfa,\
0xe2,0xfa,0xe2,0xfa,0xe3,0xfa,0xe4,0xfa,0xe5,0xfa,0xe6,0xfa,0xe6,0xfa,0xe7,0xfa,\
0xe8,0xfa,0xe9,0xfa,0xea,0xfa,0xea,0xfa,0xeb,0xfa,0xec,0xfa,0xed,0xfa,0xee,0xfa,\
0xee,0xfa,0xef,0xfa,0xf0,0xfa,0xf1,0xfa,0xf2,0xfa,0xf2,0xfa,0xf3,0xfa,0xf4,0xfa,\
0xf5,0xfa,0xf6,0xfa,0xf6,0xfa,0xf7,0xfa,0xf8,0xfa,0xf9,0xfa,0xfa,0xfa,0xfa,0xfa,\
0xfb,0xfa,0xfc,0xfa,0xfd,0xfa,0xfe,0xfa,0xfe,0xfa,0xff,0xfa,0x00,0xfb,0x01,0xfb,\
0x02,0xfb,0x02,0xfb,0x03,0xfb,0x04,0xfb,0x05,0xfb,0x06,0xfb,0x06,0xfb,0x07,0xfb,\
0x08,0xfb,0x09,0xfb,0x0a,0xfb,0x0a,0xfb,0x0b,0xfb,0x0c,0xfb,0x0d,0xfb,0x0e,0xfb,\
0x0e,0xfb,0x0f,0xfb,0x10,0xfb,0x11,0xfb,0x12,0xfb,0x12,0xfb,0x13,0xfb,0x14,0xfb,\
0x15,0xfb,0x16,0xfb,0x16,0xfb,0x17,0xfb,0x18,0xfb,0x19,0xfb,0x1a,0xfb,0x1a,0xfb,\
0x1b,0xfb,0x1c,0xfb,0x1d,0xfb,0x1e,0xfb,0x1e,0xfb,0x1f,0xfb,0x20,0xfb,0x21,0xfb,\
0x22,0xfb,0x22,0xfb,0x23,0xfb,0x24,0xfb,0x25,0xfb,0x26,0xfb,0x26,0xfb,0x27,0xfb,\
0x28,0xfb,0x29,0xfb,0x2a,0xfb,0x2a,0xfb,0x2b,0xfb,0x2c,0xfb,0x2d,0xfb,0x2e,0xfb,\
0x2e,0xfb,0x2f,0xfb,0x30,0xfb,0x31,0xfb,0x32,0xfb,0x32,0xfb,0x33,0xfb,0x34,0xfb,\
0x35,0xfb,0x36,0xfb,0x36,0xfb,0x37,0xfb,0x38,0xfb,0x39,0xfb,0x3a,0xfb,0x3a,0xfb,\
0x3b,0xfb,0x3c,0xfb,0x3d,0xfb,0x3e,0xfb,0x3e,0xfb,0x3f,0xfb,0x40,0xfb,0x41,0xfb,\
0x42,0xfb,0x42,0xfb,0x43,0xfb,0x44,0xfb,0x45,0xfb,0x46,0xfb,0x46,0xfb,0x47,0xfb,\
0x48,0xfb,0x49,0xfb,0x4a,0xfb,0x4a,0xfb,0x4b,0xfb,0x4c,0xfb,0x4d,0xfb,0x4e,0xfb,\
0x4e,0xfb,0x4f,0xfb,0x50,0xfb,0x51,0xfb,0x52,0xfb,0x52,0xfb,0x53,0xfb,0x54,0xfb,\
0x55,0xfb,0x56,0xfb,0x56,0xfb,0x57,0xfb,0x58,0xfb,0x59,0xfb,0x5a,0xfb,0x5a,0xfb,\
0x5b,0xfb,0x5c,0xfb,0x5d,0xfb,0x5e,0xfb,0x5e,0xfb,0x5f,0xfb,0x60,0xfb,0x61,0xfb,\
0x62,0xfb,0x62,0xfb,0x63,0xfb,0x64,0xfb,0x65,0xfb,0x66,0xfb,0x66,0xfb,0x67,0xfb,\
0x68,0xfb,0x69,0xfb,0x6a,0xfb,0x6a,0xfb,0x6b,0xfb,0x6c,0xfb,0x6d,0xfb,0x6e,0xfb,\
0x6e,0xfb,0x6f,0xfb,0x70,0xfb,0x71,0xfb,0x72,0xfb,0x72,0xfb,0x73,0xfb,0x74,0xfb,\
0x75,0xfb,0x76,0xfb,0x76,0xfb,0x77,0xfb,0x78,0xfb,0x79,0xfb,0x7a,0xfb,0x7a,0xfb,\
0x7b,0xfb,0x7c,0xfb,0x7d,0xfb,0x7e,0xfb,0x7e,0xfb,0x7f,0xfb,0x80,0xfb,0x81,0xfb,\
0x82,0xfb,0x82,0xfb,0x83,0xfb,0x84,0xfb,0x85,0xfb,0x86,0xfb,0x86,0xfb,0x87,0xfb,\
0x88,0xfb,0x89,0xfb,0x8a,0xfb,0x8a,0xfb,0x8b,0xfb,0x8c,0xfb,0x8d,0xfb,0x8e,0xfb,\
0x8e,0xfb,0x8f,0xfb,0x90,0xfb,0x91,0xfb,0x92,0xfb,0x92,0xfb,0x93,0xfb,0x94,0xfb,\
0x95,0xfb,0x96,0xfb,0x96,0xfb,0x97,0xfb,0x98,0xfb,0x99,0xfb,0x9a,0xfb,0x9a,0xfb,\
0x9b,0xfb,0x9c,0xfb,0x9d,0xfb,0x9e,0xfb,0x9e,0xfb,0x9f,0xfb,0xa0,0xfb,0xa1,0xfb,\
0xa2,0xfb,0xa2,0xfb,0xa3,0xfb,0xa4,0xfb,0xa5,0xfb,0xa6,0xfb,0xa6,0xfb,0xa7,0xfb,\
0xa8,0xfb,0xa9,0xfb,0xaa,0xfb,0xaa,0xfb,0xab,0xfb,0xac,0xfb,0xad,0xfb,0xae,0xfb,\
0xae,0xfb,0xaf,0xfb,0xb0,0xfb,0xb1,0xfb,0xb2,0xfb,0xb2,0xfb,0xb3,0xfb,0xb4,0xfb,\
0xb5,0xfb,0xb6,0xfb,0xb6,0xfb,0xb7,0xfb,0xb8,0xfb,0xb9,0xfb,0xba,0xfb,0xba,0xfb,\
0xbb,0xfb,0xbc,0xfb,0xbd,0xfb,0xbe,0xfb,0xbe,0xfb,0xbf,0xfb,0xc0,0xfb,0xc1,0xfb,\
0xc2,0xfb,0xc2,0xfb,0xc3,0xfb,0xc4,0xfb,0xc5,0xfb,0xc6,0xfb,0xc6,0xfb,0xc7,0xfb,\
0xc8,0xfb,0xc9,0xfb,0xca,0xfb,0xca,0xfb,0xcb,0xfb,0xcc,0xfb,0xcd,0xfb,0xce,0xfb,\
0xce,0xfb,0xcf,0xfb,0xd0,0xfb,0xd1,0xfb,0xd2,0xfb,0xd2,0xfb,0xd3,0xfb,0xd4,0xfb,\
0xd5,0xfb,0xd6,0xfb,0xd6,0xfb,0xd7,0xfb,0xd8,0xfb,0xd9,0xfb,0xda,0xfb,0xda,0xfb,\
0xdb,0xfb,0xdc,0xfb,0xdd,0xfb,0xde,0xfb,0xde,0xfb,0xdf,0xfb,0xe0,0xfb,0xe1,0xfb,\
0xe2,0xfb,0xe2,0xfb,0xe3,0xfb,0xe4,0xfb,0xe5,0xfb,0xe6,0xfb,0xe6,0xfb,0xe7,0xfb,\
0xe8,0xfb,0xe9,0xfb,0xea,0xfb,0xea,0xfb,0xeb,0xfb,0xec,0xfb,0xed,0xfb,0xee,0xfb,\
0xee,0xfb,0xef,0xfb,0xf0,0xfb,0xf1,0xfb,0xf2,0xfb,0xf2,0xfb,0xf3,0xfb,0xf4,0xfb,\
0xf5,0xfb,0xf6,0xfb,0xf6,0xfb,0xf7,0xfb,0xf8,0xfb,0xf9,0xfb,0xfa,0xfb,0xfa,0xfb,\
0xfb,0xfb,0xfc,0xfb,0xfd,0xfb,0xfe,0xfb,0xfe,0xfb,0xff,0xfb,0x00,0xfc,0x01,0xfc,\
0x02,0xfc,0x02,0xfc,0x03,0xfc,0x04,0xfc,0x05,0xfc,0x06,0xfc,0x06,0xfc,0x07,0xfc,\
0x08,0xfc,0x09,0xfc,0x0a,0xfc,0x0a,0xfc,0x0b,0xfc,0x0c,0xfc,0x0d,0xfc,0x0e,0xfc,\
0x0e,0xfc,0x0f,0xfc,0x10,0xfc,0x11,0xfc,0x12,0xfc,0x12,0xfc,0x13,0xfc,0x14,0xfc,\
0x15,0xfc,0x16,0xfc,0x16,0xfc,0x17,0xfc,0x18,0xfc,0x19,0xfc,0x1a,0xfc,0x1a,0xfc,\
0x1b,0xfc,0x1c,0xfc,0x1d,0xfc,0x1e,0xfc,0x1e,0xfc,0x1f,0xfc,0x20,0xfc,0x21,0xfc,\
0x22,0xfc,0x22,0xfc,0x23,0xfc,0x24,0xfc,0x25,0xfc,0x26,0xfc,0x26,0xfc,0x27,0xfc,\
0x28,0xfc,0x29,0xfc,0x2a,0xfc,0x2a,0xfc,0x2b,0xfc,0x2c,0xfc,0x2d,0xfc,0x2e,0xfc,\
0x2e,0xfc,0x2f,0xfc,0x30,0xfc,0x31,0xfc,0x32,0xfc,0x32,0xfc,0x33,0xfc,0x34,0xfc,\
0x35,0xfc,0x36,0xfc,0x36,0xfc,0x37,0xfc,0x38,0xfc,0x39,0xfc,0x3a,0xfc,0x3a,0xfc,\
0x3b,0xfc,0x3c,0xfc,0x3d,0xfc,0x3e,0xfc,0x3e,0xfc,0x3f,0xfc,0x40,0xfc,0x41,0xfc,\
0x42,0xfc,0x42,0xfc,0x43,0xfc,0x44,0xfc,0x45,0xfc,0x46,0xfc,0x46,0xfc,0x47,0xfc,\
0x48,0xfc,0x49,0xfc,0x4a,0xfc,0x4a,0xfc,0x4b,0xfc,0x4c,0xfc,0x4d,0xfc,0x4e,0xfc,\
0x4e,0xfc,0x4f,0xfc,0x50,0xfc,0x51,0xfc,0x52,0xfc,0x52,0xfc,0x53,0xfc,0x54,0xfc,\
0x55,0xfc,0x56,0xfc,0x56,0xfc,0x57,0xfc,0x58,0xfc,0x59,0xfc,0x5a,0xfc,0x5a,0xfc,\
0x5b,0xfc,0x5c,0xfc,0x5d,0xfc,0x5e,0xfc,0x5e,0xfc,0x5f,0xfc,0x60,0xfc,0x61,0xfc,\
0x62,0xfc,0x62,0xfc,0x63,0xfc,0x64,0xfc,0x65,0xfc,0x66,0xfc,0x66,0xfc,0x67,0xfc,\
0x68,0xfc,0x69,0xfc,0x6a,0xfc,0x6a,0xfc,0x6b,0xfc,0x6c,0xfc,0x6d,0xfc,0x6e,0xfc,\
0x6e,0xfc,0x6f,0xfc,0x70,0xfc,0x71,0xfc,0x72,0xfc,0x72,0xfc,0x73,0xfc,0x74,0xfc,\
0x75,0xfc,0x76,0xfc,0x76,0xfc,0x77,0xfc,0x78,0xfc,0x79,0xfc,0x7a,0xfc,0x7a,0xfc,\
0x7b,0xfc,0x7c,0xfc,0x7d,0xfc,0x7e,0xfc,0x7e,0xfc,0x7f,0xfc,0x80,0xfc,0x81,0xfc,\
0x82,0xfc,0x82,0xfc,0x83,0xfc,0x84,0xfc,0x85,0xfc,0x86,0xfc,0x86,0xfc,0x87,0xfc,\
0x88,0xfc,0x89,0xfc,0x8a,0xfc,0x8a,0xfc,0x8b,0xfc,0x8c,0xfc,0x8d,0xfc,0x8e,0xfc,\
0x8e,0xfc,0x8f,0xfc,0x90,0xfc,0x91,0xfc,0x92,0xfc,0x92,0xfc,0x93,0xfc,0x94,0xfc,\
0x95,0xfc,0x96,0xfc,0x96,0xfc,0x97,0xfc,0x98,0xfc,0x99,0xfc,0x9a,0xfc,0x9a,0xfc,\
0x9b,0xfc,0x9c,0xfc,0x9d,0xfc,0x9e,0xfc,0x9e,0xfc,0x9f,0xfc,0xa0,0xfc,0xa1,0xfc,\
0xa2,0xfc,0xa2,0xfc,0xa3,0xfc,0xa4,0xfc,0xa5,0xfc,0xa6,0xfc,0xa6,0xfc,0xa7,0xfc,\
0xa8,0xfc,0xa9,0xfc,0xaa,0xfc,0xaa,0xfc,0xab,0xfc,0xac,0xfc,0xad,0xfc,0xae,0xfc,\
0xae,0xfc,0xaf,0xfc,0xb0,0xfc,0xb1,0xfc,0xb2,0xfc,0xb2,0xfc,0xb3,0xfc,0xb4,0xfc,\
0xb5,0xfc,0xb6,0xfc,0xb6,0xfc,0xb7,0xfc,0xb8,0xfc,0xb9,0xfc,0xba,0xfc,0xba,0xfc,\
0xbb,0xfc,0xbc,0xfc,0xbd,0xfc,0xbe,0xfc,0xbe,0xfc,0xbf,0xfc,0xc0,0xfc,0xc1,0xfc,\
0xc2,0xfc,0xc2,0xfc,0xc3,0xfc,0xc4,0xfc,0xc5,0xfc,0xc6,0xfc,0xc6,0xfc,0xc7,0xfc,\
0xc8,0xfc,0xc9,0xfc,0xca,0xfc,0xca,0xfc,0xcb,0xfc,0xcc,0xfc,0xcd,0xfc,0xce,0xfc,\
0xce,0xfc,0xcf,0xfc,0xd0,0xfc,0xd1,0xfc,0xd2,0xfc,0xd2,0xfc,0xd3,0xfc,0xd4,0xfc,\
0xd5,0xfc,0xd6,0xfc,0xd6,0xfc,0xd7,0xfc,0xd8,0xfc,0xd9,0xfc,0xda,0xfc,0xda,0xfc,\
0xdb,0xfc,0xdc,0xfc,0xdd,0xfc,0xde,0xfc,0xde,0xfc,0xdf,0xfc,0xe0,0xfc,0xe1,0xfc,\
0xe2,0xfc,0xe2,0xfc,0xe3,0xfc,0xe4,0xfc,0xe5,0xfc,0xe6,0xfc,0xe6,0xfc,0xe7,0xfc,\
0xe8,0xfc,0xe9,0xfc,0xea,0xfc,0xea,0xfc,0xeb,0xfc,0xec,0xfc,0xed,0xfc,0xee,0xfc,\
0xee,0xfc,0xef,0xfc,0xf0,0xfc,0xf1,0xfc,0xf2,0xfc,0xf2,0xfc,0xf3,0xfc,0xf4,0xfc,\
0xf5,0xfc,0xf6,0xfc,0xf6,0xfc,0xf7,0xfc,0xf8,0xfc,0xf9,0xfc,0xfa,0xfc,0xfa,0xfc,\
0xfb,0xfc,0xfc,0xfc,0xfd,0xfc,0xfe,0xfc,0xfe,0xfc,0xff,0xfc,0x00,0xfd,0x01,0xfd,\
0x02,0xfd,0x02,0xfd,0x03,0xfd,0x04,0xfd,0x05,0xfd,0x06,0xfd,0x06,0xfd,0x07,0xfd,\
0x08,0xfd,0x09,0xfd,0x0a,0xfd,0x0a,0xfd,0x0b,0xfd,0x0c,0xfd,0x0d,0xfd,0x0e,0xfd,\
0x0e,0xfd,0x0f,0xfd,0x10,0xfd,0x11,0xfd,0x12,0xfd,0x12,0xfd,0x13,0xfd,0x14,0xfd,\
0x15,0xfd,0x16,0xfd,0x16,0xfd,0x17,0xfd,0x18,0xfd,0x19,0xfd,0x1a,0xfd,0x1a,0xfd,\
0x1b,0xfd,0x1c,0xfd,0x1d,0xfd,0x1e,0xfd,0x1e,0xfd,0x1f,0xfd,0x20,0xfd,0x21,0xfd,\
0x22,0xfd,0x22,0xfd,0x23,0xfd,0x24,0xfd,0x25,0xfd,0x26,0xfd,0x26,0xfd,0x27,0xfd,\
0x28,0xfd,0x29,0xfd,0x2a,0xfd,0x2a,0xfd,0x2b,0xfd,0x2c,0xfd,0x2d,0xfd,0x2e,0xfd,\
0x2e,0xfd,0x2f,0xfd,0x30,0xfd,0x31,0xfd,0x32,0xfd,0x32,0xfd,0x33,0xfd,0x34,0xfd,\
0x35,0xfd,0x36,0xfd,0x36,0xfd,0x37,0xfd,0x38,0xfd,0x39,0xfd,0x3a,0xfd,0x3a,0xfd,\
0x3b,0xfd,0x3c,0xfd,0x3d,0xfd,0x3e,0xfd,0x3e,0xfd,0x3f,0xfd,0x40,0xfd,0x41,0xfd,\
0x42,0xfd,0x42,0xfd,0x43,0xfd,0x44,0xfd,0x45,0xfd,0x46,0xfd,0x46,0xfd,0x47,0xfd,\
0x48,0xfd,0x49,0xfd,0x4a,0xfd,0x4a,0xfd,0x4b,0xfd,0x4c,0xfd,0x4d,0xfd,0x4e,0xfd,\
0x4e,0xfd,0x4f,0xfd,0x50,0xfd,0x51,0xfd,0x52,0xfd,0x52,0xfd,0x53,0xfd,0x54,0xfd,\
0x55,0xfd,0x56,0xfd,0x56,0xfd,0x57,0xfd,0x58,0xfd,0x59,0xfd,0x5a,0xfd,0x5a,0xfd,\
0x5b,0xfd,0x5c,0xfd,0x5d,0xfd,0x5e,0xfd,0x5e,0xfd,0x5f,0xfd,0x60,0xfd,0x61,0xfd,\
0x62,0xfd,0x62,0xfd,0x63,0xfd,0x64,0xfd,0x65,0xfd,0x66,0xfd,0x66,0xfd,0x67,0xfd,\
0x68,0xfd,0x69,0xfd,0x6a,0xfd,0x6a,0xfd,0x6b,0xfd,0x6c,0xfd,0x6d,0xfd,0x6e,0xfd,\
0x6e,0xfd,0x6f,0xfd,0x70,0xfd,0x71,0xfd,0x72,0xfd,0x72,0xfd,0x73,0xfd,0x74,0xfd,\
0x75,0xfd,0x76,0xfd,0x76,0xfd,0x77,0xfd,0x78,0xfd,0x79,0xfd,0x7a,0xfd,0x7a,0xfd,\
0x7b,0xfd,0x7c,0xfd,0x7d,0xfd,0x7e,0xfd,0x7e,0xfd,0x7f,0xfd,0x80,0xfd,0x81,0xfd,\
0x82,0xfd,0x82,0xfd,0x83,0xfd,0x84,0xfd,0x85,0xfd,0x86,0xfd,0x86,0xfd,0x87,0xfd,\
0x88,0xfd,0x89,0xfd,0x8a,0xfd,0x8a,0xfd,0x8b,0xfd,0x8c,0xfd,0x8d,0xfd,0x8e,0xfd,\
0x8e,0xfd,0x8f,0xfd,0x90,0xfd,0x91,0xfd,0x92,0xfd,0x92,0xfd,0x93,0xfd,0x94,0xfd,\
0x95,0xfd,0x96,0xfd,0x96,0xfd,0x97,0xfd,0x98,0xfd,0x99,0xfd,0x9a,0xfd,0x9a,0xfd,\
0x9b,0xfd,0x9c,0xfd,0x9d,0xfd,0x9e,0xfd,0x9e,0xfd,0x9f,0xfd,0xa0,0xfd,0xa1,0xfd,\
0xa2,0xfd,0xa2,0xfd,0xa3,0xfd,0xa4,0xfd,0xa5,0xfd,0xa6,0xfd,0xa6,0xfd,0xa7,0xfd,\
0xa8,0xfd,0xa9,0xfd,0xaa,0xfd,0xaa,0xfd,0xab,0xfd,0xac,0xfd,0xad,0xfd,0xae,0xfd,\
0xae,0xfd,0xaf,0xfd,0xb0,0xfd,0xb1,0xfd,0xb2,0xfd,0xb2,0xfd,0xb3,0xfd,0xb4,0xfd,\
0xb5,0xfd,0xb6,0xfd,0xb6,0xfd,0xb7,0xfd,0xb8,0xfd,0xb9,0xfd,0xba,0xfd,0xba,0xfd,\
0xbb,0xfd,0xbc,0xfd,0xbd,0xfd,0xbe,0xfd,0xbe,0xfd,0xbf,0xfd,0xc0,0xfd,0xc1,0xfd,\
0xc2,0xfd,0xc2,0xfd,0xc3,0xfd,0xc4,0xfd,0xc5,0xfd,0xc6,0xfd,0xc6,0xfd,0xc7,0xfd,\
0xc8,0xfd,0xc9,0xfd,0xca,0xfd,0xca,0xfd,0xcb,0xfd,0xcc,0xfd,0xcd,0xfd,0xce,0xfd,\
0xce,0xfd,0xcf,0xfd,0xd0,0xfd,0xd1,0xfd,0xd2,0xfd,0xd2,0xfd,0xd3,0xfd,0xd4,0xfd,\
0xd5,0xfd,0xd6,0xfd,0xd6,0xfd,0xd7,0xfd,0xd8,0xfd,0xd9,0xfd,0xda,0xfd,0xda,0xfd,\
0xdb,0xfd,0xdc,0xfd,0xdd,0xfd,0xde,0xfd,0xde,0xfd,0xdf,0xfd,0xe0,0xfd,0xe1,0xfd,\
0xe2,0xfd,0xe2,0xfd,0xe3,0xfd,0xe4,0xfd,0xe5,0xfd,0xe6,0xfd,0xe6,0xfd,0xe7,0xfd,\
0xe8,0xfd,0xe9,0xfd,0xea,0xfd,0xea,0xfd,0xeb,0xfd,0xec,0xfd,0xed,0xfd,0xee,0xfd,\
0xee,0xfd,0xef,0xfd,0xf0,0xfd,0xf1,0xfd,0xf2,0xfd,0xf2,0xfd,0xf3,0xfd,0xf4,0xfd,\
0xf5,0xfd,0xf6,0xfd,0xf6,0xfd,0xf7,0xfd,0xf8,0xfd,0xf9,0xfd,0xfa,0xfd,0xfa,0xfd,\
0xfb,0xfd,0xfc,0xfd,0xfd,0xfd,0xfe,0xfd,0xfe,0xfd,0xff,0xfd,0x00,0xfe,0x01,0xfe,\
0x02,0xfe,0x02,0xfe,0x03,0xfe,0x04,0xfe,0x05,0xfe,0x06,0xfe,0x06,0xfe,0x07,0xfe,\
0x08,0xfe,0x09,0xfe,0x0a,0xfe,0x0a,0xfe,0x0b,0xfe,0x0c,0xfe,0x0d,0xfe,0x0e,0xfe,\
0x0e,0xfe,0x0f,0xfe,0x10,0xfe,0x11,0xfe,0x12,0xfe,0x12,0xfe,0x13,0xfe,0x14,0xfe,\
0x15,0xfe,0x16,0xfe,0x16,0xfe,0x17,0xfe,0x18,0xfe,0x19,0xfe,0x1a,0xfe,0x1a,0xfe,\
0x1b,0xfe,0x1c,0xfe,0x1d,0xfe,0x1e,0xfe,0x1e,0xfe,0x1f,0xfe,0x20,0xfe,0x21,0xfe,\
0x22,0xfe,0x22,0xfe,0x23,0xfe,0x24,0xfe,0x25,0xfe,0x26,0xfe,0x26,0xfe,0x27,0xfe,\
0x28,0xfe,0x29,0xfe,0x2a,0xfe,0x2a,0xfe,0x2b,0xfe,0x2c,0xfe,0x2d,0xfe,0x2e,0xfe,\
0x2e,0xfe,0x2f,0xfe,0x30,0xfe,0x31,0xfe,0x32,0xfe,0x32,0xfe,0x33,0xfe,0x34,0xfe,\
0x35,0xfe,0x36,0xfe,0x36,0xfe,0x37,0xfe,0x38,0xfe,0x39,0xfe,0x3a,0xfe,0x3a,0xfe,\
0x3b,0xfe,0x3c,0xfe,0x3d,0xfe,0x3e,0xfe,0x3e,0xfe,0x3f,0xfe,0x40,0xfe,0x41,0xfe,\
0x42,0xfe,0x42,0xfe,0x43,0xfe,0x44,0xfe,0x45,0xfe,0x46,0xfe,0x46,0xfe,0x47,0xfe,\
0x48,0xfe,0x49,0xfe,0x4a,0xfe,0x4a,0xfe,0x4b,0xfe,0x4c,0xfe,0x4d,0xfe,0x4e,0xfe,\
0x4e,0xfe,0x4f,0xfe,0x50,0xfe,0x51,0xfe,0x52,0xfe,0x52,0xfe,0x53,0xfe,0x54,0xfe,\
0x55,0xfe,0x56,0xfe,0x56,0xfe,0x57,0xfe,0x58,0xfe,0x59,0xfe,0x5a,0xfe,0x5a,0xfe,\
0x5b,0xfe,0x5c,0xfe,0x5d,0xfe,0x5e,0xfe,0x5e,0xfe,0x5f,0xfe,0x60,0xfe,0x61,0xfe,\
0x62,0xfe,0x62,0xfe,0x63,0xfe,0x64,0xfe,0x65,0xfe,0x66,0xfe,0x66,0xfe,0x67,0xfe,\
0x68,0xfe,0x69,0xfe,0x6a,0xfe,0x6a,0xfe,0x6b,0xfe,0x6c,0xfe,0x6d,0xfe,0x6e,0xfe,\
0x6e,0xfe,0x6f,0xfe,0x70,0xfe,0x71,0xfe,0x72,0xfe,0x72,0xfe,0x73,0xfe,0x74,0xfe,\
0x75,0xfe,0x76,0xfe,0x76,0xfe,0x77,0xfe,0x78,0xfe,0x79,0xfe,0x7a,0xfe,0x7a,0xfe,\
0x7b,0xfe,0x7c,0xfe,0x7d,0xfe,0x7e,0xfe,0x7e,0xfe,0x7f,0xfe,0x80,0xfe,0x81,0xfe,\
0x82,0xfe,0x82,0xfe,0x83,0xfe,0x84,0xfe,0x85,0xfe,0x86,0xfe,0x86,0xfe,0x87,0xfe,\
0x88,0xfe,0x89,0xfe,0x8a,0xfe,0x8a,0xfe,0x8b,0xfe,0x8c,0xfe,0x8d,0xfe,0x8e,0xfe,\
0x8e,0xfe,0x8f,0xfe,0x90,0xfe,0x91,0xfe,0x92,0xfe,0x92,0xfe,0x93,0xfe,0x94,0xfe,\
0x95,0xfe,0x96,0xfe,0x96,0xfe,0x97,0xfe,0x98,0xfe,0x99,0xfe,0x9a,0xfe,0x9a,0xfe,\
0x9b,0xfe,0x9c,0xfe,0x9d,0xfe,0x9e,0xfe,0x9e,0xfe,0x9f,0xfe,0xa0,0xfe,0xa1,0xfe,\
0xa2,0xfe,0xa2,0xfe,0xa3,0xfe,0xa4,0xfe,0xa5,0xfe,0xa6,0xfe,0xa6,0xfe,0xa7,0xfe,\
0xa8,0xfe,0xa9,0xfe,0xaa,0xfe,0xaa,0xfe,0xab,0xfe,0xac,0xfe,0xad,0xfe,0xae,0xfe,\
0xae,0xfe,0xaf,0xfe,0xb0,0xfe,0xb1,0xfe,0xb2,0xfe,0xb2,0xfe,0xb3,0xfe,0xb4,0xfe,\
0xb5,0xfe,0xb6,0xfe,0xb6,0xfe,0xb7,0xfe,0xb8,0xfe,0xb9,0xfe,0xba,0xfe,0xba,0xfe,\
0xbb,0xfe,0xbc,0xfe,0xbd,0xfe,0xbe,0xfe,0xbe,0xfe,0xbf,0xfe,0xc0,0xfe,0xc1,0xfe,\
0xc2,0xfe,0xc2,0xfe,0xc3,0xfe,0xc4,0xfe,0xc5,0xfe,0xc6,0xfe,0xc6,0xfe,0xc7,0xfe,\
0xc8,0xfe,0xc9,0xfe,0xca,0xfe,0xca,0xfe,0xcb,0xfe,0xcc,0xfe,0xcd,0xfe,0xce,0xfe,\
0xce,0xfe,0xcf,0xfe,0xd0,0xfe,0xd1,0xfe,0xd2,0xfe,0xd2,0xfe,0xd3,0xfe,0xd4,0xfe,\
0xd5,0xfe,0xd6,0xfe,0xd6,0xfe,0xd7,0xfe,0xd8,0xfe,0xd9,0xfe,0xda,0xfe,0xda,0xfe,\
0xdb,0xfe,0xdc,0xfe,0xdd,0xfe,0xde,0xfe,0xde,0xfe,0xdf,0xfe,0xe0,0xfe,0xe1,0xfe,\
0xe2,0xfe,0xe2,0xfe,0xe3,0xfe,0xe4,0xfe,0xe5,0xfe,0xe6,0xfe,0xe6,0xfe,0xe7,0xfe,\
0xe8,0xfe,0xe9,0xfe,0xea,0xfe,0xea,0xfe,0xeb,0xfe,0xec,0xfe,0xed,0xfe,0xee,0xfe,\
0xee,0xfe,0xef,0xfe,0xf0,0xfe,0xf1,0xfe,0xf2,0xfe,0xf2,0xfe,0xf3,0xfe,0xf4,0xfe,\
0xf5,0xfe,0xf6,0xfe,0xf6,0xfe,0xf7,0xfe,0xf8,0xfe,0xf9,0xfe,0xfa,0xfe,0xfa,0xfe,\
0xfb,0xfe,0xfc,0xfe,0xfd,0xfe,0xfe,0xfe,0xfe,0xfe,0xff,0xfe,0x00,0xff,0x01,0xff,\
0x02,0xff,0x02,0xff,0x03,0xff,0x04,0xff,0x05,0xff,0x06,0xff,0x06,0xff,0x07,0xff,\
0x08,0xff,0x09,0xff,0x0a,0xff,0x0a,0xff,0x0b,0xff,0x0c,0xff,0x0d,0xff,0x0e,0xff,\
0x0e,0xff,0x0f,0xff,0x10,0xff,0x11,0xff,0x12,0xff,0x12,0xff,0x13,0xff,0x14,0xff,\
0x15,0xff,0x16,0xff,0x16,0xff,0x17,0xff,0x18,0xff,0x19,0xff,0x1a,0xff,0x1a,0xff,\
0x1b,0xff,0x1c,0xff,0x1d,0xff,0x1e,0xff,0x1e,0xff,0x1f,0xff,0x20,0xff,0x21,0xff,\
0x22,0xff,0x22,0xff,0x23,0xff,0x24,0xff,0x25,0xff,0x26,0xff,0x26,0xff,0x27,0xff,\
0x28,0xff,0x29,0xff,0x2a,0xff,0x2a,0xff,0x2b,0xff,0x2c,0xff,0x2d,0xff,0x2e,0xff,\
0x2e,0xff,0x2f,0xff,0x30,0xff,0x31,0xff,0x32,0xff,0x32,0xff,0x33,0xff,0x34,0xff,\
0x35,0xff,0x36,0xff,0x36,0xff,0x37,0xff,0x38,0xff,0x39,0xff,0x3a,0xff,0x3a,0xff,\
0x3b,0xff,0x3c,0xff,0x3d,0xff,0x3e,0xff,0x3e,0xff,0x3f,0xff,0x40,0xff,0x41,0xff,\
0x42,0xff,0x42,0xff,0x43,0xff,0x44,0xff,0x45,0xff,0x46,0xff,0x46,0xff,0x47,0xff,\
0x48,0xff,0x49,0xff,0x4a,0xff,0x4a,0xff,0x4b,0xff,0x4c,0xff,0x4d,0xff,0x4e,0xff,\
0x4e,0xff,0x4f,0xff,0x50,0xff,0x51,0xff,0x52,0xff,0x52,0xff,0x53,0xff,0x54,0xff,\
0x55,0xff,0x56,0xff,0x56,0xff,0x57,0xff,0x58,0xff,0x59,0xff,0x5a,0xff,0x5a,0xff,\
0x5b,0xff,0x5c,0xff,0x5d,0xff,0x5e,0xff,0x5e,0xff,0x5f,0xff,0x60,0xff,0x61,0xff,\
0x62,0xff,0x62,0xff,0x63,0xff,0x64,0xff,0x65,0xff,0x66,0xff,0x66,0xff,0x67,0xff,\
0x68,0xff,0x69,0xff,0x6a,0xff,0x6a,0xff,0x6b,0xff,0x6c,0xff,0x6d,0xff,0x6e,0xff,\
0x6e,0xff,0x6f,0xff,0x70,0xff,0x71,0xff,0x72,0xff,0x72,0xff,0x73,0xff,0x74,0xff,\
0x75,0xff,0x76,0xff,0x76,0xff,0x77,0xff,0x78,0xff,0x79,0xff,0x7a,0xff,0x7a,0xff,\
0x7b,0xff,0x7c,0xff,0x7d,0xff,0x7e,0xff,0x7e,0xff,0x7f,0xff,0x80,0xff,0x81,0xff,\
0x82,0xff,0x82,0xff,0x83,0xff,0x84,0xff,0x85,0xff,0x86,0xff,0x86,0xff,0x87,0xff,\
0x88,0xff,0x89,0xff,0x8a,0xff,0x8a,0xff,0x8b,0xff,0x8c,0xff,0x8d,0xff,0x8e,0xff,\
0x8e,0xff,0x8f,0xff,0x90,0xff,0x91,0xff,0x92,0xff,0x92,0xff,0x93,0xff,0x94,0xff,\
0x95,0xff,0x96,0xff,0x96,0xff,0x97,0xff,0x98,0xff,0x99,0xff,0x9a,0xff,0x9a,0xff,\
0x9b,0xff,0x9c,0xff,0x9d,0xff,0x9e,0xff,0x9e,0xff,0x9f,0xff,0xa0,0xff,0xa1,0xff,\
0xa2,0xff,0xa2,0xff,0xa3,0xff,0xa4,0xff,0xa5,0xff,0xa6,0xff,0xa6,0xff,0xa7,0xff,\
0xa8,0xff,0xa9,0xff,0xaa,0xff,0xaa,0xff,0xab,0xff,0xac,0xff,0xad,0xff,0xae,0xff,\
0xae,0xff,0xaf,0xff,0xb0,0xff,0xb1,0xff,0xb2,0xff,0xb2,0xff,0xb3,0xff,0xb4,0xff,\
0xb5,0xff,0xb6,0xff,0xb6,0xff,0xb7,0xff,0xb8,0xff,0xb9,0xff,0xba,0xff,0xba,0xff,\
0xbb,0xff,0xbc,0xff,0xbd,0xff,0xbe,0xff,0xbe,0xff,0xbf,0xff,0xc0,0xff,0xc1,0xff,\
0xc2,0xff,0xc2,0xff,0xc3,0xff,0xc4,0xff,0xc5,0xff,0xc6,0xff,0xc6,0xff,0xc7,0xff,\
0xc8,0xff,0xc9,0xff,0xca,0xff,0xca,0xff,0xcb,0xff,0xcc,0xff,0xcd,0xff,0xce,0xff,\
0xce,0xff,0xcf,0xff,0xd0,0xff,0xd1,0xff,0xd2,0xff,0xd2,0xff,0xd3,0xff,0xd4,0xff,\
0xd5,0xff,0xd6,0xff,0xd6,0xff,0xd7,0xff,0xd8,0xff,0xd9,0xff,0xda,0xff,0xda,0xff,\
0xdb,0xff,0xdc,0xff,0xdd,0xff,0xde,0xff,0xde,0xff,0xdf,0xff,0xe0,0xff,0xe1,0xff,\
0xe2,0xff,0xe2,0xff,0xe3,0xff,0xe4,0xff,0xe5,0xff,0xe6,0xff,0xe6,0xff,0xe7,0xff,\
0xe8,0xff,0xe9,0xff,0xea,0xff,0xea,0xff,0xeb,0xff,0xec,0xff,0xed,0xff,0xee,0xff,\
0xee,0xff,0xef,0xff,0xf0,0xff,0xf1,0xff,0xf2,0xff,0xf2,0xff,0xf3,0xff,0xf4,0xff,\
0xf5,0xff,0xf6,0xff,0xf6,0xff,0xf7,0xff,0xf8,0xff,0xf9,0xff,0xfa,0xff,0xfa,0xff,\
0xfb,0xff,0xfc,0xff,0xfd,0xff,0xfe,0xff,0xfe,0xff,0xff,0xff,0x00,0x00,0x01,0x00,\
0x02,0x00,0x02,0x00,0x03,0x00,0x04,0x00,0x05,0x00,0x06,0x00,0x06,0x00,0x07,0x00,\
0x08,0x00,0x09,0x00,0x0a,0x00,0x0a,0x00,0x0b,0x00,0x0c,0x00,0x0d,0x00,0x0e,0x00,\
0x0e,0x00,0x0f,0x00,0x10,0x00,0x11,0x00,0x12,0x00,0x12,0x00,0x13,0x00,0x14,0x00,\
0x15,0x00,0x16,0x00,0x16,0x00,0x17,0x00,0x18,0x00,0x19,0x00,0x1a,0x00,0x1a,0x00,\
0x1b,0x00,0x1c,0x00,0x1d,0x00,0x1e,0x00,0x1e,0x00,0x1f,0x00,0x20,0x00,0x21,0x00,\
0x22,0x00,0x22,0x00,0x23,0x00,0x24,0x00,0x25,0x00,0x26,0x00,0x26,0x00,0x27,0x00,\
0x28,0x00,0x29,0x00,0x2a,0x00,0x2a,0x00,0x2b,0x00,0x2c,0x00,0x2d,0x00,0x2e,0x00,\
0x2e,0x00,0x2f,0x00,0x30,0x00,0x31,0x00,0x32,0x00,0x32,0x00,0x33,0x00,0x34,0x00,\
0x35,0x00,0x36,0x00,0x36,0x00,0x37,0x00,0x38,0x00,0x39,0x00,0x3a,0x00,0x3a,0x00,\
0x3b,0x00,0x3c,0x00,0x3d,0x00,0x3e,0x00,0x3e,0x00,0x3f,0x00,0x40,0x00,0x41,0x00,\
0x42,0x00,0x42,0x00,0x43,0x00,0x44,0x00,0x45,0x00,0x46,0x00,0x46,0x00,0x47,0x00,\
0x48,0x00,0x49,0x00,0x4a,0x00,0x4a,0x00,0x4b,0x00,0x4c,0x00,0x4d,0x00,0x4e,0x00,\
0x4e,0x00,0x4f,0x00,0x50,0x00,0x51,0x00,0x52,0x00,0x52,0x00,0x53,0x00,0x54,0x00,\
0x55,0x00,0x56,0x00,0x56,0x00,0x57,0x00,0x58,0x00,0x59,0x00,0x5a,0x00,0x5a,0x00,\
0x5b,0x00,0x5c,0x00,0x5d,0x00,0x5e,0x00,0x5e,0x00,0x5f,0x00,0x60,0x00,0x61,0x00,\
0x62,0x00,0x62,0x00,0x63,0x00,0x64,0x00,0x65,0x00,0x66,0x00,0x66,0x00,0x67,0x00,\
0x68,0x00,0x69,0x00,0x6a,0x00,0x6a,0x00,0x6b,0x00,0x6c,0x00,0x6d,0x00,0x6e,0x00,\
0x6e,0x00,0x6f,0x00,0x70,0x00,0x71,0x00,0x72,0x00,0x72,0x00,0x73,0x00,0x74,0x00,\
0x75,0x00,0x76,0x00,0x76,0x00,0x77,0x00,0x78,0x00,0x79,0x00,0x7a,0x00,0x7a,0x00,\
0x7b,0x00,0x7c,0x00,0x7d,0x00,0x7e,0x00,0x7e,0x00,0x7f,0x00,0x80,0x00,0x81,0x00,\
0x82,0x00,0x82,0x00,0x83,0x00,0x84,0x00,0x85,0x00,0x86,0x00,0x86,0x00,0x87,0x00,\
0x88,0x00,0x89,0x00,0x8a,0x00,0x8a,0x00,0x8b,0x00,0x8c,0x00,0x8d,0x00,0x8e,0x00,\
0x8e,0x00,0x8f,0x00,0x90,0x00,0x91,0x00,0x92,0x00,0x92,0x00,0x93,0x00,0x94,0x00,\
0x95,0x00,0x96,0x00,0x96,0x00,0x97,0x00,0x98,0x00,0x99,0x00,0x9a,0x00,0x9a,0x00,\
0x9b,0x00,0x9c,0x00,0x9d,0x00,0x9e,0x00,0x9e,0x00,0x9f,0x00,0xa0,0x00,0xa1,0x00,\
0xa2,0x00,0xa2,0x00,0xa3,0x00,0xa4,0x00,0xa5,0x00,0xa6,0x00,0xa6,0x00,0xa7,0x00,\
0xa8,0x00,0xa9,0x00,0xaa,0x00,0xaa,0x00,0xab,0x00,0xac,0x00,0xad,0x00,0xae,0x00,\
0xae,0x00,0xaf,0x00,0xb0,0x00,0xb1,0x00,0xb2,0x00,0xb2,0x00,0xb3,0x00,0xb4,0x00,\
0xb5,0x00,0xb6,0x00,0xb6,0x00,0xb7,0x00,0xb8,0x00,0xb9,0x00,0xba,0x00,0xba,0x00,\
0xbb,0x00,0xbc,0x00,0xbd,0x00,0xbe,0x00,0xbe,0x00,0xbf,0x00,0xc0,0x00,0xc1,0x00,\
0xc2,0x00,0xc2,0x00,0xc3,0x00,0xc4,0x00,0xc5,0x00,0xc6,0x00,0xc6,0x00,0xc7,0x00,\
0xc8,0x00,0xc9,0x00,0xca,0x00,0xca,0x00,0xcb,0x00,0xcc,0x00,0xcd,0x00,0xce,0x00,\
0xce,0x00,0xcf,0x00,0xd0,0x00,0xd1,0x00,0xd2,0x00,0xd2,0x00,0xd3,0x00,0xd4,0x00,\
0xd5,0x00,0xd6,0x00,0xd6,0x00,0xd7,0x00,0xd8,0x00,0xd9,0x00,0xda,0x00,0xda,0x00,\
0xdb,0x00,0xdc,0x00,0xdd,0x00,0xde,0x00,0xde,0x00,0xdf,0x00,0xe0,0x00,0xe1,0x00,\
0xe2,0x00,0xe2,0x00,0xe3,0x00,0xe4,0x00,0xe5,0x00,0xe6,0x00,0xe6,0x00,0xe7,0x00,\
0xe8,0x00,0xe9,0x00,0xea,0x00,0xea,0x00,0xeb,0x00,0xec,0x00,0xed,0x00,0xee,0x00,\
0xee,0x00,0xef,0x00,0xf0,0x00,0xf1,0x00,0xf2,0x00,0xf2,0x00,0xf3,0x00,0xf4,0x00,\
0xf5,0x00,0xf6,0x00,0xf6,0x00,0xf7,0x00,0xf8,0x00,0xf9,0x00,0xfa,0x00,0xfa,0x00,\
0xfb,0x00,0xfc,0x00,0xfd,0x00,0xfe,0x00,0xfe,0x00,0xff,0x00,0x00,0x01,0x01,0x01,\
0x02,0x01,0x02,0x01,0x03,0x01,0x04,0x01,0x05,0x01,0x06,0x01,0x06,0x01,0x07,0x01,\
0x08,0x01,0x09,0x01,0x0a,0x01,0x0a,0x01,0x0b,0x01,0x0c,0x01,0x0d,0x01,0x0e,0x01,\
0x0e,0x01,0x0f,0x01,0x10,0x01,0x11,0x01,0x12,0x01,0x12,0x01,0x13,0x01,0x14,0x01,\
0x15,0x01,0x16,0x01,0x16,0x01,0x17,0x01,0x18,0x01,0x19,0x01,0x1a,0x01,0x1a,0x01,\
0x1b,0x01,0x1c,0x01,0x1d,0x01,0x1e,0x01,0x1e,0x01,0x1f,0x01,0x20,0x01,0x21,0x01,\
0x22,0x01,0x22,0x01,0x23,0x01,0x24,0x01,0x25,0x01,0x26,0x01,0x26,0x01,0x27,0x01,\
0x28,0x01,0x29,0x01,0x2a,0x01,0x2a,0x01,0x2b,0x01,0x2c,0x01,0x2d,0x01,0x2e,0x01,\
0x2e,0x01,0x2f,0x01,0x30,0x01,0x31,0x01,0x32,0x01,0x32,0x01,0x33,0x01,0x34,0x01,\
0x35,0x01,0x36,0x01,0x36,0x01,0x37,0x01,0x38,0x01,0x39,0x01,0x3a,0x01,0x3a,0x01,\
0x3b,0x01,0x3c,0x01,0x3d,0x01,0x3e,0x01,0x3e,0x01,0x3f,0x01,0x40,0x01,0x41,0x01,\
0x42,0x01,0x42,0x01,0x43,0x01,0x44,0x01,0x45,0x01,0x46,0x01,0x46,0x01,0x47,0x01,\
0x48,0x01,0x49,0x01,0x4a,0x01,0x4a,0x01,0x4b,0x01,0x4c,0x01,0x4d,0x01,0x4e,0x01,\
0x4e,0x01,0x4f,0x01,0x50,0x01,0x51,0x01,0x52,0x01,0x52,0x01,0x53,0x01,0x54,0x01,\
0x55,0x01,0x56,0x01,0x56,0x01,0x57,0x01,0x58,0x01,0x59,0x01,0x5a,0x01,0x5a,0x01,\
0x5b,0x01,0x5c,0x01,0x5d,0x01,0x5e,0x01,0x5e,0x01,0x5f,0x01,0x60,0x01,0x61,0x01,\
0x62,0x01,0x62,0x01,0x63,0x01,0x64,0x01,0x65,0x01,0x66,0x01,0x66,0x01,0x67,0x01,\
0x68,0x01,0x69,0x01,0x6a,0x01,0x6a,0x01,0x6b,0x01,0x6c,0x01,0x6d,0x01,0x6e,0x01,\
0x6e,0x01,0x6f,0x01,0x70,0x01,0x71,0x01,0x72,0x01,0x72,0x01,0x73,0x01,0x74,0x01,\
0x75,0x01,0x76,0x01,0x76,0x01,0x77,0x01,0x78,0x01,0x79,0x01,0x7a,0x01,0x7a,0x01,\
0x7b,0x01,0x7c,0x01,0x7d,0x01,0x7e,0x01,0x7e,0x01,0x7f,0x01,0x80,0x01,0x81,0x01,\
0x82,0x01,0x82,0x01,0x83,0x01,0x84,0x01,0x85,0x01,0x86,0x01,0x86,0x01,0x87,0x01,\
0x88,0x01,0x89,0x01,0x8a,0x01,0x8a,0x01,0x8b,0x01,0x8c,0x01,0x8d,0x01,0x8e,0x01,\
0x8e,0x01,0x8f,0x01,0x90,0x01,0x91,0x01,0x92,0x01,0x92,0x01,0x93,0x01,0x94,0x01,\
0x95,0x01,0x96,0x01,0x96,0x01,0x97,0x01,0x98,0x01,0x99,0x01,0x9a,0x01,0x9a,0x01,\
0x9b,0x01,0x9c,0x01,0x9d,0x01,0x9e,0x01,0x9e,0x01,0x9f,0x01,0xa0,0x01,0xa1,0x01,\
0xa2,0x01,0xa2,0x01,0xa3,0x01,0xa4,0x01,0xa5,0x01,0xa6,0x01,0xa6,0x01,0xa7,0x01,\
0xa8,0x01,0xa9,0x01,0xaa,0x01,0xaa,0x01,0xab,0x01,0xac,0x01,0xad,0x01,0xae,0x01,\
0xae,0x01,0xaf,0x01,0xb0,0x01,0xb1,0x01,0xb2,0x01,0xb2,0x01,0xb3,0x01,0xb4,0x01,\
0xb5,0x01,0xb6,0x01,0xb6,0x01,0xb7,0x01,0xb8,0x01,0xb9,0x01,0xba,0x01,0xba,0x01,\
0xbb,0x01,0xbc,0x01,0xbd,0x01,0xbe,0x01,0xbe,0x01,0xbf,0x01,0xc0,0x01,0xc1,0x01,\
0xc2,0x01,0xc2,0x01,0xc3,0x01,0xc4,0x01,0xc5,0x01,0xc6,0x01,0xc6,0x01,0xc7,0x01,\
0xc8,0x01,0xc9,0x01,0xca,0x01,0xca,0x01,0xcb,0x01,0xcc,0x01,0xcd,0x01,0xce,0x01,\
0xce,0x01,0xcf,0x01,0xd0,0x01,0xd1,0x01,0xd2,0x01,0xd2,0x01,0xd3,0x01,0xd4,0x01,\
0xd5,0x01,0xd6,0x01,0xd6,0x01,0xd7,0x01,0xd8,0x01,0xd9,0x01,0xda,0x01,0xda,0x01,\
0xdb,0x01,0xdc,0x01,0xdd,0x01,0xde,0x01,0xde,0x01,0xdf,0x01,0xe0,0x01,0xe1,0x01,\
0xe2,0x01,0xe2,0x01,0xe3,0x01,0xe4,0x01,0xe5,0x01,0xe6,0x01,0xe6,0x01,0xe7,0x01,\
0xe8,0x01,0xe9,0x01,0xea,0x01,0xea,0x01,0xeb,0x01,0xec,0x01,0xed,0x01,0xee,0x01,\
0xee,0x01,0xef,0x01,0xf0,0x01,0xf1,0x01,0xf2,0x01,0xf2,0x01,0xf3,0x01,0xf4,0x01,\
0xf5,0x01,0xf6,0x01,0xf6,0x01,0xf7,0x01,0xf8,0x01,0xf9,0x01,0xfa,0x01,0xfa,0x01,\
0xfb,0x01,0xfc,0x01,0xfd,0x01,0xfe,0x01,0xfe,0x01,0xff,0x01,0x00,0x02,0x01,0x02,\
0x02,0x02,0x02,0x02,0x03,0x02,0x04,0x02,0x05,0x02,0x06,0x02,0x06,0x02,0x07,0x02,\
0x08,0x02,0x09,0x02,0x0a,0x02,0x0a,0x02,0x0b,0x02,0x0c,0x02,0x0d,0x02,0x0e,0x02,\
0x0e,0x02,0x0f,0x02,0x10,0x02,0x11,0x02,0x12,0x02,0x12,0x02,0x13,0x02,0x14,0x02,\
0x15,0x02,0x16,0x02,0x16,0x02,0x17,0x02,0x18,0x02,0x19,0x02,0x1a,0x02,0x1a,0x02,\
0x1b,0x02,0x1c,0x02,0x1d,0x02,0x1e,0x02,0x1e,0x02,0x1f,0x02,0x20,0x02,0x21,0x02,\
0x22,0x02,0x22,0x02,0x23,0x02,0x24,0x02,0x25,0x02,0x26,0x02,0x26,0x02,0x27,0x02,\
0x28,0x02,0x29,0x02,0x2a,0x02,0x2a,0x02,0x2b,0x02,0x2c,0x02,0x2d,0x02,0x2e,0x02,\
0x2e,0x02,0x2f,0x02,0x30,0x02,0x31,0x02,0x32,0x02,0x32,0x02,0x33,0x02,0x34,0x02,\
0x35,0x02,0x36,0x02,0x36,0x02,0x37,0x02,0x38,0x02,0x39,0x02,0x3a,0x02,0x3a,0x02,\
0x3b,0x02,0x3c,0x02,0x3d,0x02,0x3e,0x02,0x3e,0x02,0x3f,0x02,0x40,0x02,0x41,0x02,\
0x42,0x02,0x42,0x02,0x43,0x02,0x44,0x02,0x45,0x02,0x46,0x02,0x46,0x02,0x47,0x02,\
0x48,0x02,0x49,0x02,0x4a,0x02,0x4a,0x02,0x4b,0x02,0x4c,0x02,0x4d,0x02,0x4e,0x02,\
0x4e,0x02,0x4f,0x02,0x50,0x02,0x51,0x02,0x52,0x02,0x52,0x02,0x53,0x02,0x54,0x02,\
0x55,0x02,0x56,0x02,0x56,0x02,0x57,0x02,0x58,0x02,0x59,0x02,0x5a,0x02,0x5a,0x02,\
0x5b,0x02,0x5c,0x02,0x5d,0x02,0x5e,0x02,0x5e,0x02,0x5f,0x02,0x60,0x02,0x61,0x02,\
0x62,0x02,0x62,0x02,0x63,0x02,0x64,0x02,0x65,0x02,0x66,0x02,0x66,0x02,0x67,0x02,\
0x68,0x02,0x69,0x02,0x6a,0x02,0x6a,0x02,0x6b,0x02,0x6c,0x02,0x6d,0x02,0x6e,0x02,\
0x6e,0x02,0x6f,0x02,0x70,0x02,0x71,0x02,0x72,0x02,0x72,0x02,0x73,0x02,0x74,0x02,\
0x75,0x02,0x76,0x02,0x76,0x02,0x77,0x02,0x78,0x02,0x79,0x02,0x7a,0x02,0x7a,0x02,\
0x7b,0x02,0x7c,0x02,0x7d,0x02,0x7e,0x02,0x7e,0x02,0x7f,0x02,0x80,0x02,0x81,0x02,\
0x82,0x02,0x82,0x02,0x83,0x02,0x84,0x02,0x85,0x02,0x86,0x02,0x86,0x02,0x87,0x02,\
0x88,0x02,0x89,0x02,0x8a,0x02,0x8a,0x02,0x8b,0x02,0x8c,0x02,0x8d,0x02,0x8e,0x02,\
0x8e,0x02,0x8f,0x02,0x90,0x02,0x91,0x02,0x92,0x02,0x92,0x02,0x93,0x02,0x94,0x02,\
0x95,0x02,0x96,0x02,0x96,0x02,0x97,0x02,0x98,0x02,0x99,0x02,0x9a,0x02,0x9a,0x02,\
0x9b,0x02,0x9c,0x02,0x9d,0x02,0x9e,0x02,0x9e,0x02,0x9f,0x02,0xa0,0x02,0xa1,0x02,\
0xa2,0x02,0xa2,0x02,0xa3,0x02,0xa4,0x02,0xa5,0x02,0xa6,0x02,0xa6,0x02,0xa7,0x02,\
0xa8,0x02,0xa9,0x02,0xaa,0x02,0xaa,0x02,0xab,0x02,0xac,0x02,0xad,0x02,0xae,0x02,\
0xae,0x02,0xaf,0x02,0xb0,0x02,0xb1,0x02,0xb2,0x02,0xb2,0x02,0xb3,0x02,0xb4,0x02,\
0xb5,0x02,0xb6,0x02,0xb6,0x02,0xb7,0x02,0xb8,0x02,0xb9,0x02,0xba,0x02,0xba,0x02,\
0xbb,0x02,0xbc,0x02,0xbd,0x02,0xbe,0x02,0xbe,0x02,0xbf,0x02,0xc0,0x02,0xc1,0x02,\
0xc2,0x02,0xc2,0x02,0xc3,0x02,0xc4,0x02,0xc5,0x02,0xc6,0x02,0xc6,0x02,0xc7,0x02,\
0xc8,0x02,0xc9,0x02,0xca,0x02,0xca,0x02,0xcb,0x02,0xcc,0x02,0xcd,0x02,0xce,0x02,\
0xce,0x02,0xcf,0x02,0xd0,0x02,0xd1,0x02,0xd2,0x02,0xd2,0x02,0xd3,0x02,0xd4,0x02,\
0xd5,0x02,0xd6,0x02,0xd6,0x02,0xd7,0x02,0xd8,0x02,0xd9,0x02,0xda,0x02,0xda,0x02,\
0xdb,0x02,0xdc,0x02,0xdd,0x02,0xde,0x02,0xde,0x02,0xdf,0x02,0xe0,0x02,0xe1,0x02,\
0xe2,0x02,0xe2,0x02,0xe3,0x02,0xe4,0x02,0xe5,0x02,0xe6,0x02,0xe6,0x02,0xe7,0x02,\
0xe8,0x02,0xe9,0x02,0xea,0x02,0xea,0x02,0xeb,0x02,0xec,0x02,0xed,0x02,0xee,0x02,\
0xee,0x02,0xef,0x02,0xf0,0x02,0xf1,0x02,0xf2,0x02,0xf2,0x02,0xf3,0x02,0xf4,0x02,\
0xf5,0x02,0xf6,0x02,0xf6,0x02,0xf7,0x02,0xf8,0x02,0xf9,0x02,0xfa,0x02,0xfa,0x02,\
0xfb,0x02,0xfc,0x02,0xfd,0x02,0xfe,0x02,0xfe,0x02,0xff,0x02,0x00,0x03,0x01,0x03,\
0x02,0x03,0x02,0x03,0x03,0x03,0x04,0x03,0x05,0x03,0x06,0x03,0x06,0x03,0x07,0x03,\
0x08,0x03,0x09,0x03,0x0a,0x03,0x0a,0x03,0x0b,0x03,0x0c,0x03,0x0d,0x03,0x0e,0x03,\
0x0e,0x03,0x0f,0x03,0x10,0x03,0x11,0x03,0x12,0x03,0x12,0x03,0x13,0x03,0x14,0x03,\
0x15,0x03,0x16,0x03,0x16,0x03,0x17,0x03,0x18,0x03,0x19,0x03,0x1a,0x03,0x1a,0x03,\
0x1b,0x03,0x1c,0x03,0x1d,0x03,0x1e,0x03,0x1e,0x03,0x1f,0x03,0x20,0x03,0x21,0x03,\
0x22,0x03,0x22,0x03,0x23,0x03,0x24,0x03,0x25,0x03,0x26,0x03,0x26,0x03,0x27,0x03,\
0x28,0x03,0x29,0x03,0x2a,0x03,0x2a,0x03,0x2b,0x03,0x2c,0x03,0x2d,0x03,0x2e,0x03,\
0x2e,0x03,0x2f,0x03,0x30,0x03,0x31,0x03,0x32,0x03,0x32,0x03,0x33,0x03,0x34,0x03,\
0x35,0x03,0x36,0x03,0x36,0x03,0x37,0x03,0x38,0x03,0x39,0x03,0x3a,0x03,0x3a,0x03,\
0x3b,0x03,0x3c,0x03,0x3d,0x03,0x3e,0x03,0x3e,0x03,0x3f,0x03,0x40,0x03,0x41,0x03,\
0x42,0x03,0x42,0x03,0x43,0x03,0x44,0x03,0x45,0x03,0x46,0x03,0x46,0x03,0x47,0x03,\
0x48,0x03,0x49,0x03,0x4a,0x03,0x4a,0x03,0x4b,0x03,0x4c,0x03,0x4d,0x03,0x4e,0x03,\
0x4e,0x03,0x4f,0x03,0x50,0x03,0x51,0x03,0x52,0x03,0x52,0x03,0x53,0x03,0x54,0x03,\
0x55,0x03,0x56,0x03,0x56,0x03,0x57,0x03,0x58,0x03,0x59,0x03,0x5a,0x03,0x5a,0x03,\
0x5b,0x03,0x5c,0x03,0x5d,0x03,0x5e,0x03,0x5e,0x03,0x5f,0x03,0x60,0x03,0x61,0x03,\
0x62,0x03,0x62,0x03,0x63,0x03,0x64,0x03,0x65,0x03,0x66,0x03,0x66,0x03,0x67,0x03,\
0x68,0x03,0x69,0x03,0x6a,0x03,0x6a,0x03,0x6b,0x03,0x6c,0x03,0x6d,0x03,0x6e,0x03,\
0x6e,0x03,0x6f,0x03,0x70,0x03,0x71,0x03,0x72,0x03,0x72,0x03,0x73,0x03,0x74,0x03,\
0x75,0x03,0x76,0x03,0x76,0x03,0x77,0x03,0x78,0x03,0x79,0x03,0x7a,0x03,0x7a,0x03,\
0x7b,0x03,0x7c,0x03,0x7d,0x03,0x7e,0x03,0x7e,0x03,0x7f,0x03,0x80,0x03,0x81,0x03,\
0x82,0x03,0x82,0x03,0x83,0x03,0x84,0x03,0x85,0x03,0x86,0x03,0x86,0x03,0x87,0x03,\
0x88,0x03,0x89,0x03,0x8a,0x03,0x8a,0x03,0x8b,0x03,0x8c,0x03,0x8d,0x03,0x8e,0x03,\
0x8e,0x03,0x8f,0x03,0x90,0x03,0x91,0x03,0x92,0x03,0x92,0x03,0x93,0x03,0x94,0x03,\
0x95,0x03,0x96,0x03,0x96,0x03,0x97,0x03,0x98,0x03,0x99,0x03,0x9a,0x03,0x9a,0x03,\
0x9b,0x03,0x9c,0x03,0x9d,0x03,0x9e,0x03,0x9e,0x03,0x9f,0x03,0xa0,0x03,0xa1,0x03,\
0xa2,0x03,0xa2,0x03,0xa3,0x03,0xa4,0x03,0xa5,0x03,0xa6,0x03,0xa6,0x03,0xa7,0x03,\
0xa8,0x03,0xa9,0x03,0xaa,0x03,0xaa,0x03,0xab,0x03,0xac,0x03,0xad,0x03,0xae,0x03,\
0xae,0x03,0xaf,0x03,0xb0,0x03,0xb1,0x03,0xb2,0x03,0xb2,0x03,0xb3,0x03,0xb4,0x03,\
0xb5,0x03,0xb6,0x03,0xb6,0x03,0xb7,0x03,0xb8,0x03,0xb9,0x03,0xba,0x03,0xba,0x03,\
0xbb,0x03,0xbc,0x03,0xbd,0x03,0xbe,0x03,0xbe,0x03,0xbf,0x03,0xc0,0x03,0xc1,0x03,\
0xc2,0x03,0xc2,0x03,0xc3,0x03,0xc4,0x03,0xc5,0x03,0xc6,0x03,0xc6,0x03,0xc7,0x03,\
0xc8,0x03,0xc9,0x03,0xca,0x03,0xca,0x03,0xcb,0x03,0xcc,0x03,0xcd,0x03,0xce,0x03,\
0xce,0x03,0xcf,0x03,0xd0,0x03,0xd1,0x03,0xd2,0x03,0xd2,0x03,0xd3,0x03,0xd4,0x03,\
0xd5,0x03,0xd6,0x03,0xd6,0x03,0xd7,0x03,0xd8,0x03,0xd9,0x03,0xda,0x03,0xda,0x03,\
0xdb,0x03,0xdc,0x03,0xdd,0x03,0xde,0x03,0xde,0x03,0xdf,0x03,0xe0,0x03,0xe1,0x03,\
0xe2,0x03,0xe2,0x03,0xe3,0x03,0xe4,0x03,0xe5,0x03,0xe6,0x03,0xe6,0x03,0xe7,0x03,\
0xe8,0x03,0xe9,0x03,0xea,0x03,0xea,0x03,0xeb,0x03,0xec,0x03,0xed,0x03,0xee,0x03,\
0xee,0x03,0xef,0x03,0xf0,0x03,0xf1,0x03,0xf2,0x03,0xf2,0x03,0xf3,0x03,0xf4,0x03,\
0xf5,0x03,0xf6,0x03,0xf6,0x03,0xf7,0x03,0xf8,0x03,0xf9,0x03,0xfa,0x03,0xfa,0x03,\
0xfb,0x03,0xfc,0x03,0xfd,0x03,0xfe,0x03,0xfe,0x03,0xff,0x03,0x00,0x04,0x01,0x04,\
0x02,0x04,0x02,0x04,0x03,0x04,0x04,0x04,0x05,0x04,0x06,0x04,0x06,0x04,0x07,0x04,\
0x08,0x04,0x09,0x04,0x0a,0x04,0x0a,0x04,0x0b,0x04,0x0c,0x04,0x0d,0x04,0x0e,0x04,\
0x0e,0x04,0x0f,0x04,0x10,0x04,0x11,0x04,0x12,0x04,0x12,0x04,0x13,0x04,0x14,0x04,\
0x15,0x04,0x16,0x04,0x16,0x04,0x17,0x04,0x18,0x04,0x19,0x04,0x1a,0x04,0x1a,0x04,\
0x1b,0x04,0x1c,0x04,0x1d,0x04,0x1e,0x04,0x1e,0x04,0x1f,0x04,0x20,0x04,0x21,0x04,\
0x22,0x04,0x22,0x04,0x23,0x04,0x24,0x04,0x25,0x04,0x26,0x04,0x26,0x04,0x27,0x04,\
0x28,0x04,0x29,0x04,0x2a,0x04,0x2a,0x04,0x2b,0x04,0x2c,0x04,0x2d,0x04,0x2e,0x04,\
0x2e,0x04,0x2f,0x04,0x30,0x04,0x31,0x04,0x32,0x04,0x32,0x04,0x33,0x04,0x34,0x04,\
0x35,0x04,0x36,0x04,0x36,0x04,0x37,0x04,0x38,0x04,0x39,0x04,0x3a,0x04,0x3a,0x04,\
0x3b,0x04,0x3c,0x04,0x3d,0x04,0x3e,0x04,0x3e,0x04,0x3f,0x04,0x40,0x04,0x41,0x04,\
0x42,0x04,0x42,0x04,0x43,0x04,0x44,0x04,0x45,0x04,0x46,0x04,0x46,0x04,0x47,0x04,\
0x48,0x04,0x49,0x04,0x4a,0x04,0x4a,0x04,0x4b,0x04,0x4c,0x04,0x4d,0x04,0x4e,0x04,\
0x4e,0x04,0x4f,0x04,0x50,0x04,0x51,0x04,0x52,0x04,0x52,0x04,0x53,0x04,0x54,0x04,\
0x55,0x04,0x56,0x04,0x56,0x04,0x57,0x04,0x58,0x04,0x59,0x04,0x5a,0x04,0x5a,0x04,\
0x5b,0x04,0x5c,0x04,0x5d,0x04,0x5e,0x04,0x5e,0x04,0x5f,0x04,0x60,0x04,0x61,0x04,\
0x62,0x04,0x62,0x04,0x63,0x04,0x64,0x04,0x65,0x04,0x66,0x04,0x66,0x04,0x67,0x04,\
0x68,0x04,0x69,0x04,0x6a,0x04,0x6a,0x04,0x6b,0x04,0x6c,0x04,0x6d,0x04,0x6e,0x04,\
0x6e,0x04,0x6f,0x04,0x70,0x04,0x71,0x04,0x72,0x04,0x72,0x04,0x73,0x04,0x74,0x04,\
0x75,0x04,0x76,0x04,0x76,0x04,0x77,0x04,0x78,0x04,0x79,0x04,0x7a,0x04,0x7a,0x04,\
0x7b,0x04,0x7c,0x04,0x7d,0x04,0x7e,0x04,0x7e,0x04,0x7f,0x04,0x80,0x04,0x81,0x04,\
0x82,0x04,0x82,0x04,0x83,0x04,0x84,0x04,0x85,0x04,0x86,0x04,0x86,0x04,0x87,0x04,\
0x88,0x04,0x89,0x04,0x8a,0x04,0x8a,0x04,0x8b,0x04,0x8c,0x04,0x8d,0x04,0x8e,0x04,\
0x8e,0x04,0x8f,0x04,0x90,0x04,0x91,0x04,0x92,0x04,0x92,0x04,0x93,0x04,0x94,0x04,\
0x95,0x04,0x96,0x04,0x96,0x04,0x97,0x04,0x98,0x04,0x99,0x04,0x9a,0x04,0x9a,0x04,\
0x9b,0x04,0x9c,0x04,0x9d,0x04,0x9e,0x04,0x9e,0x04,0x9f,0x04,0xa0,0x04,0xa1,0x04,\
0xa2,0x04,0xa2,0x04,0xa3,0x04,0xa4,0x04,0xa5,0x04,0xa6,0x04,0xa6,0x04,0xa7,0x04,\
0xa8,0x04,0xa9,0x04,0xaa,0x04,0xaa,0x04,0xab,0x04,0xac,0x04,0xad,0x04,0xae,0x04,\
0xae,0x04,0xaf,0x04,0xb0,0x04,0xb1,0x04,0xb2,0x04,0xb2,0x04,0xb3,0x04,0xb4,0x04,\
0xb5,0x04,0xb6,0x04,0xb6,0x04,0xb7,0x04,0xb8,0x04,0xb9,0x04,0xba,0x04,0xba,0x04,\
0xbb,0x04,0xbc,0x04,0xbd,0x04,0xbe,0x04,0xbe,0x04,0xbf,0x04,0xc0,0x04,0xc1,0x04,\
0xc2,0x04,0xc2,0x04,0xc3,0x04,0xc4,0x04,0xc5,0x04,0xc6,0x04,0xc6,0x04,0xc7,0x04,\
0xc8,0x04,0xc9,0x04,0xca,0x04,0xca,0x04,0xcb,0x04,0xcc,0x04,0xcd,0x04,0xce,0x04,\
0xce,0x04,0xcf,0x04,0xd0,0x04,0xd1,0x04,0xd2,0x04,0xd2,0x04,0xd3,0x04,0xd4,0x04,\
0xd5,0x04,0xd6,0x04,0xd6,0x04,0xd7,0x04,0xd8,0x04,0xd9,0x04,0xda,0x04,0xda,0x04,\
0xdb,0x04,0xdc,0x04,0xdd,0x04,0xde,0x04,0xde,0x04,0xdf,0x04,0xe0,0x04,0xe1,0x04,\
0xe2,0x04,0xe2,0x04,0xe3,0x04,0xe4,0x04,0xe5,0x04,0xe6,0x04,0xe6,0x04,0xe7,0x04,\
0xe8,0x04,0xe9,0x04,0xea,0x04,0xea,0x04,0xeb,0x04,0xec,0x04,0xed,0x04,0xee,0x04,\
0xee,0x04,0xef,0x04,0xf0,0x04,0xf1,0x04,0xf2,0x04,0xf2,0x04,0xf3,0x04,0xf4,0x04,\
0xf5,0x04,0xf6,0x04,0xf6,0x04,0xf7,0x04,0xf8,0x04,0xf9,0x04,0xfa,0x04,0xfa,0x04,\
0xfb,0x04,0xfc,0x04,0xfd,0x04,0xfe,0x04,0xfe,0x04,0xff,0x04,0x00,0x05,0x01,0x05,\
0x02,0x05,0x02,0x05,0x03,0x05,0x04,0x05,0x05,0x05,0x06,0x05,0x06,0x05,0x07,0x05,\
0x08,0x05,0x09,0x05,0x0a,0x05,0x0a,0x05,0x0b,0x05,0x0c,0x05,0x0d,0x05,0x0e,0x05,\
0x0e,0x05,0x0f,0x05,0x10,0x05,0x11,0x05,0x12,0x05,0x12,0x05,0x13,0x05,0x14,0x05,\
0x15,0x05,0x16,0x05,0x16,0x05,0x17,0x05,0x18,0x05,0x19,0x05,0x1a,0x05,0x1a,0x05,\
0x1b,0x05,0x1c,0x05,0x1d,0x05,0x1e,0x05,0x1e,0x05,0x1f,0x05,0x20,0x05,0x21,0x05,\
0x22,0x05,0x22,0x05,0x23,0x05,0x24,0x05,0x25,0x05,0x26,0x05,0x26,0x05,0x27,0x05,\
0x28,0x05,0x29,0x05,0x2a,0x05,0x2a,0x05,0x2b,0x05,0x2c,0x05,0x2d,0x05,0x2e,0x05,\
0x2e,0x05,0x2f,0x05,0x30,0x05,0x31,0x05,0x32,0x05,0x32,0x05,0x33,0x05,0x34,0x05,\
0x35,0x05,0x36,0x05,0x36,0x05,0x37,0x05,0x38,0x05,0x39,0x05,0x3a,0x05,0x3a,0x05,\
0x3b,0x05,0x3c,0x05,0x3d,0x05,0x3e,0x05,0x3e,0x05,0x3f,0x05,0x40,0x05,0x41,0x05,\
0x42,0x05,0x42,0x05,0x43,0x05,0x44,0x05,0x45,0x05,0x46,0x05,0x46,0x05,0x47,0x05,\
0x48,0x05,0x49,0x05,0x4a,0x05,0x4a,0x05,0x4b,0x05,0x4c,0x05,0x4d,0x05,0x4e,0x05,\
0x4e,0x05,0x4f,0x05,0x50,0x05,0x51,0x05,0x52,0x05,0x52,0x05,0x53,0x05,0x54,0x05,\
0x55,0x05,0x56,0x05,0x56,0x05,0x57,0x05,0x58,0x05,0x59,0x05,0x5a,0x05,0x5a,0x05,\
0x5b,0x05,0x5c,0x05,0x5d,0x05,0x5e,0x05,0x5e,0x05,0x5f,0x05,0x60,0x05,0x61,0x05,\
0x62,0x05,0x62,0x05,0x63,0x05,0x64,0x05,0x65,0x05,0x66,0x05,0x66,0x05,0x67,0x05,\
0x68,0x05,0x69,0x05,0x6a,0x05,0x6a,0x05,0x6b,0x05,0x6c,0x05,0x6d,0x05,0x6e,0x05,\
0x6e,0x05,0x6f,0x05,0x70,0x05,0x71,0x05,0x72,0x05,0x72,0x05,0x73,0x05,0x74,0x05,\
0x75,0x05,0x76,0x05,0x76,0x05,0x77,0x05,0x78,0x05,0x79,0x05,0x7a,0x05,0x7a,0x05,\
0x7b,0x05,0x7c,0x05,0x7d,0x05,0x7e,0x05,0x7e,0x05,0x7f,0x05,0x80,0x05,0x81,0x05,\
0x82,0x05,0x82,0x05,0x83,0x05,0x84,0x05,0x85,0x05,0x86,0x05,0x86,0x05,0x87,0x05,\
0x88,0x05,0x89,0x05,0x8a,0x05,0x8a,0x05,0x8b,0x05,0x8c,0x05,0x8d,0x05,0x8e,0x05,\
0x8e,0x05,0x8f,0x05,0x90,0x05,0x91,0x05,0x92,0x05,0x92,0x05,0x93,0x05,0x94,0x05,\
0x95,0x05,0x96,0x05,0x96,0x05,0x97,0x05,0x98,0x05,0x99,0x05,0x9a,0x05,0x9a,0x05,\
0x9b,0x05,0x9c,0x05,0x9d,0x05,0x9e,0x05,0x9e,0x05,0x9f,0x05,0xa0,0x05,0xa1,0x05,\
0xa2,0x05,0xa2,0x05,0xa3,0x05,0xa4,0x05,0xa5,0x05,0xa6,0x05,0xa6,0x05,0xa7,0x05,\
0xa8,0x05,0xa9,0x05,0xaa,0x05,0xaa,0x05,0xab,0x05,0xac,0x05,0xad,0x05,0xae,0x05,\
0xae,0x05,0xaf,0x05,0xb0,0x05,0xb1,0x05,0xb2,0x05,0xb2,0x05,0xb3,0x05,0xb4,0x05,\
0xb5,0x05,0xb6,0x05,0xb6,0x05,0xb7,0x05,0xb8,0x05,0xb9,0x05,0xba,0x05,0xba,0x05,\
0xbb,0x05,0xbc,0x05,0xbd,0x05,0xbe,0x05,0xbe,0x05,0xbf,0x05,0xc0,0x05,0xc1,0x05,\
0xc2,0x05,0xc2,0x05,0xc3,0x05,0xc4,0x05,0xc5,0x05,0xc6,0x05,0xc6,0x05,0xc7,0x05,\
0xc8,0x05,0xc9,0x05,0xca,0x05,0xca,0x05,0xcb,0x05,0xcc,0x05,0xcd,0x05,0xce,0x05,\
0xce,0x05,0xcf,0x05,0xd0,0x05,0xd1,0x05,0xd2,0x05,0xd2,0x05,0xd3,0x05,0xd4,0x05,\
0xd5,0x05,0xd6,0x05,0xd6,0x05,0xd7,0x05,0xd8,0x05,0xd9,0x05,0xda,0x05,0xda,0x05,\
0xdb,0x05,0xdc,0x05,0xdd,0x05,0xde,0x05,0xde,0x05,0xdf,0x05,0xe0,0x05,0xe1,0x05,\
0xe2,0x05,0xe2,0x05,0xe3,0x05,0xe4,0x05,0xe5,0x05,0xe6,0x05,0xe6,0x05,0xe7,0x05,\
0xe8,0x05,0xe9,0x05,0xea,0x05,0xea,0x05,0xeb,0x05,0xec,0x05,0xed,0x05,0xee,0x05,\
0xee,0x05,0xef,0x05,0xf0,0x05,0xf1,0x05,0xf2,0x05,0xf2,0x05,0xf3,0x05,0xf4,0x05,\
0xf5,0x05,0xf6,0x05,0xf6,0x05,0xf7,0x05,0xf8,0x05,0xf9,0x05,0xfa,0x05,0xfa,0x05,\
0xfb,0x05,0xfc,0x05,0xfd,0x05,0xfe,0x05,0xfe,0x05,0xff,0x05,0x00,0x06,0x01,0x06,\
0x02,0x06,0x02,0x06,0x03,0x06,0x04,0x06,0x05,0x06,0x06,0x06,0x06,0x06,0x07,0x06,\
0x08,0x06,0x09,0x06,0x0a,0x06,0x0a,0x06,0x0b,0x06,0x0c,0x06,0x0d,0x06,0x0e,0x06,\
0x0e,0x06,0x0f,0x06,0x10,0x06,0x11,0x06,0x12,0x06,0x12,0x06,0x13,0x06,0x14,0x06,\
0x15,0x06,0x16,0x06,0x16,0x06,0x17,0x06,0x18,0x06,0x19,0x06,0x1a,0x06,0x1a,0x06,\
0x1b,0x06,0x1c,0x06,0x1d,0x06,0x1e,0x06,0x1e,0x06,0x1f,0x06,0x20,0x06,0x21,0x06,\
0x22,0x06,0x22,0x06,0x23,0x06,0x24,0x06,0x25,0x06,0x26,0x06,0x26,0x06,0x27,0x06,\
0x28,0x06,0x29,0x06,0x2a,0x06,0x2a,0x06,0x2b,0x06,0x2c,0x06,0x2d,0x06,0x2e,0x06,\
0x2e,0x06,0x2f,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,\
0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,\
0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,\
0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,\
0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,\
0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,\
0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,\
0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,\
0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x30,0x06,0x86,0x01,0x00,0x00,\
0x06,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x37,0xd9,0xef,0x53,0x6d,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xa8,0x02,0x00,0x00,0x3c,0x03,0x00,0x00,0x01,0x00,0x00,0x00,\
0xff,0x03,0x00,0x00,0x60,0x00,0x00,0x00,0xdc,0x02,0x00,0x00,0x03,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x28,0x00,0x00,0x80,0x96,0x98,0x00,0x10,0x27,0x00,0x00,\
0xff,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x40,0x00,0x00,0x00,\
0x48,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x12,0x00,0x00,\
0xcd,0x21,0x00,0x00,0xa4,0x2d,0x00,0x00,0x73,0x37,0x00,0x00,0xfc,0x3f,0x00,0x00,\
0x9f,0x47,0x00,0x00,0x96,0x4e,0x00,0x00,0x06,0x55,0x00,0x00,0x08,0x5b,0x00,0x00,\
0xaf,0x60,0x00,0x00,0x07,0x66,0x00,0x00,0x1e,0x6b,0x00,0x00,0xf9,0x6f,0x00,0x00,\
0xa1,0x74,0x00,0x00,0x1b,0x79,0x00,0x00,0x6c,0x7d,0x00,0x00,0x98,0x81,0x00,0x00,\
0xa1,0x85,0x00,0x00,0x8b,0x89,0x00,0x00,0x59,0x8d,0x00,0x00,0x0c,0x91,0x00,0x00,\
0xa7,0x94,0x00,0x00,0x2b,0x98,0x00,0x00,0x9a,0x9b,0x00,0x00,0xf5,0x9e,0x00,0x00,\
0x3d,0xa2,0x00,0x00,0x73,0xa5,0x00,0x00,0x99,0xa8,0x00,0x00,0xaf,0xab,0x00,0x00,\
0xb7,0xae,0x00,0x00,0xb0,0xb1,0x00,0x00,0x9c,0xb4,0x00,0x00,0x7b,0xb7,0x00,0x00,\
0x4e,0xba,0x00,0x00,0x15,0xbd,0x00,0x00,0xd2,0xbf,0x00,0x00,0x83,0xc2,0x00,0x00,\
0x2b,0xc5,0x00,0x00,0xc9,0xc7,0x00,0x00,0x5d,0xca,0x00,0x00,0xe8,0xcc,0x00,0x00,\
0x6b,0xcf,0x00,0x00,0xe5,0xd1,0x00,0x00,0x58,0xd4,0x00,0x00,0xc2,0xd6,0x00,0x00,\
0x25,0xd9,0x00,0x00,0x81,0xdb,0x00,0x00,0xd5,0xdd,0x00,0x00,0x23,0xe0,0x00,0x00,\
0x6b,0xe2,0x00,0x00,0xab,0xe4,0x00,0x00,0xe6,0xe6,0x00,0x00,0x1b,0xe9,0x00,0x00,\
0x4a,0xeb,0x00,0x00,0x73,0xed,0x00,0x00,0x97,0xef,0x00,0x00,0xb5,0xf1,0x00,0x00,\
0xce,0xf3,0x00,0x00,0xe2,0xf5,0x00,0x00,0xf1,0xf7,0x00,0x00,0xfc,0xf9,0x00,0x00,\
0x01,0xfc,0x00,0x00,0x02,0xfe,0x00,0x00,0xff,0xff,0x00,0x00,0x01,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0xe4,0x00,0x00,0x00,0xc7,0x01,0x00,0x00,0xab,0x02,0x00,0x00,\
0x8e,0x03,0x00,0x00,0x72,0x04,0x00,0x00,0x59,0x05,0x00,0x00,0x5c,0x06,0x00,0x00,\
0x78,0x07,0x00,0x00,0xad,0x08,0x00,0x00,0xfc,0x09,0x00,0x00,0x64,0x0b,0x00,0x00,\
0xe8,0x0c,0x00,0x00,0x85,0x0e,0x00,0x00,0x3e,0x10,0x00,0x00,0x12,0x12,0x00,0x00,\
0x02,0x14,0x00,0x00,0x0d,0x16,0x00,0x00,0x35,0x18,0x00,0x00,0x79,0x1a,0x00,0x00,\
0xda,0x1c,0x00,0x00,0x58,0x1f,0x00,0x00,0xf3,0x21,0x00,0x00,0xab,0x24,0x00,0x00,\
0x81,0x27,0x00,0x00,0x75,0x2a,0x00,0x00,0x86,0x2d,0x00,0x00,0xb7,0x30,0x00,0x00,\
0x05,0x34,0x00,0x00,0x72,0x37,0x00,0x00,0xff,0x3a,0x00,0x00,0xaa,0x3e,0x00,0x00,\
0x74,0x42,0x00,0x00,0x5e,0x46,0x00,0x00,0x68,0x4a,0x00,0x00,0x91,0x4e,0x00,0x00,\
0xda,0x52,0x00,0x00,0x44,0x57,0x00,0x00,0xcd,0x5b,0x00,0x00,0x78,0x60,0x00,0x00,\
0x42,0x65,0x00,0x00,0x2e,0x6a,0x00,0x00,0x3b,0x6f,0x00,0x00,0x68,0x74,0x00,0x00,\
0xb7,0x79,0x00,0x00,0x28,0x7f,0x00,0x00,0xb9,0x84,0x00,0x00,0x6d,0x8a,0x00,0x00,\
0x42,0x90,0x00,0x00,0x3a,0x96,0x00,0x00,0x53,0x9c,0x00,0x00,0x8f,0xa2,0x00,0x00,\
0xed,0xa8,0x00,0x00,0x6e,0xaf,0x00,0x00,0x11,0xb6,0x00,0x00,0xd7,0xbc,0x00,0x00,\
0xc0,0xc3,0x00,0x00,0xcc,0xca,0x00,0x00,0xfb,0xd1,0x00,0x00,0x4e,0xd9,0x00,0x00,\
0xc3,0xe0,0x00,0x00,0x5d,0xe8,0x00,0x00,0x1a,0xf0,0x00,0x00,0xfa,0xf7,0x00,0x00,\
0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x8d,0x2f,0x00,0x00,0x05,0x52,0x00,0x00,\
0x27,0x6c,0x00,0x00,0xa6,0x80,0x00,0x00,0x27,0x91,0x00,0x00,0xba,0x9e,0x00,0x00,\
0x17,0xaa,0x00,0x00,0xbe,0xb3,0x00,0x00,0x0a,0xbc,0x00,0x00,0x40,0xc3,0x00,0x00,\
0x93,0xc9,0x00,0x00,0x2b,0xcf,0x00,0x00,0x26,0xd4,0x00,0x00,0x9d,0xd8,0x00,0x00,\
0xa3,0xdc,0x00,0x00,0x48,0xe0,0x00,0x00,0x99,0xe3,0x00,0x00,0xa1,0xe6,0x00,0x00,\
0x69,0xe9,0x00,0x00,0xf9,0xeb,0x00,0x00,0x57,0xee,0x00,0x00,0x89,0xf0,0x00,0x00,\
0x93,0xf2,0x00,0x00,0x79,0xf4,0x00,0x00,0x3f,0xf6,0x00,0x00,0xe8,0xf7,0x00,0x00,\
0x77,0xf9,0x00,0x00,0xed,0xfa,0x00,0x00,0x4e,0xfc,0x00,0x00,0x9b,0xfd,0x00,0x00,\
0xd5,0xfe,0x00,0x00,0xff,0xff,0x00,0x00,0x86,0x01,0x00,0x00,0x03,0x00,0x00,0x00,\
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd2,0x5a,0x29,0xd0,\
0x6d,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x15,0x00,0x00,0x00,0xa9,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0xff,0x03,0x00,0x00,\
0x60,0x00,0x00,0x00,0x49,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x28,0x00,0x00,0x80,0x96,0x98,0x00,0x10,0x27,0x00,0x00,0x01,0x02,0x02,0x00,\
0x20,0x00,0x40,0x3a,0x10,0x20,0x08,0x08,0xe8,0x03,0x02,0x00,0x46,0x04,0x02,0x00,\
0x00,0x86,0x01,0x00,0x00,0x02,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0xd1,0x9e,0xbe,0xc5,0x6d,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x0e,0x00,0x00,0x92,0x0f,0x00,\
0x00,0x01,0x00,0x00,0x00,0xff,0x03,0x00,0x00,0x60,0x00,0x00,0x00,0x32,0x0f,0x00,\
0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x02,0x00,0x00,\
0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x00,0x00,0x80,0x96,0x98,\
0x00,0x10,0x27,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,\
0x00,0x02,0x00,0x03,0x00,0x04,0x00,0x05,0x00,0x06,0x00,0x07,0x00,0x08,0x00,0x09,\
0x00,0x0b,0x00,0x0c,0x00,0x0d,0x00,0x0f,0x00,0x10,0x00,0x11,0x00,0x13,0x00,0x14,\
0x00,0x16,0x00,0x18,0x00,0x19,0x00,0x1b,0x00,0x1d,0x00,0x1e,0x00,0x20,0x00,0x22,\
0x00,0x24,0x00,0x25,0x00,0x27,0x00,0x29,0x00,0x2b,0x00,0x2d,0x00,0x2f,0x00,0x31,\
0x00,0x33,0x00,0x35,0x00,0x37,0x00,0x39,0x00,0x3b,0x00,0x3d,0x00,0x40,0x00,0x42,\
0x00,0x44,0x00,0x46,0x00,0x48,0x00,0x4b,0x00,0x4d,0x00,0x4f,0x00,0x51,0x00,0x54,\
0x00,0x56,0x00,0x59,0x00,0x5b,0x00,0x5d,0x00,0x60,0x00,0x62,0x00,0x65,0x00,0x67,\
0x00,0x6a,0x00,0x6c,0x00,0x6f,0x00,0x71,0x00,0x74,0x00,0x77,0x00,0x79,0x00,0x7c,\
0x00,0x7e,0x00,0x81,0x00,0x84,0x00,0x86,0x00,0x89,0x00,0x8c,0x00,0x8f,0x00,0x91,\
0x00,0x94,0x00,0x97,0x00,0x9a,0x00,0x9d,0x00,0x9f,0x00,0xa2,0x00,0xa5,0x00,0xa8,\
0x00,0xab,0x00,0xae,0x00,0xb1,0x00,0xb4,0x00,0xb7,0x00,0xba,0x00,0xbd,0x00,0xc0,\
0x00,0xc3,0x00,0xc6,0x00,0xc9,0x00,0xcc,0x00,0xcf,0x00,0xd2,0x00,0xd5,0x00,0xd8,\
0x00,0xdb,0x00,0xde,0x00,0xe2,0x00,0xe5,0x00,0xe8,0x00,0xeb,0x00,0xee,0x00,0xf2,\
0x00,0xf5,0x00,0xf8,0x00,0xfb,0x00,0xff,0x00,0x02,0x01,0x05,0x01,0x08,0x01,0x0c,\
0x01,0x0f,0x01,0x12,0x01,0x16,0x01,0x19,0x01,0x1d,0x01,0x20,0x01,0x23,0x01,0x27,\
0x01,0x2a,0x01,0x2e,0x01,0x31,0x01,0x35,0x01,0x38,0x01,0x46,0x01,0x54,0x01,0x63,\
0x01,0x71,0x01,0x80,0x01,0x8f,0x01,0x9e,0x01,0xad,0x01,0xbd,0x01,0xcc,0x01,0xdc,\
0x01,0xec,0x01,0xfc,0x01,0x0c,0x02,0x1c,0x02,0x2d,0x02,0x3e,0x02,0x4e,0x02,0x5f,\
0x02,0x70,0x02,0x82,0x02,0x93,0x02,0xa5,0x02,0xb6,0x02,0xc8,0x02,0xda,0x02,0xec,\
0x02,0xfe,0x02,0x10,0x03,0x23,0x03,0x35,0x03,0x48,0x03,0x5b,0x03,0x6e,0x03,0x81,\
0x03,0x94,0x03,0xa7,0x03,0xbb,0x03,0xce,0x03,0xe2,0x03,0xf6,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x02,\
0x00,0x03,0x00,0x04,0x00,0x05,0x00,0x06,0x00,0x07,0x00,0x08,0x00,0x09,0x00,0x0b,\
0x00,0x0c,0x00,0x0d,0x00,0x0f,0x00,0x10,0x00,0x11,0x00,0x13,0x00,0x14,0x00,0x16,\
0x00,0x18,0x00,0x19,0x00,0x1b,0x00,0x1d,0x00,0x1e,0x00,0x20,0x00,0x22,0x00,0x24,\
0x00,0x25,0x00,0x27,0x00,0x29,0x00,0x2b,0x00,0x2d,0x00,0x2f,0x00,0x31,0x00,0x33,\
0x00,0x35,0x00,0x37,0x00,0x39,0x00,0x3b,0x00,0x3d,0x00,0x40,0x00,0x42,0x00,0x44,\
0x00,0x46,0x00,0x48,0x00,0x4b,0x00,0x4d,0x00,0x4f,0x00,0x51,0x00,0x54,0x00,0x56,\
0x00,0x59,0x00,0x5b,0x00,0x5d,0x00,0x60,0x00,0x62,0x00,0x65,0x00,0x67,0x00,0x6a,\
0x00,0x6c,0x00,0x6f,0x00,0x71,0x00,0x74,0x00,0x77,0x00,0x79,0x00,0x7c,0x00,0x7e,\
0x00,0x81,0x00,0x84,0x00,0x86,0x00,0x89,0x00,0x8c,0x00,0x8f,0x00,0x91,0x00,0x94,\
0x00,0x97,0x00,0x9a,0x00,0x9d,0x00,0x9f,0x00,0xa2,0x00,0xa5,0x00,0xa8,0x00,0xab,\
0x00,0xae,0x00,0xb1,0x00,0xb4,0x00,0xb7,0x00,0xba,0x00,0xbd,0x00,0xc0,0x00,0xc3,\
0x00,0xc6,0x00,0xc9,0x00,0xcc,0x00,0xcf,0x00,0xd2,0x00,0xd5,0x00,0xd8,0x00,0xdb,\
0x00,0xde,0x00,0xe2,0x00,0xe5,0x00,0xe8,0x00,0xeb,0x00,0xee,0x00,0xf2,0x00,0xf5,\
0x00,0xf8,0x00,0xfb,0x00,0xff,0x00,0x02,0x01,0x05,0x01,0x08,0x01,0x0c,0x01,0x0f,\
0x01,0x12,0x01,0x16,0x01,0x19,0x01,0x1d,0x01,0x20,0x01,0x23,0x01,0x27,0x01,0x2a,\
0x01,0x2e,0x01,0x31,0x01,0x35,0x01,0x38,0x01,0x46,0x01,0x54,0x01,0x63,0x01,0x71,\
0x01,0x80,0x01,0x8f,0x01,0x9e,0x01,0xad,0x01,0xbd,0x01,0xcc,0x01,0xdc,0x01,0xec,\
0x01,0xfc,0x01,0x0c,0x02,0x1c,0x02,0x2d,0x02,0x3e,0x02,0x4e,0x02,0x5f,0x02,0x70,\
0x02,0x82,0x02,0x93,0x02,0xa5,0x02,0xb6,0x02,0xc8,0x02,0xda,0x02,0xec,0x02,0xfe,\
0x02,0x10,0x03,0x23,0x03,0x35,0x03,0x48,0x03,0x5b,0x03,0x6e,0x03,0x81,0x03,0x94,\
0x03,0xa7,0x03,0xbb,0x03,0xce,0x03,0xe2,0x03,0xf6,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x02,0x00,0x03,\
0x00,0x04,0x00,0x05,0x00,0x06,0x00,0x07,0x00,0x08,0x00,0x09,0x00,0x0b,0x00,0x0c,\
0x00,0x0d,0x00,0x0f,0x00,0x10,0x00,0x11,0x00,0x13,0x00,0x14,0x00,0x16,0x00,0x18,\
0x00,0x19,0x00,0x1b,0x00,0x1d,0x00,0x1e,0x00,0x20,0x00,0x22,0x00,0x24,0x00,0x25,\
0x00,0x27,0x00,0x29,0x00,0x2b,0x00,0x2d,0x00,0x2f,0x00,0x31,0x00,0x33,0x00,0x35,\
0x00,0x37,0x00,0x39,0x00,0x3b,0x00,0x3d,0x00,0x40,0x00,0x42,0x00,0x44,0x00,0x46,\
0x00,0x48,0x00,0x4b,0x00,0x4d,0x00,0x4f,0x00,0x51,0x00,0x54,0x00,0x56,0x00,0x59,\
0x00,0x5b,0x00,0x5d,0x00,0x60,0x00,0x62,0x00,0x65,0x00,0x67,0x00,0x6a,0x00,0x6c,\
0x00,0x6f,0x00,0x71,0x00,0x74,0x00,0x77,0x00,0x79,0x00,0x7c,0x00,0x7e,0x00,0x81,\
0x00,0x84,0x00,0x86,0x00,0x89,0x00,0x8c,0x00,0x8f,0x00,0x91,0x00,0x94,0x00,0x97,\
0x00,0x9a,0x00,0x9d,0x00,0x9f,0x00,0xa2,0x00,0xa5,0x00,0xa8,0x00,0xab,0x00,0xae,\
0x00,0xb1,0x00,0xb4,0x00,0xb7,0x00,0xba,0x00,0xbd,0x00,0xc0,0x00,0xc3,0x00,0xc6,\
0x00,0xc9,0x00,0xcc,0x00,0xcf,0x00,0xd2,0x00,0xd5,0x00,0xd8,0x00,0xdb,0x00,0xde,\
0x00,0xe2,0x00,0xe5,0x00,0xe8,0x00,0xeb,0x00,0xee,0x00,0xf2,0x00,0xf5,0x00,0xf8,\
0x00,0xfb,0x00,0xff,0x00,0x02,0x01,0x05,0x01,0x08,0x01,0x0c,0x01,0x0f,0x01,0x12,\
0x01,0x16,0x01,0x19,0x01,0x1d,0x01,0x20,0x01,0x23,0x01,0x27,0x01,0x2a,0x01,0x2e,\
0x01,0x31,0x01,0x35,0x01,0x38,0x01,0x46,0x01,0x54,0x01,0x63,0x01,0x71,0x01,0x80,\
0x01,0x8f,0x01,0x9e,0x01,0xad,0x01,0xbd,0x01,0xcc,0x01,0xdc,0x01,0xec,0x01,0xfc,\
0x01,0x0c,0x02,0x1c,0x02,0x2d,0x02,0x3e,0x02,0x4e,0x02,0x5f,0x02,0x70,0x02,0x82,\
0x02,0x93,0x02,0xa5,0x02,0xb6,0x02,0xc8,0x02,0xda,0x02,0xec,0x02,0xfe,0x02,0x10,\
0x03,0x23,0x03,0x35,0x03,0x48,0x03,0x5b,0x03,0x6e,0x03,0x81,0x03,0x94,0x03,0xa7,\
0x03,0xbb,0x03,0xce,0x03,0xe2,0x03,0xf6,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,0x03,0xff,\
0x03,0xff,0x03,0x86,0x01,0x00,0x00,0x15,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe1,0x95,0xda,0x41,0x6d,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x04,0x00,0x00,0x9c,\
0x04,0x00,0x00,0x01,0x00,0x00,0x00,0xff,0x03,0x00,0x00,0x60,0x00,0x00,0x00,0x3c,\
0x04,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x02,\
0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x00,0x00,0x80,\
0x96,0x98,0x00,0x10,0x27,0x00,0x00,0x01,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x10,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0x04,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,\
0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,\
0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0x04,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,\
0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,\
0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0x04,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,\
0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,\
0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,\
0x04,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,\
0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,\
0x10,0x00,0x00,0x10,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x26,0x00,0x00,0x00,0x4c,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x26,0x00,0x00,0x00,0x4c,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x26,0x00,0x00,0x00,0x4c,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x26,0x00,0x00,0x00,0x4c,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x80,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x34,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x80,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x34,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x80,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x34,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x80,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x34,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x02,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x02,0x00,0x00,0x86,\
0x01,0x00,0x00,0x08,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0xf5,0x3c,0xd1,0xd1,0x6d,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x22,0x00,0x00,0x00,0xf4,0x00,0x00,0x00,0x01,\
0x00,0x00,0x00,0xff,0x03,0x00,0x00,0x60,0x00,0x00,0x00,0x94,0x00,0x00,0x00,0x03,\
0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,\
0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x4e,0x00,0x00,0x80,0x96,0x98,0x00,0x1d,\
0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1e,\
0x00,0x00,0x00,0x20,0x4e,0x00,0x00,0x80,0x96,0x98,0x00,0x00,0x04,0x00,0x00,0x01,\
0x00,0xff,0xff,0x00,0x00,0xff,0xff,0x00,0x00,0xff,0xff,0x00,0x00,0xff,0xff,0x00,\
0x00,0xff,0xff,0x00,0x00,0xff,0xff,0x00,0x00,0xff,0xff,0x00,0x00,0xff,0xff,0x00,\
0x00,0x01,0x00,0xc8,0x00,0x00,0x00,0xc8,0x00,0x32,0x00,0x2c,0x01,0x32,0x00,0xf4,\
0x01,0x25,0x00,0x20,0x03,0x32,0x00,0x40,0x06,0x32,0x00,0x80,0x0c,0x32,0x00,0x00,\
0x19,0x32,0x00,   \
}


#endif /* End of #ifndef BSPDRV_DCC_VISS_IMX390_DISCOVERY_WIDE_WDR_DCC_H_ */
