SUMMARY = "PHYTEC's Qt6 reference demo implementation"
HOMEPAGE = "https://github.com/phytec/qtphy"

LICENSE = "MIT"
LIC_FILES_CHKSUM = "file://LICENSE;md5=ad96fc5ccd38a6b654d43bd52c4724ac"

SRC_URI:append = " \
    https://download.phytec.de/Software/Linux/Applications/Media/caminandes_3_llamigos_720p_vp9.webm;name=caminandes_3 \
    https://download.phytec.de/Software/Linux/Applications/Media/IMG_7942.JPG;name=image_pcb1 \
    https://download.phytec.de/Software/Linux/Applications/Media/IMG_8004.JPG;name=image_pcb2 \
    https://download.phytec.de/Software/Linux/Applications/Media/phytec_logo_medium.png;name=image_logo \
    file://${BPN}.service \
"
SRC_URI:append:mx8-nxp-bsp = "file://select_pa_sink.sh"
SRC_URI:append:mx93-generic-bsp = "file://${BPN}.conf"
SRC_URI[caminandes_3.sha256sum] = "54f8ac10627c4d3d4c0e1ee67062ce969ea5ce9a78df99f6f33818ca993aa067"
SRC_URI[image_pcb1.sha256sum] = "8f5511608bbecd3d96c1ed4be9537ee4910fba138dfb5e5a464f1b3e4bbb41bc"
SRC_URI[image_pcb2.sha256sum] = "bf9e383406ed573ce91ef6486d5c518eb8f4b49c3b7ef34d1a570fe7c3d15122"
SRC_URI[image_logo.sha256sum] = "a496649e6df34649af8205b0cae64dd617e921a9d9c212e808682474b473df23"

inherit qt6-meson systemd

DEPENDS = "packagegroup-qt6-essentials qtmultimedia"

PACKAGES =+ "${PN}-service ${PN}-images"
SYSTEMD_SERVICE:${PN}-service = "${BPN}.service"
SYSTEMD_PACKAGES = "${PN}-service"

QTPHY_ENV_EXTRA ?= ""
QTPHY_ENV_EXTRA:mx8-generic-bsp = "QT_SCALE_FACTOR=2"
QTPHY_ENV_EXTRA:phyboard-nash = "QT_SCALE_FACTOR=2"
QTPHY_ENV_EXTRA:phyboard-segin-imx93 = "QT_SCALE_FACTOR=1.4"

do_fetch[vardeps] += "QTPHY_ENV_EXTRA"

PACKAGECONFIG[qmlsink] = "-Dqmlsink=enabled,-Dqmlsink=disabled, gstreamer1.0-plugins-good"

PACKAGECONFIG:append:mx8-nxp-bsp = " qmlsink"

do_patch[postfuncs] += "parse_systemd_service"
parse_systemd_service () {
    sed -i -e 's/@QTPHY_ENV_EXTRA@/${QTPHY_ENV_EXTRA}/g' ${WORKDIR}/${BPN}.service
}

do_install:append () {
    install -d ${D}${systemd_system_unitdir}
    install -m 0644 ${WORKDIR}/${BPN}.service ${D}${systemd_system_unitdir}

    # Images from qtphy repo
    install -d ${D}${datadir}/${BPN}/images
    for f in ${S}/resources/images/*.jpg; do \
        install -Dm 0644 $f ${D}${datadir}/${BPN}/images/
    done

    # Images from phytec download server
    for f in ${WORKDIR}/*.JPG ${WORKDIR}/*.png; do \
        install -Dm 0644 $f ${D}${datadir}/${BPN}/images/
    done

    # Videos from phytec download server
    install -d ${D}${datadir}/${BPN}/videos
    for f in ${WORKDIR}/*.webm; do \
        install -Dm 0644 $f ${D}${datadir}/${BPN}/videos/
    done
}
do_install:append:mx93-generic-bsp () {
    install -Dm 0644 ${WORKDIR}/${BPN}.conf "${D}${ROOT_HOME}/.config/PHYTEC Messtechnik GmbH/${BPN}.conf"
}

do_install:append:mx8-nxp-bsp () {
    install -m 0755 ${WORKDIR}/select_pa_sink.sh ${D}/${bindir}/select_pa_sink.sh
}

FILES:${PN}:append:mx93-generic-bsp = " \
    ${ROOT_HOME}/.config/* \
"
FILES:${PN}-service += " \
    ${systemd_system_unitdir}/${BPN}.service \
"

FILES:${PN}-images += " \
    ${datadir}/${BPN}/images/* \
    ${datadir}/${BPN}/videos/* \
"

RDEPENDS:${PN} += " \
    qtmultimedia \
    ${@bb.utils.contains('DISTRO_FEATURES', 'wayland', 'qtwayland', '', d)} \
    qtvirtualkeyboard \
"
RDEPENDS:${PN}-service += " \
    weston \
    weston-init \
"

PACKAGE_ARCH = "${MACHINE_ARCH}"
