do_patch[depends] += "${@bb.utils.contains('DISTRO_FEATURES', 'secureboot', 'nxp-cst-native:do_populate_sysroot', '', d)}"

AHAB_SRK_TABLE_BIN ??= ""
AHAB_SRK_PUB_CERT ??= ""
AHAB_SRK_INDEX ??= "0"

do_fetch[vardeps] = " \
    AHAB_SRK_TABLE_BIN \
    AHAB_SRK_PUB_CERT \
    AHAB_SRK_INDEX \
"

def csf_get_offsets_from_string(target, logstring):
    import re

    regex = r'Output\:\s*' + re.escape(target) + r'[\s\S]*?Offsets\s+=\s+([0-9x]+)\s+([0-9x]+)$'
    match = re.search(regex, logstring, re.MULTILINE)

    if match is None:
        bb.fatal(f'CSF: Failed finding offsets in log file for target \'{target}\'')
        return None

    return match.group(1), match.group(2)

def csf_get_offsets_from_file(target, logfile):
    with open(logfile, 'r') as f:
        return csf_get_offsets_from_string(target, f.read())

def csf_emit_template(sign_bin, offset_container_header, offset_signature_block, d):
    import textwrap
    return textwrap.dedent(d.expand(f'''\
        [Header]
        Target = AHAB
        Version = 1.0

        [Install SRK]
        # SRK table generated by srktool
        File = "${{AHAB_SRK_TABLE_BIN}}"
        # Public key certificate in PEM format
        Source = "${{AHAB_SRK_PUB_CERT}}"
        # Index of the public key certificate within the SRK table (0 .. 3)
        Source index = ${{AHAB_SRK_INDEX}}
        # Type of SRK set (NXP or OEM)
        Source set = OEM
        # bitmask of the revoked SRKs
        Revocations = 0x0

        [Authenticate Data]
        # Binary to be signed generated by mkimage
        File = "{sign_bin}"
        # Offsets = Container header  Signature block (printed out by mkimage)
        Offsets = {offset_container_header} {offset_signature_block}
    '''))

def ahab_sign(image_path, signed_image_path, offset_container_header, offset_signature_block, d):
    import subprocess

    target = os.path.basename(image_path)
    csf_path = f'csf-{target}.txt'
    with open(csf_path, 'w') as f:
        bb.note('AHAB: Writing CSF')
        f.write(csf_emit_template(image_path, offset_container_header,
                offset_signature_block, d))

    bb.note('AHAB: Running CST')
    subprocess.run(['cst', '-i', csf_path, '-o', signed_image_path])

    if not os.path.isfile(signed_image_path):
        bb.fatal(f'File {signed_image_path} not found! CST probably failed!')
