#!/bin/sh
# Run HALCON phyCAM scripts on your Arm-based Linux computer.
# Copyright (C) 2022 PHYTEC, Mainz, Germany

platform=$(uname -m)
case "$platform" in
  aarch64)
    arch="aarch64-linux"
  ;;
  armv7l)
    arch="armv7a-linux"
  ;;
  x86_64)
    echo "HPeek is available for Arm-based platforms only." >&2
    echo "" >&2
    exit 1
  ;;
  *)
    echo "Your platform $platform is not supported." >&2
    echo "" >&2
    exit 1
  ;;
esac

./init_isi_phyCAM-M_v4l_device.sh

echo " Choose the example script"
echo " ========================="
echo " 1 = show live stream"
echo " 2 = save a jpg image"
echo " 3 = optical flow"
read SET_MEDIA_CTL
echo " Your select = $SET_MEDIA_CTL"


if [ "$(v4l2-ctl -d /dev/cam-csi1 --get-subdev-fmt 0 | grep "Mediabus Code" | sed 's/.*BUS_FMT_\([A-Z]*\).*/\1/g')" = "Y" ]; then
	SET_MEDIA_CTL=$[$SET_MEDIA_CTL+3]
fi

case $SET_MEDIA_CTL in
  "1") script=grabb_bayer_and_show_phyCAM_via_gst.hdev ;;
  "2") script=grabb_bayer_and_save-jpg_phyCAM_via_gst.hdev ;;
  "3") script=grabb_bayer_and_optical_flow.hdev ;;
  "4") script=grabb_y8_and_show_phyCAM_via_gst.hdev ;;
  "5") script=grabb_y8_and_save-jpg_phyCAM_via_gst.hdev ;;
  "6") script=grabb_y8_and_optical_flow.hdev ;;
  *) script=grabb_bayer_and_show_phyCAM_via_gst.hdev ;;
esac

if [ ! -f $script ]; then
  echo " Could not find '$script'." >&2
  echo " Please change to the HALCON examples/phytec directory and run ./start.sh there." >&2
  echo "" >&2
  exit 1
fi

source ./init_display.sh

echo " Running '../../bin/$arch/hpeek $script'"
../../bin/$arch/hpeek $script
